/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MemoryAccessVarHandleBase;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarForm;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import jdk.internal.access.foreign.MemorySegmentProxy;
import jdk.internal.misc.ScopedMemoryAccess;
import jdk.internal.vm.annotation.ForceInline;

final class MemoryAccessVarHandleByteHelper
extends MemoryAccessVarHandleBase {
    static final boolean BE = MethodHandleStatics.UNSAFE.isBigEndian();
    static final ScopedMemoryAccess SCOPED_MEMORY_ACCESS = ScopedMemoryAccess.getScopedMemoryAccess();
    static final int VM_ALIGN = 0;
    static final VarForm FORM = new VarForm(MemoryAccessVarHandleByteHelper.class, MemorySegmentProxy.class, Byte.TYPE, Long.TYPE);

    MemoryAccessVarHandleByteHelper(boolean skipAlignmentMaskCheck, boolean be, long length, long alignmentMask, boolean exact) {
        super(FORM, skipAlignmentMaskCheck, be, length, alignmentMask, exact);
    }

    @Override
    final MethodType accessModeTypeUncached(VarHandle.AccessType accessType) {
        return accessType.accessModeType(MemorySegmentProxy.class, Byte.TYPE, Long.TYPE);
    }

    @Override
    public MemoryAccessVarHandleByteHelper withInvokeExactBehavior() {
        return this.hasInvokeExactBehavior() ? this : new MemoryAccessVarHandleByteHelper(this.skipAlignmentMaskCheck, this.be, this.length, this.alignmentMask, true);
    }

    @Override
    public MemoryAccessVarHandleByteHelper withInvokeBehavior() {
        return !this.hasInvokeExactBehavior() ? this : new MemoryAccessVarHandleByteHelper(this.skipAlignmentMaskCheck, this.be, this.length, this.alignmentMask, false);
    }

    @ForceInline
    static byte convEndian(boolean big, byte n) {
        return n;
    }

    @ForceInline
    static MemorySegmentProxy checkAddress(Object obb, long offset, long length, boolean ro) {
        MemorySegmentProxy oo = (MemorySegmentProxy)Objects.requireNonNull(obb);
        oo.checkAccess(offset, length, ro);
        return oo;
    }

    @ForceInline
    static long offset(boolean skipAlignmentMaskCheck, MemorySegmentProxy bb, long offset, long alignmentMask) {
        long address = MemoryAccessVarHandleByteHelper.offsetNoVMAlignCheck(skipAlignmentMaskCheck, bb, offset, alignmentMask);
        if ((address & 0L) != 0L) {
            throw MemoryAccessVarHandleBase.newIllegalStateExceptionForMisalignedAccess(address);
        }
        return address;
    }

    @ForceInline
    static long offsetNoVMAlignCheck(boolean skipAlignmentMaskCheck, MemorySegmentProxy bb, long offset, long alignmentMask) {
        long base = bb.unsafeGetOffset();
        long address = base + offset;
        if (skipAlignmentMaskCheck ? (base & alignmentMask) != 0L : (address & alignmentMask) != 0L) {
            throw MemoryAccessVarHandleBase.newIllegalStateExceptionForMisalignedAccess(address);
        }
        return address;
    }

    @ForceInline
    static byte get(VarHandle ob, Object obb, long base) {
        MemoryAccessVarHandleBase handle = (MemoryAccessVarHandleBase)ob;
        MemorySegmentProxy bb = MemoryAccessVarHandleByteHelper.checkAddress(obb, base, handle.length, true);
        return SCOPED_MEMORY_ACCESS.getByte(bb.scope(), bb.unsafeGetBase(), MemoryAccessVarHandleByteHelper.offsetNoVMAlignCheck(handle.skipAlignmentMaskCheck, bb, base, handle.alignmentMask));
    }

    @ForceInline
    static void set(VarHandle ob, Object obb, long base, byte value) {
        MemoryAccessVarHandleBase handle = (MemoryAccessVarHandleBase)ob;
        MemorySegmentProxy bb = MemoryAccessVarHandleByteHelper.checkAddress(obb, base, handle.length, false);
        SCOPED_MEMORY_ACCESS.putByte(bb.scope(), bb.unsafeGetBase(), MemoryAccessVarHandleByteHelper.offsetNoVMAlignCheck(handle.skipAlignmentMaskCheck, bb, base, handle.alignmentMask), value);
    }

    @ForceInline
    static byte getVolatile(VarHandle ob, Object obb, long base) {
        MemoryAccessVarHandleBase handle = (MemoryAccessVarHandleBase)ob;
        MemorySegmentProxy bb = MemoryAccessVarHandleByteHelper.checkAddress(obb, base, handle.length, true);
        return MemoryAccessVarHandleByteHelper.convEndian(handle.be, SCOPED_MEMORY_ACCESS.getByteVolatile(bb.scope(), bb.unsafeGetBase(), MemoryAccessVarHandleByteHelper.offset(handle.skipAlignmentMaskCheck, bb, base, handle.alignmentMask)));
    }

    @ForceInline
    static void setVolatile(VarHandle ob, Object obb, long base, byte value) {
        MemoryAccessVarHandleBase handle = (MemoryAccessVarHandleBase)ob;
        MemorySegmentProxy bb = MemoryAccessVarHandleByteHelper.checkAddress(obb, base, handle.length, false);
        SCOPED_MEMORY_ACCESS.putByteVolatile(bb.scope(), bb.unsafeGetBase(), MemoryAccessVarHandleByteHelper.offset(handle.skipAlignmentMaskCheck, bb, base, handle.alignmentMask), MemoryAccessVarHandleByteHelper.convEndian(handle.be, value));
    }

    @ForceInline
    static byte getAcquire(VarHandle ob, Object obb, long base) {
        MemoryAccessVarHandleBase handle = (MemoryAccessVarHandleBase)ob;
        MemorySegmentProxy bb = MemoryAccessVarHandleByteHelper.checkAddress(obb, base, handle.length, true);
        return MemoryAccessVarHandleByteHelper.convEndian(handle.be, SCOPED_MEMORY_ACCESS.getByteAcquire(bb.scope(), bb.unsafeGetBase(), MemoryAccessVarHandleByteHelper.offset(handle.skipAlignmentMaskCheck, bb, base, handle.alignmentMask)));
    }

    @ForceInline
    static void setRelease(VarHandle ob, Object obb, long base, byte value) {
        MemoryAccessVarHandleBase handle = (MemoryAccessVarHandleBase)ob;
        MemorySegmentProxy bb = MemoryAccessVarHandleByteHelper.checkAddress(obb, base, handle.length, false);
        SCOPED_MEMORY_ACCESS.putByteRelease(bb.scope(), bb.unsafeGetBase(), MemoryAccessVarHandleByteHelper.offset(handle.skipAlignmentMaskCheck, bb, base, handle.alignmentMask), MemoryAccessVarHandleByteHelper.convEndian(handle.be, value));
    }

    @ForceInline
    static byte getOpaque(VarHandle ob, Object obb, long base) {
        MemoryAccessVarHandleBase handle = (MemoryAccessVarHandleBase)ob;
        MemorySegmentProxy bb = MemoryAccessVarHandleByteHelper.checkAddress(obb, base, handle.length, true);
        return MemoryAccessVarHandleByteHelper.convEndian(handle.be, SCOPED_MEMORY_ACCESS.getByteOpaque(bb.scope(), bb.unsafeGetBase(), MemoryAccessVarHandleByteHelper.offset(handle.skipAlignmentMaskCheck, bb, base, handle.alignmentMask)));
    }

    @ForceInline
    static void setOpaque(VarHandle ob, Object obb, long base, byte value) {
        MemoryAccessVarHandleBase handle = (MemoryAccessVarHandleBase)ob;
        MemorySegmentProxy bb = MemoryAccessVarHandleByteHelper.checkAddress(obb, base, handle.length, false);
        SCOPED_MEMORY_ACCESS.putByteOpaque(bb.scope(), bb.unsafeGetBase(), MemoryAccessVarHandleByteHelper.offset(handle.skipAlignmentMaskCheck, bb, base, handle.alignmentMask), MemoryAccessVarHandleByteHelper.convEndian(handle.be, value));
    }
}

