/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MemoryAccessVarHandleBase;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarForm;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import jdk.internal.access.foreign.MemorySegmentProxy;
import jdk.internal.misc.ScopedMemoryAccess;
import jdk.internal.vm.annotation.ForceInline;

final class MemoryAccessVarHandleCharHelper
extends MemoryAccessVarHandleBase {
    static final boolean BE = MethodHandleStatics.UNSAFE.isBigEndian();
    static final ScopedMemoryAccess SCOPED_MEMORY_ACCESS = ScopedMemoryAccess.getScopedMemoryAccess();
    static final int VM_ALIGN = 1;
    static final VarForm FORM = new VarForm(MemoryAccessVarHandleCharHelper.class, MemorySegmentProxy.class, Character.TYPE, Long.TYPE);

    MemoryAccessVarHandleCharHelper(boolean skipAlignmentMaskCheck, boolean be, long length, long alignmentMask, boolean exact) {
        super(FORM, skipAlignmentMaskCheck, be, length, alignmentMask, exact);
    }

    @Override
    final MethodType accessModeTypeUncached(VarHandle.AccessType accessType) {
        return accessType.accessModeType(MemorySegmentProxy.class, Character.TYPE, Long.TYPE);
    }

    @Override
    public MemoryAccessVarHandleCharHelper withInvokeExactBehavior() {
        return this.hasInvokeExactBehavior() ? this : new MemoryAccessVarHandleCharHelper(this.skipAlignmentMaskCheck, this.be, this.length, this.alignmentMask, true);
    }

    @Override
    public MemoryAccessVarHandleCharHelper withInvokeBehavior() {
        return !this.hasInvokeExactBehavior() ? this : new MemoryAccessVarHandleCharHelper(this.skipAlignmentMaskCheck, this.be, this.length, this.alignmentMask, false);
    }

    @ForceInline
    static char convEndian(boolean big, char n) {
        return big == BE ? n : Character.reverseBytes(n);
    }

    @ForceInline
    static MemorySegmentProxy checkAddress(Object obb, long offset, long length, boolean ro) {
        MemorySegmentProxy oo = (MemorySegmentProxy)Objects.requireNonNull(obb);
        oo.checkAccess(offset, length, ro);
        return oo;
    }

    @ForceInline
    static long offset(boolean skipAlignmentMaskCheck, MemorySegmentProxy bb, long offset, long alignmentMask) {
        long address = MemoryAccessVarHandleCharHelper.offsetNoVMAlignCheck(skipAlignmentMaskCheck, bb, offset, alignmentMask);
        if ((address & 1L) != 0L) {
            throw MemoryAccessVarHandleBase.newIllegalStateExceptionForMisalignedAccess(address);
        }
        return address;
    }

    @ForceInline
    static long offsetNoVMAlignCheck(boolean skipAlignmentMaskCheck, MemorySegmentProxy bb, long offset, long alignmentMask) {
        long base = bb.unsafeGetOffset();
        long address = base + offset;
        if (skipAlignmentMaskCheck ? (base & alignmentMask) != 0L : (address & alignmentMask) != 0L) {
            throw MemoryAccessVarHandleBase.newIllegalStateExceptionForMisalignedAccess(address);
        }
        return address;
    }

    @ForceInline
    static char get(VarHandle ob, Object obb, long base) {
        MemoryAccessVarHandleBase handle = (MemoryAccessVarHandleBase)ob;
        MemorySegmentProxy bb = MemoryAccessVarHandleCharHelper.checkAddress(obb, base, handle.length, true);
        return SCOPED_MEMORY_ACCESS.getCharUnaligned(bb.scope(), bb.unsafeGetBase(), MemoryAccessVarHandleCharHelper.offsetNoVMAlignCheck(handle.skipAlignmentMaskCheck, bb, base, handle.alignmentMask), handle.be);
    }

    @ForceInline
    static void set(VarHandle ob, Object obb, long base, char value) {
        MemoryAccessVarHandleBase handle = (MemoryAccessVarHandleBase)ob;
        MemorySegmentProxy bb = MemoryAccessVarHandleCharHelper.checkAddress(obb, base, handle.length, false);
        SCOPED_MEMORY_ACCESS.putCharUnaligned(bb.scope(), bb.unsafeGetBase(), MemoryAccessVarHandleCharHelper.offsetNoVMAlignCheck(handle.skipAlignmentMaskCheck, bb, base, handle.alignmentMask), value, handle.be);
    }

    @ForceInline
    static char getVolatile(VarHandle ob, Object obb, long base) {
        MemoryAccessVarHandleBase handle = (MemoryAccessVarHandleBase)ob;
        MemorySegmentProxy bb = MemoryAccessVarHandleCharHelper.checkAddress(obb, base, handle.length, true);
        return MemoryAccessVarHandleCharHelper.convEndian(handle.be, SCOPED_MEMORY_ACCESS.getCharVolatile(bb.scope(), bb.unsafeGetBase(), MemoryAccessVarHandleCharHelper.offset(handle.skipAlignmentMaskCheck, bb, base, handle.alignmentMask)));
    }

    @ForceInline
    static void setVolatile(VarHandle ob, Object obb, long base, char value) {
        MemoryAccessVarHandleBase handle = (MemoryAccessVarHandleBase)ob;
        MemorySegmentProxy bb = MemoryAccessVarHandleCharHelper.checkAddress(obb, base, handle.length, false);
        SCOPED_MEMORY_ACCESS.putCharVolatile(bb.scope(), bb.unsafeGetBase(), MemoryAccessVarHandleCharHelper.offset(handle.skipAlignmentMaskCheck, bb, base, handle.alignmentMask), MemoryAccessVarHandleCharHelper.convEndian(handle.be, value));
    }

    @ForceInline
    static char getAcquire(VarHandle ob, Object obb, long base) {
        MemoryAccessVarHandleBase handle = (MemoryAccessVarHandleBase)ob;
        MemorySegmentProxy bb = MemoryAccessVarHandleCharHelper.checkAddress(obb, base, handle.length, true);
        return MemoryAccessVarHandleCharHelper.convEndian(handle.be, SCOPED_MEMORY_ACCESS.getCharAcquire(bb.scope(), bb.unsafeGetBase(), MemoryAccessVarHandleCharHelper.offset(handle.skipAlignmentMaskCheck, bb, base, handle.alignmentMask)));
    }

    @ForceInline
    static void setRelease(VarHandle ob, Object obb, long base, char value) {
        MemoryAccessVarHandleBase handle = (MemoryAccessVarHandleBase)ob;
        MemorySegmentProxy bb = MemoryAccessVarHandleCharHelper.checkAddress(obb, base, handle.length, false);
        SCOPED_MEMORY_ACCESS.putCharRelease(bb.scope(), bb.unsafeGetBase(), MemoryAccessVarHandleCharHelper.offset(handle.skipAlignmentMaskCheck, bb, base, handle.alignmentMask), MemoryAccessVarHandleCharHelper.convEndian(handle.be, value));
    }

    @ForceInline
    static char getOpaque(VarHandle ob, Object obb, long base) {
        MemoryAccessVarHandleBase handle = (MemoryAccessVarHandleBase)ob;
        MemorySegmentProxy bb = MemoryAccessVarHandleCharHelper.checkAddress(obb, base, handle.length, true);
        return MemoryAccessVarHandleCharHelper.convEndian(handle.be, SCOPED_MEMORY_ACCESS.getCharOpaque(bb.scope(), bb.unsafeGetBase(), MemoryAccessVarHandleCharHelper.offset(handle.skipAlignmentMaskCheck, bb, base, handle.alignmentMask)));
    }

    @ForceInline
    static void setOpaque(VarHandle ob, Object obb, long base, char value) {
        MemoryAccessVarHandleBase handle = (MemoryAccessVarHandleBase)ob;
        MemorySegmentProxy bb = MemoryAccessVarHandleCharHelper.checkAddress(obb, base, handle.length, false);
        SCOPED_MEMORY_ACCESS.putCharOpaque(bb.scope(), bb.unsafeGetBase(), MemoryAccessVarHandleCharHelper.offset(handle.skipAlignmentMaskCheck, bb, base, handle.alignmentMask), MemoryAccessVarHandleCharHelper.convEndian(handle.be, value));
    }
}

