/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MemoryAccessVarHandleBase;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarForm;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import jdk.internal.access.foreign.MemorySegmentProxy;
import jdk.internal.misc.ScopedMemoryAccess;
import jdk.internal.vm.annotation.ForceInline;

final class MemoryAccessVarHandleFloatHelper
extends MemoryAccessVarHandleBase {
    static final boolean BE = MethodHandleStatics.UNSAFE.isBigEndian();
    static final ScopedMemoryAccess SCOPED_MEMORY_ACCESS = ScopedMemoryAccess.getScopedMemoryAccess();
    static final int VM_ALIGN = 3;
    static final VarForm FORM = new VarForm(MemoryAccessVarHandleFloatHelper.class, MemorySegmentProxy.class, Float.TYPE, Long.TYPE);

    MemoryAccessVarHandleFloatHelper(boolean skipAlignmentMaskCheck, boolean be, long length, long alignmentMask, boolean exact) {
        super(FORM, skipAlignmentMaskCheck, be, length, alignmentMask, exact);
    }

    @Override
    final MethodType accessModeTypeUncached(VarHandle.AccessType accessType) {
        return accessType.accessModeType(MemorySegmentProxy.class, Float.TYPE, Long.TYPE);
    }

    @Override
    public MemoryAccessVarHandleFloatHelper withInvokeExactBehavior() {
        return this.hasInvokeExactBehavior() ? this : new MemoryAccessVarHandleFloatHelper(this.skipAlignmentMaskCheck, this.be, this.length, this.alignmentMask, true);
    }

    @Override
    public MemoryAccessVarHandleFloatHelper withInvokeBehavior() {
        return !this.hasInvokeExactBehavior() ? this : new MemoryAccessVarHandleFloatHelper(this.skipAlignmentMaskCheck, this.be, this.length, this.alignmentMask, false);
    }

    @ForceInline
    static int convEndian(boolean big, float v) {
        int rv = Float.floatToRawIntBits(v);
        return big == BE ? rv : Integer.reverseBytes(rv);
    }

    @ForceInline
    static float convEndian(boolean big, int rv) {
        rv = big == BE ? rv : Integer.reverseBytes(rv);
        return Float.intBitsToFloat(rv);
    }

    @ForceInline
    static MemorySegmentProxy checkAddress(Object obb, long offset, long length, boolean ro) {
        MemorySegmentProxy oo = (MemorySegmentProxy)Objects.requireNonNull(obb);
        oo.checkAccess(offset, length, ro);
        return oo;
    }

    @ForceInline
    static long offset(boolean skipAlignmentMaskCheck, MemorySegmentProxy bb, long offset, long alignmentMask) {
        long address = MemoryAccessVarHandleFloatHelper.offsetNoVMAlignCheck(skipAlignmentMaskCheck, bb, offset, alignmentMask);
        if ((address & 3L) != 0L) {
            throw MemoryAccessVarHandleBase.newIllegalStateExceptionForMisalignedAccess(address);
        }
        return address;
    }

    @ForceInline
    static long offsetNoVMAlignCheck(boolean skipAlignmentMaskCheck, MemorySegmentProxy bb, long offset, long alignmentMask) {
        long base = bb.unsafeGetOffset();
        long address = base + offset;
        if (skipAlignmentMaskCheck ? (base & alignmentMask) != 0L : (address & alignmentMask) != 0L) {
            throw MemoryAccessVarHandleBase.newIllegalStateExceptionForMisalignedAccess(address);
        }
        return address;
    }

    @ForceInline
    static float get(VarHandle ob, Object obb, long base) {
        MemoryAccessVarHandleBase handle = (MemoryAccessVarHandleBase)ob;
        MemorySegmentProxy bb = MemoryAccessVarHandleFloatHelper.checkAddress(obb, base, handle.length, true);
        int rawValue = SCOPED_MEMORY_ACCESS.getIntUnaligned(bb.scope(), bb.unsafeGetBase(), MemoryAccessVarHandleFloatHelper.offsetNoVMAlignCheck(handle.skipAlignmentMaskCheck, bb, base, handle.alignmentMask), handle.be);
        return Float.intBitsToFloat(rawValue);
    }

    @ForceInline
    static void set(VarHandle ob, Object obb, long base, float value) {
        MemoryAccessVarHandleBase handle = (MemoryAccessVarHandleBase)ob;
        MemorySegmentProxy bb = MemoryAccessVarHandleFloatHelper.checkAddress(obb, base, handle.length, false);
        SCOPED_MEMORY_ACCESS.putIntUnaligned(bb.scope(), bb.unsafeGetBase(), MemoryAccessVarHandleFloatHelper.offsetNoVMAlignCheck(handle.skipAlignmentMaskCheck, bb, base, handle.alignmentMask), Float.floatToRawIntBits(value), handle.be);
    }

    @ForceInline
    static float getVolatile(VarHandle ob, Object obb, long base) {
        MemoryAccessVarHandleBase handle = (MemoryAccessVarHandleBase)ob;
        MemorySegmentProxy bb = MemoryAccessVarHandleFloatHelper.checkAddress(obb, base, handle.length, true);
        return MemoryAccessVarHandleFloatHelper.convEndian(handle.be, SCOPED_MEMORY_ACCESS.getIntVolatile(bb.scope(), bb.unsafeGetBase(), MemoryAccessVarHandleFloatHelper.offset(handle.skipAlignmentMaskCheck, bb, base, handle.alignmentMask)));
    }

    @ForceInline
    static void setVolatile(VarHandle ob, Object obb, long base, float value) {
        MemoryAccessVarHandleBase handle = (MemoryAccessVarHandleBase)ob;
        MemorySegmentProxy bb = MemoryAccessVarHandleFloatHelper.checkAddress(obb, base, handle.length, false);
        SCOPED_MEMORY_ACCESS.putIntVolatile(bb.scope(), bb.unsafeGetBase(), MemoryAccessVarHandleFloatHelper.offset(handle.skipAlignmentMaskCheck, bb, base, handle.alignmentMask), MemoryAccessVarHandleFloatHelper.convEndian(handle.be, value));
    }

    @ForceInline
    static float getAcquire(VarHandle ob, Object obb, long base) {
        MemoryAccessVarHandleBase handle = (MemoryAccessVarHandleBase)ob;
        MemorySegmentProxy bb = MemoryAccessVarHandleFloatHelper.checkAddress(obb, base, handle.length, true);
        return MemoryAccessVarHandleFloatHelper.convEndian(handle.be, SCOPED_MEMORY_ACCESS.getIntAcquire(bb.scope(), bb.unsafeGetBase(), MemoryAccessVarHandleFloatHelper.offset(handle.skipAlignmentMaskCheck, bb, base, handle.alignmentMask)));
    }

    @ForceInline
    static void setRelease(VarHandle ob, Object obb, long base, float value) {
        MemoryAccessVarHandleBase handle = (MemoryAccessVarHandleBase)ob;
        MemorySegmentProxy bb = MemoryAccessVarHandleFloatHelper.checkAddress(obb, base, handle.length, false);
        SCOPED_MEMORY_ACCESS.putIntRelease(bb.scope(), bb.unsafeGetBase(), MemoryAccessVarHandleFloatHelper.offset(handle.skipAlignmentMaskCheck, bb, base, handle.alignmentMask), MemoryAccessVarHandleFloatHelper.convEndian(handle.be, value));
    }

    @ForceInline
    static float getOpaque(VarHandle ob, Object obb, long base) {
        MemoryAccessVarHandleBase handle = (MemoryAccessVarHandleBase)ob;
        MemorySegmentProxy bb = MemoryAccessVarHandleFloatHelper.checkAddress(obb, base, handle.length, true);
        return MemoryAccessVarHandleFloatHelper.convEndian(handle.be, SCOPED_MEMORY_ACCESS.getIntOpaque(bb.scope(), bb.unsafeGetBase(), MemoryAccessVarHandleFloatHelper.offset(handle.skipAlignmentMaskCheck, bb, base, handle.alignmentMask)));
    }

    @ForceInline
    static void setOpaque(VarHandle ob, Object obb, long base, float value) {
        MemoryAccessVarHandleBase handle = (MemoryAccessVarHandleBase)ob;
        MemorySegmentProxy bb = MemoryAccessVarHandleFloatHelper.checkAddress(obb, base, handle.length, false);
        SCOPED_MEMORY_ACCESS.putIntOpaque(bb.scope(), bb.unsafeGetBase(), MemoryAccessVarHandleFloatHelper.offset(handle.skipAlignmentMaskCheck, bb, base, handle.alignmentMask), MemoryAccessVarHandleFloatHelper.convEndian(handle.be, value));
    }

    @ForceInline
    static boolean compareAndSet(VarHandle ob, Object obb, long base, float expected, float value) {
        MemoryAccessVarHandleBase handle = (MemoryAccessVarHandleBase)ob;
        MemorySegmentProxy bb = MemoryAccessVarHandleFloatHelper.checkAddress(obb, base, handle.length, false);
        return SCOPED_MEMORY_ACCESS.compareAndSetInt(bb.scope(), bb.unsafeGetBase(), MemoryAccessVarHandleFloatHelper.offset(handle.skipAlignmentMaskCheck, bb, base, handle.alignmentMask), MemoryAccessVarHandleFloatHelper.convEndian(handle.be, expected), MemoryAccessVarHandleFloatHelper.convEndian(handle.be, value));
    }

    @ForceInline
    static float compareAndExchange(VarHandle ob, Object obb, long base, float expected, float value) {
        MemoryAccessVarHandleBase handle = (MemoryAccessVarHandleBase)ob;
        MemorySegmentProxy bb = MemoryAccessVarHandleFloatHelper.checkAddress(obb, base, handle.length, false);
        return MemoryAccessVarHandleFloatHelper.convEndian(handle.be, SCOPED_MEMORY_ACCESS.compareAndExchangeInt(bb.scope(), bb.unsafeGetBase(), MemoryAccessVarHandleFloatHelper.offset(handle.skipAlignmentMaskCheck, bb, base, handle.alignmentMask), MemoryAccessVarHandleFloatHelper.convEndian(handle.be, expected), MemoryAccessVarHandleFloatHelper.convEndian(handle.be, value)));
    }

    @ForceInline
    static float compareAndExchangeAcquire(VarHandle ob, Object obb, long base, float expected, float value) {
        MemoryAccessVarHandleBase handle = (MemoryAccessVarHandleBase)ob;
        MemorySegmentProxy bb = MemoryAccessVarHandleFloatHelper.checkAddress(obb, base, handle.length, false);
        return MemoryAccessVarHandleFloatHelper.convEndian(handle.be, SCOPED_MEMORY_ACCESS.compareAndExchangeIntAcquire(bb.scope(), bb.unsafeGetBase(), MemoryAccessVarHandleFloatHelper.offset(handle.skipAlignmentMaskCheck, bb, base, handle.alignmentMask), MemoryAccessVarHandleFloatHelper.convEndian(handle.be, expected), MemoryAccessVarHandleFloatHelper.convEndian(handle.be, value)));
    }

    @ForceInline
    static float compareAndExchangeRelease(VarHandle ob, Object obb, long base, float expected, float value) {
        MemoryAccessVarHandleBase handle = (MemoryAccessVarHandleBase)ob;
        MemorySegmentProxy bb = MemoryAccessVarHandleFloatHelper.checkAddress(obb, base, handle.length, false);
        return MemoryAccessVarHandleFloatHelper.convEndian(handle.be, SCOPED_MEMORY_ACCESS.compareAndExchangeIntRelease(bb.scope(), bb.unsafeGetBase(), MemoryAccessVarHandleFloatHelper.offset(handle.skipAlignmentMaskCheck, bb, base, handle.alignmentMask), MemoryAccessVarHandleFloatHelper.convEndian(handle.be, expected), MemoryAccessVarHandleFloatHelper.convEndian(handle.be, value)));
    }

    @ForceInline
    static boolean weakCompareAndSetPlain(VarHandle ob, Object obb, long base, float expected, float value) {
        MemoryAccessVarHandleBase handle = (MemoryAccessVarHandleBase)ob;
        MemorySegmentProxy bb = MemoryAccessVarHandleFloatHelper.checkAddress(obb, base, handle.length, false);
        return SCOPED_MEMORY_ACCESS.weakCompareAndSetIntPlain(bb.scope(), bb.unsafeGetBase(), MemoryAccessVarHandleFloatHelper.offset(handle.skipAlignmentMaskCheck, bb, base, handle.alignmentMask), MemoryAccessVarHandleFloatHelper.convEndian(handle.be, expected), MemoryAccessVarHandleFloatHelper.convEndian(handle.be, value));
    }

    @ForceInline
    static boolean weakCompareAndSet(VarHandle ob, Object obb, long base, float expected, float value) {
        MemoryAccessVarHandleBase handle = (MemoryAccessVarHandleBase)ob;
        MemorySegmentProxy bb = MemoryAccessVarHandleFloatHelper.checkAddress(obb, base, handle.length, false);
        return SCOPED_MEMORY_ACCESS.weakCompareAndSetInt(bb.scope(), bb.unsafeGetBase(), MemoryAccessVarHandleFloatHelper.offset(handle.skipAlignmentMaskCheck, bb, base, handle.alignmentMask), MemoryAccessVarHandleFloatHelper.convEndian(handle.be, expected), MemoryAccessVarHandleFloatHelper.convEndian(handle.be, value));
    }

    @ForceInline
    static boolean weakCompareAndSetAcquire(VarHandle ob, Object obb, long base, float expected, float value) {
        MemoryAccessVarHandleBase handle = (MemoryAccessVarHandleBase)ob;
        MemorySegmentProxy bb = MemoryAccessVarHandleFloatHelper.checkAddress(obb, base, handle.length, false);
        return SCOPED_MEMORY_ACCESS.weakCompareAndSetIntAcquire(bb.scope(), bb.unsafeGetBase(), MemoryAccessVarHandleFloatHelper.offset(handle.skipAlignmentMaskCheck, bb, base, handle.alignmentMask), MemoryAccessVarHandleFloatHelper.convEndian(handle.be, expected), MemoryAccessVarHandleFloatHelper.convEndian(handle.be, value));
    }

    @ForceInline
    static boolean weakCompareAndSetRelease(VarHandle ob, Object obb, long base, float expected, float value) {
        MemoryAccessVarHandleBase handle = (MemoryAccessVarHandleBase)ob;
        MemorySegmentProxy bb = MemoryAccessVarHandleFloatHelper.checkAddress(obb, base, handle.length, false);
        return SCOPED_MEMORY_ACCESS.weakCompareAndSetIntRelease(bb.scope(), bb.unsafeGetBase(), MemoryAccessVarHandleFloatHelper.offset(handle.skipAlignmentMaskCheck, bb, base, handle.alignmentMask), MemoryAccessVarHandleFloatHelper.convEndian(handle.be, expected), MemoryAccessVarHandleFloatHelper.convEndian(handle.be, value));
    }

    @ForceInline
    static float getAndSet(VarHandle ob, Object obb, long base, float value) {
        MemoryAccessVarHandleBase handle = (MemoryAccessVarHandleBase)ob;
        MemorySegmentProxy bb = MemoryAccessVarHandleFloatHelper.checkAddress(obb, base, handle.length, false);
        return MemoryAccessVarHandleFloatHelper.convEndian(handle.be, SCOPED_MEMORY_ACCESS.getAndSetInt(bb.scope(), bb.unsafeGetBase(), MemoryAccessVarHandleFloatHelper.offset(handle.skipAlignmentMaskCheck, bb, base, handle.alignmentMask), MemoryAccessVarHandleFloatHelper.convEndian(handle.be, value)));
    }

    @ForceInline
    static float getAndSetAcquire(VarHandle ob, Object obb, long base, float value) {
        MemoryAccessVarHandleBase handle = (MemoryAccessVarHandleBase)ob;
        MemorySegmentProxy bb = MemoryAccessVarHandleFloatHelper.checkAddress(obb, base, handle.length, false);
        return MemoryAccessVarHandleFloatHelper.convEndian(handle.be, SCOPED_MEMORY_ACCESS.getAndSetIntAcquire(bb.scope(), bb.unsafeGetBase(), MemoryAccessVarHandleFloatHelper.offset(handle.skipAlignmentMaskCheck, bb, base, handle.alignmentMask), MemoryAccessVarHandleFloatHelper.convEndian(handle.be, value)));
    }

    @ForceInline
    static float getAndSetRelease(VarHandle ob, Object obb, long base, float value) {
        MemoryAccessVarHandleBase handle = (MemoryAccessVarHandleBase)ob;
        MemorySegmentProxy bb = MemoryAccessVarHandleFloatHelper.checkAddress(obb, base, handle.length, false);
        return MemoryAccessVarHandleFloatHelper.convEndian(handle.be, SCOPED_MEMORY_ACCESS.getAndSetIntRelease(bb.scope(), bb.unsafeGetBase(), MemoryAccessVarHandleFloatHelper.offset(handle.skipAlignmentMaskCheck, bb, base, handle.alignmentMask), MemoryAccessVarHandleFloatHelper.convEndian(handle.be, value)));
    }
}

