/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MemoryAccessVarHandleBase;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarForm;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import jdk.internal.access.foreign.MemorySegmentProxy;
import jdk.internal.misc.ScopedMemoryAccess;
import jdk.internal.vm.annotation.ForceInline;

final class MemoryAccessVarHandleShortHelper
extends MemoryAccessVarHandleBase {
    static final boolean BE = MethodHandleStatics.UNSAFE.isBigEndian();
    static final ScopedMemoryAccess SCOPED_MEMORY_ACCESS = ScopedMemoryAccess.getScopedMemoryAccess();
    static final int VM_ALIGN = 1;
    static final VarForm FORM = new VarForm(MemoryAccessVarHandleShortHelper.class, MemorySegmentProxy.class, Short.TYPE, Long.TYPE);

    MemoryAccessVarHandleShortHelper(boolean skipAlignmentMaskCheck, boolean be, long length, long alignmentMask, boolean exact) {
        super(FORM, skipAlignmentMaskCheck, be, length, alignmentMask, exact);
    }

    @Override
    final MethodType accessModeTypeUncached(VarHandle.AccessType accessType) {
        return accessType.accessModeType(MemorySegmentProxy.class, Short.TYPE, Long.TYPE);
    }

    @Override
    public MemoryAccessVarHandleShortHelper withInvokeExactBehavior() {
        return this.hasInvokeExactBehavior() ? this : new MemoryAccessVarHandleShortHelper(this.skipAlignmentMaskCheck, this.be, this.length, this.alignmentMask, true);
    }

    @Override
    public MemoryAccessVarHandleShortHelper withInvokeBehavior() {
        return !this.hasInvokeExactBehavior() ? this : new MemoryAccessVarHandleShortHelper(this.skipAlignmentMaskCheck, this.be, this.length, this.alignmentMask, false);
    }

    @ForceInline
    static short convEndian(boolean big, short n) {
        return big == BE ? n : Short.reverseBytes(n);
    }

    @ForceInline
    static MemorySegmentProxy checkAddress(Object obb, long offset, long length, boolean ro) {
        MemorySegmentProxy oo = (MemorySegmentProxy)Objects.requireNonNull(obb);
        oo.checkAccess(offset, length, ro);
        return oo;
    }

    @ForceInline
    static long offset(boolean skipAlignmentMaskCheck, MemorySegmentProxy bb, long offset, long alignmentMask) {
        long address = MemoryAccessVarHandleShortHelper.offsetNoVMAlignCheck(skipAlignmentMaskCheck, bb, offset, alignmentMask);
        if ((address & 1L) != 0L) {
            throw MemoryAccessVarHandleBase.newIllegalStateExceptionForMisalignedAccess(address);
        }
        return address;
    }

    @ForceInline
    static long offsetNoVMAlignCheck(boolean skipAlignmentMaskCheck, MemorySegmentProxy bb, long offset, long alignmentMask) {
        long base = bb.unsafeGetOffset();
        long address = base + offset;
        if (skipAlignmentMaskCheck ? (base & alignmentMask) != 0L : (address & alignmentMask) != 0L) {
            throw MemoryAccessVarHandleBase.newIllegalStateExceptionForMisalignedAccess(address);
        }
        return address;
    }

    @ForceInline
    static short get(VarHandle ob, Object obb, long base) {
        MemoryAccessVarHandleBase handle = (MemoryAccessVarHandleBase)ob;
        MemorySegmentProxy bb = MemoryAccessVarHandleShortHelper.checkAddress(obb, base, handle.length, true);
        return SCOPED_MEMORY_ACCESS.getShortUnaligned(bb.scope(), bb.unsafeGetBase(), MemoryAccessVarHandleShortHelper.offsetNoVMAlignCheck(handle.skipAlignmentMaskCheck, bb, base, handle.alignmentMask), handle.be);
    }

    @ForceInline
    static void set(VarHandle ob, Object obb, long base, short value) {
        MemoryAccessVarHandleBase handle = (MemoryAccessVarHandleBase)ob;
        MemorySegmentProxy bb = MemoryAccessVarHandleShortHelper.checkAddress(obb, base, handle.length, false);
        SCOPED_MEMORY_ACCESS.putShortUnaligned(bb.scope(), bb.unsafeGetBase(), MemoryAccessVarHandleShortHelper.offsetNoVMAlignCheck(handle.skipAlignmentMaskCheck, bb, base, handle.alignmentMask), value, handle.be);
    }

    @ForceInline
    static short getVolatile(VarHandle ob, Object obb, long base) {
        MemoryAccessVarHandleBase handle = (MemoryAccessVarHandleBase)ob;
        MemorySegmentProxy bb = MemoryAccessVarHandleShortHelper.checkAddress(obb, base, handle.length, true);
        return MemoryAccessVarHandleShortHelper.convEndian(handle.be, SCOPED_MEMORY_ACCESS.getShortVolatile(bb.scope(), bb.unsafeGetBase(), MemoryAccessVarHandleShortHelper.offset(handle.skipAlignmentMaskCheck, bb, base, handle.alignmentMask)));
    }

    @ForceInline
    static void setVolatile(VarHandle ob, Object obb, long base, short value) {
        MemoryAccessVarHandleBase handle = (MemoryAccessVarHandleBase)ob;
        MemorySegmentProxy bb = MemoryAccessVarHandleShortHelper.checkAddress(obb, base, handle.length, false);
        SCOPED_MEMORY_ACCESS.putShortVolatile(bb.scope(), bb.unsafeGetBase(), MemoryAccessVarHandleShortHelper.offset(handle.skipAlignmentMaskCheck, bb, base, handle.alignmentMask), MemoryAccessVarHandleShortHelper.convEndian(handle.be, value));
    }

    @ForceInline
    static short getAcquire(VarHandle ob, Object obb, long base) {
        MemoryAccessVarHandleBase handle = (MemoryAccessVarHandleBase)ob;
        MemorySegmentProxy bb = MemoryAccessVarHandleShortHelper.checkAddress(obb, base, handle.length, true);
        return MemoryAccessVarHandleShortHelper.convEndian(handle.be, SCOPED_MEMORY_ACCESS.getShortAcquire(bb.scope(), bb.unsafeGetBase(), MemoryAccessVarHandleShortHelper.offset(handle.skipAlignmentMaskCheck, bb, base, handle.alignmentMask)));
    }

    @ForceInline
    static void setRelease(VarHandle ob, Object obb, long base, short value) {
        MemoryAccessVarHandleBase handle = (MemoryAccessVarHandleBase)ob;
        MemorySegmentProxy bb = MemoryAccessVarHandleShortHelper.checkAddress(obb, base, handle.length, false);
        SCOPED_MEMORY_ACCESS.putShortRelease(bb.scope(), bb.unsafeGetBase(), MemoryAccessVarHandleShortHelper.offset(handle.skipAlignmentMaskCheck, bb, base, handle.alignmentMask), MemoryAccessVarHandleShortHelper.convEndian(handle.be, value));
    }

    @ForceInline
    static short getOpaque(VarHandle ob, Object obb, long base) {
        MemoryAccessVarHandleBase handle = (MemoryAccessVarHandleBase)ob;
        MemorySegmentProxy bb = MemoryAccessVarHandleShortHelper.checkAddress(obb, base, handle.length, true);
        return MemoryAccessVarHandleShortHelper.convEndian(handle.be, SCOPED_MEMORY_ACCESS.getShortOpaque(bb.scope(), bb.unsafeGetBase(), MemoryAccessVarHandleShortHelper.offset(handle.skipAlignmentMaskCheck, bb, base, handle.alignmentMask)));
    }

    @ForceInline
    static void setOpaque(VarHandle ob, Object obb, long base, short value) {
        MemoryAccessVarHandleBase handle = (MemoryAccessVarHandleBase)ob;
        MemorySegmentProxy bb = MemoryAccessVarHandleShortHelper.checkAddress(obb, base, handle.length, false);
        SCOPED_MEMORY_ACCESS.putShortOpaque(bb.scope(), bb.unsafeGetBase(), MemoryAccessVarHandleShortHelper.offset(handle.skipAlignmentMaskCheck, bb, base, handle.alignmentMask), MemoryAccessVarHandleShortHelper.convEndian(handle.be, value));
    }
}

