/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.constant.ClassDesc;
import java.lang.constant.Constable;
import java.lang.constant.DirectMethodHandleDesc;
import java.lang.constant.MethodHandleDesc;
import java.lang.constant.MethodTypeDesc;
import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.LambdaForm;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandleImpl;
import java.lang.invoke.MethodHandleInfo;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.invoke.WrongMethodTypeException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import jdk.internal.vm.annotation.IntrinsicCandidate;

public abstract class MethodHandle
implements Constable {
    private final MethodType type;
    final LambdaForm form;
    MethodHandle asTypeCache;
    private byte customizationCount;
    private volatile boolean updateInProgress;
    private static final long FORM_OFFSET = MethodHandleStatics.UNSAFE.objectFieldOffset(MethodHandle.class, "form");
    private static final long UPDATE_OFFSET = MethodHandleStatics.UNSAFE.objectFieldOffset(MethodHandle.class, "updateInProgress");

    public MethodType type() {
        return this.type;
    }

    MethodHandle(MethodType type, LambdaForm form) {
        this.type = Objects.requireNonNull(type);
        this.form = Objects.requireNonNull(form).uncustomize();
        this.form.prepare();
    }

    @IntrinsicCandidate
    @PolymorphicSignature
    public final native Object invokeExact(Object ... var1) throws Throwable;

    @IntrinsicCandidate
    @PolymorphicSignature
    public final native Object invoke(Object ... var1) throws Throwable;

    @IntrinsicCandidate
    @PolymorphicSignature
    final native Object invokeBasic(Object ... var1) throws Throwable;

    @IntrinsicCandidate
    @PolymorphicSignature
    static native Object linkToVirtual(Object ... var0) throws Throwable;

    @IntrinsicCandidate
    @PolymorphicSignature
    static native Object linkToStatic(Object ... var0) throws Throwable;

    @IntrinsicCandidate
    @PolymorphicSignature
    static native Object linkToSpecial(Object ... var0) throws Throwable;

    @IntrinsicCandidate
    @PolymorphicSignature
    static native Object linkToInterface(Object ... var0) throws Throwable;

    @IntrinsicCandidate
    @PolymorphicSignature
    static native Object linkToNative(Object ... var0) throws Throwable;

    public Object invokeWithArguments(Object ... arguments) throws Throwable {
        MethodType invocationType = MethodType.genericMethodType(arguments == null ? 0 : arguments.length);
        return invocationType.invokers().spreadInvoker(0).invokeExact(this.asType(invocationType), arguments);
    }

    public Object invokeWithArguments(List<?> arguments) throws Throwable {
        return this.invokeWithArguments(arguments.toArray());
    }

    public MethodHandle asType(MethodType newType) {
        if (newType == this.type) {
            return this;
        }
        MethodHandle atc = this.asTypeCached(newType);
        if (atc != null) {
            return atc;
        }
        return this.asTypeUncached(newType);
    }

    private MethodHandle asTypeCached(MethodType newType) {
        MethodHandle atc = this.asTypeCache;
        if (atc != null && newType == atc.type) {
            return atc;
        }
        return null;
    }

    MethodHandle asTypeUncached(MethodType newType) {
        if (!this.type.isConvertibleTo(newType)) {
            throw new WrongMethodTypeException("cannot convert " + this + " to " + newType);
        }
        this.asTypeCache = MethodHandleImpl.makePairwiseConvert(this, newType, true);
        return this.asTypeCache;
    }

    public MethodHandle asSpreader(Class<?> arrayType, int arrayLength) {
        return this.asSpreader(this.type().parameterCount() - arrayLength, arrayType, arrayLength);
    }

    public MethodHandle asSpreader(int spreadArgPos, Class<?> arrayType, int arrayLength) {
        MethodType postSpreadType = this.asSpreaderChecks(arrayType, spreadArgPos, arrayLength);
        MethodHandle afterSpread = this.asType(postSpreadType);
        BoundMethodHandle mh = afterSpread.rebind();
        LambdaForm lform = mh.editor().spreadArgumentsForm(1 + spreadArgPos, arrayType, arrayLength);
        MethodType preSpreadType = postSpreadType.replaceParameterTypes(spreadArgPos, spreadArgPos + arrayLength, arrayType);
        return mh.copyWith(preSpreadType, lform);
    }

    private MethodType asSpreaderChecks(Class<?> arrayType, int pos, int arrayLength) {
        this.spreadArrayChecks(arrayType, arrayLength);
        int nargs = this.type().parameterCount();
        if (nargs < arrayLength || arrayLength < 0) {
            throw MethodHandleStatics.newIllegalArgumentException("bad spread array length");
        }
        if (pos < 0 || pos + arrayLength > nargs) {
            throw MethodHandleStatics.newIllegalArgumentException("bad spread position");
        }
        Class<?> arrayElement = arrayType.getComponentType();
        MethodType mtype = this.type();
        boolean match = true;
        boolean fail = false;
        for (int i = pos; i < pos + arrayLength; ++i) {
            TypeDescriptor.OfField ptype = mtype.parameterType(i);
            if (ptype == arrayElement) continue;
            match = false;
            if (MethodType.canConvert(arrayElement, ptype)) continue;
            fail = true;
            break;
        }
        if (match) {
            return mtype;
        }
        MethodType needType = mtype.asSpreaderType(arrayType, pos, arrayLength);
        if (!fail) {
            return needType;
        }
        this.asType(needType);
        throw MethodHandleStatics.newInternalError("should not return");
    }

    private void spreadArrayChecks(Class<?> arrayType, int arrayLength) {
        Class<?> arrayElement = arrayType.getComponentType();
        if (arrayElement == null) {
            throw MethodHandleStatics.newIllegalArgumentException("not an array type", arrayType);
        }
        if ((arrayLength & 0x7F) != arrayLength) {
            if ((arrayLength & 0xFF) != arrayLength) {
                throw MethodHandleStatics.newIllegalArgumentException("array length is not legal", arrayLength);
            }
            assert (arrayLength >= 128);
            if (arrayElement == Long.TYPE || arrayElement == Double.TYPE) {
                throw MethodHandleStatics.newIllegalArgumentException("array length is not legal for long[] or double[]", arrayLength);
            }
        }
    }

    public MethodHandle withVarargs(boolean makeVarargs) {
        assert (!this.isVarargsCollector());
        if (makeVarargs) {
            return this.asVarargsCollector(this.type().lastParameterType());
        }
        return this;
    }

    public MethodHandle asCollector(Class<?> arrayType, int arrayLength) {
        return this.asCollector(this.type().parameterCount() - 1, arrayType, arrayLength);
    }

    public MethodHandle asCollector(int collectArgPos, Class<?> arrayType, int arrayLength) {
        this.asCollectorChecks(arrayType, collectArgPos, arrayLength);
        BoundMethodHandle mh = this.rebind();
        MethodType resultType = this.type().asCollectorType(arrayType, collectArgPos, arrayLength);
        MethodHandle collector = MethodHandleImpl.varargsArray(arrayType, arrayLength);
        LambdaForm lform = mh.editor().collectArgumentsForm(1 + collectArgPos, collector.type().basicType());
        return mh.copyWithExtendL(resultType, lform, collector);
    }

    boolean asCollectorChecks(Class<?> arrayType, int pos, int arrayLength) {
        this.spreadArrayChecks(arrayType, arrayLength);
        int nargs = this.type().parameterCount();
        if (pos < 0 || pos >= nargs) {
            throw MethodHandleStatics.newIllegalArgumentException("bad collect position");
        }
        if (nargs != 0) {
            TypeDescriptor.OfField param = this.type().parameterType(pos);
            if (param == arrayType) {
                return true;
            }
            if (((Class)param).isAssignableFrom(arrayType)) {
                return false;
            }
        }
        throw MethodHandleStatics.newIllegalArgumentException("array type not assignable to argument", this, arrayType);
    }

    public MethodHandle asVarargsCollector(Class<?> arrayType) {
        Objects.requireNonNull(arrayType);
        boolean lastMatch = this.asCollectorChecks(arrayType, this.type().parameterCount() - 1, 0);
        if (this.isVarargsCollector() && lastMatch) {
            return this;
        }
        return MethodHandleImpl.makeVarargsCollector(this, arrayType);
    }

    public boolean isVarargsCollector() {
        return false;
    }

    public MethodHandle asFixedArity() {
        assert (!this.isVarargsCollector());
        return this;
    }

    public MethodHandle bindTo(Object x) {
        x = this.type.leadingReferenceParameter().cast(x);
        return this.bindArgumentL(0, x);
    }

    public Optional<MethodHandleDesc> describeConstable() {
        String name;
        MethodTypeDesc type;
        ClassDesc owner;
        boolean isInterface;
        MethodHandleInfo info;
        try {
            info = MethodHandles.Lookup.IMPL_LOOKUP.revealDirect(this);
            isInterface = info.getDeclaringClass().isInterface();
            owner = info.getDeclaringClass().describeConstable().orElseThrow();
            type = info.getMethodType().describeConstable().orElseThrow();
            name = info.getName();
        }
        catch (Exception e) {
            return Optional.empty();
        }
        return switch (info.getReferenceKind()) {
            case 1 -> Optional.of(MethodHandleDesc.ofField(DirectMethodHandleDesc.Kind.GETTER, owner, name, type.returnType()));
            case 3 -> Optional.of(MethodHandleDesc.ofField(DirectMethodHandleDesc.Kind.SETTER, owner, name, type.parameterType(0)));
            case 2 -> Optional.of(MethodHandleDesc.ofField(DirectMethodHandleDesc.Kind.STATIC_GETTER, owner, name, type.returnType()));
            case 4 -> Optional.of(MethodHandleDesc.ofField(DirectMethodHandleDesc.Kind.STATIC_SETTER, owner, name, type.parameterType(0)));
            case 5 -> Optional.of(MethodHandleDesc.ofMethod(DirectMethodHandleDesc.Kind.VIRTUAL, owner, name, type));
            case 6 -> {
                if (isInterface) {
                    yield Optional.of(MethodHandleDesc.ofMethod(DirectMethodHandleDesc.Kind.INTERFACE_STATIC, owner, name, type));
                }
                yield Optional.of(MethodHandleDesc.ofMethod(DirectMethodHandleDesc.Kind.STATIC, owner, name, type));
            }
            case 7 -> {
                if (isInterface) {
                    yield Optional.of(MethodHandleDesc.ofMethod(DirectMethodHandleDesc.Kind.INTERFACE_SPECIAL, owner, name, type));
                }
                yield Optional.of(MethodHandleDesc.ofMethod(DirectMethodHandleDesc.Kind.SPECIAL, owner, name, type));
            }
            case 9 -> Optional.of(MethodHandleDesc.ofMethod(DirectMethodHandleDesc.Kind.INTERFACE_VIRTUAL, owner, name, type));
            case 8 -> Optional.of(MethodHandleDesc.ofMethod(DirectMethodHandleDesc.Kind.CONSTRUCTOR, owner, name, type));
            default -> Optional.empty();
        };
    }

    public String toString() {
        if (MethodHandleStatics.DEBUG_METHOD_HANDLE_NAMES) {
            return "MethodHandle" + this.debugString();
        }
        return this.standardString();
    }

    String standardString() {
        return "MethodHandle" + this.type;
    }

    String debugString() {
        return this.type + " : " + this.internalForm() + this.internalProperties();
    }

    BoundMethodHandle bindArgumentL(int pos, Object value) {
        return this.rebind().bindArgumentL(pos, value);
    }

    MethodHandle setVarargs(MemberName member) throws IllegalAccessException {
        if (!member.isVarargs()) {
            return this;
        }
        try {
            return this.withVarargs(true);
        }
        catch (IllegalArgumentException ex) {
            throw member.makeAccessException("cannot make variable arity", null);
        }
    }

    MethodHandle viewAsType(MethodType newType, boolean strict) {
        assert (this.viewAsTypeChecks(newType, strict));
        return this.copyWith(newType, this.form);
    }

    boolean viewAsTypeChecks(MethodType newType, boolean strict) {
        if (strict ? !$assertionsDisabled && !this.type().isViewableAs(newType, true) : !$assertionsDisabled && !this.type().basicType().isViewableAs(newType.basicType(), true)) {
            throw new AssertionError(Arrays.asList(this, newType));
        }
        return true;
    }

    LambdaForm internalForm() {
        return this.form;
    }

    MemberName internalMemberName() {
        return null;
    }

    Class<?> internalCallerClass() {
        return null;
    }

    MethodHandleImpl.Intrinsic intrinsicName() {
        return MethodHandleImpl.Intrinsic.NONE;
    }

    Object intrinsicData() {
        return null;
    }

    MethodHandle withInternalMemberName(MemberName member, boolean isInvokeSpecial) {
        if (member != null) {
            return MethodHandleImpl.makeWrappedMember(this, member, isInvokeSpecial);
        }
        if (this.internalMemberName() == null) {
            return this;
        }
        BoundMethodHandle result = this.rebind();
        assert (result.internalMemberName() == null);
        return result;
    }

    boolean isInvokeSpecial() {
        return false;
    }

    boolean isCrackable() {
        return false;
    }

    Object internalValues() {
        return null;
    }

    Object internalProperties() {
        return "";
    }

    abstract MethodHandle copyWith(MethodType var1, LambdaForm var2);

    abstract BoundMethodHandle rebind();

    void maybeCustomize() {
        if (this.form.customized == null) {
            byte count = this.customizationCount;
            if (count >= MethodHandleStatics.CUSTOMIZE_THRESHOLD) {
                this.customize();
            } else {
                this.customizationCount = (byte)(count + 1);
            }
        }
    }

    void customize() {
        this.updateForm(new Function<LambdaForm, LambdaForm>(){

            @Override
            public LambdaForm apply(LambdaForm oldForm) {
                return oldForm.customize(MethodHandle.this);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateForm(Function<LambdaForm, LambdaForm> updater) {
        if (MethodHandleStatics.UNSAFE.compareAndSetBoolean(this, UPDATE_OFFSET, false, true)) {
            try {
                LambdaForm oldForm = this.form;
                LambdaForm newForm = updater.apply(oldForm);
                if (oldForm != newForm) {
                    assert (newForm.customized == null || newForm.customized == this);
                    newForm.prepare();
                    MethodHandleStatics.UNSAFE.putReference(this, FORM_OFFSET, newForm);
                    MethodHandleStatics.UNSAFE.fullFence();
                }
            }
            finally {
                this.updateInProgress = false;
            }
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface PolymorphicSignature {
    }
}

