/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.DelegatingMethodHandle;
import java.lang.invoke.GenerateJLIClassesHelper;
import java.lang.invoke.InvokerBytecodeGenerator;
import java.lang.invoke.LambdaForm;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.NativeMethodHandle;
import java.lang.invoke.SimpleMethodHandle;
import java.lang.invoke.TypeDescriptor;
import java.lang.invoke.VarHandle;
import java.lang.invoke.VarHandles;
import java.lang.invoke.WrongMethodTypeException;
import java.lang.reflect.Array;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import jdk.internal.access.JavaLangInvokeAccess;
import jdk.internal.access.SharedSecrets;
import jdk.internal.invoke.NativeEntryPoint;
import jdk.internal.org.objectweb.asm.ClassWriter;
import jdk.internal.org.objectweb.asm.MethodVisitor;
import jdk.internal.reflect.CallerSensitive;
import jdk.internal.reflect.Reflection;
import jdk.internal.vm.annotation.ForceInline;
import jdk.internal.vm.annotation.Hidden;
import jdk.internal.vm.annotation.IntrinsicCandidate;
import jdk.internal.vm.annotation.Stable;
import sun.invoke.empty.Empty;
import sun.invoke.util.ValueConversions;
import sun.invoke.util.VerifyType;
import sun.invoke.util.Wrapper;

abstract class MethodHandleImpl {
    static MethodHandle[] FAKE_METHOD_HANDLE_INVOKE = new MethodHandle[2];
    @Stable
    private static final MethodHandle[] ARRAYS = new MethodHandle[MethodHandleStatics.MAX_ARITY + 1];
    static final int MAX_JVM_ARITY = 255;
    static final byte NF_checkSpreadArgument = 0;
    static final byte NF_guardWithCatch = 1;
    static final byte NF_throwException = 2;
    static final byte NF_tryFinally = 3;
    static final byte NF_loop = 4;
    static final byte NF_profileBoolean = 5;
    static final byte NF_tableSwitch = 6;
    static final byte NF_LIMIT = 7;
    @Stable
    private static final LambdaForm.NamedFunction[] NFS = new LambdaForm.NamedFunction[7];
    static final int MH_cast = 0;
    static final int MH_selectAlternative = 1;
    static final int MH_countedLoopPred = 2;
    static final int MH_countedLoopStep = 3;
    static final int MH_initIterator = 4;
    static final int MH_iteratePred = 5;
    static final int MH_iterateNext = 6;
    static final int MH_Array_newInstance = 7;
    static final int MH_LIMIT = 8;
    @Stable
    private static final MethodHandle[] HANDLES;

    MethodHandleImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MethodHandle makeArrayElementAccessor(Class<?> arrayClass, ArrayAccess access) {
        int cacheIndex;
        if (arrayClass == Object[].class) {
            return ArrayAccess.objectAccessor(access);
        }
        if (!arrayClass.isArray()) {
            throw MethodHandleStatics.newIllegalArgumentException("not an array: " + arrayClass);
        }
        MethodHandle[] cache = ArrayAccessor.TYPED_ACCESSORS.get(arrayClass);
        MethodHandle mh = cache[cacheIndex = ArrayAccess.cacheIndex(access)];
        if (mh != null) {
            return mh;
        }
        mh = ArrayAccessor.getAccessor(arrayClass, access);
        MethodType correctType = ArrayAccessor.correctType(arrayClass, access);
        if (mh.type() != correctType) {
            assert (mh.type().parameterType(0) == Object[].class);
            assert (access != ArrayAccess.SET || mh.type().parameterType(2) == Object.class);
            assert (access != ArrayAccess.GET || mh.type().returnType() == Object.class && ((Class)correctType.parameterType(0)).getComponentType() == correctType.returnType());
            mh = mh.viewAsType(correctType, false);
        }
        mh = MethodHandleImpl.makeIntrinsic(mh, ArrayAccess.intrinsic(access));
        MethodHandle[] methodHandleArray = cache;
        synchronized (cache) {
            if (cache[cacheIndex] == null) {
                cache[cacheIndex] = mh;
            } else {
                mh = cache[cacheIndex];
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return mh;
        }
    }

    static InternalError unmatchedArrayAccess(ArrayAccess a) {
        return MethodHandleStatics.newInternalError("should not reach here (unmatched ArrayAccess: " + (Object)((Object)a) + ")");
    }

    static MethodHandle makePairwiseConvert(MethodHandle target, MethodType srcType, boolean strict, boolean monobox) {
        MethodType dstType = target.type();
        if (srcType == dstType) {
            return target;
        }
        return MethodHandleImpl.makePairwiseConvertByEditor(target, srcType, strict, monobox);
    }

    private static int countNonNull(Object[] array) {
        int count = 0;
        if (array != null) {
            for (Object x : array) {
                if (x == null) continue;
                ++count;
            }
        }
        return count;
    }

    static MethodHandle makePairwiseConvertByEditor(MethodHandle target, MethodType srcType, boolean strict, boolean monobox) {
        boolean MH_RECEIVER_OFFSET = true;
        Object[] convSpecs = MethodHandleImpl.computeValueConversions(srcType, target.type(), strict, monobox);
        int convCount = MethodHandleImpl.countNonNull(convSpecs);
        if (convCount == 0) {
            return target.viewAsType(srcType, strict);
        }
        MethodType basicSrcType = srcType.basicType();
        MethodType midType = target.type().basicType();
        BoundMethodHandle mh = target.rebind();
        HashMap<Object, int[]> convSpecMap = new HashMap<Object, int[]>(4 * convCount / 3 + 1);
        for (int i = 0; i < convSpecs.length - 1; ++i) {
            Object convSpec = convSpecs[i];
            if (convSpec == null) continue;
            int[] positions = (int[])convSpecMap.get(convSpec);
            if (positions == null) {
                positions = new int[]{i + 1};
            } else {
                positions = Arrays.copyOf(positions, positions.length + 1);
                positions[positions.length - 1] = i + 1;
            }
            convSpecMap.put(convSpec, positions);
        }
        for (Map.Entry entry : convSpecMap.entrySet()) {
            Object convSpec = entry.getKey();
            MethodHandle fn = convSpec instanceof Class ? MethodHandleImpl.getConstantHandle(0).bindTo(convSpec) : (MethodHandle)convSpec;
            int[] positions = (int[])entry.getValue();
            TypeDescriptor.OfField newType = basicSrcType.parameterType(positions[0] - 1);
            LambdaForm.BasicType newBasicType = LambdaForm.BasicType.basicType(newType);
            if ((convCount -= positions.length) == 0) {
                midType = srcType;
            } else {
                Class[] ptypes = (Class[])midType.ptypes().clone();
                for (int pos : positions) {
                    ptypes[pos - 1] = newType;
                }
                midType = MethodType.makeImpl(midType.rtype(), ptypes, true);
            }
            LambdaForm form2 = positions.length > 1 ? mh.editor().filterRepeatedArgumentForm(newBasicType, positions) : mh.editor().filterArgumentForm(positions[0], newBasicType);
            mh = mh.copyWithExtendL(midType, form2, fn);
        }
        Object convSpec = convSpecs[convSpecs.length - 1];
        if (convSpec != null) {
            Object fn = convSpec instanceof Class ? (convSpec == Void.TYPE ? null : MethodHandleImpl.getConstantHandle(0).bindTo(convSpec)) : (MethodHandle)convSpec;
            TypeDescriptor.OfField newType = basicSrcType.returnType();
            assert (--convCount == 0);
            midType = srcType;
            if (fn != null) {
                mh = mh.rebind();
                form2 = mh.editor().filterReturnForm(LambdaForm.BasicType.basicType(newType), false);
                mh = mh.copyWithExtendL(midType, form2, fn);
            } else {
                form2 = mh.editor().filterReturnForm(LambdaForm.BasicType.basicType(newType), true);
                mh = mh.copyWith(midType, form2);
            }
        }
        assert (convCount == 0);
        assert (mh.type().equals((Object)srcType));
        return mh;
    }

    static Object[] computeValueConversions(MethodType srcType, MethodType dstType, boolean strict, boolean monobox) {
        int INARG_COUNT = srcType.parameterCount();
        Object[] convSpecs = null;
        for (int i = 0; i <= INARG_COUNT; ++i) {
            TypeDescriptor.OfField dst;
            boolean isRet = i == INARG_COUNT;
            TypeDescriptor.OfField src = isRet ? dstType.returnType() : srcType.parameterType(i);
            TypeDescriptor.OfField ofField = dst = isRet ? srcType.returnType() : dstType.parameterType(i);
            if (VerifyType.isNullConversion(src, dst, strict)) continue;
            if (convSpecs == null) {
                convSpecs = new Object[INARG_COUNT + 1];
            }
            convSpecs[i] = MethodHandleImpl.valueConversion(src, dst, strict, monobox);
        }
        return convSpecs;
    }

    static MethodHandle makePairwiseConvert(MethodHandle target, MethodType srcType, boolean strict) {
        return MethodHandleImpl.makePairwiseConvert(target, srcType, strict, false);
    }

    static Object valueConversion(Class<?> src, Class<?> dst, boolean strict, boolean monobox) {
        MethodHandle fn;
        assert (!VerifyType.isNullConversion(src, dst, strict));
        if (dst == Void.TYPE) {
            return dst;
        }
        if (src.isPrimitive()) {
            if (src == Void.TYPE) {
                return Void.TYPE;
            }
            if (dst.isPrimitive()) {
                fn = ValueConversions.convertPrimitive(src, dst);
            } else {
                Wrapper wsrc = Wrapper.forPrimitiveType(src);
                fn = ValueConversions.boxExact(wsrc);
                assert (fn.type().parameterType(0) == wsrc.primitiveType());
                assert (fn.type().returnType() == wsrc.wrapperType());
                if (!VerifyType.isNullConversion(wsrc.wrapperType(), dst, strict)) {
                    MethodType mt = MethodType.methodType(dst, src);
                    fn = strict ? fn.asType(mt) : MethodHandleImpl.makePairwiseConvert(fn, mt, false);
                }
            }
        } else if (dst.isPrimitive()) {
            Wrapper wdst = Wrapper.forPrimitiveType(dst);
            fn = monobox || src == wdst.wrapperType() ? ValueConversions.unboxExact(wdst, strict) : (strict ? ValueConversions.unboxWiden(wdst) : ValueConversions.unboxCast(wdst));
        } else {
            return dst;
        }
        assert (fn.type().parameterCount() <= 1) : "pc" + Arrays.asList(src.getSimpleName(), dst.getSimpleName(), fn);
        return fn;
    }

    static MethodHandle makeVarargsCollector(MethodHandle target, Class<?> arrayType) {
        int last;
        MethodType type = target.type();
        if (type.parameterType(last = type.parameterCount() - 1) != arrayType) {
            target = target.asType(type.changeParameterType(last, arrayType));
        }
        target = target.asFixedArity();
        return new AsVarargsCollector(target, arrayType);
    }

    static void checkSpreadArgument(Object av, int n) {
        int len;
        if (av == null && n == 0) {
            return;
        }
        if (av == null) {
            throw new NullPointerException("null array reference");
        }
        if (av instanceof Object[] ? (len = ((Object[])av).length) == n : (len = Array.getLength(av)) == n) {
            return;
        }
        throw MethodHandleStatics.newIllegalArgumentException("array is not of length " + n);
    }

    @Hidden
    static MethodHandle selectAlternative(boolean testResult, MethodHandle target, MethodHandle fallback) {
        if (testResult) {
            return target;
        }
        return fallback;
    }

    @Hidden
    @IntrinsicCandidate
    static boolean profileBoolean(boolean result, int[] counters) {
        int idx = result ? 1 : 0;
        try {
            counters[idx] = Math.addExact(counters[idx], 1);
        }
        catch (ArithmeticException e) {
            counters[idx] = counters[idx] / 2;
        }
        return result;
    }

    @Hidden
    @IntrinsicCandidate
    static boolean isCompileConstant(Object obj) {
        return false;
    }

    static MethodHandle makeGuardWithTest(MethodHandle test, MethodHandle target, MethodHandle fallback) {
        BoundMethodHandle mh;
        MethodType type = target.type();
        assert (test.type().equals((Object)type.changeReturnType(Boolean.TYPE)) && fallback.type().equals((Object)type));
        MethodType basicType = type.basicType();
        LambdaForm form = MethodHandleImpl.makeGuardWithTestForm(basicType);
        try {
            if (MethodHandleStatics.PROFILE_GWT) {
                int[] counts = new int[2];
                mh = BoundMethodHandle.speciesData_LLLL().factory().invokeBasic(type, form, test, MethodHandleImpl.profile(target), MethodHandleImpl.profile(fallback), counts);
            } else {
                mh = BoundMethodHandle.speciesData_LLL().factory().invokeBasic(type, form, test, MethodHandleImpl.profile(target), MethodHandleImpl.profile(fallback));
            }
        }
        catch (Throwable ex) {
            throw MethodHandleStatics.uncaughtException(ex);
        }
        assert (mh.type() == type);
        return mh;
    }

    static MethodHandle profile(MethodHandle target) {
        if (MethodHandleStatics.DONT_INLINE_THRESHOLD >= 0) {
            return MethodHandleImpl.makeBlockInliningWrapper(target);
        }
        return target;
    }

    static MethodHandle makeBlockInliningWrapper(MethodHandle target) {
        LambdaForm lform = MethodHandleStatics.DONT_INLINE_THRESHOLD > 0 ? Makers.PRODUCE_BLOCK_INLINING_FORM.apply(target) : Makers.PRODUCE_REINVOKER_FORM.apply(target);
        return new CountingWrapper(target, lform, Makers.PRODUCE_BLOCK_INLINING_FORM, Makers.PRODUCE_REINVOKER_FORM, MethodHandleStatics.DONT_INLINE_THRESHOLD);
    }

    static LambdaForm makeGuardWithTestForm(MethodType basicType) {
        int ARG_LIMIT;
        LambdaForm lform = basicType.form().cachedLambdaForm(17);
        if (lform != null) {
            return lform;
        }
        boolean THIS_MH = false;
        boolean ARG_BASE = true;
        int nameCursor = ARG_LIMIT = 1 + basicType.parameterCount();
        int GET_TEST = nameCursor++;
        int GET_TARGET = nameCursor++;
        int GET_FALLBACK = nameCursor++;
        int GET_COUNTERS = MethodHandleStatics.PROFILE_GWT ? nameCursor++ : -1;
        int CALL_TEST = nameCursor++;
        int PROFILE = GET_COUNTERS != -1 ? nameCursor++ : -1;
        int TEST = nameCursor - 1;
        int SELECT_ALT = nameCursor++;
        int CALL_TARGET = nameCursor++;
        assert (CALL_TARGET == SELECT_ALT + 1);
        MethodType lambdaType = basicType.invokerType();
        LambdaForm.Name[] names = LambdaForm.arguments(nameCursor - ARG_LIMIT, lambdaType);
        BoundMethodHandle.SpeciesData data = GET_COUNTERS != -1 ? BoundMethodHandle.speciesData_LLLL() : BoundMethodHandle.speciesData_LLL();
        names[0] = names[0].withConstraint(data);
        names[GET_TEST] = new LambdaForm.Name(data.getterFunction(0), names[0]);
        names[GET_TARGET] = new LambdaForm.Name(data.getterFunction(1), names[0]);
        names[GET_FALLBACK] = new LambdaForm.Name(data.getterFunction(2), names[0]);
        if (GET_COUNTERS != -1) {
            names[GET_COUNTERS] = new LambdaForm.Name(data.getterFunction(3), names[0]);
        }
        Object[] invokeArgs = Arrays.copyOfRange(names, 0, ARG_LIMIT, Object[].class);
        MethodType testType = basicType.changeReturnType(Boolean.TYPE).basicType();
        invokeArgs[0] = names[GET_TEST];
        names[CALL_TEST] = new LambdaForm.Name(testType, invokeArgs);
        if (PROFILE != -1) {
            names[PROFILE] = new LambdaForm.Name(MethodHandleImpl.getFunction((byte)5), names[CALL_TEST], names[GET_COUNTERS]);
        }
        names[SELECT_ALT] = new LambdaForm.Name(new LambdaForm.NamedFunction(MethodHandleImpl.makeIntrinsic(MethodHandleImpl.getConstantHandle(1), Intrinsic.SELECT_ALTERNATIVE)), names[TEST], names[GET_TARGET], names[GET_FALLBACK]);
        invokeArgs[0] = names[SELECT_ALT];
        names[CALL_TARGET] = new LambdaForm.Name(basicType, invokeArgs);
        lform = new LambdaForm(lambdaType.parameterCount(), names, true, LambdaForm.Kind.GUARD);
        return basicType.form().setCachedLambdaForm(17, lform);
    }

    private static LambdaForm makeGuardWithCatchForm(MethodType basicType) {
        int ARG_LIMIT;
        MethodType lambdaType = basicType.invokerType();
        LambdaForm lform = basicType.form().cachedLambdaForm(16);
        if (lform != null) {
            return lform;
        }
        boolean THIS_MH = false;
        boolean ARG_BASE = true;
        int nameCursor = ARG_LIMIT = 1 + basicType.parameterCount();
        int GET_TARGET = nameCursor++;
        int GET_CLASS = nameCursor++;
        int GET_CATCHER = nameCursor++;
        int GET_COLLECT_ARGS = nameCursor++;
        int GET_UNBOX_RESULT = nameCursor++;
        int BOXED_ARGS = nameCursor++;
        int TRY_CATCH = nameCursor++;
        int UNBOX_RESULT = nameCursor++;
        LambdaForm.Name[] names = LambdaForm.arguments(nameCursor - ARG_LIMIT, lambdaType);
        BoundMethodHandle.SpeciesData data = BoundMethodHandle.speciesData_LLLLL();
        names[0] = names[0].withConstraint(data);
        names[GET_TARGET] = new LambdaForm.Name(data.getterFunction(0), names[0]);
        names[GET_CLASS] = new LambdaForm.Name(data.getterFunction(1), names[0]);
        names[GET_CATCHER] = new LambdaForm.Name(data.getterFunction(2), names[0]);
        names[GET_COLLECT_ARGS] = new LambdaForm.Name(data.getterFunction(3), names[0]);
        names[GET_UNBOX_RESULT] = new LambdaForm.Name(data.getterFunction(4), names[0]);
        MethodType collectArgsType = basicType.changeReturnType(Object.class);
        MethodHandle invokeBasic = MethodHandles.basicInvoker(collectArgsType);
        Object[] args = new Object[invokeBasic.type().parameterCount()];
        args[0] = names[GET_COLLECT_ARGS];
        System.arraycopy(names, 1, args, 1, ARG_LIMIT - 1);
        names[BOXED_ARGS] = new LambdaForm.Name(new LambdaForm.NamedFunction(MethodHandleImpl.makeIntrinsic(invokeBasic, Intrinsic.GUARD_WITH_CATCH)), args);
        Object[] gwcArgs = new Object[]{names[GET_TARGET], names[GET_CLASS], names[GET_CATCHER], names[BOXED_ARGS]};
        names[TRY_CATCH] = new LambdaForm.Name(MethodHandleImpl.getFunction((byte)1), gwcArgs);
        MethodHandle invokeBasicUnbox = MethodHandles.basicInvoker(MethodType.methodType(basicType.rtype(), Object.class));
        Object[] unboxArgs = new Object[]{names[GET_UNBOX_RESULT], names[TRY_CATCH]};
        names[UNBOX_RESULT] = new LambdaForm.Name(invokeBasicUnbox, unboxArgs);
        lform = new LambdaForm(lambdaType.parameterCount(), names, LambdaForm.Kind.GUARD_WITH_CATCH);
        return basicType.form().setCachedLambdaForm(16, lform);
    }

    static MethodHandle makeGuardWithCatch(MethodHandle target, Class<? extends Throwable> exType, MethodHandle catcher) {
        BoundMethodHandle mh;
        MethodType type = target.type();
        LambdaForm form = MethodHandleImpl.makeGuardWithCatchForm(type.basicType());
        MethodType varargsType = type.changeReturnType(Object[].class);
        MethodHandle collectArgs = MethodHandleImpl.varargsArray(type.parameterCount()).asType(varargsType);
        MethodHandle unboxResult = MethodHandleImpl.unboxResultHandle(type.returnType());
        BoundMethodHandle.SpeciesData data = BoundMethodHandle.speciesData_LLLLL();
        try {
            mh = data.factory().invokeBasic(type, form, target, exType, catcher, collectArgs, unboxResult);
        }
        catch (Throwable ex) {
            throw MethodHandleStatics.uncaughtException(ex);
        }
        assert (mh.type() == type);
        return mh;
    }

    @Hidden
    static Object guardWithCatch(MethodHandle target, Class<? extends Throwable> exType, MethodHandle catcher, Object ... av) throws Throwable {
        try {
            return target.asFixedArity().invokeWithArguments(av);
        }
        catch (Throwable t) {
            if (!exType.isInstance(t)) {
                throw t;
            }
            return catcher.asFixedArity().invokeWithArguments(MethodHandleImpl.prepend(av, t));
        }
    }

    @Hidden
    private static Object[] prepend(Object[] array, Object ... elems) {
        int nArray = array.length;
        int nElems = elems.length;
        Object[] newArray = new Object[nArray + nElems];
        System.arraycopy(elems, 0, newArray, 0, nElems);
        System.arraycopy(array, 0, newArray, nElems, nArray);
        return newArray;
    }

    static MethodHandle throwException(MethodType type) {
        assert (Throwable.class.isAssignableFrom((Class<?>)type.parameterType(0)));
        int arity = type.parameterCount();
        if (arity > 1) {
            MethodHandle mh = MethodHandleImpl.throwException(type.dropParameterTypes(1, arity));
            mh = MethodHandles.dropArguments(mh, 1, Arrays.copyOfRange(type.parameterArray(), 1, arity));
            return mh;
        }
        return MethodHandleImpl.makePairwiseConvert(MethodHandleImpl.getFunction((byte)2).resolvedHandle(), type, false, true);
    }

    static <T extends Throwable> Empty throwException(T t) throws T {
        throw t;
    }

    static MethodHandle fakeMethodHandleInvoke(MemberName method) {
        assert (method.isMethodHandleInvoke());
        int idx = switch (method.getName()) {
            case "invoke" -> 0;
            case "invokeExact" -> 1;
            default -> throw new InternalError(method.getName());
        };
        MethodHandle mh = FAKE_METHOD_HANDLE_INVOKE[idx];
        if (mh != null) {
            return mh;
        }
        MethodType type = MethodType.methodType(Object.class, UnsupportedOperationException.class, MethodHandle.class, Object[].class);
        mh = MethodHandleImpl.throwException(type);
        mh = mh.bindTo(new UnsupportedOperationException("cannot reflectively invoke MethodHandle"));
        if (!method.getInvocationType().equals((Object)mh.type())) {
            throw new InternalError(method.toString());
        }
        mh = mh.withInternalMemberName(method, false);
        mh = mh.withVarargs(true);
        assert (method.isVarargs());
        MethodHandleImpl.FAKE_METHOD_HANDLE_INVOKE[idx] = mh;
        return mh;
    }

    static MethodHandle fakeVarHandleInvoke(MemberName method) {
        MethodType type = MethodType.methodType(method.getReturnType(), UnsupportedOperationException.class, VarHandle.class, Object[].class);
        MethodHandle mh = MethodHandleImpl.throwException(type);
        mh = mh.bindTo(new UnsupportedOperationException("cannot reflectively invoke VarHandle"));
        if (!method.getInvocationType().equals((Object)mh.type())) {
            throw new InternalError(method.toString());
        }
        mh = mh.withInternalMemberName(method, false);
        mh = mh.asVarargsCollector(Object[].class);
        assert (method.isVarargs());
        return mh;
    }

    static MethodHandle bindCaller(MethodHandle mh, Class<?> hostClass) {
        return BindCaller.bindCaller(mh, hostClass);
    }

    static MethodHandle makeWrappedMember(MethodHandle target, MemberName member, boolean isInvokeSpecial) {
        if (member.equals(target.internalMemberName()) && isInvokeSpecial == target.isInvokeSpecial()) {
            return target;
        }
        return new WrappedMember(target, target.type(), member, isInvokeSpecial, null);
    }

    static MethodHandle makeIntrinsic(MethodHandle target, Intrinsic intrinsicName) {
        return MethodHandleImpl.makeIntrinsic(target, intrinsicName, null);
    }

    static MethodHandle makeIntrinsic(MethodHandle target, Intrinsic intrinsicName, Object intrinsicData) {
        if (intrinsicName == target.intrinsicName()) {
            return target;
        }
        return new IntrinsicMethodHandle(target, intrinsicName, intrinsicData);
    }

    static MethodHandle makeIntrinsic(MethodType type, LambdaForm form, Intrinsic intrinsicName) {
        return new IntrinsicMethodHandle(SimpleMethodHandle.make(type, form), intrinsicName);
    }

    static MethodHandle varargsArray(int nargs) {
        MethodHandle mh = ARRAYS[nargs];
        if (mh != null) {
            return mh;
        }
        mh = MethodHandleImpl.makeCollector(Object[].class, nargs);
        assert (MethodHandleImpl.assertCorrectArity(mh, nargs));
        MethodHandleImpl.ARRAYS[nargs] = mh;
        return MethodHandleImpl.ARRAYS[nargs];
    }

    static MethodHandle varargsArray(Class<?> arrayType, int nargs) {
        MethodHandle mh;
        Class<?> elemType = arrayType.getComponentType();
        if (elemType == null) {
            throw new IllegalArgumentException("not an array: " + arrayType);
        }
        if (nargs >= 126) {
            int slots = nargs;
            int MAX_ARRAY_SLOTS = 254;
            if (slots <= 254 && elemType.isPrimitive()) {
                slots *= Wrapper.forPrimitiveType(elemType).stackSlots();
            }
            if (slots > 254) {
                throw new IllegalArgumentException("too many arguments: " + arrayType.getSimpleName() + ", length " + nargs);
            }
        }
        if (elemType == Object.class) {
            return MethodHandleImpl.varargsArray(nargs);
        }
        MethodHandle[] cache = Makers.TYPED_COLLECTORS.get(elemType);
        MethodHandle methodHandle = mh = nargs < cache.length ? cache[nargs] : null;
        if (mh != null) {
            return mh;
        }
        mh = MethodHandleImpl.makeCollector(arrayType, nargs);
        assert (MethodHandleImpl.assertCorrectArity(mh, nargs));
        if (nargs < cache.length) {
            cache[nargs] = mh;
        }
        return mh;
    }

    private static boolean assertCorrectArity(MethodHandle mh, int arity) {
        assert (mh.type().parameterCount() == arity) : "arity != " + arity + ": " + mh;
        return true;
    }

    static void assertSame(Object mh1, Object mh2) {
        if (mh1 != mh2) {
            String msg = String.format("mh1 != mh2: mh1 = %s (form: %s); mh2 = %s (form: %s)", mh1, ((MethodHandle)mh1).form, mh2, ((MethodHandle)mh2).form);
            throw MethodHandleStatics.newInternalError(msg);
        }
    }

    static LambdaForm.NamedFunction getFunction(byte func) {
        LambdaForm.NamedFunction nf = NFS[func];
        if (nf != null) {
            return nf;
        }
        MethodHandleImpl.NFS[func] = MethodHandleImpl.createFunction(func);
        return MethodHandleImpl.NFS[func];
    }

    private static LambdaForm.NamedFunction createFunction(byte func) {
        try {
            return switch (func) {
                case 0 -> new LambdaForm.NamedFunction(MethodHandleImpl.class.getDeclaredMethod("checkSpreadArgument", Object.class, Integer.TYPE));
                case 1 -> new LambdaForm.NamedFunction(MethodHandleImpl.class.getDeclaredMethod("guardWithCatch", MethodHandle.class, Class.class, MethodHandle.class, Object[].class));
                case 3 -> new LambdaForm.NamedFunction(MethodHandleImpl.class.getDeclaredMethod("tryFinally", MethodHandle.class, MethodHandle.class, Object[].class));
                case 4 -> new LambdaForm.NamedFunction(MethodHandleImpl.class.getDeclaredMethod("loop", LambdaForm.BasicType[].class, LoopClauses.class, Object[].class));
                case 2 -> new LambdaForm.NamedFunction(MethodHandleImpl.class.getDeclaredMethod("throwException", Throwable.class));
                case 5 -> new LambdaForm.NamedFunction(MethodHandleImpl.class.getDeclaredMethod("profileBoolean", Boolean.TYPE, int[].class));
                case 6 -> new LambdaForm.NamedFunction(MethodHandleImpl.class.getDeclaredMethod("tableSwitch", Integer.TYPE, MethodHandle.class, CasesHolder.class, Object[].class));
                default -> throw new InternalError("Undefined function: " + func);
            };
        }
        catch (ReflectiveOperationException ex) {
            throw MethodHandleStatics.newInternalError(ex);
        }
    }

    private static MethodHandle unboxResultHandle(Class<?> returnType) {
        if (returnType.isPrimitive()) {
            if (returnType == Void.TYPE) {
                return ValueConversions.ignore();
            }
            Wrapper w = Wrapper.forPrimitiveType(returnType);
            return ValueConversions.unboxExact(w);
        }
        return MethodHandles.identity(Object.class);
    }

    static MethodHandle makeLoop(Class<?> tloop, List<Class<?>> targs, List<MethodHandle> init, List<MethodHandle> step, List<MethodHandle> pred, List<MethodHandle> fini) {
        BoundMethodHandle mh;
        MethodType type = MethodType.methodType(tloop, targs);
        LambdaForm.BasicType[] initClauseTypes = (LambdaForm.BasicType[])init.stream().map(h -> h.type().returnType()).map(LambdaForm.BasicType::basicType).toArray(LambdaForm.BasicType[]::new);
        LambdaForm form = MethodHandleImpl.makeLoopForm(type.basicType(), initClauseTypes);
        MethodType varargsType = type.changeReturnType(Object[].class);
        MethodHandle collectArgs = MethodHandleImpl.varargsArray(type.parameterCount()).asType(varargsType);
        MethodHandle unboxResult = MethodHandleImpl.unboxResultHandle(tloop);
        LoopClauses clauseData = new LoopClauses(new MethodHandle[][]{MethodHandleImpl.toArray(init), MethodHandleImpl.toArray(step), MethodHandleImpl.toArray(pred), MethodHandleImpl.toArray(fini)});
        BoundMethodHandle.SpeciesData data = BoundMethodHandle.speciesData_LLL();
        try {
            mh = data.factory().invokeBasic(type, form, clauseData, collectArgs, unboxResult);
        }
        catch (Throwable ex) {
            throw MethodHandleStatics.uncaughtException(ex);
        }
        assert (mh.type() == type);
        return mh;
    }

    private static MethodHandle[] toArray(List<MethodHandle> l) {
        return l.toArray(new MethodHandle[0]);
    }

    private static LambdaForm makeLoopForm(MethodType basicType, LambdaForm.BasicType[] localVarTypes) {
        int ARG_LIMIT;
        MethodType lambdaType = basicType.invokerType();
        boolean THIS_MH = false;
        boolean ARG_BASE = true;
        int nameCursor = ARG_LIMIT = 1 + basicType.parameterCount();
        int GET_CLAUSE_DATA = nameCursor++;
        int GET_COLLECT_ARGS = nameCursor++;
        int GET_UNBOX_RESULT = nameCursor++;
        int BOXED_ARGS = nameCursor++;
        int LOOP = nameCursor++;
        int UNBOX_RESULT = nameCursor++;
        LambdaForm lform = basicType.form().cachedLambdaForm(19);
        if (lform == null) {
            LambdaForm.Name[] names = LambdaForm.arguments(nameCursor - ARG_LIMIT, lambdaType);
            BoundMethodHandle.SpeciesData data = BoundMethodHandle.speciesData_LLL();
            names[0] = names[0].withConstraint(data);
            names[GET_CLAUSE_DATA] = new LambdaForm.Name(data.getterFunction(0), names[0]);
            names[GET_COLLECT_ARGS] = new LambdaForm.Name(data.getterFunction(1), names[0]);
            names[GET_UNBOX_RESULT] = new LambdaForm.Name(data.getterFunction(2), names[0]);
            MethodType collectArgsType = basicType.changeReturnType(Object.class);
            MethodHandle invokeBasic = MethodHandles.basicInvoker(collectArgsType);
            Object[] args = new Object[invokeBasic.type().parameterCount()];
            args[0] = names[GET_COLLECT_ARGS];
            System.arraycopy(names, 1, args, 1, ARG_LIMIT - 1);
            names[BOXED_ARGS] = new LambdaForm.Name(new LambdaForm.NamedFunction(MethodHandleImpl.makeIntrinsic(invokeBasic, Intrinsic.LOOP)), args);
            Object[] lArgs = new Object[]{null, names[GET_CLAUSE_DATA], names[BOXED_ARGS]};
            names[LOOP] = new LambdaForm.Name(MethodHandleImpl.getFunction((byte)4), lArgs);
            MethodHandle invokeBasicUnbox = MethodHandles.basicInvoker(MethodType.methodType(basicType.rtype(), Object.class));
            Object[] unboxArgs = new Object[]{names[GET_UNBOX_RESULT], names[LOOP]};
            names[UNBOX_RESULT] = new LambdaForm.Name(invokeBasicUnbox, unboxArgs);
            lform = basicType.form().setCachedLambdaForm(19, new LambdaForm(lambdaType.parameterCount(), names, LambdaForm.Kind.LOOP));
        }
        return lform.editor().noteLoopLocalTypesForm(BOXED_ARGS, localVarTypes);
    }

    @Hidden
    static Object loop(LambdaForm.BasicType[] localTypes, LoopClauses clauseData, Object ... av) throws Throwable {
        MethodHandle[] init = clauseData.clauses[0];
        MethodHandle[] step = clauseData.clauses[1];
        MethodHandle[] pred = clauseData.clauses[2];
        MethodHandle[] fini = clauseData.clauses[3];
        int varSize = (int)Stream.of(init).filter(h -> h.type().returnType() != Void.TYPE).count();
        int nArgs = init[0].type().parameterCount();
        Object[] varsAndArgs = new Object[varSize + nArgs];
        int v = 0;
        for (int i = 0; i < init.length; ++i) {
            MethodHandle ih = init[i];
            if (ih.type().returnType() == Void.TYPE) {
                ih.invokeWithArguments(av);
                continue;
            }
            varsAndArgs[v++] = ih.invokeWithArguments(av);
        }
        System.arraycopy(av, 0, varsAndArgs, varSize, nArgs);
        int nSteps = step.length;
        block1: while (true) {
            int i = 0;
            int v2 = 0;
            while (true) {
                if (i >= nSteps) continue block1;
                MethodHandle p = pred[i];
                MethodHandle s = step[i];
                MethodHandle f = fini[i];
                if (s.type().returnType() == Void.TYPE) {
                    s.invokeWithArguments(varsAndArgs);
                } else {
                    varsAndArgs[v2++] = s.invokeWithArguments(varsAndArgs);
                }
                if (!((Boolean)p.invokeWithArguments(varsAndArgs)).booleanValue()) {
                    return f.invokeWithArguments(varsAndArgs);
                }
                ++i;
            }
            break;
        }
    }

    static boolean countedLoopPredicate(int limit, int counter) {
        return counter < limit;
    }

    static int countedLoopStep(int limit, int counter) {
        return counter + 1;
    }

    static Iterator<?> initIterator(Iterable<?> it) {
        return it.iterator();
    }

    static boolean iteratePredicate(Iterator<?> it) {
        return it.hasNext();
    }

    static Object iterateNext(Iterator<?> it) {
        return it.next();
    }

    static MethodHandle makeTryFinally(MethodHandle target, MethodHandle cleanup, Class<?> rtype, List<Class<?>> argTypes) {
        BoundMethodHandle mh;
        MethodType type = MethodType.methodType(rtype, argTypes);
        LambdaForm form = MethodHandleImpl.makeTryFinallyForm(type.basicType());
        MethodType varargsType = type.changeReturnType(Object[].class);
        MethodHandle collectArgs = MethodHandleImpl.varargsArray(type.parameterCount()).asType(varargsType);
        MethodHandle unboxResult = MethodHandleImpl.unboxResultHandle(rtype);
        BoundMethodHandle.SpeciesData data = BoundMethodHandle.speciesData_LLLL();
        try {
            mh = data.factory().invokeBasic(type, form, target, cleanup, collectArgs, unboxResult);
        }
        catch (Throwable ex) {
            throw MethodHandleStatics.uncaughtException(ex);
        }
        assert (mh.type() == type);
        return mh;
    }

    private static LambdaForm makeTryFinallyForm(MethodType basicType) {
        int ARG_LIMIT;
        MethodType lambdaType = basicType.invokerType();
        LambdaForm lform = basicType.form().cachedLambdaForm(18);
        if (lform != null) {
            return lform;
        }
        boolean THIS_MH = false;
        boolean ARG_BASE = true;
        int nameCursor = ARG_LIMIT = 1 + basicType.parameterCount();
        int GET_TARGET = nameCursor++;
        int GET_CLEANUP = nameCursor++;
        int GET_COLLECT_ARGS = nameCursor++;
        int GET_UNBOX_RESULT = nameCursor++;
        int BOXED_ARGS = nameCursor++;
        int TRY_FINALLY = nameCursor++;
        int UNBOX_RESULT = nameCursor++;
        LambdaForm.Name[] names = LambdaForm.arguments(nameCursor - ARG_LIMIT, lambdaType);
        BoundMethodHandle.SpeciesData data = BoundMethodHandle.speciesData_LLLL();
        names[0] = names[0].withConstraint(data);
        names[GET_TARGET] = new LambdaForm.Name(data.getterFunction(0), names[0]);
        names[GET_CLEANUP] = new LambdaForm.Name(data.getterFunction(1), names[0]);
        names[GET_COLLECT_ARGS] = new LambdaForm.Name(data.getterFunction(2), names[0]);
        names[GET_UNBOX_RESULT] = new LambdaForm.Name(data.getterFunction(3), names[0]);
        MethodType collectArgsType = basicType.changeReturnType(Object.class);
        MethodHandle invokeBasic = MethodHandles.basicInvoker(collectArgsType);
        Object[] args = new Object[invokeBasic.type().parameterCount()];
        args[0] = names[GET_COLLECT_ARGS];
        System.arraycopy(names, 1, args, 1, ARG_LIMIT - 1);
        names[BOXED_ARGS] = new LambdaForm.Name(new LambdaForm.NamedFunction(MethodHandleImpl.makeIntrinsic(invokeBasic, Intrinsic.TRY_FINALLY)), args);
        Object[] tfArgs = new Object[]{names[GET_TARGET], names[GET_CLEANUP], names[BOXED_ARGS]};
        names[TRY_FINALLY] = new LambdaForm.Name(MethodHandleImpl.getFunction((byte)3), tfArgs);
        MethodHandle invokeBasicUnbox = MethodHandles.basicInvoker(MethodType.methodType(basicType.rtype(), Object.class));
        Object[] unboxArgs = new Object[]{names[GET_UNBOX_RESULT], names[TRY_FINALLY]};
        names[UNBOX_RESULT] = new LambdaForm.Name(invokeBasicUnbox, unboxArgs);
        lform = new LambdaForm(lambdaType.parameterCount(), names, LambdaForm.Kind.TRY_FINALLY);
        return basicType.form().setCachedLambdaForm(18, lform);
    }

    @Hidden
    static Object tryFinally(MethodHandle target, MethodHandle cleanup, Object ... av) throws Throwable {
        Object[] objectArray;
        Throwable t = null;
        Object r = null;
        try {
            r = target.invokeWithArguments(av);
            objectArray = target.type().returnType() == Void.TYPE ? MethodHandleImpl.prepend(av, t) : MethodHandleImpl.prepend(av, t, r);
        }
        catch (Throwable thrown) {
            try {
                t = thrown;
                throw t;
            }
            catch (Throwable throwable) {
                Object[] args = target.type().returnType() == Void.TYPE ? MethodHandleImpl.prepend(av, t) : MethodHandleImpl.prepend(av, t, r);
                r = cleanup.invokeWithArguments(args);
                throw throwable;
            }
        }
        Object[] args = objectArray;
        r = cleanup.invokeWithArguments(args);
        return r;
    }

    private static MethodHandle makeCollector(Class<?> arrayType, int parameterCount) {
        BoundMethodHandle mh;
        MethodType type = MethodType.methodType(arrayType, Collections.nCopies(parameterCount, arrayType.componentType()));
        MethodHandle newArray = MethodHandles.arrayConstructor(arrayType);
        LambdaForm form = MethodHandleImpl.makeCollectorForm(type.basicType(), arrayType);
        BoundMethodHandle.SpeciesData data = BoundMethodHandle.speciesData_L();
        try {
            mh = data.factory().invokeBasic(type, form, newArray);
        }
        catch (Throwable ex) {
            throw MethodHandleStatics.uncaughtException(ex);
        }
        assert (mh.type() == type);
        return mh;
    }

    private static LambdaForm makeCollectorForm(MethodType basicType, Class<?> arrayType) {
        int STORE_ELEMENT_LIMIT;
        int ARG_LIMIT;
        LambdaForm lform;
        boolean isSharedLambdaForm;
        MethodType lambdaType = basicType.invokerType();
        int parameterCount = basicType.parameterCount();
        boolean isReferenceType = !((Class)arrayType.componentType()).isPrimitive();
        boolean bl = isSharedLambdaForm = parameterCount == 0 || isReferenceType;
        if (isSharedLambdaForm && (lform = basicType.form().cachedLambdaForm(25)) != null) {
            return lform;
        }
        MethodHandle storeFunc = isReferenceType ? ArrayAccessor.OBJECT_ARRAY_SETTER : MethodHandleImpl.makeArrayElementAccessor(arrayType, ArrayAccess.SET);
        boolean THIS_MH = false;
        boolean ARG_BASE = true;
        int nameCursor = ARG_LIMIT = 1 + parameterCount;
        int GET_NEW_ARRAY = nameCursor++;
        int CALL_NEW_ARRAY = nameCursor++;
        int STORE_ELEMENT_BASE = nameCursor;
        nameCursor = STORE_ELEMENT_LIMIT = STORE_ELEMENT_BASE + parameterCount;
        LambdaForm.Name[] names = LambdaForm.arguments(nameCursor - ARG_LIMIT, lambdaType);
        BoundMethodHandle.SpeciesData data = BoundMethodHandle.speciesData_L();
        names[0] = names[0].withConstraint(data);
        names[GET_NEW_ARRAY] = new LambdaForm.Name(data.getterFunction(0), names[0]);
        MethodHandle invokeBasic = MethodHandles.basicInvoker(MethodType.methodType(Object.class, Integer.TYPE));
        names[CALL_NEW_ARRAY] = new LambdaForm.Name(new LambdaForm.NamedFunction(invokeBasic), names[GET_NEW_ARRAY], parameterCount);
        int storeIndex = 0;
        int storeNameCursor = STORE_ELEMENT_BASE;
        int argCursor = 1;
        while (storeNameCursor < STORE_ELEMENT_LIMIT) {
            names[storeNameCursor] = new LambdaForm.Name(new LambdaForm.NamedFunction(MethodHandleImpl.makeIntrinsic(storeFunc, Intrinsic.ARRAY_STORE)), names[CALL_NEW_ARRAY], storeIndex, names[argCursor]);
            ++storeIndex;
            ++storeNameCursor;
            ++argCursor;
        }
        LambdaForm lform2 = new LambdaForm(lambdaType.parameterCount(), names, CALL_NEW_ARRAY, LambdaForm.Kind.COLLECTOR);
        if (isSharedLambdaForm) {
            lform2 = basicType.form().setCachedLambdaForm(25, lform2);
        }
        return lform2;
    }

    static MethodHandle makeTableSwitch(MethodType type, MethodHandle defaultCase, MethodHandle[] caseActions) {
        BoundMethodHandle mh;
        MethodType varargsType = type.changeReturnType(Object[].class);
        MethodHandle collectArgs = MethodHandleImpl.varargsArray(type.parameterCount()).asType(varargsType);
        MethodHandle unboxResult = MethodHandleImpl.unboxResultHandle(type.returnType());
        BoundMethodHandle.SpeciesData data = BoundMethodHandle.speciesData_LLLL();
        LambdaForm form = MethodHandleImpl.makeTableSwitchForm(type.basicType(), data, caseActions.length);
        CasesHolder caseHolder = new CasesHolder(caseActions);
        try {
            mh = data.factory().invokeBasic(type, form, defaultCase, collectArgs, unboxResult, caseHolder);
        }
        catch (Throwable ex) {
            throw MethodHandleStatics.uncaughtException(ex);
        }
        assert (mh.type() == type);
        return mh;
    }

    private static LambdaForm makeTableSwitchForm(MethodType basicType, BoundMethodHandle.SpeciesData data, int numCases) {
        MethodType lambdaType = basicType.invokerType();
        TableSwitchCacheKey key = new TableSwitchCacheKey(basicType, numCases);
        LambdaForm lform = TableSwitchCacheKey.CACHE.get(key);
        if (lform != null) {
            return lform;
        }
        boolean THIS_MH = false;
        boolean ARG_BASE = true;
        int ARG_LIMIT = 1 + basicType.parameterCount();
        boolean ARG_SWITCH_ON = true;
        assert (1 < ARG_LIMIT);
        int nameCursor = ARG_LIMIT;
        int GET_COLLECT_ARGS = nameCursor++;
        int GET_DEFAULT_CASE = nameCursor++;
        int GET_UNBOX_RESULT = nameCursor++;
        int GET_CASES = nameCursor++;
        int BOXED_ARGS = nameCursor++;
        int TABLE_SWITCH = nameCursor++;
        int UNBOXED_RESULT = nameCursor++;
        int fieldCursor = 0;
        int FIELD_DEFAULT_CASE = fieldCursor++;
        int FIELD_COLLECT_ARGS = fieldCursor++;
        int FIELD_UNBOX_RESULT = fieldCursor++;
        int FIELD_CASES = fieldCursor++;
        LambdaForm.Name[] names = LambdaForm.arguments(nameCursor - ARG_LIMIT, lambdaType);
        names[0] = names[0].withConstraint(data);
        names[GET_DEFAULT_CASE] = new LambdaForm.Name(data.getterFunction(FIELD_DEFAULT_CASE), names[0]);
        names[GET_COLLECT_ARGS] = new LambdaForm.Name(data.getterFunction(FIELD_COLLECT_ARGS), names[0]);
        names[GET_UNBOX_RESULT] = new LambdaForm.Name(data.getterFunction(FIELD_UNBOX_RESULT), names[0]);
        names[GET_CASES] = new LambdaForm.Name(data.getterFunction(FIELD_CASES), names[0]);
        MethodType collectArgsType = basicType.changeReturnType(Object.class);
        MethodHandle invokeBasic = MethodHandles.basicInvoker(collectArgsType);
        Object[] args = new Object[invokeBasic.type().parameterCount()];
        args[0] = names[GET_COLLECT_ARGS];
        System.arraycopy(names, 1, args, 1, ARG_LIMIT - 1);
        names[BOXED_ARGS] = new LambdaForm.Name(new LambdaForm.NamedFunction(MethodHandleImpl.makeIntrinsic(invokeBasic, Intrinsic.TABLE_SWITCH, numCases)), args);
        Object[] tfArgs = new Object[]{names[1], names[GET_DEFAULT_CASE], names[GET_CASES], names[BOXED_ARGS]};
        names[TABLE_SWITCH] = new LambdaForm.Name(MethodHandleImpl.getFunction((byte)6), tfArgs);
        MethodHandle invokeBasic2 = MethodHandles.basicInvoker(MethodType.methodType(basicType.rtype(), Object.class));
        Object[] unboxArgs = new Object[]{names[GET_UNBOX_RESULT], names[TABLE_SWITCH]};
        names[UNBOXED_RESULT] = new LambdaForm.Name(invokeBasic2, unboxArgs);
        lform = new LambdaForm(lambdaType.parameterCount(), names, LambdaForm.Kind.TABLE_SWITCH);
        LambdaForm prev = TableSwitchCacheKey.CACHE.putIfAbsent(key, lform);
        return prev != null ? prev : lform;
    }

    @Hidden
    static Object tableSwitch(int input, MethodHandle defaultCase, CasesHolder holder, Object[] args) throws Throwable {
        MethodHandle[] caseActions = holder.cases;
        MethodHandle selectedCase = input < 0 || input >= caseActions.length ? defaultCase : caseActions[input];
        return selectedCase.invokeWithArguments(args);
    }

    static MethodHandle getConstantHandle(int idx) {
        MethodHandle handle = HANDLES[idx];
        if (handle != null) {
            return handle;
        }
        return MethodHandleImpl.setCachedHandle(idx, MethodHandleImpl.makeConstantHandle(idx));
    }

    private static synchronized MethodHandle setCachedHandle(int idx, MethodHandle method) {
        MethodHandle prev = HANDLES[idx];
        if (prev != null) {
            return prev;
        }
        MethodHandleImpl.HANDLES[idx] = method;
        return method;
    }

    private static MethodHandle makeConstantHandle(int idx) {
        try {
            switch (idx) {
                case 0: {
                    return MethodHandles.Lookup.IMPL_LOOKUP.findVirtual(Class.class, "cast", MethodType.methodType(Object.class, Object.class));
                }
                case 1: {
                    return MethodHandles.Lookup.IMPL_LOOKUP.findStatic(MethodHandleImpl.class, "selectAlternative", MethodType.methodType(MethodHandle.class, Boolean.TYPE, MethodHandle.class, MethodHandle.class));
                }
                case 2: {
                    return MethodHandles.Lookup.IMPL_LOOKUP.findStatic(MethodHandleImpl.class, "countedLoopPredicate", MethodType.methodType(Boolean.TYPE, Integer.TYPE, Integer.TYPE));
                }
                case 3: {
                    return MethodHandles.Lookup.IMPL_LOOKUP.findStatic(MethodHandleImpl.class, "countedLoopStep", MethodType.methodType(Integer.TYPE, Integer.TYPE, Integer.TYPE));
                }
                case 4: {
                    return MethodHandles.Lookup.IMPL_LOOKUP.findStatic(MethodHandleImpl.class, "initIterator", MethodType.methodType(Iterator.class, Iterable.class));
                }
                case 5: {
                    return MethodHandles.Lookup.IMPL_LOOKUP.findStatic(MethodHandleImpl.class, "iteratePredicate", MethodType.methodType(Boolean.TYPE, Iterator.class));
                }
                case 6: {
                    return MethodHandles.Lookup.IMPL_LOOKUP.findStatic(MethodHandleImpl.class, "iterateNext", MethodType.methodType(Object.class, Iterator.class));
                }
                case 7: {
                    return MethodHandles.Lookup.IMPL_LOOKUP.findStatic(Array.class, "newInstance", MethodType.methodType(Object.class, Class.class, Integer.TYPE));
                }
            }
        }
        catch (ReflectiveOperationException ex) {
            throw MethodHandleStatics.newInternalError(ex);
        }
        throw MethodHandleStatics.newInternalError("Unknown function index: " + idx);
    }

    static {
        SharedSecrets.setJavaLangInvokeAccess(new JavaLangInvokeAccess(){

            @Override
            public Object newMemberName() {
                return new MemberName();
            }

            @Override
            public String getName(Object mname) {
                MemberName memberName = (MemberName)mname;
                return memberName.getName();
            }

            @Override
            public Class<?> getDeclaringClass(Object mname) {
                MemberName memberName = (MemberName)mname;
                return memberName.getDeclaringClass();
            }

            @Override
            public MethodType getMethodType(Object mname) {
                MemberName memberName = (MemberName)mname;
                return memberName.getMethodType();
            }

            @Override
            public String getMethodDescriptor(Object mname) {
                MemberName memberName = (MemberName)mname;
                return memberName.getMethodDescriptor();
            }

            @Override
            public boolean isNative(Object mname) {
                MemberName memberName = (MemberName)mname;
                return memberName.isNative();
            }

            @Override
            public Map<String, byte[]> generateHolderClasses(Stream<String> traces) {
                return GenerateJLIClassesHelper.generateHolderClasses(traces);
            }

            @Override
            public void ensureCustomized(MethodHandle mh) {
                mh.customize();
            }

            @Override
            public VarHandle memoryAccessVarHandle(Class<?> carrier, boolean skipAlignmentMaskCheck, long alignmentMask, ByteOrder order) {
                return VarHandles.makeMemoryAddressViewHandle(carrier, skipAlignmentMaskCheck, alignmentMask, order);
            }

            @Override
            public MethodHandle nativeMethodHandle(NativeEntryPoint nep, MethodHandle fallback) {
                return NativeMethodHandle.make(nep, fallback);
            }

            @Override
            public VarHandle filterValue(VarHandle target, MethodHandle filterToTarget, MethodHandle filterFromTarget) {
                return VarHandles.filterValue(target, filterToTarget, filterFromTarget);
            }

            @Override
            public VarHandle filterCoordinates(VarHandle target, int pos, MethodHandle ... filters) {
                return VarHandles.filterCoordinates(target, pos, filters);
            }

            @Override
            public VarHandle dropCoordinates(VarHandle target, int pos, Class<?> ... valueTypes) {
                return VarHandles.dropCoordinates(target, pos, valueTypes);
            }

            @Override
            public VarHandle permuteCoordinates(VarHandle target, List<Class<?>> newCoordinates, int ... reorder) {
                return VarHandles.permuteCoordinates(target, newCoordinates, reorder);
            }

            @Override
            public VarHandle collectCoordinates(VarHandle target, int pos, MethodHandle filter) {
                return VarHandles.collectCoordinates(target, pos, filter);
            }

            @Override
            public VarHandle insertCoordinates(VarHandle target, int pos, Object ... values) {
                return VarHandles.insertCoordinates(target, pos, values);
            }
        });
        HANDLES = new MethodHandle[8];
    }

    static enum ArrayAccess {
        GET,
        SET,
        LENGTH;


        static String opName(ArrayAccess a) {
            return switch (a) {
                case GET -> "getElement";
                case SET -> "setElement";
                case LENGTH -> "length";
                default -> throw MethodHandleImpl.unmatchedArrayAccess(a);
            };
        }

        static MethodHandle objectAccessor(ArrayAccess a) {
            return switch (a) {
                case GET -> ArrayAccessor.OBJECT_ARRAY_GETTER;
                case SET -> ArrayAccessor.OBJECT_ARRAY_SETTER;
                case LENGTH -> ArrayAccessor.OBJECT_ARRAY_LENGTH;
                default -> throw MethodHandleImpl.unmatchedArrayAccess(a);
            };
        }

        static int cacheIndex(ArrayAccess a) {
            return switch (a) {
                case GET -> 0;
                case SET -> 1;
                case LENGTH -> 2;
                default -> throw MethodHandleImpl.unmatchedArrayAccess(a);
            };
        }

        static Intrinsic intrinsic(ArrayAccess a) {
            return switch (a) {
                case GET -> Intrinsic.ARRAY_LOAD;
                case SET -> Intrinsic.ARRAY_STORE;
                case LENGTH -> Intrinsic.ARRAY_LENGTH;
                default -> throw MethodHandleImpl.unmatchedArrayAccess(a);
            };
        }
    }

    static final class ArrayAccessor {
        static final int GETTER_INDEX = 0;
        static final int SETTER_INDEX = 1;
        static final int LENGTH_INDEX = 2;
        static final int INDEX_LIMIT = 3;
        static final ClassValue<MethodHandle[]> TYPED_ACCESSORS = new ClassValue<MethodHandle[]>(){

            @Override
            protected MethodHandle[] computeValue(Class<?> type) {
                return new MethodHandle[3];
            }
        };
        static final MethodHandle OBJECT_ARRAY_GETTER;
        static final MethodHandle OBJECT_ARRAY_SETTER;
        static final MethodHandle OBJECT_ARRAY_LENGTH;

        ArrayAccessor() {
        }

        static int getElementI(int[] a, int i) {
            return a[i];
        }

        static long getElementJ(long[] a, int i) {
            return a[i];
        }

        static float getElementF(float[] a, int i) {
            return a[i];
        }

        static double getElementD(double[] a, int i) {
            return a[i];
        }

        static boolean getElementZ(boolean[] a, int i) {
            return a[i];
        }

        static byte getElementB(byte[] a, int i) {
            return a[i];
        }

        static short getElementS(short[] a, int i) {
            return a[i];
        }

        static char getElementC(char[] a, int i) {
            return a[i];
        }

        static Object getElementL(Object[] a, int i) {
            return a[i];
        }

        static void setElementI(int[] a, int i, int x) {
            a[i] = x;
        }

        static void setElementJ(long[] a, int i, long x) {
            a[i] = x;
        }

        static void setElementF(float[] a, int i, float x) {
            a[i] = x;
        }

        static void setElementD(double[] a, int i, double x) {
            a[i] = x;
        }

        static void setElementZ(boolean[] a, int i, boolean x) {
            a[i] = x;
        }

        static void setElementB(byte[] a, int i, byte x) {
            a[i] = x;
        }

        static void setElementS(short[] a, int i, short x) {
            a[i] = x;
        }

        static void setElementC(char[] a, int i, char x) {
            a[i] = x;
        }

        static void setElementL(Object[] a, int i, Object x) {
            a[i] = x;
        }

        static int lengthI(int[] a) {
            return a.length;
        }

        static int lengthJ(long[] a) {
            return a.length;
        }

        static int lengthF(float[] a) {
            return a.length;
        }

        static int lengthD(double[] a) {
            return a.length;
        }

        static int lengthZ(boolean[] a) {
            return a.length;
        }

        static int lengthB(byte[] a) {
            return a.length;
        }

        static int lengthS(short[] a) {
            return a.length;
        }

        static int lengthC(char[] a) {
            return a.length;
        }

        static int lengthL(Object[] a) {
            return a.length;
        }

        static String name(Class<?> arrayClass, ArrayAccess access) {
            Class<?> elemClass = arrayClass.getComponentType();
            if (elemClass == null) {
                throw MethodHandleStatics.newIllegalArgumentException("not an array", arrayClass);
            }
            return ArrayAccess.opName(access) + Wrapper.basicTypeChar(elemClass);
        }

        static MethodType type(Class<?> arrayClass, ArrayAccess access) {
            Class<Object> elemClass = arrayClass.getComponentType();
            Class<Object> arrayArgClass = arrayClass;
            if (!elemClass.isPrimitive()) {
                arrayArgClass = Object[].class;
                elemClass = Object.class;
            }
            return switch (access) {
                case ArrayAccess.GET -> MethodType.methodType(elemClass, arrayArgClass, Integer.TYPE);
                case ArrayAccess.SET -> MethodType.methodType(Void.TYPE, arrayArgClass, Integer.TYPE, elemClass);
                case ArrayAccess.LENGTH -> MethodType.methodType(Integer.TYPE, arrayArgClass);
                default -> throw MethodHandleImpl.unmatchedArrayAccess(access);
            };
        }

        static MethodType correctType(Class<?> arrayClass, ArrayAccess access) {
            Class<?> elemClass = arrayClass.getComponentType();
            return switch (access) {
                case ArrayAccess.GET -> MethodType.methodType(elemClass, arrayClass, Integer.TYPE);
                case ArrayAccess.SET -> MethodType.methodType(Void.TYPE, arrayClass, Integer.TYPE, elemClass);
                case ArrayAccess.LENGTH -> MethodType.methodType(Integer.TYPE, arrayClass);
                default -> throw MethodHandleImpl.unmatchedArrayAccess(access);
            };
        }

        static MethodHandle getAccessor(Class<?> arrayClass, ArrayAccess access) {
            String name = ArrayAccessor.name(arrayClass, access);
            MethodType type = ArrayAccessor.type(arrayClass, access);
            try {
                return MethodHandles.Lookup.IMPL_LOOKUP.findStatic(ArrayAccessor.class, name, type);
            }
            catch (ReflectiveOperationException ex) {
                throw MethodHandleStatics.uncaughtException(ex);
            }
        }

        static {
            MethodHandle[] cache = TYPED_ACCESSORS.get(Object[].class);
            cache[0] = OBJECT_ARRAY_GETTER = MethodHandleImpl.makeIntrinsic(ArrayAccessor.getAccessor(Object[].class, ArrayAccess.GET), Intrinsic.ARRAY_LOAD);
            cache[1] = OBJECT_ARRAY_SETTER = MethodHandleImpl.makeIntrinsic(ArrayAccessor.getAccessor(Object[].class, ArrayAccess.SET), Intrinsic.ARRAY_STORE);
            cache[2] = OBJECT_ARRAY_LENGTH = MethodHandleImpl.makeIntrinsic(ArrayAccessor.getAccessor(Object[].class, ArrayAccess.LENGTH), Intrinsic.ARRAY_LENGTH);
            assert (InvokerBytecodeGenerator.isStaticallyInvocable(OBJECT_ARRAY_GETTER.internalMemberName()));
            assert (InvokerBytecodeGenerator.isStaticallyInvocable(OBJECT_ARRAY_SETTER.internalMemberName()));
            assert (InvokerBytecodeGenerator.isStaticallyInvocable(OBJECT_ARRAY_LENGTH.internalMemberName()));
        }
    }

    static enum Intrinsic {
        SELECT_ALTERNATIVE,
        GUARD_WITH_CATCH,
        TRY_FINALLY,
        TABLE_SWITCH,
        LOOP,
        ARRAY_LOAD,
        ARRAY_STORE,
        ARRAY_LENGTH,
        IDENTITY,
        ZERO,
        NONE;

    }

    private static final class AsVarargsCollector
    extends DelegatingMethodHandle {
        private final MethodHandle target;
        private final Class<?> arrayType;
        @Stable
        private MethodHandle asCollectorCache;

        AsVarargsCollector(MethodHandle target, Class<?> arrayType) {
            this(target.type(), target, arrayType);
        }

        AsVarargsCollector(MethodType type, MethodHandle target, Class<?> arrayType) {
            super(type, target);
            this.target = target;
            this.arrayType = arrayType;
        }

        @Override
        public boolean isVarargsCollector() {
            return true;
        }

        @Override
        protected MethodHandle getTarget() {
            return this.target;
        }

        @Override
        public MethodHandle asFixedArity() {
            return this.target;
        }

        @Override
        MethodHandle setVarargs(MemberName member) {
            if (member.isVarargs()) {
                return this;
            }
            return this.asFixedArity();
        }

        @Override
        public MethodHandle withVarargs(boolean makeVarargs) {
            if (makeVarargs) {
                return this;
            }
            return this.asFixedArity();
        }

        @Override
        public MethodHandle asTypeUncached(MethodType newType) {
            MethodHandle collector;
            MethodType type = this.type();
            int collectArg = type.parameterCount() - 1;
            int newArity = newType.parameterCount();
            if (newArity == collectArg + 1 && ((Class)type.parameterType(collectArg)).isAssignableFrom((Class<?>)newType.parameterType(collectArg))) {
                this.asTypeCache = this.asFixedArity().asType(newType);
                return this.asTypeCache;
            }
            MethodHandle acc = this.asCollectorCache;
            if (acc != null && acc.type().parameterCount() == newArity) {
                this.asTypeCache = acc.asType(newType);
                return this.asTypeCache;
            }
            int arrayLength = newArity - collectArg;
            try {
                collector = this.asFixedArity().asCollector(this.arrayType, arrayLength);
                assert (collector.type().parameterCount() == newArity) : "newArity=" + newArity + " but collector=" + collector;
            }
            catch (IllegalArgumentException ex) {
                throw new WrongMethodTypeException("cannot build collector", ex);
            }
            this.asCollectorCache = collector;
            this.asTypeCache = collector.asType(newType);
            return this.asTypeCache;
        }

        @Override
        boolean viewAsTypeChecks(MethodType newType, boolean strict) {
            super.viewAsTypeChecks(newType, true);
            if (strict) {
                return true;
            }
            assert (this.type().lastParameterType().getComponentType().isAssignableFrom(newType.lastParameterType().getComponentType())) : Arrays.asList(this, newType);
            return true;
        }

        @Override
        public Object invokeWithArguments(Object ... arguments) throws Throwable {
            Object collArgs;
            int argc;
            MethodType type = this.type();
            int MAX_SAFE = 127;
            if (arguments == null || (argc = arguments.length) <= 127 || argc < type.parameterCount()) {
                return super.invokeWithArguments(arguments);
            }
            int uncollected = type.parameterCount() - 1;
            Class<?> elemType = this.arrayType.getComponentType();
            int collected = argc - uncollected;
            Object object2 = collArgs = elemType == Object.class ? new Object[collected] : Array.newInstance(elemType, collected);
            if (!elemType.isPrimitive()) {
                try {
                    System.arraycopy(arguments, uncollected, collArgs, 0, collected);
                }
                catch (ArrayStoreException ex) {
                    return super.invokeWithArguments(arguments);
                }
            }
            MethodHandle arraySetter = MethodHandles.arrayElementSetter(this.arrayType);
            try {
                for (int i = 0; i < collected; ++i) {
                    arraySetter.invoke(collArgs, i, arguments[uncollected + i]);
                }
            }
            catch (ClassCastException | WrongMethodTypeException ex) {
                return super.invokeWithArguments(arguments);
            }
            Object[] newArgs = new Object[uncollected + 1];
            System.arraycopy(arguments, 0, newArgs, 0, uncollected);
            newArgs[uncollected] = collArgs;
            return this.asFixedArity().invokeWithArguments(newArgs);
        }
    }

    private static final class Makers {
        static final Function<MethodHandle, LambdaForm> PRODUCE_BLOCK_INLINING_FORM = new Function<MethodHandle, LambdaForm>(){

            @Override
            public LambdaForm apply(MethodHandle target) {
                return DelegatingMethodHandle.makeReinvokerForm(target, 9, CountingWrapper.class, false, DelegatingMethodHandle.NF_getTarget, CountingWrapper.NF_maybeStopCounting);
            }
        };
        static final Function<MethodHandle, LambdaForm> PRODUCE_REINVOKER_FORM = new Function<MethodHandle, LambdaForm>(){

            @Override
            public LambdaForm apply(MethodHandle target) {
                return DelegatingMethodHandle.makeReinvokerForm(target, 8, DelegatingMethodHandle.class, DelegatingMethodHandle.NF_getTarget);
            }
        };
        static final ClassValue<MethodHandle[]> TYPED_COLLECTORS = new ClassValue<MethodHandle[]>(){

            @Override
            protected MethodHandle[] computeValue(Class<?> type) {
                return new MethodHandle[256];
            }
        };

        private Makers() {
        }
    }

    static class CountingWrapper
    extends DelegatingMethodHandle {
        private final MethodHandle target;
        private int count;
        private Function<MethodHandle, LambdaForm> countingFormProducer;
        private Function<MethodHandle, LambdaForm> nonCountingFormProducer;
        private volatile boolean isCounting;
        static final LambdaForm.NamedFunction NF_maybeStopCounting;

        private CountingWrapper(MethodHandle target, LambdaForm lform, Function<MethodHandle, LambdaForm> countingFromProducer, Function<MethodHandle, LambdaForm> nonCountingFormProducer, int count) {
            super(target.type(), lform);
            this.target = target;
            this.count = count;
            this.countingFormProducer = countingFromProducer;
            this.nonCountingFormProducer = nonCountingFormProducer;
            this.isCounting = count > 0;
        }

        @Override
        @Hidden
        protected MethodHandle getTarget() {
            return this.target;
        }

        @Override
        public MethodHandle asTypeUncached(MethodType newType) {
            MethodHandle wrapper;
            MethodHandle newTarget = this.target.asType(newType);
            if (this.isCounting) {
                LambdaForm lform = this.countingFormProducer.apply(newTarget);
                wrapper = new CountingWrapper(newTarget, lform, this.countingFormProducer, this.nonCountingFormProducer, MethodHandleStatics.DONT_INLINE_THRESHOLD);
            } else {
                wrapper = newTarget;
            }
            this.asTypeCache = wrapper;
            return this.asTypeCache;
        }

        boolean countDown() {
            int c = this.count;
            this.target.maybeCustomize();
            if (c <= 1) {
                if (this.isCounting) {
                    this.isCounting = false;
                    return true;
                }
                return false;
            }
            this.count = c - 1;
            return false;
        }

        @Hidden
        static void maybeStopCounting(Object o1) {
            final CountingWrapper wrapper = (CountingWrapper)o1;
            if (wrapper.countDown()) {
                wrapper.updateForm(new Function<LambdaForm, LambdaForm>(){

                    @Override
                    public LambdaForm apply(LambdaForm oldForm) {
                        LambdaForm lform = wrapper.nonCountingFormProducer.apply(wrapper.target);
                        lform.compileToBytecode();
                        return lform;
                    }
                });
            }
        }

        static {
            Class<CountingWrapper> THIS_CLASS = CountingWrapper.class;
            try {
                NF_maybeStopCounting = new LambdaForm.NamedFunction(THIS_CLASS.getDeclaredMethod("maybeStopCounting", Object.class));
            }
            catch (ReflectiveOperationException ex) {
                throw MethodHandleStatics.newInternalError(ex);
            }
        }
    }

    private static class BindCaller {
        private static MethodType INVOKER_MT = MethodType.methodType(Object.class, MethodHandle.class, Object[].class);
        private static ClassValue<MethodHandle> CV_makeInjectedInvoker = new ClassValue<MethodHandle>(){

            @Override
            protected MethodHandle computeValue(Class<?> hostClass) {
                return BindCaller.makeInjectedInvoker(hostClass);
            }
        };
        private static final MethodHandle MH_checkCallerClass;
        private static final byte[] INJECTED_INVOKER_TEMPLATE;

        private BindCaller() {
        }

        static MethodHandle bindCaller(MethodHandle mh, Class<?> hostClass) {
            if (hostClass == null || hostClass.isArray() || hostClass.isPrimitive() || hostClass.getName().startsWith("java.lang.invoke.")) {
                throw new InternalError();
            }
            MethodHandle vamh = BindCaller.prepareForInvoker(mh);
            MethodHandle bccInvoker = CV_makeInjectedInvoker.get(hostClass);
            return BindCaller.restoreToType(bccInvoker.bindTo(vamh), mh, hostClass);
        }

        private static MethodHandle makeInjectedInvoker(Class<?> targetClass) {
            try {
                String name = targetClass.getName() + "$$InjectedInvoker";
                if (targetClass.isHidden()) {
                    name = name.replace('/', '_');
                }
                Class<?> invokerClass = new MethodHandles.Lookup(targetClass).makeHiddenClassDefiner(name, INJECTED_INVOKER_TEMPLATE).defineClass(true);
                assert (BindCaller.checkInjectedInvoker(targetClass, invokerClass));
                return MethodHandles.Lookup.IMPL_LOOKUP.findStatic(invokerClass, "invoke_V", INVOKER_MT);
            }
            catch (ReflectiveOperationException ex) {
                throw MethodHandleStatics.uncaughtException(ex);
            }
        }

        private static MethodHandle prepareForInvoker(MethodHandle mh) {
            mh = mh.asFixedArity();
            MethodType mt = mh.type();
            int arity = mt.parameterCount();
            MethodHandle vamh = mh.asType(mt.generic());
            vamh.internalForm().compileToBytecode();
            vamh = vamh.asSpreader(Object[].class, arity);
            vamh.internalForm().compileToBytecode();
            return vamh;
        }

        private static MethodHandle restoreToType(MethodHandle vamh, MethodHandle original, Class<?> hostClass) {
            MethodType type = original.type();
            MethodHandle mh = vamh.asCollector(Object[].class, type.parameterCount());
            MemberName member = original.internalMemberName();
            mh = mh.asType(type);
            mh = new WrappedMember(mh, type, member, original.isInvokeSpecial(), hostClass);
            return mh;
        }

        private static boolean checkInjectedInvoker(Class<?> hostClass, Class<?> invokerClass) {
            assert (hostClass.getClassLoader() == invokerClass.getClassLoader()) : hostClass.getName() + " (CL)";
            try {
                assert (hostClass.getProtectionDomain() == invokerClass.getProtectionDomain()) : hostClass.getName() + " (PD)";
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            try {
                MethodHandle invoker = MethodHandles.Lookup.IMPL_LOOKUP.findStatic(invokerClass, "invoke_V", INVOKER_MT);
                MethodHandle vamh = BindCaller.prepareForInvoker(MH_checkCallerClass);
                return invoker.invoke(vamh, new Object[]{invokerClass});
            }
            catch (Throwable ex) {
                throw new InternalError(ex);
            }
        }

        @CallerSensitive
        @ForceInline
        private static boolean checkCallerClass(Class<?> expected) {
            Class<?> actual = Reflection.getCallerClass();
            if (actual != expected) {
                throw new InternalError("found " + actual.getName() + ", expected " + expected.getName());
            }
            return true;
        }

        private static byte[] generateInvokerTemplate() {
            ClassWriter cw = new ClassWriter(0);
            cw.visit(52, 34, "InjectedInvoker", null, "java/lang/Object", null);
            MethodVisitor mv = cw.visitMethod(8, "invoke_V", "(Ljava/lang/invoke/MethodHandle;[Ljava/lang/Object;)Ljava/lang/Object;", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(182, "java/lang/invoke/MethodHandle", "invokeExact", "([Ljava/lang/Object;)Ljava/lang/Object;", false);
            mv.visitInsn(176);
            mv.visitMaxs(2, 2);
            mv.visitEnd();
            cw.visitEnd();
            return cw.toByteArray();
        }

        static {
            Class<BindCaller> THIS_CLASS = BindCaller.class;
            assert (BindCaller.checkCallerClass(THIS_CLASS));
            try {
                MH_checkCallerClass = MethodHandles.Lookup.IMPL_LOOKUP.findStatic(THIS_CLASS, "checkCallerClass", MethodType.methodType(Boolean.TYPE, Class.class));
                assert (MH_checkCallerClass.invokeExact(THIS_CLASS));
            }
            catch (Throwable ex) {
                throw new InternalError(ex);
            }
            INJECTED_INVOKER_TEMPLATE = BindCaller.generateInvokerTemplate();
        }
    }

    private static final class WrappedMember
    extends DelegatingMethodHandle {
        private final MethodHandle target;
        private final MemberName member;
        private final Class<?> callerClass;
        private final boolean isInvokeSpecial;

        private WrappedMember(MethodHandle target, MethodType type, MemberName member, boolean isInvokeSpecial, Class<?> callerClass) {
            super(type, target);
            this.target = target;
            this.member = member;
            this.callerClass = callerClass;
            this.isInvokeSpecial = isInvokeSpecial;
        }

        @Override
        MemberName internalMemberName() {
            return this.member;
        }

        @Override
        Class<?> internalCallerClass() {
            return this.callerClass;
        }

        @Override
        boolean isInvokeSpecial() {
            return this.isInvokeSpecial;
        }

        @Override
        protected MethodHandle getTarget() {
            return this.target;
        }

        @Override
        public MethodHandle asTypeUncached(MethodType newType) {
            this.asTypeCache = this.target.asType(newType);
            return this.asTypeCache;
        }
    }

    static final class IntrinsicMethodHandle
    extends DelegatingMethodHandle {
        private final MethodHandle target;
        private final Intrinsic intrinsicName;
        private final Object intrinsicData;

        IntrinsicMethodHandle(MethodHandle target, Intrinsic intrinsicName) {
            this(target, intrinsicName, null);
        }

        IntrinsicMethodHandle(MethodHandle target, Intrinsic intrinsicName, Object intrinsicData) {
            super(target.type(), target);
            this.target = target;
            this.intrinsicName = intrinsicName;
            this.intrinsicData = intrinsicData;
        }

        @Override
        protected MethodHandle getTarget() {
            return this.target;
        }

        @Override
        Intrinsic intrinsicName() {
            return this.intrinsicName;
        }

        @Override
        Object intrinsicData() {
            return this.intrinsicData;
        }

        @Override
        public MethodHandle asTypeUncached(MethodType newType) {
            this.asTypeCache = this.target.asType(newType);
            return this.asTypeCache;
        }

        @Override
        String internalProperties() {
            return super.internalProperties() + "\n& Intrinsic=" + (Object)((Object)this.intrinsicName);
        }

        @Override
        public MethodHandle asCollector(Class<?> arrayType, int arrayLength) {
            if (this.intrinsicName == Intrinsic.IDENTITY) {
                MethodType resultType = this.type().asCollectorType(arrayType, this.type().parameterCount() - 1, arrayLength);
                MethodHandle newArray = MethodHandleImpl.varargsArray(arrayType, arrayLength);
                return newArray.asType(resultType);
            }
            return super.asCollector(arrayType, arrayLength);
        }
    }

    static class LoopClauses {
        @Stable
        final MethodHandle[][] clauses;

        LoopClauses(MethodHandle[][] clauses) {
            assert (clauses.length == 4);
            this.clauses = clauses;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("LoopClauses -- ");
            for (int i = 0; i < 4; ++i) {
                if (i > 0) {
                    sb.append("       ");
                }
                sb.append('<').append(i).append(">: ");
                MethodHandle[] hs = this.clauses[i];
                for (int j = 0; j < hs.length; ++j) {
                    if (j > 0) {
                        sb.append("          ");
                    }
                    sb.append('*').append(j).append(": ").append(hs[j]).append('\n');
                }
            }
            sb.append(" --\n");
            return sb.toString();
        }
    }

    static class CasesHolder {
        @Stable
        final MethodHandle[] cases;

        public CasesHolder(MethodHandle[] cases) {
            this.cases = cases;
        }
    }

    private static class TableSwitchCacheKey {
        private static final Map<TableSwitchCacheKey, LambdaForm> CACHE = new ConcurrentHashMap<TableSwitchCacheKey, LambdaForm>();
        private final MethodType basicType;
        private final int numberOfCases;

        public TableSwitchCacheKey(MethodType basicType, int numberOfCases) {
            this.basicType = basicType;
            this.numberOfCases = numberOfCases;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TableSwitchCacheKey that = (TableSwitchCacheKey)o;
            return this.numberOfCases == that.numberOfCases && Objects.equals(this.basicType, that.basicType);
        }

        public int hashCode() {
            return Objects.hash(this.basicType, this.numberOfCases);
        }
    }
}

