/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.Invokers;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.invoke.VarHandle;
import java.lang.invoke.VarHandleGuards;
import java.lang.reflect.Field;
import java.util.Arrays;
import jdk.internal.access.JavaLangAccess;
import jdk.internal.access.SharedSecrets;
import jdk.internal.ref.CleanerFactory;
import sun.invoke.util.Wrapper;

class MethodHandleNatives {
    private static final JavaLangAccess JLA;

    private MethodHandleNatives() {
    }

    static native void init(MemberName var0, Object var1);

    static native void expand(MemberName var0);

    static native MemberName resolve(MemberName var0, Class<?> var1, int var2, boolean var3) throws LinkageError, ClassNotFoundException;

    static native int getMembers(Class<?> var0, String var1, String var2, int var3, Class<?> var4, int var5, MemberName[] var6);

    static native long objectFieldOffset(MemberName var0);

    static native long staticFieldOffset(MemberName var0);

    static native Object staticFieldBase(MemberName var0);

    static native Object getMemberVMInfo(MemberName var0);

    static native void setCallSiteTargetNormal(CallSite var0, MethodHandle var1);

    static native void setCallSiteTargetVolatile(CallSite var0, MethodHandle var1);

    static native void copyOutBootstrapArguments(Class<?> var0, int[] var1, int var2, int var3, Object[] var4, int var5, boolean var6, Object var7);

    private static native void clearCallSiteContext(CallSiteContext var0);

    private static native void registerNatives();

    static boolean refKindIsValid(int refKind) {
        return refKind > 0 && refKind < 10;
    }

    static boolean refKindIsField(byte refKind) {
        assert (MethodHandleNatives.refKindIsValid(refKind));
        return refKind <= 4;
    }

    static boolean refKindIsGetter(byte refKind) {
        assert (MethodHandleNatives.refKindIsValid(refKind));
        return refKind <= 2;
    }

    static boolean refKindIsSetter(byte refKind) {
        return MethodHandleNatives.refKindIsField(refKind) && !MethodHandleNatives.refKindIsGetter(refKind);
    }

    static boolean refKindIsMethod(byte refKind) {
        return !MethodHandleNatives.refKindIsField(refKind) && refKind != 8;
    }

    static boolean refKindIsConstructor(byte refKind) {
        return refKind == 8;
    }

    static boolean refKindHasReceiver(byte refKind) {
        assert (MethodHandleNatives.refKindIsValid(refKind));
        return (refKind & 1) != 0;
    }

    static boolean refKindIsStatic(byte refKind) {
        return !MethodHandleNatives.refKindHasReceiver(refKind) && refKind != 8;
    }

    static boolean refKindDoesDispatch(byte refKind) {
        assert (MethodHandleNatives.refKindIsValid(refKind));
        return refKind == 5 || refKind == 9;
    }

    static String refKindName(byte refKind) {
        assert (MethodHandleNatives.refKindIsValid(refKind));
        return switch (refKind) {
            case 1 -> "getField";
            case 2 -> "getStatic";
            case 3 -> "putField";
            case 4 -> "putStatic";
            case 5 -> "invokeVirtual";
            case 6 -> "invokeStatic";
            case 7 -> "invokeSpecial";
            case 8 -> "newInvokeSpecial";
            case 9 -> "invokeInterface";
            default -> "REF_???";
        };
    }

    private static native int getNamedCon(int var0, Object[] var1);

    static boolean verifyConstants() {
        Object[] box = new Object[]{null};
        int i = 0;
        while (true) {
            block4: {
                box[0] = null;
                int vmval = MethodHandleNatives.getNamedCon(i, box);
                if (box[0] == null) break;
                String name = (String)box[0];
                try {
                    Field con = Constants.class.getDeclaredField(name);
                    int jval = con.getInt(null);
                    if (jval == vmval) break block4;
                    String err = name + ": JVM has " + vmval + " while Java has " + jval;
                    if (name.equals("CONV_OP_LIMIT")) {
                        System.err.println("warning: " + err);
                        break block4;
                    }
                    throw new InternalError(err);
                }
                catch (IllegalAccessException | NoSuchFieldException ex) {
                    String err = name + ": JVM has " + vmval + " which Java does not define";
                }
            }
            ++i;
        }
        return true;
    }

    static MemberName linkCallSite(Object callerObj, int indexInCP, Object bootstrapMethodObj, Object nameObj, Object typeObj, Object staticArguments, Object[] appendixResult) {
        MethodHandle bootstrapMethod = (MethodHandle)bootstrapMethodObj;
        Class caller = (Class)callerObj;
        String name = nameObj.toString().intern();
        MethodType type = (MethodType)typeObj;
        if (!MethodHandleStatics.TRACE_METHOD_LINKAGE) {
            return MethodHandleNatives.linkCallSiteImpl(caller, bootstrapMethod, name, type, staticArguments, appendixResult);
        }
        return MethodHandleNatives.linkCallSiteTracing(caller, bootstrapMethod, name, type, staticArguments, appendixResult);
    }

    static MemberName linkCallSiteImpl(Class<?> caller, MethodHandle bootstrapMethod, String name, MethodType type, Object staticArguments, Object[] appendixResult) {
        CallSite callSite = CallSite.makeSite(bootstrapMethod, name, type, staticArguments, caller);
        if (callSite instanceof ConstantCallSite) {
            appendixResult[0] = callSite.dynamicInvoker();
            return Invokers.linkToTargetMethod(type);
        }
        appendixResult[0] = callSite;
        return Invokers.linkToCallSiteMethod(type);
    }

    static MemberName linkCallSiteTracing(Class<?> caller, MethodHandle bootstrapMethod, String name, MethodType type, Object staticArguments, Object[] appendixResult) {
        Object bsmReference = bootstrapMethod.internalMemberName();
        if (bsmReference == null) {
            bsmReference = bootstrapMethod;
        }
        String staticArglist = MethodHandleNatives.staticArglistForTrace(staticArguments);
        System.out.println("linkCallSite " + caller.getName() + " " + bsmReference + " " + name + type + "/" + staticArglist);
        try {
            MemberName res = MethodHandleNatives.linkCallSiteImpl(caller, bootstrapMethod, name, type, staticArguments, appendixResult);
            System.out.println("linkCallSite => " + res + " + " + appendixResult[0]);
            return res;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            System.out.println("linkCallSite => throw " + ex);
            throw ex;
        }
    }

    static Object linkDynamicConstant(Object callerObj, int indexInCP, Object bootstrapMethodObj, Object nameObj, Object typeObj, Object staticArguments) {
        MethodHandle bootstrapMethod = (MethodHandle)bootstrapMethodObj;
        Class caller = (Class)callerObj;
        String name = nameObj.toString().intern();
        Class type = (Class)typeObj;
        if (!MethodHandleStatics.TRACE_METHOD_LINKAGE) {
            return MethodHandleNatives.linkDynamicConstantImpl(caller, bootstrapMethod, name, type, staticArguments);
        }
        return MethodHandleNatives.linkDynamicConstantTracing(caller, bootstrapMethod, name, type, staticArguments);
    }

    static Object linkDynamicConstantImpl(Class<?> caller, MethodHandle bootstrapMethod, String name, Class<?> type, Object staticArguments) {
        return ConstantBootstraps.makeConstant(bootstrapMethod, name, type, staticArguments, caller);
    }

    private static String staticArglistForTrace(Object staticArguments) {
        if (staticArguments instanceof Object[]) {
            return "BSA=" + Arrays.asList((Object[])staticArguments);
        }
        if (staticArguments instanceof int[]) {
            return "BSA@" + Arrays.toString((int[])staticArguments);
        }
        if (staticArguments == null) {
            return "BSA0=null";
        }
        return "BSA1=" + staticArguments;
    }

    static Object linkDynamicConstantTracing(Class<?> caller, MethodHandle bootstrapMethod, String name, Class<?> type, Object staticArguments) {
        Object bsmReference = bootstrapMethod.internalMemberName();
        if (bsmReference == null) {
            bsmReference = bootstrapMethod;
        }
        String staticArglist = MethodHandleNatives.staticArglistForTrace(staticArguments);
        System.out.println("linkDynamicConstant " + caller.getName() + " " + bsmReference + " " + name + type + "/" + staticArglist);
        try {
            Object res = MethodHandleNatives.linkDynamicConstantImpl(caller, bootstrapMethod, name, type, staticArguments);
            System.out.println("linkDynamicConstantImpl => " + res);
            return res;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            System.out.println("linkDynamicConstant => throw " + ex);
            throw ex;
        }
    }

    static boolean staticArgumentsPulled(Object staticArguments) {
        return staticArguments instanceof int[];
    }

    static boolean isPullModeBSM(MethodHandle bsm) {
        return false;
    }

    static MethodType findMethodHandleType(Class<?> rtype, Class<?>[] ptypes) {
        return MethodType.makeImpl(rtype, ptypes, true);
    }

    static MemberName linkMethod(Class<?> callerClass, int refKind, Class<?> defc, String name, Object type, Object[] appendixResult) {
        if (!MethodHandleStatics.TRACE_METHOD_LINKAGE) {
            return MethodHandleNatives.linkMethodImpl(callerClass, refKind, defc, name, type, appendixResult);
        }
        return MethodHandleNatives.linkMethodTracing(callerClass, refKind, defc, name, type, appendixResult);
    }

    static MemberName linkMethodImpl(Class<?> callerClass, int refKind, Class<?> defc, String name, Object type, Object[] appendixResult) {
        try {
            if (refKind == 5) {
                if (defc == MethodHandle.class) {
                    return Invokers.methodHandleInvokeLinkerMethod(name, MethodHandleNatives.fixMethodType(callerClass, type), appendixResult);
                }
                if (defc == VarHandle.class) {
                    return MethodHandleNatives.varHandleOperationLinkerMethod(name, MethodHandleNatives.fixMethodType(callerClass, type), appendixResult);
                }
            }
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable ex) {
            throw new LinkageError(ex.getMessage(), ex);
        }
        throw new LinkageError("no such method " + defc.getName() + "." + name + type);
    }

    private static MethodType fixMethodType(Class<?> callerClass, Object type) {
        if (type instanceof MethodType) {
            return (MethodType)type;
        }
        return MethodType.fromDescriptor((String)type, callerClass.getClassLoader());
    }

    static MemberName linkMethodTracing(Class<?> callerClass, int refKind, Class<?> defc, String name, Object type, Object[] appendixResult) {
        System.out.println("linkMethod " + defc.getName() + "." + name + type + "/" + Integer.toHexString(refKind));
        try {
            MemberName res = MethodHandleNatives.linkMethodImpl(callerClass, refKind, defc, name, type, appendixResult);
            System.out.println("linkMethod => " + res + " + " + appendixResult[0]);
            return res;
        }
        catch (Throwable ex) {
            System.out.println("linkMethod => throw " + ex);
            throw ex;
        }
    }

    private static MemberName varHandleOperationLinkerMethod(String name, MethodType mtype, Object[] appendixResult) {
        VarHandle.AccessMode ak;
        MethodType sigType = mtype.basicType();
        try {
            ak = VarHandle.AccessMode.valueFromMethodName(name);
        }
        catch (IllegalArgumentException e) {
            throw MethodHandleStatics.newInternalError(e);
        }
        VarHandle.AccessDescriptor ad = new VarHandle.AccessDescriptor(mtype, ak.at.ordinal(), ak.ordinal());
        appendixResult[0] = ad;
        if (MethodHandleStatics.VAR_HANDLE_GUARDS) {
            Class<?> guardReturnType = sigType.returnType();
            if (ak.at.isMonomorphicInReturnType) {
                if (ak.at.returnType != mtype.returnType()) {
                    throw MethodHandleNatives.newNoSuchMethodErrorOnVarHandle(name, mtype);
                }
                guardReturnType = ak.at.returnType;
            }
            Class[] guardParams = new Class[sigType.parameterCount() + 2];
            guardParams[0] = VarHandle.class;
            for (int i = 0; i < sigType.parameterCount(); ++i) {
                guardParams[i + 1] = sigType.parameterType(i);
            }
            guardParams[guardParams.length - 1] = VarHandle.AccessDescriptor.class;
            MethodType guardType = MethodType.makeImpl(guardReturnType, guardParams, true);
            MemberName linker = new MemberName(VarHandleGuards.class, MethodHandleNatives.getVarHandleGuardMethodName(guardType), guardType, 6);
            linker = MemberName.getFactory().resolveOrNull((byte)6, linker, VarHandleGuards.class, -1);
            if (linker != null) {
                return linker;
            }
        }
        return Invokers.varHandleInvokeLinkerMethod(mtype);
    }

    static String getVarHandleGuardMethodName(MethodType guardType) {
        String prefix = "guard_";
        StringBuilder sb = new StringBuilder(prefix.length() + guardType.parameterCount());
        sb.append(prefix);
        for (int i = 1; i < guardType.parameterCount() - 1; ++i) {
            TypeDescriptor.OfField pt = guardType.parameterType(i);
            sb.append(MethodHandleNatives.getCharType(pt));
        }
        sb.append('_').append(MethodHandleNatives.getCharType(guardType.returnType()));
        return sb.toString();
    }

    static char getCharType(Class<?> pt) {
        return Wrapper.forBasicType(pt).basicTypeChar();
    }

    static NoSuchMethodError newNoSuchMethodErrorOnVarHandle(String name, MethodType mtype) {
        return new NoSuchMethodError("VarHandle." + name + mtype);
    }

    static MethodHandle linkMethodHandleConstant(Class<?> callerClass, int refKind, Class<?> defc, String name, Object type) {
        try {
            MethodHandles.Lookup lookup = MethodHandles.Lookup.IMPL_LOOKUP.in(callerClass);
            assert (MethodHandleNatives.refKindIsValid(refKind));
            return lookup.linkMethodHandleConstant((byte)refKind, defc, name, type);
        }
        catch (ReflectiveOperationException ex) {
            throw MethodHandleNatives.mapLookupExceptionToError(ex);
        }
    }

    static LinkageError mapLookupExceptionToError(ReflectiveOperationException ex) {
        IncompatibleClassChangeError err;
        if (ex instanceof IllegalAccessException) {
            Throwable cause = ex.getCause();
            if (cause instanceof AbstractMethodError) {
                return (AbstractMethodError)cause;
            }
            err = new IllegalAccessError(ex.getMessage());
        } else {
            err = ex instanceof NoSuchMethodException ? new NoSuchMethodError(ex.getMessage()) : (ex instanceof NoSuchFieldException ? new NoSuchFieldError(ex.getMessage()) : new IncompatibleClassChangeError());
        }
        return MethodHandleNatives.initCauseFrom(err, ex);
    }

    static <E extends Error> E initCauseFrom(E err, Exception ex) {
        Throwable th = ex.getCause();
        Class<?> Eclass = err.getClass();
        if (Eclass.isInstance(th)) {
            return (E)((Error)Eclass.cast(th));
        }
        err.initCause(th == null ? ex : th);
        return err;
    }

    static boolean isCallerSensitive(MemberName mem) {
        if (!mem.isInvocable()) {
            return false;
        }
        return mem.isCallerSensitive() || MethodHandleNatives.canBeCalledVirtual(mem);
    }

    static boolean canBeCalledVirtual(MemberName mem) {
        assert (mem.isInvocable());
        return mem.getName().equals("getContextClassLoader") && MethodHandleNatives.canBeCalledVirtual(mem, Thread.class);
    }

    static boolean canBeCalledVirtual(MemberName symbolicRef, Class<?> definingClass) {
        Class<?> symbolicRefClass = symbolicRef.getDeclaringClass();
        if (symbolicRefClass == definingClass) {
            return true;
        }
        if (symbolicRef.isStatic() || symbolicRef.isPrivate()) {
            return false;
        }
        return definingClass.isAssignableFrom(symbolicRefClass) || symbolicRefClass.isInterface();
    }

    static Object classData(Class<?> c) {
        MethodHandleStatics.UNSAFE.ensureClassInitialized(c);
        return JLA.classData(c);
    }

    static {
        MethodHandleNatives.registerNatives();
        int HR_MASK = 682;
        for (byte refKind = 1; refKind < 10; refKind = (byte)(refKind + 1)) {
            assert (MethodHandleNatives.refKindHasReceiver(refKind) == ((1 << refKind & 0x2AA) != 0)) : refKind;
        }
        assert (MethodHandleNatives.verifyConstants());
        JLA = SharedSecrets.getJavaLangAccess();
    }

    static class Constants {
        static final int MN_IS_METHOD = 65536;
        static final int MN_IS_CONSTRUCTOR = 131072;
        static final int MN_IS_FIELD = 262144;
        static final int MN_IS_TYPE = 524288;
        static final int MN_CALLER_SENSITIVE = 0x100000;
        static final int MN_TRUSTED_FINAL = 0x200000;
        static final int MN_REFERENCE_KIND_SHIFT = 24;
        static final int MN_REFERENCE_KIND_MASK = 15;
        static final int MN_SEARCH_SUPERCLASSES = 0x100000;
        static final int MN_SEARCH_INTERFACES = 0x200000;
        static final byte REF_NONE = 0;
        static final byte REF_getField = 1;
        static final byte REF_getStatic = 2;
        static final byte REF_putField = 3;
        static final byte REF_putStatic = 4;
        static final byte REF_invokeVirtual = 5;
        static final byte REF_invokeStatic = 6;
        static final byte REF_invokeSpecial = 7;
        static final byte REF_newInvokeSpecial = 8;
        static final byte REF_invokeInterface = 9;
        static final byte REF_LIMIT = 10;
        static final int NESTMATE_CLASS = 1;
        static final int HIDDEN_CLASS = 2;
        static final int STRONG_LOADER_LINK = 4;
        static final int ACCESS_VM_ANNOTATIONS = 8;
        static final int LM_MODULE = 16;
        static final int LM_UNCONDITIONAL = 32;
        static final int LM_TRUSTED = -1;

        Constants() {
        }
    }

    static class CallSiteContext
    implements Runnable {
        CallSiteContext() {
        }

        static CallSiteContext make(CallSite cs) {
            CallSiteContext newContext = new CallSiteContext();
            CleanerFactory.cleaner().register(cs, newContext);
            return newContext;
        }

        @Override
        public void run() {
            MethodHandleNatives.clearCallSiteContext(this);
        }
    }
}

