/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.BootstrapMethodInvoker;
import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.DirectMethodHandle;
import java.lang.invoke.InfoFromMemberName;
import java.lang.invoke.LambdaForm;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleImpl;
import java.lang.invoke.MethodHandleInfo;
import java.lang.invoke.MethodHandleNatives;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.invoke.VarHandle;
import java.lang.invoke.VarHandles;
import java.lang.invoke.WrongMethodTypeException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ReflectPermission;
import java.nio.ByteOrder;
import java.security.Permission;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import jdk.internal.access.SharedSecrets;
import jdk.internal.misc.Unsafe;
import jdk.internal.misc.VM;
import jdk.internal.org.objectweb.asm.ClassReader;
import jdk.internal.org.objectweb.asm.Type;
import jdk.internal.reflect.CallerSensitive;
import jdk.internal.reflect.Reflection;
import jdk.internal.vm.annotation.ForceInline;
import sun.invoke.util.ValueConversions;
import sun.invoke.util.VerifyAccess;
import sun.invoke.util.Wrapper;
import sun.reflect.misc.ReflectUtil;
import sun.security.util.SecurityConstants;

public class MethodHandles {
    static final MemberName.Factory IMPL_NAMES = MemberName.getFactory();
    private static final Permission ACCESS_PERMISSION = new ReflectPermission("suppressAccessChecks");
    private static final MethodHandle[] IDENTITY_MHS = new MethodHandle[10];
    private static final MethodHandle[] ZERO_MHS = new MethodHandle[10];

    private MethodHandles() {
    }

    @CallerSensitive
    @ForceInline
    public static Lookup lookup() {
        return new Lookup(Reflection.getCallerClass());
    }

    @CallerSensitive
    private static Lookup reflected$lookup() {
        Class<?> caller = Reflection.getCallerClass();
        if (caller.getClassLoader() == null) {
            throw MethodHandleStatics.newIllegalArgumentException("illegal lookupClass: " + caller);
        }
        return new Lookup(caller);
    }

    public static Lookup publicLookup() {
        return Lookup.PUBLIC_LOOKUP;
    }

    public static Lookup privateLookupIn(Class<?> targetClass, Lookup caller) throws IllegalAccessException {
        if (caller.allowedModes == -1) {
            return new Lookup(targetClass);
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ACCESS_PERMISSION);
        }
        if (targetClass.isPrimitive()) {
            throw new IllegalArgumentException(targetClass + " is a primitive class");
        }
        if (targetClass.isArray()) {
            throw new IllegalArgumentException(targetClass + " is an array class");
        }
        int requireAccess = 18;
        if ((caller.lookupModes() & requireAccess) != requireAccess) {
            throw new IllegalAccessException("caller does not have PRIVATE and MODULE lookup mode");
        }
        assert (caller.previousLookupClass() == null);
        Class<?> callerClass = caller.lookupClass();
        Module callerModule = callerClass.getModule();
        Module targetModule = targetClass.getModule();
        Class<?> newPreviousClass = null;
        int newModes = 31;
        if (targetModule != callerModule) {
            if (!callerModule.canRead(targetModule)) {
                throw new IllegalAccessException(callerModule + " does not read " + targetModule);
            }
            if (targetModule.isNamed()) {
                String pn = targetClass.getPackageName();
                assert (!pn.isEmpty()) : "unnamed package cannot be in named module";
                if (!targetModule.isOpen(pn, callerModule)) {
                    throw new IllegalAccessException(targetModule + " does not open " + pn + " to " + callerModule);
                }
            }
            newPreviousClass = callerClass;
            newModes &= 0xFFFFFFEF;
        }
        return Lookup.newLookup(targetClass, newPreviousClass, newModes);
    }

    public static <T> T classData(Lookup caller, String name, Class<T> type) throws IllegalAccessException {
        Objects.requireNonNull(caller);
        Objects.requireNonNull(type);
        if (!"_".equals(name)) {
            throw new IllegalArgumentException("name must be \"_\": " + name);
        }
        if ((caller.lookupModes() & 0x40) != 64) {
            throw new IllegalAccessException(caller + " does not have ORIGINAL access");
        }
        Object classdata = MethodHandleNatives.classData(caller.lookupClass());
        if (classdata == null) {
            return null;
        }
        try {
            return BootstrapMethodInvoker.widenAndCast(classdata, type);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InternalError(e);
        }
    }

    public static <T> T classDataAt(Lookup caller, String name, Class<T> type, int index) throws IllegalAccessException {
        List classdata = MethodHandles.classData(caller, name, List.class);
        if (classdata == null) {
            return null;
        }
        try {
            Object element = classdata.get(index);
            return BootstrapMethodInvoker.widenAndCast(element, type);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InternalError(e);
        }
    }

    public static <T extends Member> T reflectAs(Class<T> expected, MethodHandle target) {
        SecurityManager smgr = System.getSecurityManager();
        if (smgr != null) {
            smgr.checkPermission(ACCESS_PERMISSION);
        }
        Lookup lookup = Lookup.IMPL_LOOKUP;
        return lookup.revealDirect(target).reflectAs(expected, lookup);
    }

    public static MethodHandle arrayConstructor(Class<?> arrayClass) throws IllegalArgumentException {
        if (!arrayClass.isArray()) {
            throw MethodHandleStatics.newIllegalArgumentException("not an array class: " + arrayClass.getName());
        }
        MethodHandle ani = MethodHandleImpl.getConstantHandle(7).bindTo(arrayClass.getComponentType());
        return ani.asType(ani.type().changeReturnType(arrayClass));
    }

    public static MethodHandle arrayLength(Class<?> arrayClass) throws IllegalArgumentException {
        return MethodHandleImpl.makeArrayElementAccessor(arrayClass, MethodHandleImpl.ArrayAccess.LENGTH);
    }

    public static MethodHandle arrayElementGetter(Class<?> arrayClass) throws IllegalArgumentException {
        return MethodHandleImpl.makeArrayElementAccessor(arrayClass, MethodHandleImpl.ArrayAccess.GET);
    }

    public static MethodHandle arrayElementSetter(Class<?> arrayClass) throws IllegalArgumentException {
        return MethodHandleImpl.makeArrayElementAccessor(arrayClass, MethodHandleImpl.ArrayAccess.SET);
    }

    public static VarHandle arrayElementVarHandle(Class<?> arrayClass) throws IllegalArgumentException {
        return VarHandles.makeArrayElementHandle(arrayClass);
    }

    public static VarHandle byteArrayViewVarHandle(Class<?> viewArrayClass, ByteOrder byteOrder) throws IllegalArgumentException {
        Objects.requireNonNull(byteOrder);
        return VarHandles.byteArrayViewHandle(viewArrayClass, byteOrder == ByteOrder.BIG_ENDIAN);
    }

    public static VarHandle byteBufferViewVarHandle(Class<?> viewArrayClass, ByteOrder byteOrder) throws IllegalArgumentException {
        Objects.requireNonNull(byteOrder);
        return VarHandles.makeByteBufferViewHandle(viewArrayClass, byteOrder == ByteOrder.BIG_ENDIAN);
    }

    public static MethodHandle spreadInvoker(MethodType type, int leadingArgCount) {
        if (leadingArgCount < 0 || leadingArgCount > type.parameterCount()) {
            throw MethodHandleStatics.newIllegalArgumentException("bad argument count", leadingArgCount);
        }
        type = type.asSpreaderType(Object[].class, leadingArgCount, type.parameterCount() - leadingArgCount);
        return type.invokers().spreadInvoker(leadingArgCount);
    }

    public static MethodHandle exactInvoker(MethodType type) {
        return type.invokers().exactInvoker();
    }

    public static MethodHandle invoker(MethodType type) {
        return type.invokers().genericInvoker();
    }

    public static MethodHandle varHandleExactInvoker(VarHandle.AccessMode accessMode, MethodType type) {
        return type.invokers().varHandleMethodExactInvoker(accessMode);
    }

    public static MethodHandle varHandleInvoker(VarHandle.AccessMode accessMode, MethodType type) {
        return type.invokers().varHandleMethodInvoker(accessMode);
    }

    static MethodHandle basicInvoker(MethodType type) {
        return type.invokers().basicInvoker();
    }

    public static MethodHandle explicitCastArguments(MethodHandle target, MethodType newType) {
        MethodHandles.explicitCastArgumentsChecks(target, newType);
        MethodType oldType = target.type();
        if (oldType == newType) {
            return target;
        }
        if (oldType.explicitCastEquivalentToAsType(newType)) {
            return target.asFixedArity().asType(newType);
        }
        return MethodHandleImpl.makePairwiseConvert(target, newType, false);
    }

    private static void explicitCastArgumentsChecks(MethodHandle target, MethodType newType) {
        if (target.type().parameterCount() != newType.parameterCount()) {
            throw new WrongMethodTypeException("cannot explicitly cast " + target + " to " + newType);
        }
    }

    public static MethodHandle permuteArguments(MethodHandle target, MethodType newType, int ... reorder) {
        int ddIdx;
        reorder = (int[])reorder.clone();
        MethodType oldType = target.type();
        MethodHandles.permuteArgumentChecks(reorder, newType, oldType);
        int[] originalReorder = reorder;
        BoundMethodHandle result = target.rebind();
        LambdaForm form = result.form;
        int newArity = newType.parameterCount();
        while ((ddIdx = MethodHandles.findFirstDupOrDrop(reorder, newArity)) != 0) {
            if (ddIdx > 0) {
                int val;
                int srcPos;
                int dstPos = srcPos = ddIdx;
                int dupVal = reorder[srcPos];
                boolean killFirst = false;
                while ((val = reorder[--dstPos]) != dupVal) {
                    if (dupVal <= val) continue;
                    killFirst = true;
                }
                if (!killFirst) {
                    srcPos = dstPos;
                    dstPos = ddIdx;
                }
                form = form.editor().dupArgumentForm(1 + srcPos, 1 + dstPos);
                assert (reorder[srcPos] == reorder[dstPos]);
                oldType = oldType.dropParameterTypes(dstPos, dstPos + 1);
                int tailPos = dstPos + 1;
                System.arraycopy(reorder, tailPos, reorder, dstPos, reorder.length - tailPos);
                reorder = Arrays.copyOf(reorder, reorder.length - 1);
            } else {
                int insPos;
                int dropVal = ~ddIdx;
                for (insPos = 0; insPos < reorder.length && reorder[insPos] < dropVal; ++insPos) {
                }
                TypeDescriptor.OfField ptype = newType.parameterType(dropVal);
                form = form.editor().addArgumentForm(1 + insPos, LambdaForm.BasicType.basicType(ptype));
                oldType = oldType.insertParameterTypes(insPos, new Class[]{ptype});
                int tailPos = insPos + 1;
                reorder = Arrays.copyOf(reorder, reorder.length + 1);
                System.arraycopy(reorder, insPos, reorder, tailPos, reorder.length - tailPos);
                reorder[insPos] = dropVal;
            }
            assert (MethodHandles.permuteArgumentChecks(reorder, newType, oldType));
        }
        assert (reorder.length == newArity);
        form = form.editor().permuteArgumentsForm(1, reorder);
        if (newType == result.type() && form == result.internalForm()) {
            return result;
        }
        return result.copyWith(newType, form);
    }

    private static int findFirstDupOrDrop(int[] reorder, int newArity) {
        int BIT_LIMIT = 63;
        if (newArity < 63) {
            long mask = 0L;
            for (int i = 0; i < reorder.length; ++i) {
                int arg = reorder[i];
                if (arg >= newArity) {
                    return reorder.length;
                }
                long bit = 1L << arg;
                if ((mask & bit) != 0L) {
                    return i;
                }
                mask |= bit;
            }
            if (mask == (1L << newArity) - 1L) {
                assert (Long.numberOfTrailingZeros(Long.lowestOneBit(mask ^ 0xFFFFFFFFFFFFFFFFL)) == newArity);
                return 0;
            }
            long zeroBit = Long.lowestOneBit(mask ^ 0xFFFFFFFFFFFFFFFFL);
            int zeroPos = Long.numberOfTrailingZeros(zeroBit);
            assert (zeroPos <= newArity);
            if (zeroPos == newArity) {
                return 0;
            }
            return ~zeroPos;
        }
        BitSet mask = new BitSet(newArity);
        for (int i = 0; i < reorder.length; ++i) {
            int arg = reorder[i];
            if (arg >= newArity) {
                return reorder.length;
            }
            if (mask.get(arg)) {
                return i;
            }
            mask.set(arg);
        }
        int zeroPos = mask.nextClearBit(0);
        assert (zeroPos <= newArity);
        if (zeroPos == newArity) {
            return 0;
        }
        return ~zeroPos;
    }

    static boolean permuteArgumentChecks(int[] reorder, MethodType newType, MethodType oldType) {
        if (newType.returnType() != oldType.returnType()) {
            throw MethodHandleStatics.newIllegalArgumentException("return types do not match", oldType, newType);
        }
        if (reorder.length != oldType.parameterCount()) {
            throw MethodHandleStatics.newIllegalArgumentException("old type parameter count and reorder array length do not match", oldType, Arrays.toString(reorder));
        }
        int limit = newType.parameterCount();
        for (int j = 0; j < reorder.length; ++j) {
            TypeDescriptor.OfField dst;
            int i = reorder[j];
            if (i < 0 || i >= limit) {
                throw MethodHandleStatics.newIllegalArgumentException("index is out of bounds for new type", i, newType);
            }
            TypeDescriptor.OfField src = newType.parameterType(i);
            if (src == (dst = oldType.parameterType(j))) continue;
            throw MethodHandleStatics.newIllegalArgumentException("parameter types do not match after reorder", oldType, newType);
        }
        return true;
    }

    public static MethodHandle constant(Class<?> type, Object value) {
        if (type.isPrimitive()) {
            if (type == Void.TYPE) {
                throw MethodHandleStatics.newIllegalArgumentException("void type");
            }
            Wrapper w = Wrapper.forPrimitiveType(type);
            value = w.convert(value, type);
            if (w.zero().equals(value)) {
                return MethodHandles.zero(w, type);
            }
            return MethodHandles.insertArguments(MethodHandles.identity(type), 0, value);
        }
        if (value == null) {
            return MethodHandles.zero(Wrapper.OBJECT, type);
        }
        return MethodHandles.identity(type).bindTo(value);
    }

    public static MethodHandle identity(Class<?> type) {
        Wrapper btw = type.isPrimitive() ? Wrapper.forPrimitiveType(type) : Wrapper.OBJECT;
        int pos = btw.ordinal();
        MethodHandle ident = IDENTITY_MHS[pos];
        if (ident == null) {
            ident = MethodHandles.setCachedMethodHandle(IDENTITY_MHS, pos, MethodHandles.makeIdentity(btw.primitiveType()));
        }
        if (ident.type().returnType() == type) {
            return ident;
        }
        assert (btw == Wrapper.OBJECT);
        return MethodHandles.makeIdentity(type);
    }

    public static MethodHandle zero(Class<?> type) {
        Objects.requireNonNull(type);
        return type.isPrimitive() ? MethodHandles.zero(Wrapper.forPrimitiveType(type), type) : MethodHandles.zero(Wrapper.OBJECT, type);
    }

    private static MethodHandle identityOrVoid(Class<?> type) {
        return type == Void.TYPE ? MethodHandles.zero(type) : MethodHandles.identity(type);
    }

    public static MethodHandle empty(MethodType type) {
        Objects.requireNonNull(type);
        return MethodHandles.dropArguments(MethodHandles.zero(type.returnType()), 0, type.parameterList());
    }

    private static MethodHandle makeIdentity(Class<?> ptype) {
        MethodType mtype = MethodType.methodType(ptype, ptype);
        LambdaForm lform = LambdaForm.identityForm(LambdaForm.BasicType.basicType(ptype));
        return MethodHandleImpl.makeIntrinsic(mtype, lform, MethodHandleImpl.Intrinsic.IDENTITY);
    }

    private static MethodHandle zero(Wrapper btw, Class<?> rtype) {
        int pos = btw.ordinal();
        MethodHandle zero = ZERO_MHS[pos];
        if (zero == null) {
            zero = MethodHandles.setCachedMethodHandle(ZERO_MHS, pos, MethodHandles.makeZero(btw.primitiveType()));
        }
        if (zero.type().returnType() == rtype) {
            return zero;
        }
        assert (btw == Wrapper.OBJECT);
        return MethodHandles.makeZero(rtype);
    }

    private static MethodHandle makeZero(Class<?> rtype) {
        MethodType mtype = MethodType.methodType(rtype);
        LambdaForm lform = LambdaForm.zeroForm(LambdaForm.BasicType.basicType(rtype));
        return MethodHandleImpl.makeIntrinsic(mtype, lform, MethodHandleImpl.Intrinsic.ZERO);
    }

    private static synchronized MethodHandle setCachedMethodHandle(MethodHandle[] cache, int pos, MethodHandle value) {
        MethodHandle prev = cache[pos];
        if (prev != null) {
            return prev;
        }
        cache[pos] = value;
        return cache[pos];
    }

    public static MethodHandle insertArguments(MethodHandle target, int pos, Object ... values) {
        int insCount = values.length;
        Class<?>[] ptypes = MethodHandles.insertArgumentsChecks(target, insCount, pos);
        if (insCount == 0) {
            return target;
        }
        BoundMethodHandle result = target.rebind();
        for (int i = 0; i < insCount; ++i) {
            Object value = values[i];
            Class<?> ptype = ptypes[pos + i];
            if (ptype.isPrimitive()) {
                result = MethodHandles.insertArgumentPrimitive(result, pos, ptype, value);
                continue;
            }
            value = ptype.cast(value);
            result = result.bindArgumentL(pos, value);
        }
        return result;
    }

    private static BoundMethodHandle insertArgumentPrimitive(BoundMethodHandle result, int pos, Class<?> ptype, Object value) {
        Wrapper w = Wrapper.forPrimitiveType(ptype);
        value = w.convert(value, ptype);
        return switch (w) {
            case Wrapper.INT -> result.bindArgumentI(pos, (Integer)value);
            case Wrapper.LONG -> result.bindArgumentJ(pos, (Long)value);
            case Wrapper.FLOAT -> result.bindArgumentF(pos, ((Float)value).floatValue());
            case Wrapper.DOUBLE -> result.bindArgumentD(pos, (Double)value);
            default -> result.bindArgumentI(pos, ValueConversions.widenSubword(value));
        };
    }

    private static Class<?>[] insertArgumentsChecks(MethodHandle target, int insCount, int pos) throws RuntimeException {
        MethodType oldType = target.type();
        int outargs = oldType.parameterCount();
        int inargs = outargs - insCount;
        if (inargs < 0) {
            throw MethodHandleStatics.newIllegalArgumentException("too many values to insert");
        }
        if (pos < 0 || pos > inargs) {
            throw MethodHandleStatics.newIllegalArgumentException("no argument type to append");
        }
        return oldType.ptypes();
    }

    public static MethodHandle dropArguments(MethodHandle target, int pos, List<Class<?>> valueTypes) {
        return MethodHandles.dropArguments0(target, pos, MethodHandles.copyTypes(valueTypes.toArray()));
    }

    private static List<Class<?>> copyTypes(Object[] array) {
        return Arrays.asList((Class[])Arrays.copyOf(array, array.length, Class[].class));
    }

    private static MethodHandle dropArguments0(MethodHandle target, int pos, List<Class<?>> valueTypes) {
        MethodType oldType = target.type();
        int dropped = MethodHandles.dropArgumentChecks(oldType, pos, valueTypes);
        MethodType newType = oldType.insertParameterTypes(pos, valueTypes);
        if (dropped == 0) {
            return target;
        }
        BoundMethodHandle result = target.rebind();
        LambdaForm lform = result.form;
        int insertFormArg = 1 + pos;
        for (Class<?> ptype : valueTypes) {
            lform = lform.editor().addArgumentForm(insertFormArg++, LambdaForm.BasicType.basicType(ptype));
        }
        result = result.copyWith(newType, lform);
        return result;
    }

    private static int dropArgumentChecks(MethodType oldType, int pos, List<Class<?>> valueTypes) {
        int dropped = valueTypes.size();
        MethodType.checkSlotCount(dropped);
        int outargs = oldType.parameterCount();
        int inargs = outargs + dropped;
        if (pos < 0 || pos > outargs) {
            throw MethodHandleStatics.newIllegalArgumentException("no argument type to remove" + Arrays.asList(oldType, pos, valueTypes, inargs, outargs));
        }
        return dropped;
    }

    public static MethodHandle dropArguments(MethodHandle target, int pos, Class<?> ... valueTypes) {
        return MethodHandles.dropArguments0(target, pos, MethodHandles.copyTypes(valueTypes));
    }

    private static MethodHandle dropArgumentsToMatch(MethodHandle target, int skip, List<Class<?>> newTypes, int pos, boolean nullOnFailure) {
        newTypes = MethodHandles.copyTypes(newTypes.toArray());
        List<Class<?>> oldTypes = target.type().parameterList();
        int match = oldTypes.size();
        if (skip != 0) {
            if (skip < 0 || skip > match) {
                throw MethodHandleStatics.newIllegalArgumentException("illegal skip", skip, target);
            }
            oldTypes = oldTypes.subList(skip, match);
            match -= skip;
        }
        List<Class<?>> addTypes = newTypes;
        int add = addTypes.size();
        if (pos != 0) {
            if (pos < 0 || pos > add) {
                throw MethodHandleStatics.newIllegalArgumentException("illegal pos", pos, newTypes);
            }
            addTypes = addTypes.subList(pos, add);
            assert (addTypes.size() == (add -= pos));
        }
        if (match > add || !oldTypes.equals(addTypes.subList(0, match))) {
            if (nullOnFailure) {
                return null;
            }
            throw MethodHandleStatics.newIllegalArgumentException("argument lists do not match", oldTypes, newTypes);
        }
        addTypes = addTypes.subList(match, add);
        assert (addTypes.size() == (add -= match));
        MethodHandle adapter = target;
        if (add > 0) {
            adapter = MethodHandles.dropArguments0(adapter, skip + match, addTypes);
        }
        if (pos > 0) {
            adapter = MethodHandles.dropArguments0(adapter, skip, newTypes.subList(0, pos));
        }
        return adapter;
    }

    public static MethodHandle dropArgumentsToMatch(MethodHandle target, int skip, List<Class<?>> newTypes, int pos) {
        Objects.requireNonNull(target);
        Objects.requireNonNull(newTypes);
        return MethodHandles.dropArgumentsToMatch(target, skip, newTypes, pos, false);
    }

    public static MethodHandle dropReturn(MethodHandle target) {
        Objects.requireNonNull(target);
        MethodType oldType = target.type();
        TypeDescriptor.OfField oldReturnType = oldType.returnType();
        if (oldReturnType == Void.TYPE) {
            return target;
        }
        MethodType newType = oldType.changeReturnType(Void.TYPE);
        BoundMethodHandle result = target.rebind();
        LambdaForm lform = result.editor().filterReturnForm(LambdaForm.BasicType.V_TYPE, true);
        result = result.copyWith(newType, lform);
        return result;
    }

    public static MethodHandle filterArguments(MethodHandle target, int pos, MethodHandle ... filters) {
        boolean MH_RECEIVER_OFFSET = true;
        MethodHandles.filterArgumentsCheckArity(target, pos, filters);
        MethodHandle adapter = target;
        int index = 0;
        int[] positions = new int[filters.length];
        MethodHandle filter = null;
        for (int i = filters.length - 1; i >= 0; --i) {
            MethodHandle newFilter = filters[i];
            if (newFilter == null) continue;
            if (filter != newFilter) {
                if (filter != null) {
                    adapter = index > 1 ? MethodHandles.filterRepeatedArgument(adapter, filter, Arrays.copyOf(positions, index)) : MethodHandles.filterArgument(adapter, positions[0] - 1, filter);
                }
                filter = newFilter;
                index = 0;
            }
            MethodHandles.filterArgumentChecks(target, pos + i, newFilter);
            positions[index++] = pos + i + 1;
        }
        if (index > 1) {
            adapter = MethodHandles.filterRepeatedArgument(adapter, filter, Arrays.copyOf(positions, index));
        } else if (index == 1) {
            adapter = MethodHandles.filterArgument(adapter, positions[0] - 1, filter);
        }
        return adapter;
    }

    private static MethodHandle filterRepeatedArgument(MethodHandle adapter, MethodHandle filter, int[] positions) {
        MethodType targetType = adapter.type();
        MethodType filterType = filter.type();
        BoundMethodHandle result = adapter.rebind();
        TypeDescriptor.OfField newParamType = filterType.parameterType(0);
        Class[] ptypes = (Class[])targetType.ptypes().clone();
        for (int pos : positions) {
            ptypes[pos - 1] = newParamType;
        }
        MethodType newType = MethodType.makeImpl(targetType.rtype(), ptypes, true);
        LambdaForm lform = result.editor().filterRepeatedArgumentForm(LambdaForm.BasicType.basicType(newParamType), positions);
        return result.copyWithExtendL(newType, lform, filter);
    }

    static MethodHandle filterArgument(MethodHandle target, int pos, MethodHandle filter) {
        MethodHandles.filterArgumentChecks(target, pos, filter);
        MethodType targetType = target.type();
        MethodType filterType = filter.type();
        BoundMethodHandle result = target.rebind();
        TypeDescriptor.OfField newParamType = filterType.parameterType(0);
        LambdaForm lform = result.editor().filterArgumentForm(1 + pos, LambdaForm.BasicType.basicType(newParamType));
        MethodType newType = targetType.changeParameterType(pos, (Class<?>)newParamType);
        result = result.copyWithExtendL(newType, lform, filter);
        return result;
    }

    private static void filterArgumentsCheckArity(MethodHandle target, int pos, MethodHandle[] filters) {
        MethodType targetType = target.type();
        int maxPos = targetType.parameterCount();
        if (pos + filters.length > maxPos) {
            throw MethodHandleStatics.newIllegalArgumentException("too many filters");
        }
    }

    private static void filterArgumentChecks(MethodHandle target, int pos, MethodHandle filter) throws RuntimeException {
        MethodType targetType = target.type();
        MethodType filterType = filter.type();
        if (filterType.parameterCount() != 1 || filterType.returnType() != targetType.parameterType(pos)) {
            throw MethodHandleStatics.newIllegalArgumentException("target and filter types do not match", targetType, filterType);
        }
    }

    public static MethodHandle collectArguments(MethodHandle target, int pos, MethodHandle filter) {
        MethodType newType = MethodHandles.collectArgumentsChecks(target, pos, filter);
        MethodType collectorType = filter.type();
        BoundMethodHandle result = target.rebind();
        LambdaForm lform = result.editor().collectArgumentsForm(1 + pos, collectorType.basicType());
        return result.copyWithExtendL(newType, lform, filter);
    }

    private static MethodType collectArgumentsChecks(MethodHandle target, int pos, MethodHandle filter) throws RuntimeException {
        MethodType targetType = target.type();
        MethodType filterType = filter.type();
        TypeDescriptor.OfField rtype = filterType.returnType();
        List<Class<?>> filterArgs = filterType.parameterList();
        if (pos < 0 || rtype == Void.TYPE && pos > targetType.parameterCount() || rtype != Void.TYPE && pos >= targetType.parameterCount()) {
            throw MethodHandleStatics.newIllegalArgumentException("position is out of range for target", target, pos);
        }
        if (rtype == Void.TYPE) {
            return targetType.insertParameterTypes(pos, filterArgs);
        }
        if (rtype != targetType.parameterType(pos)) {
            throw MethodHandleStatics.newIllegalArgumentException("target and filter types do not match", targetType, filterType);
        }
        return targetType.dropParameterTypes(pos, pos + 1).insertParameterTypes(pos, filterArgs);
    }

    public static MethodHandle filterReturnValue(MethodHandle target, MethodHandle filter) {
        MethodType targetType = target.type();
        MethodType filterType = filter.type();
        MethodHandles.filterReturnValueChecks(targetType, filterType);
        BoundMethodHandle result = target.rebind();
        LambdaForm.BasicType rtype = LambdaForm.BasicType.basicType(filterType.returnType());
        LambdaForm lform = result.editor().filterReturnForm(rtype, false);
        MethodType newType = targetType.changeReturnType((Class<?>)filterType.returnType());
        result = result.copyWithExtendL(newType, lform, filter);
        return result;
    }

    private static void filterReturnValueChecks(MethodType targetType, MethodType filterType) throws RuntimeException {
        TypeDescriptor.OfField rtype = targetType.returnType();
        int filterValues = filterType.parameterCount();
        if (filterValues == 0 ? rtype != Void.TYPE : rtype != filterType.parameterType(0) || filterValues != 1) {
            throw MethodHandleStatics.newIllegalArgumentException("target and filter types do not match", targetType, filterType);
        }
    }

    static MethodHandle collectReturnValue(MethodHandle target, MethodHandle filter) {
        MethodType targetType = target.type();
        MethodType filterType = filter.type();
        BoundMethodHandle result = target.rebind();
        LambdaForm lform = result.editor().collectReturnValueForm(filterType.basicType());
        MethodType newType = targetType.changeReturnType((Class<?>)filterType.returnType());
        if (filterType.parameterList().size() > 1) {
            for (int i = 0; i < filterType.parameterList().size() - 1; ++i) {
                newType = newType.appendParameterTypes(new Class[]{filterType.parameterType(i)});
            }
        }
        result = result.copyWithExtendL(newType, lform, filter);
        return result;
    }

    public static MethodHandle foldArguments(MethodHandle target, MethodHandle combiner) {
        return MethodHandles.foldArguments(target, 0, combiner);
    }

    public static MethodHandle foldArguments(MethodHandle target, int pos, MethodHandle combiner) {
        MethodType targetType = target.type();
        MethodType combinerType = combiner.type();
        Class<?> rtype = MethodHandles.foldArgumentChecks(pos, targetType, combinerType);
        BoundMethodHandle result = target.rebind();
        boolean dropResult = rtype == Void.TYPE;
        LambdaForm lform = result.editor().foldArgumentsForm(1 + pos, dropResult, combinerType.basicType());
        MethodType newType = targetType;
        if (!dropResult) {
            newType = newType.dropParameterTypes(pos, pos + 1);
        }
        result = result.copyWithExtendL(newType, lform, combiner);
        return result;
    }

    private static Class<?> foldArgumentChecks(int foldPos, MethodType targetType, MethodType combinerType) {
        boolean ok;
        int foldArgs = combinerType.parameterCount();
        TypeDescriptor.OfField rtype = combinerType.returnType();
        int foldVals = rtype == Void.TYPE ? 0 : 1;
        int afterInsertPos = foldPos + foldVals;
        boolean bl = ok = targetType.parameterCount() >= afterInsertPos + foldArgs;
        if (ok) {
            for (int i = 0; i < foldArgs; ++i) {
                if (combinerType.parameterType(i) == targetType.parameterType(i + afterInsertPos)) continue;
                ok = false;
                break;
            }
        }
        if (ok && foldVals != 0 && combinerType.returnType() != targetType.parameterType(foldPos)) {
            ok = false;
        }
        if (!ok) {
            throw MethodHandles.misMatchedTypes("target and combiner types", targetType, combinerType);
        }
        return rtype;
    }

    static MethodHandle filterArgumentsWithCombiner(MethodHandle target, int position, MethodHandle combiner, int ... argPositions) {
        return MethodHandles.argumentsWithCombiner(true, target, position, combiner, argPositions);
    }

    static MethodHandle foldArgumentsWithCombiner(MethodHandle target, int position, MethodHandle combiner, int ... argPositions) {
        return MethodHandles.argumentsWithCombiner(false, target, position, combiner, argPositions);
    }

    private static MethodHandle argumentsWithCombiner(boolean filter, MethodHandle target, int position, MethodHandle combiner, int ... argPositions) {
        LambdaForm lform;
        MethodType targetType = target.type();
        MethodType combinerType = combiner.type();
        Class<?> rtype = MethodHandles.argumentsWithCombinerChecks(position, filter, targetType, combinerType, argPositions);
        BoundMethodHandle result = target.rebind();
        MethodType newType = targetType;
        if (filter) {
            lform = result.editor().filterArgumentsForm(1 + position, combinerType.basicType(), argPositions);
        } else {
            boolean dropResult = rtype == Void.TYPE;
            lform = result.editor().foldArgumentsForm(1 + position, dropResult, combinerType.basicType(), argPositions);
            if (!dropResult) {
                newType = newType.dropParameterTypes(position, position + 1);
            }
        }
        result = result.copyWithExtendL(newType, lform, combiner);
        return result;
    }

    private static Class<?> argumentsWithCombinerChecks(int position, boolean filter, MethodType targetType, MethodType combinerType, int ... argPos) {
        int combinerArgs = combinerType.parameterCount();
        if (argPos.length != combinerArgs) {
            throw MethodHandleStatics.newIllegalArgumentException("combiner and argument map must be equal size", combinerType, argPos.length);
        }
        TypeDescriptor.OfField rtype = combinerType.returnType();
        for (int i = 0; i < combinerArgs; ++i) {
            int arg = argPos[i];
            if (arg < 0 || arg > targetType.parameterCount()) {
                throw MethodHandleStatics.newIllegalArgumentException("arg outside of target parameterRange", targetType, arg);
            }
            if (combinerType.parameterType(i) == targetType.parameterType(arg)) continue;
            throw MethodHandleStatics.newIllegalArgumentException("target argument type at position " + arg + " must match combiner argument type at index " + i + ": " + targetType + " -> " + combinerType + ", map: " + Arrays.toString(argPos));
        }
        if (filter && combinerType.returnType() != targetType.parameterType(position)) {
            throw MethodHandles.misMatchedTypes("target and combiner types", targetType, combinerType);
        }
        return rtype;
    }

    public static MethodHandle guardWithTest(MethodHandle test, MethodHandle target, MethodHandle fallback) {
        MethodType ftype;
        MethodType gtype = test.type();
        MethodType ttype = target.type();
        if (!ttype.equals((Object)(ftype = fallback.type()))) {
            throw MethodHandles.misMatchedTypes("target and fallback types", ttype, ftype);
        }
        if (gtype.returnType() != Boolean.TYPE) {
            throw MethodHandleStatics.newIllegalArgumentException("guard type is not a predicate " + gtype);
        }
        List<Class<?>> targs = ttype.parameterList();
        if ((test = MethodHandles.dropArgumentsToMatch(test, 0, targs, 0, true)) == null) {
            throw MethodHandles.misMatchedTypes("target and test types", ttype, gtype);
        }
        return MethodHandleImpl.makeGuardWithTest(test, target, fallback);
    }

    static <T> RuntimeException misMatchedTypes(String what, T t1, T t2) {
        return MethodHandleStatics.newIllegalArgumentException(what + " must match: " + t1 + " != " + t2);
    }

    public static MethodHandle catchException(MethodHandle target, Class<? extends Throwable> exType, MethodHandle handler) {
        MethodType ttype = target.type();
        MethodType htype = handler.type();
        if (!Throwable.class.isAssignableFrom(exType)) {
            throw new ClassCastException(exType.getName());
        }
        if (htype.parameterCount() < 1 || !((Class)htype.parameterType(0)).isAssignableFrom(exType)) {
            throw MethodHandleStatics.newIllegalArgumentException("handler does not accept exception type " + exType);
        }
        if (htype.returnType() != ttype.returnType()) {
            throw MethodHandles.misMatchedTypes("target and handler return types", ttype, htype);
        }
        if ((handler = MethodHandles.dropArgumentsToMatch(handler, 1, ttype.parameterList(), 0, true)) == null) {
            throw MethodHandles.misMatchedTypes("target and handler types", ttype, htype);
        }
        return MethodHandleImpl.makeGuardWithCatch(target, exType, handler);
    }

    public static MethodHandle throwException(Class<?> returnType, Class<? extends Throwable> exType) {
        if (!Throwable.class.isAssignableFrom(exType)) {
            throw new ClassCastException(exType.getName());
        }
        return MethodHandleImpl.throwException(MethodType.methodType(returnType, exType));
    }

    public static MethodHandle loop(MethodHandle[] ... clauses) {
        MethodHandles.loopChecks0(clauses);
        ArrayList<MethodHandle> init = new ArrayList<MethodHandle>();
        ArrayList<MethodHandle> step = new ArrayList<MethodHandle>();
        ArrayList<MethodHandle> pred = new ArrayList<MethodHandle>();
        ArrayList<MethodHandle> fini = new ArrayList<MethodHandle>();
        Stream.of(clauses).filter(c -> Stream.of(c).anyMatch(Objects::nonNull)).forEach(clause -> {
            init.add(clause[0]);
            step.add(((MethodHandle[])clause).length <= 1 ? null : clause[1]);
            pred.add(((MethodHandle[])clause).length <= 2 ? null : clause[2]);
            fini.add(((MethodHandle[])clause).length <= 3 ? null : clause[3]);
        });
        assert (Stream.of(init, step, pred, fini).map(List::size).distinct().count() == 1L);
        int nclauses = init.size();
        ArrayList<TypeDescriptor.OfField> iterationVariableTypes = new ArrayList<TypeDescriptor.OfField>();
        for (int i = 0; i < nclauses; ++i) {
            MethodHandle in = (MethodHandle)init.get(i);
            MethodHandle st = (MethodHandle)step.get(i);
            if (in == null && st == null) {
                iterationVariableTypes.add(Void.TYPE);
                continue;
            }
            if (in != null && st != null) {
                MethodHandles.loopChecks1a(i, in, st);
                iterationVariableTypes.add(in.type().returnType());
                continue;
            }
            iterationVariableTypes.add(in == null ? st.type().returnType() : in.type().returnType());
        }
        List<Class> commonPrefix = iterationVariableTypes.stream().filter(t -> t != Void.TYPE).toList();
        List<Class<?>> commonSuffix = MethodHandles.buildCommonSuffix(init, step, pred, fini, commonPrefix.size());
        MethodHandles.loopChecks1b(init, commonSuffix);
        Stream<Class> cstream = fini.stream().filter(Objects::nonNull).map(MethodHandle::type).map(MethodType::returnType);
        Class<Void> loopReturnType = cstream.findFirst().orElse(Void.TYPE);
        MethodHandles.loopChecks1cd(pred, fini, loopReturnType);
        ArrayList commonParameterSequence = new ArrayList(commonPrefix);
        commonParameterSequence.addAll(commonSuffix);
        MethodHandles.loopChecks2(step, pred, fini, commonParameterSequence);
        for (int i = 0; i < nclauses; ++i) {
            Class t2 = (Class)iterationVariableTypes.get(i);
            if (init.get(i) == null) {
                init.set(i, MethodHandles.empty(MethodType.methodType(t2, commonSuffix)));
            }
            if (step.get(i) == null) {
                step.set(i, MethodHandles.dropArgumentsToMatch(MethodHandles.identityOrVoid(t2), 0, commonParameterSequence, i));
            }
            if (pred.get(i) == null) {
                pred.set(i, MethodHandles.dropArguments0(MethodHandles.constant(Boolean.TYPE, true), 0, commonParameterSequence));
            }
            if (fini.get(i) != null) continue;
            fini.set(i, MethodHandles.empty(MethodType.methodType(t2, commonParameterSequence)));
        }
        List<MethodHandle> finit = MethodHandles.fixArities(MethodHandles.fillParameterTypes(init, commonSuffix));
        List<MethodHandle> fstep = MethodHandles.fixArities(MethodHandles.fillParameterTypes(step, commonParameterSequence));
        List<MethodHandle> fpred = MethodHandles.fixArities(MethodHandles.fillParameterTypes(pred, commonParameterSequence));
        List<MethodHandle> ffini = MethodHandles.fixArities(MethodHandles.fillParameterTypes(fini, commonParameterSequence));
        assert (finit.stream().map(MethodHandle::type).map(MethodType::parameterList).allMatch(pl -> pl.equals(commonSuffix)));
        assert (Stream.of(fstep, fpred, ffini).flatMap(Collection::stream).map(MethodHandle::type).map(MethodType::parameterList).allMatch(pl -> pl.equals(commonParameterSequence)));
        return MethodHandleImpl.makeLoop(loopReturnType, commonSuffix, finit, fstep, fpred, ffini);
    }

    private static void loopChecks0(MethodHandle[][] clauses) {
        if (clauses == null || clauses.length == 0) {
            throw MethodHandleStatics.newIllegalArgumentException("null or no clauses passed");
        }
        if (Stream.of(clauses).anyMatch(Objects::isNull)) {
            throw MethodHandleStatics.newIllegalArgumentException("null clauses are not allowed");
        }
        if (Stream.of(clauses).anyMatch(c -> ((MethodHandle[])c).length > 4)) {
            throw MethodHandleStatics.newIllegalArgumentException("All loop clauses must be represented as MethodHandle arrays with at most 4 elements.");
        }
    }

    private static void loopChecks1a(int i, MethodHandle in, MethodHandle st) {
        if (in.type().returnType() != st.type().returnType()) {
            throw MethodHandles.misMatchedTypes("clause " + i + ": init and step return types", in.type().returnType(), st.type().returnType());
        }
    }

    private static List<Class<?>> longestParameterList(Stream<MethodHandle> mhs, int skipSize) {
        List<Class<?>> empty = List.of();
        List longest = mhs.filter(Objects::nonNull).map(MethodHandle::type).filter(t -> t.parameterCount() > skipSize).map(MethodType::parameterList).reduce((p, q) -> p.size() >= q.size() ? p : q).orElse(empty);
        return longest.size() == 0 ? empty : longest.subList(skipSize, longest.size());
    }

    private static List<Class<?>> longestParameterList(List<List<Class<?>>> lists) {
        List empty = List.of();
        return lists.stream().reduce((p, q) -> p.size() >= q.size() ? p : q).orElse(empty);
    }

    private static List<Class<?>> buildCommonSuffix(List<MethodHandle> init, List<MethodHandle> step, List<MethodHandle> pred, List<MethodHandle> fini, int cpSize) {
        List<Class<?>> longest1 = MethodHandles.longestParameterList(Stream.of(step, pred, fini).flatMap(Collection::stream), cpSize);
        List<Class<?>> longest2 = MethodHandles.longestParameterList(init.stream(), 0);
        return MethodHandles.longestParameterList(Arrays.asList(longest1, longest2));
    }

    private static void loopChecks1b(List<MethodHandle> init, List<Class<?>> commonSuffix) {
        if (init.stream().filter(Objects::nonNull).map(MethodHandle::type).anyMatch(t -> !t.effectivelyIdenticalParameters(0, commonSuffix))) {
            throw MethodHandleStatics.newIllegalArgumentException("found non-effectively identical init parameter type lists: " + init + " (common suffix: " + commonSuffix + ")");
        }
    }

    private static void loopChecks1cd(List<MethodHandle> pred, List<MethodHandle> fini, Class<?> loopReturnType) {
        if (fini.stream().filter(Objects::nonNull).map(MethodHandle::type).map(MethodType::returnType).anyMatch(t -> t != loopReturnType)) {
            throw MethodHandleStatics.newIllegalArgumentException("found non-identical finalizer return types: " + fini + " (return type: " + loopReturnType + ")");
        }
        if (!pred.stream().filter(Objects::nonNull).findFirst().isPresent()) {
            throw MethodHandleStatics.newIllegalArgumentException("no predicate found", pred);
        }
        if (pred.stream().filter(Objects::nonNull).map(MethodHandle::type).map(MethodType::returnType).anyMatch(t -> t != Boolean.TYPE)) {
            throw MethodHandleStatics.newIllegalArgumentException("predicates must have boolean return type", pred);
        }
    }

    private static void loopChecks2(List<MethodHandle> step, List<MethodHandle> pred, List<MethodHandle> fini, List<Class<?>> commonParameterSequence) {
        if (Stream.of(step, pred, fini).flatMap(Collection::stream).filter(Objects::nonNull).map(MethodHandle::type).anyMatch(t -> !t.effectivelyIdenticalParameters(0, commonParameterSequence))) {
            throw MethodHandleStatics.newIllegalArgumentException("found non-effectively identical parameter type lists:\nstep: " + step + "\npred: " + pred + "\nfini: " + fini + " (common parameter sequence: " + commonParameterSequence + ")");
        }
    }

    private static List<MethodHandle> fillParameterTypes(List<MethodHandle> hs, List<Class<?>> targetParams) {
        return hs.stream().map(h -> {
            int tpsize;
            int pc = h.type().parameterCount();
            return pc < (tpsize = targetParams.size()) ? MethodHandles.dropArguments0(h, pc, targetParams.subList(pc, tpsize)) : h;
        }).toList();
    }

    private static List<MethodHandle> fixArities(List<MethodHandle> hs) {
        return hs.stream().map(MethodHandle::asFixedArity).toList();
    }

    public static MethodHandle whileLoop(MethodHandle init, MethodHandle pred, MethodHandle body) {
        MethodHandles.whileLoopChecks(init, pred, body);
        MethodHandle fini = MethodHandles.identityOrVoid(body.type().returnType());
        MethodHandle[] checkExit = new MethodHandle[]{null, null, pred, fini};
        MethodHandle[] varBody = new MethodHandle[]{init, body};
        return MethodHandles.loop(checkExit, varBody);
    }

    public static MethodHandle doWhileLoop(MethodHandle init, MethodHandle body, MethodHandle pred) {
        MethodHandles.whileLoopChecks(init, pred, body);
        MethodHandle fini = MethodHandles.identityOrVoid(body.type().returnType());
        MethodHandle[] clause = new MethodHandle[]{init, body, pred, fini};
        return MethodHandles.loop(new MethodHandle[][]{clause});
    }

    private static void whileLoopChecks(MethodHandle init, MethodHandle pred, MethodHandle body) {
        MethodType initType;
        MethodType predType;
        List<Class<?>> innerList;
        Objects.requireNonNull(pred);
        Objects.requireNonNull(body);
        MethodType bodyType = body.type();
        TypeDescriptor.OfField returnType = bodyType.returnType();
        List<Class<?>> outerList = innerList = bodyType.parameterList();
        if (returnType != Void.TYPE) {
            if (innerList.size() == 0 || innerList.get(0) != returnType) {
                MethodType expected = bodyType.insertParameterTypes(0, new Class[]{returnType});
                throw MethodHandles.misMatchedTypes("body function", bodyType, expected);
            }
            outerList = innerList.subList(1, innerList.size());
        }
        if ((predType = pred.type()).returnType() != Boolean.TYPE || !predType.effectivelyIdenticalParameters(0, innerList)) {
            throw MethodHandles.misMatchedTypes("loop predicate", predType, MethodType.methodType(Boolean.TYPE, innerList));
        }
        if (!(init == null || (initType = init.type()).returnType() == returnType && initType.effectivelyIdenticalParameters(0, outerList))) {
            throw MethodHandles.misMatchedTypes("loop initializer", initType, MethodType.methodType(returnType, outerList));
        }
    }

    public static MethodHandle countedLoop(MethodHandle iterations, MethodHandle init, MethodHandle body) {
        return MethodHandles.countedLoop(MethodHandles.empty(iterations.type()), iterations, init, body);
    }

    public static MethodHandle countedLoop(MethodHandle start, MethodHandle end, MethodHandle init, MethodHandle body) {
        MethodHandles.countedLoopChecks(start, end, init, body);
        TypeDescriptor.OfField counterType = start.type().returnType();
        TypeDescriptor.OfField limitType = end.type().returnType();
        TypeDescriptor.OfField returnType = body.type().returnType();
        MethodHandle incr = MethodHandleImpl.getConstantHandle(3);
        MethodHandle pred = MethodHandleImpl.getConstantHandle(2);
        MethodHandle retv = null;
        if (returnType != Void.TYPE) {
            incr = MethodHandles.dropArguments(incr, 1, new Class[]{returnType});
            pred = MethodHandles.dropArguments(pred, 1, new Class[]{returnType});
            retv = MethodHandles.dropArguments(MethodHandles.identity(returnType), 0, new Class[]{counterType});
        }
        body = MethodHandles.dropArguments(body, 0, new Class[]{counterType});
        MethodHandle[] loopLimit = new MethodHandle[]{end, null, pred, retv};
        MethodHandle[] bodyClause = new MethodHandle[]{init, body};
        MethodHandle[] indexVar = new MethodHandle[]{start, incr};
        return MethodHandles.loop(loopLimit, bodyClause, indexVar);
    }

    private static void countedLoopChecks(MethodHandle start, MethodHandle end, MethodHandle init, MethodHandle body) {
        MethodType initType;
        int vsize;
        Objects.requireNonNull(start);
        Objects.requireNonNull(end);
        Objects.requireNonNull(body);
        TypeDescriptor.OfField counterType = start.type().returnType();
        if (counterType != Integer.TYPE) {
            MethodType expected = start.type().changeReturnType(Integer.TYPE);
            throw MethodHandles.misMatchedTypes("start function", start.type(), expected);
        }
        if (end.type().returnType() != counterType) {
            MethodType expected = end.type().changeReturnType((Class<?>)counterType);
            throw MethodHandles.misMatchedTypes("end function", end.type(), expected);
        }
        MethodType bodyType = body.type();
        TypeDescriptor.OfField returnType = bodyType.returnType();
        List<Class<?>> innerList = bodyType.parameterList();
        int n = vsize = returnType == Void.TYPE ? 0 : 1;
        if (vsize != 0 && (innerList.size() == 0 || innerList.get(0) != returnType)) {
            MethodType expected = bodyType.insertParameterTypes(0, new Class[]{returnType});
            throw MethodHandles.misMatchedTypes("body function", bodyType, expected);
        }
        if (innerList.size() <= vsize || innerList.get(vsize) != counterType) {
            MethodType expected = bodyType.insertParameterTypes(vsize, new Class[]{counterType});
            throw MethodHandles.misMatchedTypes("body function", bodyType, expected);
        }
        List<Class<?>> outerList = innerList.subList(vsize + 1, innerList.size());
        if (outerList.isEmpty()) {
            outerList = end.type().parameterList();
            innerList = bodyType.insertParameterTypes(vsize + 1, outerList).parameterList();
        }
        MethodType expected = MethodType.methodType(counterType, outerList);
        if (!start.type().effectivelyIdenticalParameters(0, outerList)) {
            throw MethodHandles.misMatchedTypes("start parameter types", start.type(), expected);
        }
        if (end.type() != start.type() && !end.type().effectivelyIdenticalParameters(0, outerList)) {
            throw MethodHandles.misMatchedTypes("end parameter types", end.type(), expected);
        }
        if (!(init == null || (initType = init.type()).returnType() == returnType && initType.effectivelyIdenticalParameters(0, outerList))) {
            throw MethodHandles.misMatchedTypes("loop initializer", initType, MethodType.methodType(returnType, outerList));
        }
    }

    public static MethodHandle iteratedLoop(MethodHandle iterator, MethodHandle init, MethodHandle body) {
        MethodHandle nextVal;
        MethodType iteratorType;
        MethodHandle startIter;
        Class<?> iterableType = MethodHandles.iteratedLoopChecks(iterator, init, body);
        TypeDescriptor.OfField returnType = body.type().returnType();
        MethodHandle hasNext = MethodHandleImpl.getConstantHandle(5);
        MethodHandle nextRaw = MethodHandleImpl.getConstantHandle(6);
        if (iterator == null) {
            startIter = MethodHandleImpl.getConstantHandle(4);
            iteratorType = startIter.type().changeParameterType(0, iterableType);
        } else {
            iteratorType = iterator.type().changeReturnType(Iterator.class);
            startIter = iterator;
        }
        TypeDescriptor.OfField ttype = body.type().parameterType(returnType == Void.TYPE ? 0 : 1);
        MethodType nextValType = nextRaw.type().changeReturnType((Class<?>)ttype);
        try {
            startIter = startIter.asType(iteratorType);
            nextVal = nextRaw.asType(nextValType);
        }
        catch (WrongMethodTypeException ex) {
            throw new IllegalArgumentException(ex);
        }
        MethodHandle retv = null;
        MethodHandle step = body;
        if (returnType != Void.TYPE) {
            retv = MethodHandles.dropArguments(MethodHandles.identity(returnType), 0, Iterator.class);
            step = MethodHandles.swapArguments(body, 0, 1);
        }
        MethodHandle[] iterVar = new MethodHandle[]{startIter, null, hasNext, retv};
        MethodHandle[] bodyClause = new MethodHandle[]{init, MethodHandles.filterArgument(step, 0, nextVal)};
        return MethodHandles.loop(iterVar, bodyClause);
    }

    private static Class<?> iteratedLoopChecks(MethodHandle iterator, MethodHandle init, MethodHandle body) {
        MethodType initType;
        int vsize;
        Objects.requireNonNull(body);
        MethodType bodyType = body.type();
        TypeDescriptor.OfField returnType = bodyType.returnType();
        List<Class<?>> internalParamList = bodyType.parameterList();
        int n = vsize = returnType == Void.TYPE ? 0 : 1;
        if (vsize != 0 && (internalParamList.size() == 0 || internalParamList.get(0) != returnType)) {
            MethodType expected = bodyType.insertParameterTypes(0, new Class[]{returnType});
            throw MethodHandles.misMatchedTypes("body function", bodyType, expected);
        }
        if (internalParamList.size() <= vsize) {
            MethodType expected = bodyType.insertParameterTypes(vsize, Object.class);
            throw MethodHandles.misMatchedTypes("body function", bodyType, expected);
        }
        List<Class<?>> externalParamList = internalParamList.subList(vsize + 1, internalParamList.size());
        Class<Object> iterableType = null;
        if (iterator != null) {
            MethodType itype;
            if (externalParamList.isEmpty()) {
                externalParamList = iterator.type().parameterList();
            }
            if (!Iterator.class.isAssignableFrom((Class<?>)(itype = iterator.type()).returnType())) {
                throw MethodHandleStatics.newIllegalArgumentException("iteratedLoop first argument must have Iterator return type");
            }
            if (!itype.effectivelyIdenticalParameters(0, externalParamList)) {
                MethodType expected = MethodType.methodType(itype.returnType(), externalParamList);
                throw MethodHandles.misMatchedTypes("iterator parameters", itype, expected);
            }
        } else if (externalParamList.isEmpty()) {
            externalParamList = Arrays.asList(Iterable.class);
            iterableType = Iterable.class;
        } else {
            iterableType = externalParamList.get(0);
            if (!Iterable.class.isAssignableFrom(iterableType)) {
                throw MethodHandleStatics.newIllegalArgumentException("inferred first loop argument must inherit from Iterable: " + iterableType);
            }
        }
        if (!(init == null || (initType = init.type()).returnType() == returnType && initType.effectivelyIdenticalParameters(0, externalParamList))) {
            throw MethodHandles.misMatchedTypes("loop initializer", initType, MethodType.methodType(returnType, externalParamList));
        }
        return iterableType;
    }

    static MethodHandle swapArguments(MethodHandle mh, int i, int j) {
        int arity = mh.type().parameterCount();
        int[] order = new int[arity];
        for (int k = 0; k < arity; ++k) {
            order[k] = k;
        }
        order[i] = j;
        order[j] = i;
        Class<?>[] types = mh.type().parameterArray();
        Class<?> ti = types[i];
        types[i] = types[j];
        types[j] = ti;
        MethodType swapType = MethodType.methodType(mh.type().returnType(), types);
        return MethodHandles.permuteArguments(mh, swapType, order);
    }

    public static MethodHandle tryFinally(MethodHandle target, MethodHandle cleanup) {
        List<Class<?>> targetParamTypes = target.type().parameterList();
        TypeDescriptor.OfField rtype = target.type().returnType();
        MethodHandles.tryFinallyChecks(target, cleanup);
        cleanup = MethodHandles.dropArgumentsToMatch(cleanup, rtype == Void.TYPE ? 1 : 2, targetParamTypes, 0);
        cleanup = cleanup.asType(cleanup.type().changeParameterType(0, Throwable.class));
        return MethodHandleImpl.makeTryFinally(target.asFixedArity(), cleanup.asFixedArity(), rtype, targetParamTypes);
    }

    private static void tryFinallyChecks(MethodHandle target, MethodHandle cleanup) {
        int cleanupArgIndex;
        TypeDescriptor.OfField rtype = target.type().returnType();
        if (rtype != cleanup.type().returnType()) {
            throw MethodHandles.misMatchedTypes("target and return types", cleanup.type().returnType(), rtype);
        }
        MethodType cleanupType = cleanup.type();
        if (!Throwable.class.isAssignableFrom((Class<?>)cleanupType.parameterType(0))) {
            throw MethodHandles.misMatchedTypes("cleanup first argument and Throwable", cleanup.type(), Throwable.class);
        }
        if (rtype != Void.TYPE && cleanupType.parameterType(1) != rtype) {
            throw MethodHandles.misMatchedTypes("cleanup second argument and target return type", cleanup.type(), rtype);
        }
        int n = cleanupArgIndex = rtype == Void.TYPE ? 1 : 2;
        if (!cleanupType.effectivelyIdenticalParameters(cleanupArgIndex, target.type().parameterList())) {
            throw MethodHandles.misMatchedTypes("cleanup parameters after (Throwable,result) and target parameter list prefix", cleanup.type(), target.type());
        }
    }

    public static MethodHandle tableSwitch(MethodHandle fallback, MethodHandle ... targets) {
        Objects.requireNonNull(fallback);
        Objects.requireNonNull(targets);
        targets = (MethodHandle[])targets.clone();
        MethodType type = MethodHandles.tableSwitchChecks(fallback, targets);
        return MethodHandleImpl.makeTableSwitch(type, fallback, targets);
    }

    private static MethodType tableSwitchChecks(MethodHandle defaultCase, MethodHandle[] caseActions) {
        if (caseActions.length == 0) {
            throw new IllegalArgumentException("Not enough cases: " + Arrays.toString(caseActions));
        }
        MethodType expectedType = defaultCase.type();
        if (expectedType.parameterCount() < 1 || expectedType.parameterType(0) != Integer.TYPE) {
            throw new IllegalArgumentException("Case actions must have int as leading parameter: " + Arrays.toString(caseActions));
        }
        for (MethodHandle mh : caseActions) {
            Objects.requireNonNull(mh);
            if (mh.type() == expectedType) continue;
            throw new IllegalArgumentException("Case actions must have the same type: " + Arrays.toString(caseActions));
        }
        return expectedType;
    }

    public static final class Lookup {
        private final Class<?> lookupClass;
        private final Class<?> prevLookupClass;
        private final int allowedModes;
        public static final int PUBLIC = 1;
        public static final int PRIVATE = 2;
        public static final int PROTECTED = 4;
        public static final int PACKAGE = 8;
        public static final int MODULE = 16;
        public static final int UNCONDITIONAL = 32;
        public static final int ORIGINAL = 64;
        private static final int ALL_MODES = 127;
        private static final int FULL_POWER_MODES = 95;
        private static final int TRUSTED = -1;
        private volatile ProtectionDomain cachedProtectionDomain;
        static final Lookup IMPL_LOOKUP;
        static final Lookup PUBLIC_LOOKUP;
        static ConcurrentHashMap<MemberName, DirectMethodHandle> LOOKASIDE_TABLE;

        private static int fixmods(int mods) {
            if (Modifier.isPublic(mods &= 7)) {
                mods |= 0x20;
            }
            return mods != 0 ? mods : 8;
        }

        public Class<?> lookupClass() {
            return this.lookupClass;
        }

        public Class<?> previousLookupClass() {
            return this.prevLookupClass;
        }

        private Class<?> lookupClassOrNull() {
            return this.allowedModes == -1 ? null : this.lookupClass;
        }

        public int lookupModes() {
            return this.allowedModes & 0x7F;
        }

        Lookup(Class<?> lookupClass) {
            this(lookupClass, null, 95);
        }

        private Lookup(Class<?> lookupClass, Class<?> prevLookupClass, int allowedModes) {
            assert (prevLookupClass == null || (allowedModes & 0x10) == 0 && prevLookupClass.getModule() != lookupClass.getModule());
            assert (!lookupClass.isArray() && !lookupClass.isPrimitive());
            this.lookupClass = lookupClass;
            this.prevLookupClass = prevLookupClass;
            this.allowedModes = allowedModes;
        }

        private static Lookup newLookup(Class<?> lookupClass, Class<?> prevLookupClass, int allowedModes) {
            Lookup.checkUnprivilegedlookupClass(lookupClass);
            return new Lookup(lookupClass, prevLookupClass, allowedModes);
        }

        public Lookup in(Class<?> requestedLookupClass) {
            Objects.requireNonNull(requestedLookupClass);
            if (requestedLookupClass.isPrimitive()) {
                throw new IllegalArgumentException(requestedLookupClass + " is a primitive class");
            }
            if (requestedLookupClass.isArray()) {
                throw new IllegalArgumentException(requestedLookupClass + " is an array class");
            }
            if (this.allowedModes == -1) {
                return new Lookup(requestedLookupClass, null, 95);
            }
            if (requestedLookupClass == this.lookupClass) {
                return this;
            }
            int newModes = this.allowedModes & 0x5F & 0xFFFFFFBF;
            Module fromModule = this.lookupClass.getModule();
            Module targetModule = requestedLookupClass.getModule();
            Class<?> plc = this.previousLookupClass();
            if ((this.allowedModes & 0x20) != 0) {
                assert (plc == null);
                newModes = 32;
            } else if (fromModule != targetModule) {
                if (plc != null && !VerifyAccess.isSameModule(plc, requestedLookupClass)) {
                    newModes = 0;
                }
                newModes &= 0xFFFFFFE1;
                plc = this.lookupClass;
            }
            if ((newModes & 8) != 0 && !VerifyAccess.isSamePackage(this.lookupClass, requestedLookupClass)) {
                newModes &= 0xFFFFFFF1;
            }
            if ((newModes & 2) != 0 && !VerifyAccess.isSamePackageMember(this.lookupClass, requestedLookupClass)) {
                newModes &= 0xFFFFFFF9;
            }
            if ((newModes & 0x21) != 0 && !VerifyAccess.isClassAccessible(requestedLookupClass, this.lookupClass, this.prevLookupClass, this.allowedModes)) {
                newModes = 0;
            }
            return Lookup.newLookup(requestedLookupClass, plc, newModes);
        }

        public Lookup dropLookupMode(int modeToDrop) {
            int oldModes = this.lookupModes();
            int newModes = oldModes & ~(modeToDrop | 4 | 0x40);
            switch (modeToDrop) {
                case 1: {
                    newModes &= 0xFFFFFFA0;
                    break;
                }
                case 16: {
                    newModes &= 0xFFFFFFF5;
                    break;
                }
                case 8: {
                    newModes &= 0xFFFFFFFD;
                    break;
                }
                case 2: 
                case 4: 
                case 32: 
                case 64: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(modeToDrop + " is not a valid mode to drop");
                }
            }
            if (newModes == oldModes) {
                return this;
            }
            return Lookup.newLookup(this.lookupClass(), this.previousLookupClass(), newModes);
        }

        public Class<?> defineClass(byte[] bytes) throws IllegalAccessException {
            this.ensureDefineClassPermission();
            if ((this.lookupModes() & 8) == 0) {
                throw new IllegalAccessException("Lookup does not have PACKAGE access");
            }
            return this.makeClassDefiner((byte[])bytes.clone()).defineClass(false);
        }

        private void ensureDefineClassPermission() {
            SecurityManager sm;
            if (this.allowedModes == -1) {
                return;
            }
            if (!this.hasFullPrivilegeAccess() && (sm = System.getSecurityManager()) != null) {
                sm.checkPermission(new RuntimePermission("defineClass"));
            }
        }

        public Lookup defineHiddenClass(byte[] bytes, boolean initialize, ClassOption ... options) throws IllegalAccessException {
            Objects.requireNonNull(bytes);
            Objects.requireNonNull(options);
            this.ensureDefineClassPermission();
            if (!this.hasFullPrivilegeAccess()) {
                throw new IllegalAccessException(this + " does not have full privilege access");
            }
            return this.makeHiddenClassDefiner((byte[])bytes.clone(), Set.of(options), false).defineClassAsLookup(initialize);
        }

        public Lookup defineHiddenClassWithClassData(byte[] bytes, Object classData, boolean initialize, ClassOption ... options) throws IllegalAccessException {
            Objects.requireNonNull(bytes);
            Objects.requireNonNull(classData);
            Objects.requireNonNull(options);
            this.ensureDefineClassPermission();
            if (!this.hasFullPrivilegeAccess()) {
                throw new IllegalAccessException(this + " does not have full privilege access");
            }
            return this.makeHiddenClassDefiner((byte[])bytes.clone(), Set.of(options), false).defineClassAsLookup(initialize, classData);
        }

        private ClassDefiner makeClassDefiner(byte[] bytes) {
            ClassFile cf = ClassFile.newInstance(bytes, this.lookupClass().getPackageName());
            return new ClassDefiner(this, cf, 4);
        }

        ClassDefiner makeHiddenClassDefiner(byte[] bytes) {
            ClassFile cf = ClassFile.newInstance(bytes, this.lookupClass().getPackageName());
            return this.makeHiddenClassDefiner(cf, Set.of(), false);
        }

        ClassDefiner makeHiddenClassDefiner(byte[] bytes, Set<ClassOption> options, boolean accessVmAnnotations) {
            ClassFile cf = ClassFile.newInstance(bytes, this.lookupClass().getPackageName());
            return this.makeHiddenClassDefiner(cf, options, accessVmAnnotations);
        }

        ClassDefiner makeHiddenClassDefiner(String name, byte[] bytes) {
            return this.makeHiddenClassDefiner(ClassFile.newInstanceNoCheck(name, bytes), Set.of(), false);
        }

        private ClassDefiner makeHiddenClassDefiner(ClassFile cf, Set<ClassOption> options, boolean accessVmAnnotations) {
            int flags = 2 | ClassOption.optionsToFlag(options);
            if (accessVmAnnotations | VM.isSystemDomainLoader(this.lookupClass.getClassLoader())) {
                flags |= 8;
            }
            return new ClassDefiner(this, cf, flags);
        }

        private ProtectionDomain lookupClassProtectionDomain() {
            ProtectionDomain pd = this.cachedProtectionDomain;
            if (pd == null) {
                this.cachedProtectionDomain = pd = SharedSecrets.getJavaLangAccess().protectionDomain(this.lookupClass);
            }
            return pd;
        }

        private static void checkUnprivilegedlookupClass(Class<?> lookupClass) {
            String name = lookupClass.getName();
            if (name.startsWith("java.lang.invoke.")) {
                throw MethodHandleStatics.newIllegalArgumentException("illegal lookupClass: " + lookupClass);
            }
        }

        public String toString() {
            String cname = this.lookupClass.getName();
            if (this.prevLookupClass != null) {
                cname = cname + "/" + this.prevLookupClass.getName();
            }
            switch (this.allowedModes) {
                case 0: {
                    return cname + "/noaccess";
                }
                case 32: {
                    return cname + "/publicLookup";
                }
                case 1: {
                    return cname + "/public";
                }
                case 17: {
                    return cname + "/module";
                }
                case 9: 
                case 25: {
                    return cname + "/package";
                }
                case 11: 
                case 27: {
                    return cname + "/private";
                }
                case 15: 
                case 31: 
                case 95: {
                    return cname;
                }
                case -1: {
                    return "/trusted";
                }
            }
            cname = cname + "/" + Integer.toHexString(this.allowedModes);
            assert (false) : cname;
            return cname;
        }

        public MethodHandle findStatic(Class<?> refc, String name, MethodType type) throws NoSuchMethodException, IllegalAccessException {
            MemberName method = this.resolveOrFail((byte)6, refc, name, type);
            return this.getDirectMethod((byte)6, refc, method, this.findBoundCallerLookup(method));
        }

        public MethodHandle findVirtual(Class<?> refc, String name, MethodType type) throws NoSuchMethodException, IllegalAccessException {
            MethodHandle mh;
            if (refc == MethodHandle.class ? (mh = this.findVirtualForMH(name, type)) != null : refc == VarHandle.class && (mh = this.findVirtualForVH(name, type)) != null) {
                return mh;
            }
            byte refKind = refc.isInterface() ? (byte)9 : 5;
            MemberName method = this.resolveOrFail(refKind, refc, name, type);
            return this.getDirectMethod(refKind, refc, method, this.findBoundCallerLookup(method));
        }

        private MethodHandle findVirtualForMH(String name, MethodType type) {
            if ("invoke".equals(name)) {
                return MethodHandles.invoker(type);
            }
            if ("invokeExact".equals(name)) {
                return MethodHandles.exactInvoker(type);
            }
            assert (!MemberName.isMethodHandleInvokeName(name));
            return null;
        }

        private MethodHandle findVirtualForVH(String name, MethodType type) {
            try {
                return MethodHandles.varHandleInvoker(VarHandle.AccessMode.valueFromMethodName(name), type);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public MethodHandle findConstructor(Class<?> refc, MethodType type) throws NoSuchMethodException, IllegalAccessException {
            if (refc.isArray()) {
                throw new NoSuchMethodException("no constructor for array class: " + refc.getName());
            }
            String name = "<init>";
            MemberName ctor = this.resolveOrFail((byte)8, refc, name, type);
            return this.getDirectConstructor(refc, ctor);
        }

        public Class<?> findClass(String targetName) throws ClassNotFoundException, IllegalAccessException {
            Class<?> targetClass = Class.forName(targetName, false, this.lookupClass.getClassLoader());
            return this.accessClass(targetClass);
        }

        public Class<?> ensureInitialized(Class<?> targetClass) throws IllegalAccessException {
            if (targetClass.isPrimitive()) {
                throw new IllegalArgumentException(targetClass + " is a primitive class");
            }
            if (targetClass.isArray()) {
                throw new IllegalArgumentException(targetClass + " is an array class");
            }
            if (!VerifyAccess.isClassAccessible(targetClass, this.lookupClass, this.prevLookupClass, this.allowedModes)) {
                throw this.makeAccessException(targetClass);
            }
            this.checkSecurityManager(targetClass);
            Unsafe.getUnsafe().ensureClassInitialized(targetClass);
            return targetClass;
        }

        private IllegalAccessException makeAccessException(Class<?> targetClass) {
            String message = "access violation: " + targetClass;
            if (this == MethodHandles.publicLookup()) {
                message = message + ", from public Lookup";
            } else {
                Module m = this.lookupClass().getModule();
                message = message + ", from " + this.lookupClass() + " (" + m + ")";
                if (this.prevLookupClass != null) {
                    message = message + ", previous lookup " + this.prevLookupClass.getName() + " (" + this.prevLookupClass.getModule() + ")";
                }
            }
            return new IllegalAccessException(message);
        }

        public Class<?> accessClass(Class<?> targetClass) throws IllegalAccessException {
            if (!this.isClassAccessible(targetClass)) {
                throw this.makeAccessException(targetClass);
            }
            this.checkSecurityManager(targetClass);
            return targetClass;
        }

        public MethodHandle findSpecial(Class<?> refc, String name, MethodType type, Class<?> specialCaller) throws NoSuchMethodException, IllegalAccessException {
            this.checkSpecialCaller(specialCaller, refc);
            Lookup specialLookup = this.in(specialCaller);
            MemberName method = specialLookup.resolveOrFail((byte)7, refc, name, type);
            return specialLookup.getDirectMethod((byte)7, refc, method, this.findBoundCallerLookup(method));
        }

        public MethodHandle findGetter(Class<?> refc, String name, Class<?> type) throws NoSuchFieldException, IllegalAccessException {
            MemberName field = this.resolveOrFail((byte)1, refc, name, type);
            return this.getDirectField((byte)1, refc, field);
        }

        public MethodHandle findSetter(Class<?> refc, String name, Class<?> type) throws NoSuchFieldException, IllegalAccessException {
            MemberName field = this.resolveOrFail((byte)3, refc, name, type);
            return this.getDirectField((byte)3, refc, field);
        }

        public VarHandle findVarHandle(Class<?> recv, String name, Class<?> type) throws NoSuchFieldException, IllegalAccessException {
            MemberName getField = this.resolveOrFail((byte)1, recv, name, type);
            MemberName putField = this.resolveOrFail((byte)3, recv, name, type);
            return this.getFieldVarHandle((byte)1, (byte)3, recv, getField, putField);
        }

        public MethodHandle findStaticGetter(Class<?> refc, String name, Class<?> type) throws NoSuchFieldException, IllegalAccessException {
            MemberName field = this.resolveOrFail((byte)2, refc, name, type);
            return this.getDirectField((byte)2, refc, field);
        }

        public MethodHandle findStaticSetter(Class<?> refc, String name, Class<?> type) throws NoSuchFieldException, IllegalAccessException {
            MemberName field = this.resolveOrFail((byte)4, refc, name, type);
            return this.getDirectField((byte)4, refc, field);
        }

        public VarHandle findStaticVarHandle(Class<?> decl, String name, Class<?> type) throws NoSuchFieldException, IllegalAccessException {
            MemberName getField = this.resolveOrFail((byte)2, decl, name, type);
            MemberName putField = this.resolveOrFail((byte)4, decl, name, type);
            return this.getFieldVarHandle((byte)2, (byte)4, decl, getField, putField);
        }

        public MethodHandle bind(Object receiver, String name, MethodType type) throws NoSuchMethodException, IllegalAccessException {
            MemberName method;
            Class<?> refc = receiver.getClass();
            MethodHandle mh = this.getDirectMethodNoRestrictInvokeSpecial(refc, method = this.resolveOrFail((byte)7, refc, name, type), this.findBoundCallerLookup(method));
            if (!mh.type().leadingReferenceParameter().isAssignableFrom(receiver.getClass())) {
                throw new IllegalAccessException("The restricted defining class " + mh.type().leadingReferenceParameter().getName() + " is not assignable from receiver class " + receiver.getClass().getName());
            }
            return mh.bindArgumentL(0, receiver).setVarargs(method);
        }

        public MethodHandle unreflect(Method m) throws IllegalAccessException {
            MethodHandle mh;
            if (m.getDeclaringClass() == MethodHandle.class && (mh = this.unreflectForMH(m)) != null) {
                return mh;
            }
            if (m.getDeclaringClass() == VarHandle.class && (mh = this.unreflectForVH(m)) != null) {
                return mh;
            }
            MemberName method = new MemberName(m);
            byte refKind = method.getReferenceKind();
            if (refKind == 7) {
                refKind = 5;
            }
            assert (method.isMethod());
            Lookup lookup = m.isAccessible() ? IMPL_LOOKUP : this;
            return lookup.getDirectMethodNoSecurityManager(refKind, method.getDeclaringClass(), method, this.findBoundCallerLookup(method));
        }

        private MethodHandle unreflectForMH(Method m) {
            if (MemberName.isMethodHandleInvokeName(m.getName())) {
                return MethodHandleImpl.fakeMethodHandleInvoke(new MemberName(m));
            }
            return null;
        }

        private MethodHandle unreflectForVH(Method m) {
            if (MemberName.isVarHandleMethodInvokeName(m.getName())) {
                return MethodHandleImpl.fakeVarHandleInvoke(new MemberName(m));
            }
            return null;
        }

        public MethodHandle unreflectSpecial(Method m, Class<?> specialCaller) throws IllegalAccessException {
            this.checkSpecialCaller(specialCaller, m.getDeclaringClass());
            Lookup specialLookup = this.in(specialCaller);
            MemberName method = new MemberName(m, true);
            assert (method.isMethod());
            return specialLookup.getDirectMethodNoSecurityManager((byte)7, method.getDeclaringClass(), method, this.findBoundCallerLookup(method));
        }

        public MethodHandle unreflectConstructor(Constructor<?> c) throws IllegalAccessException {
            MemberName ctor = new MemberName(c);
            assert (ctor.isConstructor());
            Lookup lookup = c.isAccessible() ? IMPL_LOOKUP : this;
            return lookup.getDirectConstructorNoSecurityManager(ctor.getDeclaringClass(), ctor);
        }

        public MethodHandle unreflectGetter(Field f) throws IllegalAccessException {
            return this.unreflectField(f, false);
        }

        public MethodHandle unreflectSetter(Field f) throws IllegalAccessException {
            return this.unreflectField(f, true);
        }

        private MethodHandle unreflectField(Field f, boolean isSetter) throws IllegalAccessException {
            MemberName field = new MemberName(f, isSetter);
            if (isSetter && field.isFinal() && field.isTrustedFinalField()) {
                String msg = field.isStatic() ? "static final field has no write access" : "final field has no write access";
                throw field.makeAccessException(msg, this);
            }
            assert (!isSetter ? MethodHandleNatives.refKindIsGetter(field.getReferenceKind()) : MethodHandleNatives.refKindIsSetter(field.getReferenceKind()));
            Lookup lookup = f.isAccessible() ? IMPL_LOOKUP : this;
            return lookup.getDirectFieldNoSecurityManager(field.getReferenceKind(), f.getDeclaringClass(), field);
        }

        public VarHandle unreflectVarHandle(Field f) throws IllegalAccessException {
            MemberName getField = new MemberName(f, false);
            MemberName putField = new MemberName(f, true);
            return this.getFieldVarHandleNoSecurityManager(getField.getReferenceKind(), putField.getReferenceKind(), f.getDeclaringClass(), getField, putField);
        }

        public MethodHandleInfo revealDirect(MethodHandle target) {
            if (!target.isCrackable()) {
                throw MethodHandleStatics.newIllegalArgumentException("not a direct method handle");
            }
            MemberName member = target.internalMemberName();
            Class<?> defc = member.getDeclaringClass();
            byte refKind = member.getReferenceKind();
            assert (MethodHandleNatives.refKindIsValid(refKind));
            if (refKind == 7 && !target.isInvokeSpecial()) {
                refKind = 5;
            }
            if (refKind == 5 && defc.isInterface()) {
                refKind = 9;
            }
            try {
                this.checkAccess(refKind, defc, member);
                this.checkSecurityManager(defc, member);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalArgumentException(ex);
            }
            if (this.allowedModes != -1 && member.isCallerSensitive()) {
                Class<?> callerClass = target.internalCallerClass();
                if ((this.lookupModes() & 0x40) == 0 || callerClass != this.lookupClass()) {
                    throw new IllegalArgumentException("method handle is caller sensitive: " + callerClass);
                }
            }
            return new InfoFromMemberName(this, member, refKind);
        }

        MemberName resolveOrFail(byte refKind, Class<?> refc, String name, Class<?> type) throws NoSuchFieldException, IllegalAccessException {
            this.checkSymbolicClass(refc);
            Objects.requireNonNull(name);
            Objects.requireNonNull(type);
            return IMPL_NAMES.resolveOrFail(refKind, new MemberName(refc, name, type, refKind), this.lookupClassOrNull(), this.allowedModes, NoSuchFieldException.class);
        }

        MemberName resolveOrFail(byte refKind, Class<?> refc, String name, MethodType type) throws NoSuchMethodException, IllegalAccessException {
            this.checkSymbolicClass(refc);
            Objects.requireNonNull(type);
            this.checkMethodName(refKind, name);
            return IMPL_NAMES.resolveOrFail(refKind, new MemberName(refc, name, type, refKind), this.lookupClassOrNull(), this.allowedModes, NoSuchMethodException.class);
        }

        MemberName resolveOrFail(byte refKind, MemberName member) throws ReflectiveOperationException {
            this.checkSymbolicClass(member.getDeclaringClass());
            Objects.requireNonNull(member.getName());
            Objects.requireNonNull(member.getType());
            return IMPL_NAMES.resolveOrFail(refKind, member, this.lookupClassOrNull(), this.allowedModes, ReflectiveOperationException.class);
        }

        MemberName resolveOrNull(byte refKind, MemberName member) {
            if (!this.isClassAccessible(member.getDeclaringClass())) {
                return null;
            }
            Objects.requireNonNull(member.getName());
            Objects.requireNonNull(member.getType());
            return IMPL_NAMES.resolveOrNull(refKind, member, this.lookupClassOrNull(), this.allowedModes);
        }

        MemberName resolveOrNull(byte refKind, Class<?> refc, String name, MethodType type) {
            if (!this.isClassAccessible(refc)) {
                return null;
            }
            Objects.requireNonNull(type);
            if (name.startsWith("<") && refKind != 8) {
                return null;
            }
            return IMPL_NAMES.resolveOrNull(refKind, new MemberName(refc, name, type, refKind), this.lookupClassOrNull(), this.allowedModes);
        }

        void checkSymbolicClass(Class<?> refc) throws IllegalAccessException {
            if (!this.isClassAccessible(refc)) {
                throw new MemberName(refc).makeAccessException("symbolic reference class is not accessible", this);
            }
        }

        boolean isClassAccessible(Class<?> refc) {
            Objects.requireNonNull(refc);
            Class<?> caller = this.lookupClassOrNull();
            Class<?> type = refc;
            while (type.isArray()) {
                type = type.getComponentType();
            }
            return caller == null || VerifyAccess.isClassAccessible(type, caller, this.prevLookupClass, this.allowedModes);
        }

        void checkMethodName(byte refKind, String name) throws NoSuchMethodException {
            if (name.startsWith("<") && refKind != 8) {
                throw new NoSuchMethodException("illegal method name: " + name);
            }
        }

        Lookup findBoundCallerLookup(MemberName m) throws IllegalAccessException {
            if (MethodHandleNatives.isCallerSensitive(m) && (this.lookupModes() & 0x40) == 0) {
                throw new IllegalAccessException("Attempt to lookup caller-sensitive method using restricted lookup object");
            }
            return this;
        }

        @Deprecated(since="14")
        public boolean hasPrivateAccess() {
            return this.hasFullPrivilegeAccess();
        }

        public boolean hasFullPrivilegeAccess() {
            return (this.allowedModes & 0x12) == 18;
        }

        void checkSecurityManager(Class<?> refc) {
            if (this.allowedModes == -1) {
                return;
            }
            SecurityManager smgr = System.getSecurityManager();
            if (smgr == null) {
                return;
            }
            boolean fullPrivilegeLookup = this.hasFullPrivilegeAccess();
            if (!fullPrivilegeLookup || !VerifyAccess.classLoaderIsAncestor(this.lookupClass, refc)) {
                ReflectUtil.checkPackageAccess(refc);
            }
            if (!fullPrivilegeLookup) {
                smgr.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
            }
        }

        void checkSecurityManager(Class<?> refc, MemberName m) {
            Objects.requireNonNull(refc);
            Objects.requireNonNull(m);
            if (this.allowedModes == -1) {
                return;
            }
            SecurityManager smgr = System.getSecurityManager();
            if (smgr == null) {
                return;
            }
            boolean fullPrivilegeLookup = this.hasFullPrivilegeAccess();
            if (!fullPrivilegeLookup || !VerifyAccess.classLoaderIsAncestor(this.lookupClass, refc)) {
                ReflectUtil.checkPackageAccess(refc);
            }
            if (m.isPublic()) {
                return;
            }
            if (!fullPrivilegeLookup) {
                smgr.checkPermission(SecurityConstants.CHECK_MEMBER_ACCESS_PERMISSION);
            }
            Class<?> defc = m.getDeclaringClass();
            if (!fullPrivilegeLookup && defc != refc) {
                ReflectUtil.checkPackageAccess(defc);
            }
        }

        void checkMethod(byte refKind, Class<?> refc, MemberName m) throws IllegalAccessException {
            String message;
            boolean wantStatic;
            boolean bl = wantStatic = refKind == 6;
            if (m.isConstructor()) {
                message = "expected a method, not a constructor";
            } else if (!m.isMethod()) {
                message = "expected a method";
            } else if (wantStatic != m.isStatic()) {
                message = wantStatic ? "expected a static method" : "expected a non-static method";
            } else {
                this.checkAccess(refKind, refc, m);
                return;
            }
            throw m.makeAccessException(message, this);
        }

        void checkField(byte refKind, Class<?> refc, MemberName m) throws IllegalAccessException {
            boolean wantStatic;
            boolean bl = wantStatic = !MethodHandleNatives.refKindHasReceiver(refKind);
            if (wantStatic == m.isStatic()) {
                this.checkAccess(refKind, refc, m);
                return;
            }
            String message = wantStatic ? "expected a static field" : "expected a non-static field";
            throw m.makeAccessException(message, this);
        }

        void checkAccess(byte refKind, Class<?> refc, MemberName m) throws IllegalAccessException {
            assert (m.referenceKindIsConsistentWith(refKind) && MethodHandleNatives.refKindIsValid(refKind) && MethodHandleNatives.refKindIsField(refKind) == m.isField());
            int allowedModes = this.allowedModes;
            if (allowedModes == -1) {
                return;
            }
            int mods = m.getModifiers();
            if (Modifier.isProtected(mods) && refKind == 5 && m.getDeclaringClass() == Object.class && m.getName().equals("clone") && refc.isArray()) {
                mods ^= 5;
            }
            if (Modifier.isProtected(mods) && refKind == 8) {
                mods ^= 4;
            }
            if (Modifier.isFinal(mods) && MethodHandleNatives.refKindIsSetter(refKind)) {
                throw m.makeAccessException("unexpected set of a final field", this);
            }
            int requestedModes = Lookup.fixmods(mods);
            if ((requestedModes & allowedModes) != 0 ? VerifyAccess.isMemberAccessible(refc, m.getDeclaringClass(), mods, this.lookupClass(), this.previousLookupClass(), allowedModes) : (requestedModes & 4) != 0 && (allowedModes & 8) != 0 && VerifyAccess.isSamePackage(m.getDeclaringClass(), this.lookupClass())) {
                return;
            }
            throw m.makeAccessException(this.accessFailedMessage(refc, m), this);
        }

        String accessFailedMessage(Class<?> refc, MemberName m) {
            boolean classOK;
            Class<?> defc = m.getDeclaringClass();
            int mods = m.getModifiers();
            boolean bl = classOK = Modifier.isPublic(defc.getModifiers()) && (defc == refc || Modifier.isPublic(refc.getModifiers()));
            if (!classOK && (this.allowedModes & 8) != 0) {
                boolean bl2 = classOK = VerifyAccess.isClassAccessible(defc, this.lookupClass(), null, 95) && (defc == refc || VerifyAccess.isClassAccessible(refc, this.lookupClass(), null, 95));
            }
            if (!classOK) {
                return "class is not public";
            }
            if (Modifier.isPublic(mods)) {
                return "access to public member failed";
            }
            if (Modifier.isPrivate(mods)) {
                return "member is private";
            }
            if (Modifier.isProtected(mods)) {
                return "member is protected";
            }
            return "member is private to package";
        }

        private void checkSpecialCaller(Class<?> specialCaller, Class<?> refc) throws IllegalAccessException {
            int allowedModes = this.allowedModes;
            if (allowedModes == -1) {
                return;
            }
            if ((this.lookupModes() & 2) == 0 || specialCaller != this.lookupClass() && (refc == null || !refc.isInterface() || !refc.isAssignableFrom(specialCaller))) {
                throw new MemberName(specialCaller).makeAccessException("no private access for invokespecial", this);
            }
        }

        private boolean restrictProtectedReceiver(MemberName method) {
            return method.isProtected() && !method.isStatic() && this.allowedModes != -1 && method.getDeclaringClass() != this.lookupClass() && !VerifyAccess.isSamePackage(method.getDeclaringClass(), this.lookupClass());
        }

        private MethodHandle restrictReceiver(MemberName method, DirectMethodHandle mh, Class<?> caller) throws IllegalAccessException {
            assert (!method.isStatic());
            if (!method.getDeclaringClass().isAssignableFrom(caller)) {
                throw method.makeAccessException("caller class must be a subclass below the method", caller);
            }
            MethodType rawType = mh.type();
            if (caller.isAssignableFrom((Class<?>)rawType.parameterType(0))) {
                return mh;
            }
            MethodType narrowType = rawType.changeParameterType(0, caller);
            assert (!mh.isVarargsCollector());
            assert (mh.viewAsTypeChecks(narrowType, true));
            return mh.copyWith(narrowType, mh.form);
        }

        private MethodHandle getDirectMethod(byte refKind, Class<?> refc, MemberName method, Lookup callerLookup) throws IllegalAccessException {
            boolean doRestrict = true;
            boolean checkSecurity = true;
            return this.getDirectMethodCommon(refKind, refc, method, true, true, callerLookup);
        }

        private MethodHandle getDirectMethodNoRestrictInvokeSpecial(Class<?> refc, MemberName method, Lookup callerLookup) throws IllegalAccessException {
            boolean doRestrict = false;
            boolean checkSecurity = true;
            return this.getDirectMethodCommon((byte)7, refc, method, true, false, callerLookup);
        }

        private MethodHandle getDirectMethodNoSecurityManager(byte refKind, Class<?> refc, MemberName method, Lookup callerLookup) throws IllegalAccessException {
            boolean doRestrict = true;
            boolean checkSecurity = false;
            return this.getDirectMethodCommon(refKind, refc, method, false, true, callerLookup);
        }

        private MethodHandle getDirectMethodCommon(byte refKind, Class<?> refc, MemberName method, boolean checkSecurity, boolean doRestrict, Lookup boundCaller) throws IllegalAccessException {
            this.checkMethod(refKind, refc, method);
            if (checkSecurity) {
                this.checkSecurityManager(refc, method);
            }
            assert (!method.isMethodHandleInvoke());
            if (refKind == 7 && refc != this.lookupClass() && !refc.isInterface() && refc != this.lookupClass().getSuperclass() && refc.isAssignableFrom(this.lookupClass())) {
                MemberName m2;
                assert (!method.getName().equals("<init>"));
                Class<?> refcAsSuper = this.lookupClass();
                do {
                    refcAsSuper = refcAsSuper.getSuperclass();
                    m2 = new MemberName(refcAsSuper, method.getName(), method.getMethodType(), 7);
                } while ((m2 = IMPL_NAMES.resolveOrNull(refKind, m2, this.lookupClassOrNull(), this.allowedModes)) == null && refc != refcAsSuper);
                if (m2 == null) {
                    throw new InternalError(method.toString());
                }
                method = m2;
                refc = refcAsSuper;
                this.checkMethod(refKind, refc, method);
            }
            DirectMethodHandle dmh = DirectMethodHandle.make(refKind, refc, method, this.lookupClass());
            MethodHandle mh = dmh;
            if (doRestrict && refKind == 7 || MethodHandleNatives.refKindHasReceiver(refKind) && this.restrictProtectedReceiver(method)) {
                mh = this.restrictReceiver(method, dmh, this.lookupClass());
            }
            mh = this.maybeBindCaller(method, mh, boundCaller);
            mh = mh.setVarargs(method);
            return mh;
        }

        private MethodHandle maybeBindCaller(MemberName method, MethodHandle mh, Lookup boundCaller) throws IllegalAccessException {
            if (boundCaller.allowedModes == -1 || !MethodHandleNatives.isCallerSensitive(method)) {
                return mh;
            }
            if ((boundCaller.lookupModes() & 0x40) == 0) {
                throw new IllegalAccessException("Attempt to lookup caller-sensitive method using restricted lookup object");
            }
            assert (boundCaller.hasFullPrivilegeAccess());
            MethodHandle cbmh = MethodHandleImpl.bindCaller(mh, boundCaller.lookupClass);
            return cbmh;
        }

        private MethodHandle getDirectField(byte refKind, Class<?> refc, MemberName field) throws IllegalAccessException {
            boolean checkSecurity = true;
            return this.getDirectFieldCommon(refKind, refc, field, true);
        }

        private MethodHandle getDirectFieldNoSecurityManager(byte refKind, Class<?> refc, MemberName field) throws IllegalAccessException {
            boolean checkSecurity = false;
            return this.getDirectFieldCommon(refKind, refc, field, false);
        }

        private MethodHandle getDirectFieldCommon(byte refKind, Class<?> refc, MemberName field, boolean checkSecurity) throws IllegalAccessException {
            boolean doRestrict;
            this.checkField(refKind, refc, field);
            if (checkSecurity) {
                this.checkSecurityManager(refc, field);
            }
            DirectMethodHandle dmh = DirectMethodHandle.make(refc, field);
            boolean bl = doRestrict = MethodHandleNatives.refKindHasReceiver(refKind) && this.restrictProtectedReceiver(field);
            if (doRestrict) {
                return this.restrictReceiver(field, dmh, this.lookupClass());
            }
            return dmh;
        }

        private VarHandle getFieldVarHandle(byte getRefKind, byte putRefKind, Class<?> refc, MemberName getField, MemberName putField) throws IllegalAccessException {
            boolean checkSecurity = true;
            return this.getFieldVarHandleCommon(getRefKind, putRefKind, refc, getField, putField, true);
        }

        private VarHandle getFieldVarHandleNoSecurityManager(byte getRefKind, byte putRefKind, Class<?> refc, MemberName getField, MemberName putField) throws IllegalAccessException {
            boolean checkSecurity = false;
            return this.getFieldVarHandleCommon(getRefKind, putRefKind, refc, getField, putField, false);
        }

        private VarHandle getFieldVarHandleCommon(byte getRefKind, byte putRefKind, Class<?> refc, MemberName getField, MemberName putField, boolean checkSecurity) throws IllegalAccessException {
            boolean doRestrict;
            assert (getField.isStatic() == putField.isStatic());
            assert (getField.isGetter() && putField.isSetter());
            assert (MethodHandleNatives.refKindIsStatic(getRefKind) == MethodHandleNatives.refKindIsStatic(putRefKind));
            assert (MethodHandleNatives.refKindIsGetter(getRefKind) && MethodHandleNatives.refKindIsSetter(putRefKind));
            this.checkField(getRefKind, refc, getField);
            if (checkSecurity) {
                this.checkSecurityManager(refc, getField);
            }
            if (!putField.isFinal()) {
                this.checkField(putRefKind, refc, putField);
                if (checkSecurity) {
                    this.checkSecurityManager(refc, putField);
                }
            }
            boolean bl = doRestrict = MethodHandleNatives.refKindHasReceiver(getRefKind) && this.restrictProtectedReceiver(getField);
            if (doRestrict) {
                assert (!getField.isStatic());
                if (!getField.getDeclaringClass().isAssignableFrom(this.lookupClass())) {
                    throw getField.makeAccessException("caller class must be a subclass below the method", this.lookupClass());
                }
                refc = this.lookupClass();
            }
            return VarHandles.makeFieldHandle(getField, refc, getField.getFieldType(), this.allowedModes == -1 && !getField.isTrustedFinalField());
        }

        private MethodHandle getDirectConstructor(Class<?> refc, MemberName ctor) throws IllegalAccessException {
            boolean checkSecurity = true;
            return this.getDirectConstructorCommon(refc, ctor, true);
        }

        private MethodHandle getDirectConstructorNoSecurityManager(Class<?> refc, MemberName ctor) throws IllegalAccessException {
            boolean checkSecurity = false;
            return this.getDirectConstructorCommon(refc, ctor, false);
        }

        private MethodHandle getDirectConstructorCommon(Class<?> refc, MemberName ctor, boolean checkSecurity) throws IllegalAccessException {
            assert (ctor.isConstructor());
            this.checkAccess((byte)8, refc, ctor);
            if (checkSecurity) {
                this.checkSecurityManager(refc, ctor);
            }
            assert (!MethodHandleNatives.isCallerSensitive(ctor));
            return DirectMethodHandle.make(ctor).setVarargs(ctor);
        }

        MethodHandle linkMethodHandleConstant(byte refKind, Class<?> defc, String name, Object type) throws ReflectiveOperationException {
            if (!(type instanceof Class) && !(type instanceof MethodType)) {
                throw new InternalError("unresolved MemberName");
            }
            MemberName member = new MemberName(refKind, defc, name, type);
            MethodHandle mh = LOOKASIDE_TABLE.get(member);
            if (mh != null) {
                this.checkSymbolicClass(defc);
                return mh;
            }
            if (defc == MethodHandle.class && refKind == 5 ? (mh = this.findVirtualForMH(member.getName(), member.getMethodType())) != null : defc == VarHandle.class && refKind == 5 && (mh = this.findVirtualForVH(member.getName(), member.getMethodType())) != null) {
                return mh;
            }
            MemberName resolved = this.resolveOrFail(refKind, member);
            mh = this.getDirectMethodForConstant(refKind, defc, resolved);
            if (mh instanceof DirectMethodHandle && this.canBeCached(refKind, defc, resolved)) {
                MemberName key = mh.internalMemberName();
                if (key != null) {
                    key = key.asNormalOriginal();
                }
                if (member.equals(key)) {
                    LOOKASIDE_TABLE.put(key, (DirectMethodHandle)mh);
                }
            }
            return mh;
        }

        private boolean canBeCached(byte refKind, Class<?> defc, MemberName member) {
            if (refKind == 7) {
                return false;
            }
            if (!Modifier.isPublic(defc.getModifiers()) || !Modifier.isPublic(member.getDeclaringClass().getModifiers()) || !member.isPublic() || member.isCallerSensitive()) {
                return false;
            }
            ClassLoader loader = defc.getClassLoader();
            if (loader != null) {
                boolean found = false;
                for (ClassLoader sysl = ClassLoader.getSystemClassLoader(); sysl != null; sysl = sysl.getParent()) {
                    if (loader != sysl) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return false;
                }
            }
            try {
                MemberName resolved2 = MethodHandles.publicLookup().resolveOrNull(refKind, new MemberName(refKind, defc, member.getName(), member.getType()));
                if (resolved2 == null) {
                    return false;
                }
                this.checkSecurityManager(defc, resolved2);
            }
            catch (SecurityException ex) {
                return false;
            }
            return true;
        }

        private MethodHandle getDirectMethodForConstant(byte refKind, Class<?> defc, MemberName member) throws ReflectiveOperationException {
            if (MethodHandleNatives.refKindIsField(refKind)) {
                return this.getDirectFieldNoSecurityManager(refKind, defc, member);
            }
            if (MethodHandleNatives.refKindIsMethod(refKind)) {
                return this.getDirectMethodNoSecurityManager(refKind, defc, member, this.findBoundCallerLookup(member));
            }
            if (refKind == 8) {
                return this.getDirectConstructorNoSecurityManager(defc, member);
            }
            throw MethodHandleStatics.newIllegalArgumentException("bad MethodHandle constant #" + member);
        }

        static {
            Reflection.registerFieldsToFilter(Lookup.class, Set.of("lookupClass", "allowedModes"));
            IMPL_NAMES.getClass();
            IMPL_LOOKUP = new Lookup(Object.class, null, -1);
            PUBLIC_LOOKUP = new Lookup(Object.class, null, 32);
            LOOKASIDE_TABLE = new ConcurrentHashMap();
        }

        static class ClassDefiner {
            private final Lookup lookup;
            private final String name;
            private final byte[] bytes;
            private final int classFlags;

            private ClassDefiner(Lookup lookup, ClassFile cf, int flags) {
                assert ((flags & 2) != 0 || (flags & 4) == 4);
                this.lookup = lookup;
                this.bytes = cf.bytes;
                this.name = cf.name;
                this.classFlags = flags;
            }

            String className() {
                return this.name;
            }

            Class<?> defineClass(boolean initialize) {
                return this.defineClass(initialize, null);
            }

            Lookup defineClassAsLookup(boolean initialize) {
                Class<?> c = this.defineClass(initialize, null);
                return new Lookup(c, null, 95);
            }

            Class<?> defineClass(boolean initialize, Object classData) {
                Class<?> lookupClass = this.lookup.lookupClass();
                ClassLoader loader = lookupClass.getClassLoader();
                ProtectionDomain pd = loader != null ? this.lookup.lookupClassProtectionDomain() : null;
                Class<?> c = SharedSecrets.getJavaLangAccess().defineClass(loader, lookupClass, this.name, this.bytes, pd, initialize, this.classFlags, classData);
                assert (!this.isNestmate() || c.getNestHost() == lookupClass.getNestHost());
                return c;
            }

            Lookup defineClassAsLookup(boolean initialize, Object classData) {
                Class<?> c = this.defineClass(initialize, classData);
                return new Lookup(c, null, 95);
            }

            private boolean isNestmate() {
                return (this.classFlags & 1) != 0;
            }
        }

        static class ClassFile {
            final String name;
            final int accessFlags;
            final byte[] bytes;

            ClassFile(String name, int accessFlags, byte[] bytes) {
                this.name = name;
                this.accessFlags = accessFlags;
                this.bytes = bytes;
            }

            static ClassFile newInstanceNoCheck(String name, byte[] bytes) {
                return new ClassFile(name, 0, bytes);
            }

            static ClassFile newInstance(byte[] bytes, String pkgName) {
                String pn;
                int accessFlags;
                String name;
                int magic = ClassFile.readInt(bytes, 0);
                if (magic != -889275714) {
                    throw new ClassFormatError("Incompatible magic value: " + magic);
                }
                int minor = ClassFile.readUnsignedShort(bytes, 4);
                int major = ClassFile.readUnsignedShort(bytes, 6);
                if (!VM.isSupportedClassFileVersion(major, minor)) {
                    throw new UnsupportedClassVersionError("Unsupported class file version " + major + "." + minor);
                }
                try {
                    ClassReader reader = new ClassReader(bytes);
                    int thisClass = reader.readUnsignedShort(reader.header + 2);
                    Object constant = reader.readConst(thisClass, new char[reader.getMaxStringLength()]);
                    if (!(constant instanceof Type)) {
                        throw new ClassFormatError("this_class item: #" + thisClass + " not a CONSTANT_Class_info");
                    }
                    Type type = (Type)constant;
                    if (!type.getDescriptor().startsWith("L")) {
                        throw new ClassFormatError("this_class item: #" + thisClass + " not a CONSTANT_Class_info");
                    }
                    name = type.getClassName();
                    accessFlags = reader.readUnsignedShort(reader.header);
                }
                catch (RuntimeException e) {
                    ClassFormatError cfe = new ClassFormatError();
                    cfe.initCause(e);
                    throw cfe;
                }
                if ((accessFlags & 0x8000) != 0) {
                    throw MethodHandleStatics.newIllegalArgumentException("Not a class or interface: ACC_MODULE flag is set");
                }
                int index = name.lastIndexOf(46);
                String string = pn = index == -1 ? "" : name.substring(0, index);
                if (!pn.equals(pkgName)) {
                    throw MethodHandleStatics.newIllegalArgumentException(name + " not in same package as lookup class");
                }
                return new ClassFile(name, accessFlags, bytes);
            }

            private static int readInt(byte[] bytes, int offset) {
                if (offset + 4 > bytes.length) {
                    throw new ClassFormatError("Invalid ClassFile structure");
                }
                return (bytes[offset] & 0xFF) << 24 | (bytes[offset + 1] & 0xFF) << 16 | (bytes[offset + 2] & 0xFF) << 8 | bytes[offset + 3] & 0xFF;
            }

            private static int readUnsignedShort(byte[] bytes, int offset) {
                if (offset + 2 > bytes.length) {
                    throw new ClassFormatError("Invalid ClassFile structure");
                }
                return (bytes[offset] & 0xFF) << 8 | bytes[offset + 1] & 0xFF;
            }
        }

        public static enum ClassOption {
            NESTMATE(1),
            STRONG(4);

            private final int flag;

            private ClassOption(int flag) {
                this.flag = flag;
            }

            static int optionsToFlag(Set<ClassOption> options) {
                int flags = 0;
                for (ClassOption cp : options) {
                    flags |= cp.flag;
                }
                return flags;
            }
        }
    }
}

