/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.constant.ClassDesc;
import java.lang.constant.Constable;
import java.lang.constant.MethodTypeDesc;
import java.lang.invoke.Invokers;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodTypeForm;
import java.lang.invoke.TypeDescriptor;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import jdk.internal.vm.annotation.Stable;
import sun.invoke.util.BytecodeDescriptor;
import sun.invoke.util.VerifyType;
import sun.invoke.util.Wrapper;
import sun.security.util.SecurityConstants;

public final class MethodType
implements Constable,
TypeDescriptor.OfMethod<Class<?>, MethodType>,
Serializable {
    private static final long serialVersionUID = 292L;
    @Stable
    private final Class<?> rtype;
    @Stable
    private final Class<?>[] ptypes;
    @Stable
    private MethodTypeForm form;
    @Stable
    private Object wrapAlt;
    @Stable
    private Invokers invokers;
    @Stable
    private String methodDescriptor;
    static final int MAX_JVM_ARITY = 255;
    static final int MAX_MH_ARITY = 254;
    static final int MAX_MH_INVOKER_ARITY = 253;
    static final ConcurrentWeakInternSet<MethodType> internTable = new ConcurrentWeakInternSet();
    static final Class<?>[] NO_PTYPES = new Class[0];
    @Stable
    private static final MethodType[] objectOnlyTypes = new MethodType[20];
    @Stable
    private static final Class<?>[] METHOD_HANDLE_ARRAY = new Class[]{MethodHandle.class};
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];

    private MethodType(Class<?> rtype, Class<?>[] ptypes) {
        this.rtype = rtype;
        this.ptypes = ptypes;
    }

    MethodTypeForm form() {
        return this.form;
    }

    Class<?> rtype() {
        return this.rtype;
    }

    Class<?>[] ptypes() {
        return this.ptypes;
    }

    void setForm(MethodTypeForm f) {
        this.form = f;
    }

    private static int checkPtypes(Class<?>[] ptypes) {
        int slots = 0;
        for (Class<?> ptype : ptypes) {
            Objects.requireNonNull(ptype);
            if (ptype == Void.TYPE) {
                throw MethodHandleStatics.newIllegalArgumentException("parameter type cannot be void");
            }
            if (ptype != Double.TYPE && ptype != Long.TYPE) continue;
            ++slots;
        }
        MethodType.checkSlotCount(ptypes.length + slots);
        return slots;
    }

    static void checkSlotCount(int count) {
        if ((count & 0xFF) != count) {
            throw MethodHandleStatics.newIllegalArgumentException("bad parameter count " + count);
        }
    }

    private static IndexOutOfBoundsException newIndexOutOfBoundsException(Object num) {
        if (num instanceof Integer) {
            num = "bad index: " + num;
        }
        return new IndexOutOfBoundsException(num.toString());
    }

    public static MethodType methodType(Class<?> rtype, Class<?>[] ptypes) {
        return MethodType.makeImpl(rtype, ptypes, false);
    }

    public static MethodType methodType(Class<?> rtype, List<Class<?>> ptypes) {
        boolean notrust = false;
        return MethodType.makeImpl(rtype, MethodType.listToArray(ptypes), notrust);
    }

    private static Class<?>[] listToArray(List<Class<?>> ptypes) {
        MethodType.checkSlotCount(ptypes.size());
        return ptypes.toArray(NO_PTYPES);
    }

    public static MethodType methodType(Class<?> rtype, Class<?> ptype0, Class<?> ... ptypes) {
        Class[] ptypes1 = new Class[1 + ptypes.length];
        ptypes1[0] = ptype0;
        System.arraycopy(ptypes, 0, ptypes1, 1, ptypes.length);
        return MethodType.makeImpl(rtype, ptypes1, true);
    }

    public static MethodType methodType(Class<?> rtype) {
        return MethodType.makeImpl(rtype, NO_PTYPES, true);
    }

    public static MethodType methodType(Class<?> rtype, Class<?> ptype0) {
        return MethodType.makeImpl(rtype, new Class[]{ptype0}, true);
    }

    public static MethodType methodType(Class<?> rtype, MethodType ptypes) {
        return MethodType.makeImpl(rtype, ptypes.ptypes, true);
    }

    static MethodType makeImpl(Class<?> rtype, Class<?>[] ptypes, boolean trusted) {
        MethodType primordialMT;
        MethodType mt;
        if (ptypes.length == 0) {
            ptypes = NO_PTYPES;
            trusted = true;
        }
        if ((mt = internTable.get(primordialMT = new MethodType(rtype, ptypes))) != null) {
            return mt;
        }
        Objects.requireNonNull(rtype);
        if (trusted) {
            MethodType.checkPtypes(ptypes);
            mt = primordialMT;
        } else {
            ptypes = Arrays.copyOf(ptypes, ptypes.length);
            MethodType.checkPtypes(ptypes);
            mt = new MethodType(rtype, ptypes);
        }
        mt.form = MethodTypeForm.findForm(mt);
        return internTable.add(mt);
    }

    public static MethodType genericMethodType(int objectArgCount, boolean finalArray) {
        MethodType mt;
        MethodType.checkSlotCount(objectArgCount);
        int ivarargs = !finalArray ? 0 : 1;
        int ootIndex = objectArgCount * 2 + ivarargs;
        if (ootIndex < objectOnlyTypes.length && (mt = objectOnlyTypes[ootIndex]) != null) {
            return mt;
        }
        Object[] ptypes = new Class[objectArgCount + ivarargs];
        Arrays.fill(ptypes, Object.class);
        if (ivarargs != 0) {
            ptypes[objectArgCount] = Object[].class;
        }
        mt = MethodType.makeImpl(Object.class, ptypes, true);
        if (ootIndex < objectOnlyTypes.length) {
            MethodType.objectOnlyTypes[ootIndex] = mt;
        }
        return mt;
    }

    public static MethodType genericMethodType(int objectArgCount) {
        return MethodType.genericMethodType(objectArgCount, false);
    }

    @Override
    public MethodType changeParameterType(int num, Class<?> nptype) {
        if (this.parameterType(num) == nptype) {
            return this;
        }
        Class[] nptypes = (Class[])this.ptypes.clone();
        nptypes[num] = nptype;
        return MethodType.makeImpl(this.rtype, nptypes, true);
    }

    public MethodType insertParameterTypes(int num, Class<?> ... ptypesToInsert) {
        int len = this.ptypes.length;
        if (num < 0 || num > len) {
            throw MethodType.newIndexOutOfBoundsException(num);
        }
        int ins = MethodType.checkPtypes(ptypesToInsert);
        MethodType.checkSlotCount(this.parameterSlotCount() + ptypesToInsert.length + ins);
        int ilen = ptypesToInsert.length;
        if (ilen == 0) {
            return this;
        }
        Class[] nptypes = new Class[len + ilen];
        if (num > 0) {
            System.arraycopy(this.ptypes, 0, nptypes, 0, num);
        }
        System.arraycopy(ptypesToInsert, 0, nptypes, num, ilen);
        if (num < len) {
            System.arraycopy(this.ptypes, num, nptypes, num + ilen, len - num);
        }
        return MethodType.makeImpl(this.rtype, nptypes, true);
    }

    public MethodType appendParameterTypes(Class<?> ... ptypesToInsert) {
        return this.insertParameterTypes(this.parameterCount(), ptypesToInsert);
    }

    public MethodType insertParameterTypes(int num, List<Class<?>> ptypesToInsert) {
        return this.insertParameterTypes(num, MethodType.listToArray(ptypesToInsert));
    }

    public MethodType appendParameterTypes(List<Class<?>> ptypesToInsert) {
        return this.insertParameterTypes(this.parameterCount(), ptypesToInsert);
    }

    MethodType replaceParameterTypes(int start, int end, Class<?> ... ptypesToInsert) {
        if (start == end) {
            return this.insertParameterTypes(start, ptypesToInsert);
        }
        int len = this.ptypes.length;
        if (0 > start || start > end || end > len) {
            throw MethodType.newIndexOutOfBoundsException("start=" + start + " end=" + end);
        }
        int ilen = ptypesToInsert.length;
        if (ilen == 0) {
            return this.dropParameterTypes(start, end);
        }
        return this.dropParameterTypes(start, end).insertParameterTypes(start, ptypesToInsert);
    }

    MethodType asSpreaderType(Class<?> arrayType, int pos, int arrayLength) {
        assert (this.parameterCount() >= arrayLength);
        int spreadPos = pos;
        if (arrayLength == 0) {
            return this;
        }
        if (arrayType == Object[].class) {
            if (this.isGeneric()) {
                return this;
            }
            if (spreadPos == 0) {
                MethodType res = MethodType.genericMethodType(arrayLength);
                if (this.rtype != Object.class) {
                    res = res.changeReturnType(this.rtype);
                }
                return res;
            }
        }
        Class<?> elemType = arrayType.getComponentType();
        assert (elemType != null);
        for (int i = spreadPos; i < spreadPos + arrayLength; ++i) {
            if (this.ptypes[i] == elemType) continue;
            Object[] fixedPtypes = (Class[])this.ptypes.clone();
            Arrays.fill(fixedPtypes, i, spreadPos + arrayLength, elemType);
            return MethodType.methodType(this.rtype, fixedPtypes);
        }
        return this;
    }

    Class<?> leadingReferenceParameter() {
        Class<?> ptype;
        if (this.ptypes.length == 0 || (ptype = this.ptypes[0]).isPrimitive()) {
            throw MethodHandleStatics.newIllegalArgumentException("no leading reference parameter");
        }
        return ptype;
    }

    MethodType asCollectorType(Class<?> arrayType, int pos, int arrayLength) {
        MethodType res;
        assert (this.parameterCount() >= 1);
        assert (pos < this.ptypes.length);
        assert (this.ptypes[pos].isAssignableFrom(arrayType));
        if (arrayType == Object[].class) {
            res = MethodType.genericMethodType(arrayLength);
            if (this.rtype != Object.class) {
                res = res.changeReturnType(this.rtype);
            }
        } else {
            Class<?> elemType = arrayType.getComponentType();
            assert (elemType != null);
            res = MethodType.methodType(this.rtype, Collections.nCopies(arrayLength, elemType));
        }
        if (this.ptypes.length == 1) {
            return res;
        }
        if (pos < this.ptypes.length - 1) {
            res = res.insertParameterTypes(arrayLength, Arrays.copyOfRange(this.ptypes, pos + 1, this.ptypes.length));
        }
        return res.insertParameterTypes(0, Arrays.copyOf(this.ptypes, pos));
    }

    @Override
    public MethodType dropParameterTypes(int start, int end) {
        Class<?>[] nptypes;
        int len = this.ptypes.length;
        if (0 > start || start > end || end > len) {
            throw MethodType.newIndexOutOfBoundsException("start=" + start + " end=" + end);
        }
        if (start == end) {
            return this;
        }
        if (start == 0) {
            nptypes = end == len ? NO_PTYPES : Arrays.copyOfRange(this.ptypes, end, len);
        } else if (end == len) {
            nptypes = Arrays.copyOfRange(this.ptypes, 0, start);
        } else {
            int tail = len - end;
            nptypes = Arrays.copyOfRange(this.ptypes, 0, start + tail);
            System.arraycopy(this.ptypes, end, nptypes, start, tail);
        }
        return MethodType.makeImpl(this.rtype, nptypes, true);
    }

    @Override
    public MethodType changeReturnType(Class<?> nrtype) {
        if (this.returnType() == nrtype) {
            return this;
        }
        return MethodType.makeImpl(nrtype, this.ptypes, true);
    }

    public boolean hasPrimitives() {
        return this.form.hasPrimitives();
    }

    public boolean hasWrappers() {
        return this.unwrap() != this;
    }

    public MethodType erase() {
        return this.form.erasedType();
    }

    MethodType basicType() {
        return this.form.basicType();
    }

    MethodType invokerType() {
        return this.insertParameterTypes(0, METHOD_HANDLE_ARRAY);
    }

    public MethodType generic() {
        return MethodType.genericMethodType(this.parameterCount());
    }

    boolean isGeneric() {
        return this == this.erase() && !this.hasPrimitives();
    }

    public MethodType wrap() {
        return this.hasPrimitives() ? MethodType.wrapWithPrims(this) : this;
    }

    public MethodType unwrap() {
        MethodType noprims = !this.hasPrimitives() ? this : MethodType.wrapWithPrims(this);
        return MethodType.unwrapWithNoPrims(noprims);
    }

    private static MethodType wrapWithPrims(MethodType pt) {
        assert (pt.hasPrimitives());
        MethodType wt = (MethodType)pt.wrapAlt;
        if (wt == null) {
            wt = MethodTypeForm.canonicalize(pt, 2);
            assert (wt != null);
            pt.wrapAlt = wt;
        }
        return wt;
    }

    private static MethodType unwrapWithNoPrims(MethodType wt) {
        assert (!wt.hasPrimitives());
        MethodType uwt = (MethodType)wt.wrapAlt;
        if (uwt == null) {
            uwt = MethodTypeForm.canonicalize(wt, 3);
            if (uwt == null) {
                uwt = wt;
            }
            wt.wrapAlt = uwt;
        }
        return uwt;
    }

    @Override
    public Class<?> parameterType(int num) {
        return this.ptypes[num];
    }

    @Override
    public int parameterCount() {
        return this.ptypes.length;
    }

    @Override
    public Class<?> returnType() {
        return this.rtype;
    }

    @Override
    public List<Class<?>> parameterList() {
        return Collections.unmodifiableList(Arrays.asList((Class[])this.ptypes.clone()));
    }

    public Class<?> lastParameterType() {
        int len = this.ptypes.length;
        return len == 0 ? Void.TYPE : this.ptypes[len - 1];
    }

    public Class<?>[] parameterArray() {
        return (Class[])this.ptypes.clone();
    }

    public boolean equals(Object x) {
        Object o;
        if (this == x) {
            return true;
        }
        if (x instanceof MethodType) {
            return this.equals((MethodType)x);
        }
        if (x instanceof ConcurrentWeakInternSet.WeakEntry && (o = ((ConcurrentWeakInternSet.WeakEntry)x).get()) instanceof MethodType) {
            return this.equals((MethodType)o);
        }
        return false;
    }

    private boolean equals(MethodType that) {
        return this.rtype == that.rtype && Arrays.equals(this.ptypes, that.ptypes);
    }

    public int hashCode() {
        int hashCode = 31 + this.rtype.hashCode();
        for (Class<?> ptype : this.ptypes) {
            hashCode = 31 * hashCode + ptype.hashCode();
        }
        return hashCode;
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(",", "(", ")" + this.rtype.getSimpleName());
        for (int i = 0; i < this.ptypes.length; ++i) {
            sj.add(this.ptypes[i].getSimpleName());
        }
        return sj.toString();
    }

    boolean effectivelyIdenticalParameters(int skipPos, List<Class<?>> fullList) {
        int myLen = this.ptypes.length;
        int fullLen = fullList.size();
        if (skipPos > myLen || myLen - skipPos > fullLen) {
            return false;
        }
        List<Class<?>> myList = Arrays.asList(this.ptypes);
        if (skipPos != 0) {
            myList = myList.subList(skipPos, myLen);
            myLen -= skipPos;
        }
        if (fullLen == myLen) {
            return myList.equals(fullList);
        }
        return myList.equals(fullList.subList(0, myLen));
    }

    boolean isViewableAs(MethodType newType, boolean keepInterfaces) {
        if (!VerifyType.isNullConversion(this.returnType(), newType.returnType(), keepInterfaces)) {
            return false;
        }
        if (this.form == newType.form && this.form.erasedType == this) {
            return true;
        }
        if (this.ptypes == newType.ptypes) {
            return true;
        }
        int argc = this.parameterCount();
        if (argc != newType.parameterCount()) {
            return false;
        }
        for (int i = 0; i < argc; ++i) {
            if (VerifyType.isNullConversion(newType.parameterType(i), this.parameterType(i), keepInterfaces)) continue;
            return false;
        }
        return true;
    }

    boolean isConvertibleTo(MethodType newType) {
        MethodTypeForm newForm;
        MethodTypeForm oldForm = this.form();
        if (oldForm == (newForm = newType.form())) {
            return true;
        }
        if (!MethodType.canConvert(this.returnType(), newType.returnType())) {
            return false;
        }
        Class<?>[] srcTypes = newType.ptypes;
        Class<?>[] dstTypes = this.ptypes;
        if (srcTypes == dstTypes) {
            return true;
        }
        int argc = srcTypes.length;
        if (argc != dstTypes.length) {
            return false;
        }
        if (argc <= 1) {
            return argc != 1 || MethodType.canConvert(srcTypes[0], dstTypes[0]);
        }
        if (!oldForm.hasPrimitives() && oldForm.erasedType == this || !newForm.hasPrimitives() && newForm.erasedType == newType) {
            assert (this.canConvertParameters(srcTypes, dstTypes));
            return true;
        }
        return this.canConvertParameters(srcTypes, dstTypes);
    }

    boolean explicitCastEquivalentToAsType(MethodType newType) {
        if (this == newType) {
            return true;
        }
        if (!MethodType.explicitCastEquivalentToAsType(this.rtype, newType.rtype)) {
            return false;
        }
        Class<?>[] dstTypes = this.ptypes;
        Class<?>[] srcTypes = newType.ptypes;
        if (dstTypes == srcTypes) {
            return true;
        }
        assert (dstTypes.length == srcTypes.length);
        for (int i = 0; i < dstTypes.length; ++i) {
            if (MethodType.explicitCastEquivalentToAsType(srcTypes[i], dstTypes[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean explicitCastEquivalentToAsType(Class<?> src, Class<?> dst) {
        if (src == dst || dst == Object.class || dst == Void.TYPE) {
            return true;
        }
        if (src.isPrimitive()) {
            return MethodType.canConvert(src, dst);
        }
        if (dst.isPrimitive()) {
            return false;
        }
        return !dst.isInterface() || dst.isAssignableFrom(src);
    }

    private boolean canConvertParameters(Class<?>[] srcTypes, Class<?>[] dstTypes) {
        for (int i = 0; i < srcTypes.length; ++i) {
            if (MethodType.canConvert(srcTypes[i], dstTypes[i])) continue;
            return false;
        }
        return true;
    }

    static boolean canConvert(Class<?> src, Class<?> dst) {
        if (src == dst || src == Object.class || dst == Object.class) {
            return true;
        }
        if (src.isPrimitive()) {
            if (src == Void.TYPE) {
                return true;
            }
            Wrapper sw = Wrapper.forPrimitiveType(src);
            if (dst.isPrimitive()) {
                return Wrapper.forPrimitiveType(dst).isConvertibleFrom(sw);
            }
            return dst.isAssignableFrom(sw.wrapperType());
        }
        if (dst.isPrimitive()) {
            if (dst == Void.TYPE) {
                return true;
            }
            Wrapper dw = Wrapper.forPrimitiveType(dst);
            if (src.isAssignableFrom(dw.wrapperType())) {
                return true;
            }
            return Wrapper.isWrapperType(src) && dw.isConvertibleFrom(Wrapper.forWrapperType(src));
        }
        return true;
    }

    int parameterSlotCount() {
        return this.form.parameterSlotCount();
    }

    Invokers invokers() {
        Invokers inv = this.invokers;
        if (inv != null) {
            return inv;
        }
        this.invokers = inv = new Invokers(this);
        return inv;
    }

    public static MethodType fromMethodDescriptorString(String descriptor, ClassLoader loader) throws IllegalArgumentException, TypeNotPresentException {
        SecurityManager sm;
        if (loader == null && (sm = System.getSecurityManager()) != null) {
            sm.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
        }
        return MethodType.fromDescriptor(descriptor, loader == null ? ClassLoader.getSystemClassLoader() : loader);
    }

    static MethodType fromDescriptor(String descriptor, ClassLoader loader) throws IllegalArgumentException, TypeNotPresentException {
        if (!descriptor.startsWith("(") || descriptor.indexOf(41) < 0 || descriptor.indexOf(46) >= 0) {
            throw MethodHandleStatics.newIllegalArgumentException("not a method descriptor: " + descriptor);
        }
        List<Class<?>> types = BytecodeDescriptor.parseMethod(descriptor, loader);
        Class<?> rtype = types.remove(types.size() - 1);
        Class<?>[] ptypes = MethodType.listToArray(types);
        return MethodType.makeImpl(rtype, ptypes, true);
    }

    public String toMethodDescriptorString() {
        String desc = this.methodDescriptor;
        if (desc == null) {
            this.methodDescriptor = desc = BytecodeDescriptor.unparseMethod(this.rtype, this.ptypes);
        }
        return desc;
    }

    @Override
    public String descriptorString() {
        return this.toMethodDescriptorString();
    }

    static String toFieldDescriptorString(Class<?> cls) {
        return BytecodeDescriptor.unparse(cls);
    }

    public Optional<MethodTypeDesc> describeConstable() {
        try {
            return Optional.of(MethodTypeDesc.of(((Class)this.returnType()).describeConstable().orElseThrow(), (ClassDesc[])Stream.of(this.parameterArray()).map(p -> p.describeConstable().orElseThrow()).toArray(ClassDesc[]::new)));
        }
        catch (NoSuchElementException e) {
            return Optional.empty();
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.returnType());
        s.writeObject(this.parameterArray());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        MethodHandleStatics.UNSAFE.putReference(this, OffsetHolder.rtypeOffset, Void.TYPE);
        MethodHandleStatics.UNSAFE.putReference(this, OffsetHolder.ptypesOffset, NO_PTYPES);
        s.defaultReadObject();
        Class returnType = (Class)s.readObject();
        Class[] parameterArray = (Class[])s.readObject();
        this.wrapAlt = new MethodType[]{MethodType.methodType(returnType, parameterArray)};
    }

    private Object readResolve() {
        MethodType mt = ((MethodType[])this.wrapAlt)[0];
        this.wrapAlt = null;
        return mt;
    }

    private static class ConcurrentWeakInternSet<T> {
        private final ConcurrentMap<WeakEntry<T>, WeakEntry<T>> map = new ConcurrentHashMap<WeakEntry<T>, WeakEntry<T>>(512);
        private final ReferenceQueue<T> stale = new ReferenceQueue();

        public T get(T elem) {
            Object res;
            if (elem == null) {
                throw new NullPointerException();
            }
            this.expungeStaleElements();
            WeakEntry value = (WeakEntry)this.map.get(elem);
            if (value != null && (res = value.get()) != null) {
                return res;
            }
            return null;
        }

        public T add(T elem) {
            WeakEntry<T> exist;
            T interned;
            if (elem == null) {
                throw new NullPointerException();
            }
            WeakEntry<T> e = new WeakEntry<T>(elem, this.stale);
            do {
                this.expungeStaleElements();
            } while ((interned = (exist = this.map.putIfAbsent(e, e)) == null ? elem : exist.get()) == null);
            return interned;
        }

        private void expungeStaleElements() {
            Reference<T> reference;
            while ((reference = this.stale.poll()) != null) {
                this.map.remove(reference);
            }
        }

        private static class WeakEntry<T>
        extends WeakReference<T> {
            public final int hashcode;

            public WeakEntry(T key, ReferenceQueue<T> queue) {
                super(key, queue);
                this.hashcode = key.hashCode();
            }

            public boolean equals(Object obj) {
                Object mine = this.get();
                if (obj instanceof WeakEntry) {
                    Object that = ((WeakEntry)obj).get();
                    return that == null || mine == null ? this == obj : mine.equals(that);
                }
                return mine == null ? obj == null : mine.equals(obj);
            }

            public int hashCode() {
                return this.hashcode;
            }
        }
    }

    private static class OffsetHolder {
        static final long rtypeOffset = MethodHandleStatics.UNSAFE.objectFieldOffset(MethodType.class, "rtype");
        static final long ptypesOffset = MethodHandleStatics.UNSAFE.objectFieldOffset(MethodType.class, "ptypes");

        private OffsetHolder() {
        }
    }
}

