/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.LambdaForm;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.ref.SoftReference;
import sun.invoke.util.Wrapper;

final class MethodTypeForm {
    final short parameterSlotCount;
    final short primitiveCount;
    final MethodType erasedType;
    final MethodType basicType;
    final SoftReference<MethodHandle>[] methodHandles;
    static final int MH_BASIC_INV = 0;
    static final int MH_NF_INV = 1;
    static final int MH_UNINIT_CS = 2;
    static final int MH_LIMIT = 3;
    final SoftReference<LambdaForm>[] lambdaForms;
    static final int LF_INVVIRTUAL = 0;
    static final int LF_INVSTATIC = 1;
    static final int LF_INVSPECIAL = 2;
    static final int LF_NEWINVSPECIAL = 3;
    static final int LF_INVINTERFACE = 4;
    static final int LF_INVSTATIC_INIT = 5;
    static final int LF_INTERPRET = 6;
    static final int LF_REBIND = 7;
    static final int LF_DELEGATE = 8;
    static final int LF_DELEGATE_BLOCK_INLINING = 9;
    static final int LF_EX_LINKER = 10;
    static final int LF_EX_INVOKER = 11;
    static final int LF_GEN_LINKER = 12;
    static final int LF_GEN_INVOKER = 13;
    static final int LF_CS_LINKER = 14;
    static final int LF_MH_LINKER = 15;
    static final int LF_GWC = 16;
    static final int LF_GWT = 17;
    static final int LF_TF = 18;
    static final int LF_LOOP = 19;
    static final int LF_INVSPECIAL_IFC = 20;
    static final int LF_INVNATIVE = 21;
    static final int LF_VH_EX_INVOKER = 22;
    static final int LF_VH_GEN_INVOKER = 23;
    static final int LF_VH_GEN_LINKER = 24;
    static final int LF_COLLECTOR = 25;
    static final int LF_LIMIT = 26;
    public static final int ERASE = 1;
    public static final int WRAP = 2;
    public static final int UNWRAP = 3;

    public MethodType erasedType() {
        return this.erasedType;
    }

    public MethodType basicType() {
        return this.basicType;
    }

    public MethodHandle cachedMethodHandle(int which) {
        SoftReference<MethodHandle> entry = this.methodHandles[which];
        return entry != null ? entry.get() : null;
    }

    public synchronized MethodHandle setCachedMethodHandle(int which, MethodHandle mh) {
        MethodHandle prev;
        SoftReference<MethodHandle> entry = this.methodHandles[which];
        if (entry != null && (prev = entry.get()) != null) {
            return prev;
        }
        this.methodHandles[which] = new SoftReference<MethodHandle>(mh);
        return mh;
    }

    public LambdaForm cachedLambdaForm(int which) {
        SoftReference<LambdaForm> entry = this.lambdaForms[which];
        return entry != null ? entry.get() : null;
    }

    public synchronized LambdaForm setCachedLambdaForm(int which, LambdaForm form) {
        LambdaForm prev;
        SoftReference<LambdaForm> entry = this.lambdaForms[which];
        if (entry != null && (prev = entry.get()) != null) {
            return prev;
        }
        this.lambdaForms[which] = new SoftReference<LambdaForm>(form);
        return form;
    }

    protected MethodTypeForm(MethodType erasedType) {
        Class<Integer> returnType;
        Wrapper w;
        Class<?>[] erasedPtypes;
        this.erasedType = erasedType;
        Class<?>[] ptypes = erasedType.ptypes();
        int pslotCount = ptypes.length;
        int primitiveCount = 0;
        int longArgCount = 0;
        Class<?>[] basicPtypes = erasedPtypes = ptypes;
        for (int i = 0; i < erasedPtypes.length; ++i) {
            Class<?> ptype = erasedPtypes[i];
            if (ptype == Object.class) continue;
            primitiveCount = (short)(primitiveCount + 1);
            w = Wrapper.forPrimitiveType(ptype);
            if (w.isDoubleWord()) {
                longArgCount = (short)(longArgCount + 1);
            }
            if (!w.isSubwordOrInt() || ptype == Integer.TYPE) continue;
            if (basicPtypes == erasedPtypes) {
                basicPtypes = (Class[])basicPtypes.clone();
            }
            basicPtypes[i] = Integer.TYPE;
        }
        pslotCount += longArgCount;
        Class<Integer> basicReturnType = returnType = erasedType.returnType();
        if (returnType != Object.class) {
            primitiveCount = (short)(primitiveCount + 1);
            w = Wrapper.forPrimitiveType(returnType);
            if (w.isSubwordOrInt() && returnType != Integer.TYPE) {
                basicReturnType = Integer.TYPE;
            }
        }
        if (erasedPtypes == basicPtypes && basicReturnType == returnType) {
            this.basicType = erasedType;
            if (pslotCount >= 256) {
                throw MethodHandleStatics.newIllegalArgumentException("too many arguments");
            }
            this.primitiveCount = (short)primitiveCount;
            this.parameterSlotCount = (short)pslotCount;
            this.lambdaForms = new SoftReference[26];
            this.methodHandles = new SoftReference[3];
        } else {
            this.basicType = MethodType.makeImpl(basicReturnType, basicPtypes, true);
            MethodTypeForm that = this.basicType.form();
            assert (this != that);
            this.parameterSlotCount = that.parameterSlotCount;
            this.primitiveCount = that.primitiveCount;
            this.methodHandles = null;
            this.lambdaForms = null;
        }
    }

    public int parameterCount() {
        return this.erasedType.parameterCount();
    }

    public int parameterSlotCount() {
        return this.parameterSlotCount;
    }

    public boolean hasPrimitives() {
        return this.primitiveCount != 0;
    }

    static MethodTypeForm findForm(MethodType mt) {
        MethodType erased = MethodTypeForm.canonicalize(mt, 1);
        if (erased == null) {
            return new MethodTypeForm(mt);
        }
        return erased.form();
    }

    public static MethodType canonicalize(MethodType mt, int how) {
        Class<?>[] ptypes = mt.ptypes();
        Class<?>[] ptypesCanonical = MethodTypeForm.canonicalizeAll(ptypes, how);
        TypeDescriptor.OfField rtype = mt.returnType();
        TypeDescriptor.OfField<Class<?>> rtypeCanonical = MethodTypeForm.canonicalize(rtype, how);
        if (ptypesCanonical == null && rtypeCanonical == null) {
            return null;
        }
        if (rtypeCanonical == null) {
            rtypeCanonical = rtype;
        }
        if (ptypesCanonical == null) {
            ptypesCanonical = ptypes;
        }
        return MethodType.makeImpl(rtypeCanonical, ptypesCanonical, true);
    }

    static Class<?> canonicalize(Class<?> t, int how) {
        if (t != Object.class) {
            if (!t.isPrimitive()) {
                switch (how) {
                    case 3: {
                        Class<?> ct = Wrapper.asPrimitiveType(t);
                        if (ct == t) break;
                        return ct;
                    }
                    case 1: {
                        return Object.class;
                    }
                }
            } else if (how == 2) {
                return Wrapper.asWrapperType(t);
            }
        }
        return null;
    }

    static Class<?>[] canonicalizeAll(Class<?>[] ts, int how) {
        Class[] cs = null;
        int imax = ts.length;
        for (int i = 0; i < imax; ++i) {
            Class<?> c = MethodTypeForm.canonicalize(ts[i], how);
            if (c == null || c == Void.TYPE) continue;
            if (cs == null) {
                cs = (Class[])ts.clone();
            }
            cs[i] = c;
        }
        return cs;
    }

    public String toString() {
        return "Form" + this.erasedType;
    }
}

