/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.InvokerBytecodeGenerator;
import java.lang.invoke.LambdaForm;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import jdk.internal.invoke.NativeEntryPoint;
import jdk.internal.vm.annotation.ForceInline;

class NativeMethodHandle
extends MethodHandle {
    final NativeEntryPoint nep;
    final MethodHandle fallback;
    private static final MemberName.Factory IMPL_NAMES = MemberName.getFactory();

    private NativeMethodHandle(MethodType type, LambdaForm form, MethodHandle fallback, NativeEntryPoint nep) {
        super(type, form);
        this.fallback = fallback;
        this.nep = nep;
    }

    public static MethodHandle make(NativeEntryPoint nep, MethodHandle fallback) {
        MethodType type = nep.type();
        if (!NativeMethodHandle.allTypesPrimitive(type)) {
            throw new IllegalArgumentException("Type must only contain primitives: " + type);
        }
        if (type != fallback.type()) {
            throw new IllegalArgumentException("Type of fallback must match: " + type + " != " + fallback.type());
        }
        LambdaForm lform = NativeMethodHandle.preparedLambdaForm(type);
        return new NativeMethodHandle(type, lform, fallback, nep);
    }

    private static boolean allTypesPrimitive(MethodType type) {
        if (!((Class)type.returnType()).isPrimitive()) {
            return false;
        }
        for (Class<?> pType : type.parameterArray()) {
            if (pType.isPrimitive()) continue;
            return false;
        }
        return true;
    }

    private static LambdaForm preparedLambdaForm(MethodType mtype) {
        int id = 21;
        LambdaForm lform = (mtype = mtype.basicType()).form().cachedLambdaForm(id);
        if (lform != null) {
            return lform;
        }
        lform = NativeMethodHandle.makePreparedLambdaForm(mtype);
        return mtype.form().setCachedLambdaForm(id, lform);
    }

    private static LambdaForm makePreparedLambdaForm(MethodType mtype) {
        int ARG_LIMIT;
        MethodType linkerType = mtype.insertParameterTypes(0, MethodHandle.class).appendParameterTypes(Object.class);
        MemberName linker = new MemberName(MethodHandle.class, "linkToNative", linkerType, 6);
        try {
            linker = IMPL_NAMES.resolveOrFail((byte)6, linker, null, -1, NoSuchMethodException.class);
        }
        catch (ReflectiveOperationException ex) {
            throw MethodHandleStatics.newInternalError(ex);
        }
        boolean NMH_THIS = false;
        boolean ARG_BASE = true;
        int nameCursor = ARG_LIMIT = 1 + mtype.parameterCount();
        int GET_FALLBACK = nameCursor++;
        int GET_NEP = nameCursor++;
        int LINKER_CALL = nameCursor++;
        LambdaForm.Name[] names = LambdaForm.arguments(nameCursor - ARG_LIMIT, mtype.invokerType());
        assert (names.length == nameCursor);
        names[GET_FALLBACK] = new LambdaForm.Name(Lazy.NF_internalFallback, names[0]);
        names[GET_NEP] = new LambdaForm.Name(Lazy.NF_internalNativeEntryPoint, names[0]);
        Object[] outArgs = new Object[linkerType.parameterCount()];
        outArgs[0] = names[GET_FALLBACK];
        System.arraycopy(names, 1, outArgs, 1, mtype.parameterCount());
        outArgs[outArgs.length - 1] = names[GET_NEP];
        names[LINKER_CALL] = new LambdaForm.Name(linker, outArgs);
        LambdaForm lform = new LambdaForm(ARG_LIMIT, names, -2);
        lform.compileToBytecode();
        return lform;
    }

    @Override
    final MethodHandle copyWith(MethodType mt, LambdaForm lf) {
        assert (this.getClass() == NativeMethodHandle.class);
        return new NativeMethodHandle(mt, lf, this.fallback, this.nep);
    }

    @Override
    BoundMethodHandle rebind() {
        return BoundMethodHandle.makeReinvoker(this);
    }

    @ForceInline
    static Object internalNativeEntryPoint(Object mh) {
        return ((NativeMethodHandle)mh).nep;
    }

    @ForceInline
    static MethodHandle internalFallback(Object mh) {
        return ((NativeMethodHandle)mh).fallback;
    }

    private static class Lazy {
        static final LambdaForm.NamedFunction NF_internalNativeEntryPoint;
        static final LambdaForm.NamedFunction NF_internalFallback;

        private Lazy() {
        }

        static {
            try {
                LambdaForm.NamedFunction[] nfs;
                Class<NativeMethodHandle> THIS_CLASS = NativeMethodHandle.class;
                NF_internalNativeEntryPoint = new LambdaForm.NamedFunction(THIS_CLASS.getDeclaredMethod("internalNativeEntryPoint", Object.class));
                for (LambdaForm.NamedFunction nf : nfs = new LambdaForm.NamedFunction[]{NF_internalNativeEntryPoint, NF_internalFallback = new LambdaForm.NamedFunction(THIS_CLASS.getDeclaredMethod("internalFallback", Object.class))}) {
                    assert (InvokerBytecodeGenerator.isStaticallyInvocable(nf.member)) : nf;
                    nf.resolve();
                }
            }
            catch (ReflectiveOperationException ex) {
                throw MethodHandleStatics.newInternalError(ex);
            }
        }
    }
}

