/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.io.FilePermission;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Objects;
import sun.util.logging.PlatformLogger;

final class ProxyClassesDumper {
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[] BAD_CHARS = new char[]{'\\', ':', '*', '?', '\"', '<', '>', '|'};
    private static final String[] REPLACEMENT = new String[]{"%5C", "%3A", "%2A", "%3F", "%22", "%3C", "%3E", "%7C"};
    private final Path dumpDir;

    public static ProxyClassesDumper getInstance(String path) {
        if (null == path) {
            return null;
        }
        try {
            path = path.trim();
            final Path dir = Path.of(path.isEmpty() ? "." : path, new String[0]);
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Void run() {
                    ProxyClassesDumper.validateDumpDir(dir);
                    return null;
                }
            }, null, new FilePermission("<<ALL FILES>>", "read, write"));
            return new ProxyClassesDumper(dir);
        }
        catch (InvalidPathException ex) {
            PlatformLogger.getLogger(ProxyClassesDumper.class.getName()).warning("Path " + path + " is not valid - dumping disabled", ex);
        }
        catch (IllegalArgumentException iae) {
            PlatformLogger.getLogger(ProxyClassesDumper.class.getName()).warning(iae.getMessage() + " - dumping disabled");
        }
        return null;
    }

    private ProxyClassesDumper(Path path) {
        this.dumpDir = Objects.requireNonNull(path);
    }

    private static void validateDumpDir(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new IllegalArgumentException("Directory " + path + " does not exist");
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new IllegalArgumentException("Path " + path + " is not a directory");
        }
        if (!Files.isWritable(path)) {
            throw new IllegalArgumentException("Directory " + path + " is not writable");
        }
    }

    public static String encodeForFilename(String className) {
        int len = className.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            int j;
            char c = className.charAt(i);
            if (c <= '\u001f') {
                sb.append('%');
                sb.append(HEX[c >> 4 & 0xF]);
                sb.append(HEX[c & 0xF]);
                continue;
            }
            for (j = 0; j < BAD_CHARS.length; ++j) {
                if (c != BAD_CHARS[j]) continue;
                sb.append(REPLACEMENT[j]);
                break;
            }
            if (j < BAD_CHARS.length) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public void dumpClass(String className, byte[] classBytes) {
        Path file;
        try {
            file = this.dumpDir.resolve(ProxyClassesDumper.encodeForFilename(className) + ".class");
        }
        catch (InvalidPathException ex) {
            PlatformLogger.getLogger(ProxyClassesDumper.class.getName()).warning("Invalid path for class " + className);
            return;
        }
        try {
            Path dir = file.getParent();
            Files.createDirectories(dir, new FileAttribute[0]);
            Files.write(file, classBytes, new OpenOption[0]);
        }
        catch (Exception ignore) {
            PlatformLogger.getLogger(ProxyClassesDumper.class.getName()).warning("Exception writing to path at " + file.toString());
        }
    }
}

