/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.StringConcatException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import jdk.internal.access.JavaLangAccess;
import jdk.internal.access.SharedSecrets;
import jdk.internal.vm.annotation.Stable;
import sun.invoke.util.Wrapper;

public final class StringConcatFactory {
    private static final char TAG_ARG = '\u0001';
    private static final char TAG_CONST = '\u0002';
    private static final int MAX_INDY_CONCAT_ARG_SLOTS = 200;
    private static final JavaLangAccess JLA = SharedSecrets.getJavaLangAccess();
    private static final Function<Class<?>, MethodHandle> PREPEND = new Function<Class<?>, MethodHandle>(){

        @Override
        public MethodHandle apply(Class<?> c) {
            MethodHandle prepend = JLA.stringConcatHelper("prepend", MethodType.methodType(Long.TYPE, Long.TYPE, byte[].class, Wrapper.asPrimitiveType(c), String.class));
            return prepend.rebind();
        }
    };
    private static final Function<Class<?>, MethodHandle> NULL_PREPEND = new Function<Class<?>, MethodHandle>(){

        @Override
        public MethodHandle apply(Class<?> c) {
            return MethodHandles.insertArguments(PREPENDERS.computeIfAbsent(c, PREPEND), 3, new Object[]{null});
        }
    };
    private static final Function<Class<?>, MethodHandle> MIX = new Function<Class<?>, MethodHandle>(){

        @Override
        public MethodHandle apply(Class<?> c) {
            MethodHandle mix = JLA.stringConcatHelper("mix", MethodType.methodType(Long.TYPE, Long.TYPE, Wrapper.asPrimitiveType(c)));
            return mix.rebind();
        }
    };
    @Stable
    private static MethodHandle SIMPLE_CONCAT;
    @Stable
    private static MethodHandle NEW_STRING;
    @Stable
    private static MethodHandle NEW_ARRAY_SUFFIX;
    @Stable
    private static MethodHandle NEW_ARRAY;
    @Stable
    private static MethodHandle OBJECT_STRINGIFIER;
    @Stable
    private static MethodHandle FLOAT_STRINGIFIER;
    @Stable
    private static MethodHandle DOUBLE_STRINGIFIER;
    @Stable
    private static MethodHandle INT_STRINGIFIER;
    @Stable
    private static MethodHandle LONG_STRINGIFIER;
    @Stable
    private static MethodHandle CHAR_STRINGIFIER;
    @Stable
    private static MethodHandle BOOLEAN_STRINGIFIER;
    @Stable
    private static MethodHandle NEW_STRINGIFIER;
    private static final ConcurrentMap<Class<?>, MethodHandle> PREPENDERS;
    private static final ConcurrentMap<Class<?>, MethodHandle> NULL_PREPENDERS;
    private static final ConcurrentMap<Class<?>, MethodHandle> MIXERS;
    private static final long INITIAL_CODER;

    public static CallSite makeConcat(MethodHandles.Lookup lookup, String name, MethodType concatType) throws StringConcatException {
        String recipe = "\u0001".repeat(concatType.parameterCount());
        return StringConcatFactory.makeConcatWithConstants(lookup, name, concatType, recipe, new Object[0]);
    }

    public static CallSite makeConcatWithConstants(MethodHandles.Lookup lookup, String name, MethodType concatType, String recipe, Object ... constants) throws StringConcatException {
        Objects.requireNonNull(lookup, "Lookup is null");
        Objects.requireNonNull(name, "Name is null");
        Objects.requireNonNull(concatType, "Concat type is null");
        Objects.requireNonNull(constants, "Constants are null");
        for (Object o : constants) {
            Objects.requireNonNull(o, "Cannot accept null constants");
        }
        if ((lookup.lookupModes() & 2) == 0) {
            throw new StringConcatException("Invalid caller: " + lookup.lookupClass().getName());
        }
        List<String> elements = StringConcatFactory.parseRecipe(concatType, recipe, constants);
        if (!((Class)concatType.returnType()).isAssignableFrom(String.class)) {
            throw new StringConcatException("The return type should be compatible with String, but it is " + concatType.returnType());
        }
        if (concatType.parameterSlotCount() > 200) {
            throw new StringConcatException("Too many concat argument slots: " + concatType.parameterSlotCount() + ", can only accept " + 200);
        }
        try {
            return new ConstantCallSite(StringConcatFactory.generateMHInlineCopy(concatType, elements).viewAsType(concatType, true));
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            throw new StringConcatException("Generator failed", t);
        }
    }

    private static List<String> parseRecipe(MethodType concatType, String recipe, Object[] constants) throws StringConcatException {
        Objects.requireNonNull(recipe, "Recipe is null");
        ArrayList<String> elements = new ArrayList<String>();
        int cCount = 0;
        int oCount = 0;
        StringBuilder acc = new StringBuilder();
        for (int i = 0; i < recipe.length(); ++i) {
            char c = recipe.charAt(i);
            if (c == '\u0002') {
                if (cCount == constants.length) {
                    throw StringConcatFactory.constantMismatch(constants, cCount);
                }
                acc.append(constants[cCount++]);
                continue;
            }
            if (c == '\u0001') {
                if (acc.length() > 0) {
                    elements.add(acc.toString());
                    acc.setLength(0);
                }
                elements.add(null);
                ++oCount;
                continue;
            }
            acc.append(c);
        }
        if (acc.length() > 0) {
            elements.add(acc.toString());
        }
        if (oCount != concatType.parameterCount()) {
            throw StringConcatFactory.argumentMismatch(concatType, oCount);
        }
        if (cCount < constants.length) {
            throw StringConcatFactory.constantMismatch(constants, cCount);
        }
        return elements;
    }

    private static StringConcatException argumentMismatch(MethodType concatType, int oCount) {
        return new StringConcatException("Mismatched number of concat arguments: recipe wants " + oCount + " arguments, but signature provides " + concatType.parameterCount());
    }

    private static StringConcatException constantMismatch(Object[] constants, int cCount) {
        return new StringConcatException("Mismatched number of concat constants: recipe wants " + cCount + " constants, but only " + constants.length + " are passed");
    }

    private static MethodHandle generateMHInlineCopy(MethodType mt, List<String> elements) {
        MethodHandle newArrayCombinator;
        if (elements.size() == 1) {
            String s0 = elements.get(0);
            if (s0 == null) {
                return StringConcatFactory.unaryConcat(mt.parameterType(0));
            }
            return MethodHandles.insertArguments(StringConcatFactory.unaryConcat(Object.class), 0, s0);
        }
        if (elements.size() == 2) {
            String s0 = elements.get(0);
            String s1 = elements.get(1);
            if (mt.parameterCount() == 2 && !((Class)mt.parameterType(0)).isPrimitive() && !((Class)mt.parameterType(1)).isPrimitive() && s0 == null && s1 == null) {
                return StringConcatFactory.simpleConcat();
            }
            if (mt.parameterCount() == 1) {
                int constIdx;
                String constant;
                if (s1 == null) {
                    constant = s0;
                    constIdx = 0;
                } else {
                    constant = s1;
                    constIdx = 1;
                }
                if (constant.isEmpty()) {
                    return StringConcatFactory.unaryConcat(mt.parameterType(0));
                }
                if (!((Class)mt.parameterType(0)).isPrimitive()) {
                    return MethodHandles.insertArguments(StringConcatFactory.simpleConcat(), constIdx, constant);
                }
            }
        }
        Class<?>[] ptypes = mt.erase().parameterArray();
        MethodHandle[] filters = null;
        for (int i = 0; i < ptypes.length; ++i) {
            MethodHandle filter = StringConcatFactory.stringifierFor(ptypes[i]);
            if (filter == null) continue;
            if (filters == null) {
                filters = new MethodHandle[ptypes.length];
            }
            filters[i] = filter;
            ptypes[i] = String.class;
        }
        MethodHandle mh = MethodHandles.dropArguments(StringConcatFactory.newString(), 2, ptypes);
        long initialLengthCoder = INITIAL_CODER;
        String constant = null;
        int pos = 0;
        for (String el : elements) {
            if (el != null) {
                initialLengthCoder = JLA.stringConcatMix(initialLengthCoder, el);
                assert (constant == null);
                constant = el;
                continue;
            }
            mh = MethodHandles.filterArgumentsWithCombiner(mh, 1, StringConcatFactory.prepender(constant, ptypes[pos]), 1, 0, 2 + pos);
            constant = null;
            ++pos;
        }
        if (constant != null) {
            initialLengthCoder -= (long)constant.length();
            newArrayCombinator = StringConcatFactory.newArrayWithSuffix(constant);
        } else {
            newArrayCombinator = StringConcatFactory.newArray();
        }
        mh = MethodHandles.foldArgumentsWithCombiner(mh, 0, newArrayCombinator, 1);
        pos = -1;
        MethodHandle mix = null;
        for (String el : elements) {
            if (el != null) continue;
            if (pos >= 0) {
                mh = MethodHandles.filterArgumentsWithCombiner(mh, 0, mix, 0, 1 + pos);
            }
            Class<?> argClass = ptypes[++pos];
            mix = StringConcatFactory.mixer(argClass);
        }
        if (pos >= 0) {
            mix = MethodHandles.insertArguments(mix, 0, initialLengthCoder);
            mh = MethodHandles.foldArgumentsWithCombiner(mh, 0, mix, 1 + pos);
        } else {
            mh = MethodHandles.insertArguments(mh, 0, initialLengthCoder);
        }
        if (filters != null) {
            mh = MethodHandles.filterArguments(mh, 0, filters);
        }
        return mh;
    }

    private static MethodHandle prepender(String prefix, Class<?> cl) {
        if (prefix == null) {
            return NULL_PREPENDERS.computeIfAbsent(cl, NULL_PREPEND);
        }
        return MethodHandles.insertArguments(PREPENDERS.computeIfAbsent(cl, PREPEND), 3, prefix);
    }

    private static MethodHandle mixer(Class<?> cl) {
        return MIXERS.computeIfAbsent(cl, MIX);
    }

    private static MethodHandle simpleConcat() {
        MethodHandle mh = SIMPLE_CONCAT;
        if (mh == null) {
            MethodHandle simpleConcat = JLA.stringConcatHelper("simpleConcat", MethodType.methodType(String.class, Object.class, Object.class));
            SIMPLE_CONCAT = mh = simpleConcat.rebind();
        }
        return mh;
    }

    private static MethodHandle newString() {
        MethodHandle mh = NEW_STRING;
        if (mh == null) {
            MethodHandle newString = JLA.stringConcatHelper("newString", MethodType.methodType(String.class, byte[].class, Long.TYPE));
            NEW_STRING = mh = newString.rebind();
        }
        return mh;
    }

    private static MethodHandle newArrayWithSuffix(String suffix) {
        MethodHandle mh = NEW_ARRAY_SUFFIX;
        if (mh == null) {
            MethodHandle newArrayWithSuffix = JLA.stringConcatHelper("newArrayWithSuffix", MethodType.methodType(byte[].class, String.class, Long.TYPE));
            NEW_ARRAY_SUFFIX = mh = newArrayWithSuffix.rebind();
        }
        return MethodHandles.insertArguments(mh, 0, suffix);
    }

    private static MethodHandle newArray() {
        MethodHandle mh = NEW_ARRAY;
        if (mh == null) {
            NEW_ARRAY = mh = JLA.stringConcatHelper("newArray", MethodType.methodType(byte[].class, Long.TYPE));
        }
        return mh;
    }

    private static MethodHandle objectStringifier() {
        MethodHandle mh = OBJECT_STRINGIFIER;
        if (mh == null) {
            OBJECT_STRINGIFIER = mh = JLA.stringConcatHelper("stringOf", MethodType.methodType(String.class, Object.class));
        }
        return mh;
    }

    private static MethodHandle floatStringifier() {
        MethodHandle mh = FLOAT_STRINGIFIER;
        if (mh == null) {
            FLOAT_STRINGIFIER = mh = StringConcatFactory.lookupStatic(MethodHandles.publicLookup(), String.class, "valueOf", String.class, Float.TYPE);
        }
        return mh;
    }

    private static MethodHandle doubleStringifier() {
        MethodHandle mh = DOUBLE_STRINGIFIER;
        if (mh == null) {
            DOUBLE_STRINGIFIER = mh = StringConcatFactory.lookupStatic(MethodHandles.publicLookup(), String.class, "valueOf", String.class, Double.TYPE);
        }
        return mh;
    }

    private static MethodHandle intStringifier() {
        MethodHandle mh = INT_STRINGIFIER;
        if (mh == null) {
            INT_STRINGIFIER = mh = StringConcatFactory.lookupStatic(MethodHandles.publicLookup(), String.class, "valueOf", String.class, Integer.TYPE);
        }
        return mh;
    }

    private static MethodHandle longStringifier() {
        MethodHandle mh = LONG_STRINGIFIER;
        if (mh == null) {
            LONG_STRINGIFIER = mh = StringConcatFactory.lookupStatic(MethodHandles.publicLookup(), String.class, "valueOf", String.class, Long.TYPE);
        }
        return mh;
    }

    private static MethodHandle charStringifier() {
        MethodHandle mh = CHAR_STRINGIFIER;
        if (mh == null) {
            CHAR_STRINGIFIER = mh = StringConcatFactory.lookupStatic(MethodHandles.publicLookup(), String.class, "valueOf", String.class, Character.TYPE);
        }
        return mh;
    }

    private static MethodHandle booleanStringifier() {
        MethodHandle mh = BOOLEAN_STRINGIFIER;
        if (mh == null) {
            BOOLEAN_STRINGIFIER = mh = StringConcatFactory.lookupStatic(MethodHandles.publicLookup(), String.class, "valueOf", String.class, Boolean.TYPE);
        }
        return mh;
    }

    private static MethodHandle newStringifier() {
        MethodHandle mh = NEW_STRINGIFIER;
        if (mh == null) {
            NEW_STRINGIFIER = mh = JLA.stringConcatHelper("newStringOf", MethodType.methodType(String.class, Object.class));
        }
        return mh;
    }

    private static MethodHandle unaryConcat(Class<?> cl) {
        if (!cl.isPrimitive()) {
            return StringConcatFactory.newStringifier();
        }
        if (cl == Integer.TYPE || cl == Short.TYPE || cl == Byte.TYPE) {
            return StringConcatFactory.intStringifier();
        }
        if (cl == Long.TYPE) {
            return StringConcatFactory.longStringifier();
        }
        if (cl == Character.TYPE) {
            return StringConcatFactory.charStringifier();
        }
        if (cl == Boolean.TYPE) {
            return StringConcatFactory.booleanStringifier();
        }
        if (cl == Float.TYPE) {
            return StringConcatFactory.floatStringifier();
        }
        if (cl == Double.TYPE) {
            return StringConcatFactory.doubleStringifier();
        }
        throw new InternalError("Unhandled type for unary concatenation: " + cl);
    }

    private static MethodHandle stringifierFor(Class<?> t) {
        if (t == Object.class) {
            return StringConcatFactory.objectStringifier();
        }
        if (t == Float.TYPE) {
            return StringConcatFactory.floatStringifier();
        }
        if (t == Double.TYPE) {
            return StringConcatFactory.doubleStringifier();
        }
        return null;
    }

    private static MethodHandle lookupStatic(MethodHandles.Lookup lookup, Class<?> refc, String name, Class<?> rtype, Class<?> ... ptypes) {
        try {
            return lookup.findStatic(refc, name, MethodType.methodType(rtype, ptypes));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    private StringConcatFactory() {
    }

    static {
        INITIAL_CODER = JLA.stringConcatInitialCoder();
        PREPENDERS = new ConcurrentHashMap();
        NULL_PREPENDERS = new ConcurrentHashMap();
        MIXERS = new ConcurrentHashMap();
    }
}

