/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MethodTypeForm;
import java.lang.invoke.VarHandle;
import jdk.internal.vm.annotation.DontInline;
import jdk.internal.vm.annotation.ForceInline;
import jdk.internal.vm.annotation.Stable;

final class VarForm {
    final Class<?> implClass;
    @Stable
    final MethodType[] methodType_table = new MethodType[VarHandle.AccessType.COUNT];
    @Stable
    final MemberName[] memberName_table;
    @Stable
    MethodType[] methodType_V_table;

    VarForm(Class<?> implClass, Class<?> receiver, Class<?> value, Class<?> ... intermediate) {
        this.memberName_table = new MemberName[VarHandle.AccessMode.COUNT];
        this.implClass = implClass;
        if (receiver == null) {
            this.initMethodTypes(value, intermediate);
        } else {
            Class[] coordinates = new Class[intermediate.length + 1];
            coordinates[0] = receiver;
            System.arraycopy(intermediate, 0, coordinates, 1, intermediate.length);
            this.initMethodTypes(value, coordinates);
        }
    }

    VarForm(Class<?> value, Class<?>[] coordinates) {
        this.memberName_table = null;
        this.implClass = null;
        this.initMethodTypes(value, coordinates);
    }

    void initMethodTypes(Class<?> value, Class<?> ... coordinates) {
        MethodType type;
        Class<?> erasedValue = MethodTypeForm.canonicalize(value, 1);
        Class<?>[] erasedCoordinates = MethodTypeForm.canonicalizeAll(coordinates, 1);
        if (erasedValue != null) {
            value = erasedValue;
        }
        if (erasedCoordinates != null) {
            coordinates = erasedCoordinates;
        }
        this.methodType_table[VarHandle.AccessType.GET.ordinal()] = type = MethodType.methodType(value, coordinates);
        MethodType methodType = type.appendParameterTypes(value);
        this.methodType_table[VarHandle.AccessType.GET_AND_UPDATE.ordinal()] = methodType;
        type = methodType;
        this.methodType_table[VarHandle.AccessType.SET.ordinal()] = type.changeReturnType(Void.TYPE);
        MethodType methodType2 = type.appendParameterTypes(value);
        this.methodType_table[VarHandle.AccessType.COMPARE_AND_EXCHANGE.ordinal()] = methodType2;
        type = methodType2;
        this.methodType_table[VarHandle.AccessType.COMPARE_AND_SET.ordinal()] = type.changeReturnType(Boolean.TYPE);
    }

    @ForceInline
    final MethodType getMethodType(int type) {
        return this.methodType_table[type];
    }

    @ForceInline
    final MemberName getMemberName(int mode) {
        MemberName mn = this.getMemberNameOrNull(mode);
        if (mn == null) {
            throw new UnsupportedOperationException();
        }
        return mn;
    }

    @ForceInline
    final MemberName getMemberNameOrNull(int mode) {
        MemberName mn = this.memberName_table[mode];
        if (mn == null) {
            mn = this.resolveMemberName(mode);
        }
        return mn;
    }

    @DontInline
    MemberName resolveMemberName(int mode) {
        VarHandle.AccessMode value = VarHandle.AccessMode.values()[mode];
        String methodName = value.methodName();
        MethodType type = this.methodType_table[value.at.ordinal()].insertParameterTypes(0, VarHandle.class);
        this.memberName_table[mode] = MethodHandles.Lookup.IMPL_LOOKUP.resolveOrNull((byte)6, this.implClass, methodName, type);
        return this.memberName_table[mode];
    }

    @ForceInline
    final MethodType[] getMethodType_V_init() {
        MethodType[] table = new MethodType[VarHandle.AccessType.values().length];
        for (int i = 0; i < this.methodType_table.length; ++i) {
            MethodType mt = this.methodType_table[i];
            table[i] = mt.changeReturnType(Void.TYPE);
        }
        this.methodType_V_table = table;
        return table;
    }

    @ForceInline
    final MethodType getMethodType_V(int type) {
        MethodType[] table = this.methodType_V_table;
        if (table == null) {
            table = this.getMethodType_V_init();
        }
        return table[type];
    }
}

