/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.constant.ClassDesc;
import java.lang.constant.Constable;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.DirectMethodHandleDesc;
import java.lang.constant.DynamicConstantDesc;
import java.lang.invoke.DirectMethodHandle;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarForm;
import java.lang.invoke.VarHandleGuards;
import java.lang.invoke.WrongMethodTypeException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import jdk.internal.util.Preconditions;
import jdk.internal.vm.annotation.DontInline;
import jdk.internal.vm.annotation.ForceInline;
import jdk.internal.vm.annotation.IntrinsicCandidate;
import jdk.internal.vm.annotation.Stable;

public abstract class VarHandle
implements Constable {
    final VarForm vform;
    final boolean exact;
    @Stable
    TypesAndInvokers typesAndInvokers;
    static final BiFunction<String, List<Number>, ArrayIndexOutOfBoundsException> AIOOBE_SUPPLIER = Preconditions.outOfBoundsExceptionFormatter(new Function<String, ArrayIndexOutOfBoundsException>(){

        @Override
        public ArrayIndexOutOfBoundsException apply(String s) {
            return new ArrayIndexOutOfBoundsException(s);
        }
    });
    private static final long VFORM_OFFSET = MethodHandleStatics.UNSAFE.objectFieldOffset(VarHandle.class, "vform");

    VarHandle(VarForm vform) {
        this(vform, false);
    }

    VarHandle(VarForm vform, boolean exact) {
        this.vform = vform;
        this.exact = exact;
    }

    RuntimeException unsupported() {
        return new UnsupportedOperationException();
    }

    boolean isDirect() {
        return true;
    }

    VarHandle asDirect() {
        return this;
    }

    VarHandle target() {
        return null;
    }

    public boolean hasInvokeExactBehavior() {
        return this.exact;
    }

    @MethodHandle.PolymorphicSignature
    @IntrinsicCandidate
    public final native Object get(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @IntrinsicCandidate
    public final native void set(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @IntrinsicCandidate
    public final native Object getVolatile(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @IntrinsicCandidate
    public final native void setVolatile(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @IntrinsicCandidate
    public final native Object getOpaque(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @IntrinsicCandidate
    public final native void setOpaque(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @IntrinsicCandidate
    public final native Object getAcquire(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @IntrinsicCandidate
    public final native void setRelease(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @IntrinsicCandidate
    public final native boolean compareAndSet(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @IntrinsicCandidate
    public final native Object compareAndExchange(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @IntrinsicCandidate
    public final native Object compareAndExchangeAcquire(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @IntrinsicCandidate
    public final native Object compareAndExchangeRelease(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @IntrinsicCandidate
    public final native boolean weakCompareAndSetPlain(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @IntrinsicCandidate
    public final native boolean weakCompareAndSet(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @IntrinsicCandidate
    public final native boolean weakCompareAndSetAcquire(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @IntrinsicCandidate
    public final native boolean weakCompareAndSetRelease(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @IntrinsicCandidate
    public final native Object getAndSet(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @IntrinsicCandidate
    public final native Object getAndSetAcquire(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @IntrinsicCandidate
    public final native Object getAndSetRelease(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @IntrinsicCandidate
    public final native Object getAndAdd(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @IntrinsicCandidate
    public final native Object getAndAddAcquire(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @IntrinsicCandidate
    public final native Object getAndAddRelease(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @IntrinsicCandidate
    public final native Object getAndBitwiseOr(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @IntrinsicCandidate
    public final native Object getAndBitwiseOrAcquire(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @IntrinsicCandidate
    public final native Object getAndBitwiseOrRelease(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @IntrinsicCandidate
    public final native Object getAndBitwiseAnd(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @IntrinsicCandidate
    public final native Object getAndBitwiseAndAcquire(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @IntrinsicCandidate
    public final native Object getAndBitwiseAndRelease(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @IntrinsicCandidate
    public final native Object getAndBitwiseXor(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @IntrinsicCandidate
    public final native Object getAndBitwiseXorAcquire(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @IntrinsicCandidate
    public final native Object getAndBitwiseXorRelease(Object ... var1);

    public abstract VarHandle withInvokeExactBehavior();

    public abstract VarHandle withInvokeBehavior();

    public final String toString() {
        return String.format("VarHandle[varType=%s, coord=%s]", this.varType().getName(), this.coordinateTypes());
    }

    public Class<?> varType() {
        MethodType typeSet = this.accessModeType(AccessMode.SET);
        return typeSet.parameterType(typeSet.parameterCount() - 1);
    }

    public List<Class<?>> coordinateTypes() {
        MethodType typeGet = this.accessModeType(AccessMode.GET);
        return typeGet.parameterList();
    }

    public final MethodType accessModeType(AccessMode accessMode) {
        return this.accessModeType(accessMode.at.ordinal());
    }

    @ForceInline
    final void checkExactAccessMode(AccessDescriptor ad) {
        if (this.exact && this.accessModeType(ad.type) != ad.symbolicMethodTypeExact) {
            this.throwWrongMethodTypeException(ad);
        }
    }

    @DontInline
    private final void throwWrongMethodTypeException(AccessDescriptor ad) {
        throw new WrongMethodTypeException("expected " + this.accessModeType(ad.type) + " but found " + ad.symbolicMethodTypeExact);
    }

    @ForceInline
    final MethodType accessModeType(int accessTypeOrdinal) {
        TypesAndInvokers tis = this.getTypesAndInvokers();
        MethodType mt = tis.methodType_table[accessTypeOrdinal];
        if (mt == null) {
            mt = tis.methodType_table[accessTypeOrdinal] = this.accessModeTypeUncached(accessTypeOrdinal);
        }
        return mt;
    }

    final MethodType accessModeTypeUncached(int accessTypeOrdinal) {
        return this.accessModeTypeUncached(AccessType.values()[accessTypeOrdinal]);
    }

    abstract MethodType accessModeTypeUncached(AccessType var1);

    public final boolean isAccessModeSupported(AccessMode accessMode) {
        return this.vform.getMemberNameOrNull(accessMode.ordinal()) != null;
    }

    public MethodHandle toMethodHandle(AccessMode accessMode) {
        if (this.isAccessModeSupported(accessMode)) {
            MethodHandle mh = this.getMethodHandle(accessMode.ordinal());
            return mh.bindTo(this);
        }
        return MethodHandles.varHandleInvoker(accessMode, this.accessModeType(accessMode)).bindTo(this);
    }

    public Optional<VarHandleDesc> describeConstable() {
        return Optional.empty();
    }

    @ForceInline
    private final TypesAndInvokers getTypesAndInvokers() {
        TypesAndInvokers tis = this.typesAndInvokers;
        if (tis == null) {
            tis = this.typesAndInvokers = new TypesAndInvokers();
        }
        return tis;
    }

    @ForceInline
    MethodHandle getMethodHandle(int mode) {
        TypesAndInvokers tis = this.getTypesAndInvokers();
        MethodHandle mh = tis.methodHandle_table[mode];
        if (mh == null) {
            mh = tis.methodHandle_table[mode] = this.getMethodHandleUncached(mode);
        }
        return mh;
    }

    private final MethodHandle getMethodHandleUncached(int mode) {
        MethodType mt = this.accessModeType(AccessMode.values()[mode]).insertParameterTypes(0, VarHandle.class);
        MemberName mn = this.vform.getMemberName(mode);
        DirectMethodHandle dmh = DirectMethodHandle.make(mn);
        MethodHandle mh = dmh.copyWith(mt, dmh.form);
        assert (mh.type().erase() == mn.getMethodType().erase());
        return mh;
    }

    final void updateVarForm(VarForm newVForm) {
        if (this.vform == newVForm) {
            return;
        }
        MethodHandleStatics.UNSAFE.putReference(this, VFORM_OFFSET, newVForm);
        MethodHandleStatics.UNSAFE.fullFence();
    }

    @ForceInline
    public static void fullFence() {
        MethodHandleStatics.UNSAFE.fullFence();
    }

    @ForceInline
    public static void acquireFence() {
        MethodHandleStatics.UNSAFE.loadFence();
    }

    @ForceInline
    public static void releaseFence() {
        MethodHandleStatics.UNSAFE.storeFence();
    }

    @ForceInline
    public static void loadLoadFence() {
        MethodHandleStatics.UNSAFE.loadLoadFence();
    }

    @ForceInline
    public static void storeStoreFence() {
        MethodHandleStatics.UNSAFE.storeStoreFence();
    }

    static {
        MethodHandleStatics.UNSAFE.ensureClassInitialized(VarHandleGuards.class);
    }

    public static final class AccessMode
    extends Enum<AccessMode> {
        public static final /* enum */ AccessMode GET = new AccessMode("get", AccessType.GET);
        public static final /* enum */ AccessMode SET = new AccessMode("set", AccessType.SET);
        public static final /* enum */ AccessMode GET_VOLATILE = new AccessMode("getVolatile", AccessType.GET);
        public static final /* enum */ AccessMode SET_VOLATILE = new AccessMode("setVolatile", AccessType.SET);
        public static final /* enum */ AccessMode GET_ACQUIRE = new AccessMode("getAcquire", AccessType.GET);
        public static final /* enum */ AccessMode SET_RELEASE = new AccessMode("setRelease", AccessType.SET);
        public static final /* enum */ AccessMode GET_OPAQUE = new AccessMode("getOpaque", AccessType.GET);
        public static final /* enum */ AccessMode SET_OPAQUE = new AccessMode("setOpaque", AccessType.SET);
        public static final /* enum */ AccessMode COMPARE_AND_SET = new AccessMode("compareAndSet", AccessType.COMPARE_AND_SET);
        public static final /* enum */ AccessMode COMPARE_AND_EXCHANGE = new AccessMode("compareAndExchange", AccessType.COMPARE_AND_EXCHANGE);
        public static final /* enum */ AccessMode COMPARE_AND_EXCHANGE_ACQUIRE = new AccessMode("compareAndExchangeAcquire", AccessType.COMPARE_AND_EXCHANGE);
        public static final /* enum */ AccessMode COMPARE_AND_EXCHANGE_RELEASE = new AccessMode("compareAndExchangeRelease", AccessType.COMPARE_AND_EXCHANGE);
        public static final /* enum */ AccessMode WEAK_COMPARE_AND_SET_PLAIN = new AccessMode("weakCompareAndSetPlain", AccessType.COMPARE_AND_SET);
        public static final /* enum */ AccessMode WEAK_COMPARE_AND_SET = new AccessMode("weakCompareAndSet", AccessType.COMPARE_AND_SET);
        public static final /* enum */ AccessMode WEAK_COMPARE_AND_SET_ACQUIRE = new AccessMode("weakCompareAndSetAcquire", AccessType.COMPARE_AND_SET);
        public static final /* enum */ AccessMode WEAK_COMPARE_AND_SET_RELEASE = new AccessMode("weakCompareAndSetRelease", AccessType.COMPARE_AND_SET);
        public static final /* enum */ AccessMode GET_AND_SET = new AccessMode("getAndSet", AccessType.GET_AND_UPDATE);
        public static final /* enum */ AccessMode GET_AND_SET_ACQUIRE = new AccessMode("getAndSetAcquire", AccessType.GET_AND_UPDATE);
        public static final /* enum */ AccessMode GET_AND_SET_RELEASE = new AccessMode("getAndSetRelease", AccessType.GET_AND_UPDATE);
        public static final /* enum */ AccessMode GET_AND_ADD = new AccessMode("getAndAdd", AccessType.GET_AND_UPDATE);
        public static final /* enum */ AccessMode GET_AND_ADD_ACQUIRE = new AccessMode("getAndAddAcquire", AccessType.GET_AND_UPDATE);
        public static final /* enum */ AccessMode GET_AND_ADD_RELEASE = new AccessMode("getAndAddRelease", AccessType.GET_AND_UPDATE);
        public static final /* enum */ AccessMode GET_AND_BITWISE_OR = new AccessMode("getAndBitwiseOr", AccessType.GET_AND_UPDATE);
        public static final /* enum */ AccessMode GET_AND_BITWISE_OR_RELEASE = new AccessMode("getAndBitwiseOrRelease", AccessType.GET_AND_UPDATE);
        public static final /* enum */ AccessMode GET_AND_BITWISE_OR_ACQUIRE = new AccessMode("getAndBitwiseOrAcquire", AccessType.GET_AND_UPDATE);
        public static final /* enum */ AccessMode GET_AND_BITWISE_AND = new AccessMode("getAndBitwiseAnd", AccessType.GET_AND_UPDATE);
        public static final /* enum */ AccessMode GET_AND_BITWISE_AND_RELEASE = new AccessMode("getAndBitwiseAndRelease", AccessType.GET_AND_UPDATE);
        public static final /* enum */ AccessMode GET_AND_BITWISE_AND_ACQUIRE = new AccessMode("getAndBitwiseAndAcquire", AccessType.GET_AND_UPDATE);
        public static final /* enum */ AccessMode GET_AND_BITWISE_XOR = new AccessMode("getAndBitwiseXor", AccessType.GET_AND_UPDATE);
        public static final /* enum */ AccessMode GET_AND_BITWISE_XOR_RELEASE = new AccessMode("getAndBitwiseXorRelease", AccessType.GET_AND_UPDATE);
        public static final /* enum */ AccessMode GET_AND_BITWISE_XOR_ACQUIRE = new AccessMode("getAndBitwiseXorAcquire", AccessType.GET_AND_UPDATE);
        static final int COUNT;
        final String methodName;
        final AccessType at;
        private static final /* synthetic */ AccessMode[] $VALUES;

        public static AccessMode[] values() {
            return (AccessMode[])$VALUES.clone();
        }

        public static AccessMode valueOf(String name) {
            return Enum.valueOf(AccessMode.class, name);
        }

        private AccessMode(String methodName, AccessType at) {
            this.methodName = methodName;
            this.at = at;
        }

        public String methodName() {
            return this.methodName;
        }

        public static AccessMode valueFromMethodName(String methodName) {
            return switch (methodName) {
                case "get" -> GET;
                case "set" -> SET;
                case "getVolatile" -> GET_VOLATILE;
                case "setVolatile" -> SET_VOLATILE;
                case "getAcquire" -> GET_ACQUIRE;
                case "setRelease" -> SET_RELEASE;
                case "getOpaque" -> GET_OPAQUE;
                case "setOpaque" -> SET_OPAQUE;
                case "compareAndSet" -> COMPARE_AND_SET;
                case "compareAndExchange" -> COMPARE_AND_EXCHANGE;
                case "compareAndExchangeAcquire" -> COMPARE_AND_EXCHANGE_ACQUIRE;
                case "compareAndExchangeRelease" -> COMPARE_AND_EXCHANGE_RELEASE;
                case "weakCompareAndSet" -> WEAK_COMPARE_AND_SET;
                case "weakCompareAndSetPlain" -> WEAK_COMPARE_AND_SET_PLAIN;
                case "weakCompareAndSetAcquire" -> WEAK_COMPARE_AND_SET_ACQUIRE;
                case "weakCompareAndSetRelease" -> WEAK_COMPARE_AND_SET_RELEASE;
                case "getAndSet" -> GET_AND_SET;
                case "getAndSetAcquire" -> GET_AND_SET_ACQUIRE;
                case "getAndSetRelease" -> GET_AND_SET_RELEASE;
                case "getAndAdd" -> GET_AND_ADD;
                case "getAndAddAcquire" -> GET_AND_ADD_ACQUIRE;
                case "getAndAddRelease" -> GET_AND_ADD_RELEASE;
                case "getAndBitwiseOr" -> GET_AND_BITWISE_OR;
                case "getAndBitwiseOrRelease" -> GET_AND_BITWISE_OR_RELEASE;
                case "getAndBitwiseOrAcquire" -> GET_AND_BITWISE_OR_ACQUIRE;
                case "getAndBitwiseAnd" -> GET_AND_BITWISE_AND;
                case "getAndBitwiseAndRelease" -> GET_AND_BITWISE_AND_RELEASE;
                case "getAndBitwiseAndAcquire" -> GET_AND_BITWISE_AND_ACQUIRE;
                case "getAndBitwiseXor" -> GET_AND_BITWISE_XOR;
                case "getAndBitwiseXorRelease" -> GET_AND_BITWISE_XOR_RELEASE;
                case "getAndBitwiseXorAcquire" -> GET_AND_BITWISE_XOR_ACQUIRE;
                default -> throw new IllegalArgumentException("No AccessMode value for method name " + methodName);
            };
        }

        private static /* synthetic */ AccessMode[] $values() {
            return new AccessMode[]{GET, SET, GET_VOLATILE, SET_VOLATILE, GET_ACQUIRE, SET_RELEASE, GET_OPAQUE, SET_OPAQUE, COMPARE_AND_SET, COMPARE_AND_EXCHANGE, COMPARE_AND_EXCHANGE_ACQUIRE, COMPARE_AND_EXCHANGE_RELEASE, WEAK_COMPARE_AND_SET_PLAIN, WEAK_COMPARE_AND_SET, WEAK_COMPARE_AND_SET_ACQUIRE, WEAK_COMPARE_AND_SET_RELEASE, GET_AND_SET, GET_AND_SET_ACQUIRE, GET_AND_SET_RELEASE, GET_AND_ADD, GET_AND_ADD_ACQUIRE, GET_AND_ADD_RELEASE, GET_AND_BITWISE_OR, GET_AND_BITWISE_OR_RELEASE, GET_AND_BITWISE_OR_ACQUIRE, GET_AND_BITWISE_AND, GET_AND_BITWISE_AND_RELEASE, GET_AND_BITWISE_AND_ACQUIRE, GET_AND_BITWISE_XOR, GET_AND_BITWISE_XOR_RELEASE, GET_AND_BITWISE_XOR_ACQUIRE};
        }

        static {
            $VALUES = AccessMode.$values();
            COUNT = GET_AND_BITWISE_XOR_ACQUIRE.ordinal() + 1;
            assert (COUNT == AccessMode.values().length);
        }
    }

    static final class AccessType
    extends Enum<AccessType> {
        public static final /* enum */ AccessType GET = new AccessType(Object.class);
        public static final /* enum */ AccessType SET = new AccessType(Void.TYPE);
        public static final /* enum */ AccessType COMPARE_AND_SET = new AccessType(Boolean.TYPE);
        public static final /* enum */ AccessType COMPARE_AND_EXCHANGE = new AccessType(Object.class);
        public static final /* enum */ AccessType GET_AND_UPDATE = new AccessType(Object.class);
        static final int COUNT;
        final Class<?> returnType;
        final boolean isMonomorphicInReturnType;
        private static final /* synthetic */ AccessType[] $VALUES;

        public static AccessType[] values() {
            return (AccessType[])$VALUES.clone();
        }

        public static AccessType valueOf(String name) {
            return Enum.valueOf(AccessType.class, name);
        }

        private AccessType(Class<?> returnType) {
            this.returnType = returnType;
            this.isMonomorphicInReturnType = returnType != Object.class;
        }

        MethodType accessModeType(Class<?> receiver, Class<?> value, Class<?> ... intermediate) {
            switch (this) {
                case GET: {
                    Class<?>[] ps = AccessType.allocateParameters(0, receiver, intermediate);
                    AccessType.fillParameters(ps, receiver, intermediate);
                    return MethodType.methodType(value, ps);
                }
                case SET: {
                    Class<?>[] ps = AccessType.allocateParameters(1, receiver, intermediate);
                    int i = AccessType.fillParameters(ps, receiver, intermediate);
                    ps[i] = value;
                    return MethodType.methodType(Void.TYPE, ps);
                }
                case COMPARE_AND_SET: {
                    Class<?>[] ps = AccessType.allocateParameters(2, receiver, intermediate);
                    int i = AccessType.fillParameters(ps, receiver, intermediate);
                    ps[i++] = value;
                    ps[i] = value;
                    return MethodType.methodType(Boolean.TYPE, ps);
                }
                case COMPARE_AND_EXCHANGE: {
                    Class<?>[] ps = AccessType.allocateParameters(2, receiver, intermediate);
                    int i = AccessType.fillParameters(ps, receiver, intermediate);
                    ps[i++] = value;
                    ps[i] = value;
                    return MethodType.methodType(value, ps);
                }
                case GET_AND_UPDATE: {
                    Class<?>[] ps = AccessType.allocateParameters(1, receiver, intermediate);
                    int i = AccessType.fillParameters(ps, receiver, intermediate);
                    ps[i] = value;
                    return MethodType.methodType(value, ps);
                }
            }
            throw new InternalError("Unknown AccessType");
        }

        private static Class<?>[] allocateParameters(int values, Class<?> receiver, Class<?> ... intermediate) {
            int size = (receiver != null ? 1 : 0) + intermediate.length + values;
            return new Class[size];
        }

        private static int fillParameters(Class<?>[] ps, Class<?> receiver, Class<?> ... intermediate) {
            int i = 0;
            if (receiver != null) {
                ps[i++] = receiver;
            }
            for (int j = 0; j < intermediate.length; ++j) {
                ps[i++] = intermediate[j];
            }
            return i;
        }

        private static /* synthetic */ AccessType[] $values() {
            return new AccessType[]{GET, SET, COMPARE_AND_SET, COMPARE_AND_EXCHANGE, GET_AND_UPDATE};
        }

        static {
            $VALUES = AccessType.$values();
            COUNT = GET_AND_UPDATE.ordinal() + 1;
            assert (COUNT == AccessType.values().length);
        }
    }

    static final class AccessDescriptor {
        final MethodType symbolicMethodTypeExact;
        final MethodType symbolicMethodTypeErased;
        final MethodType symbolicMethodTypeInvoker;
        final Class<?> returnType;
        final int type;
        final int mode;

        public AccessDescriptor(MethodType symbolicMethodType, int type, int mode) {
            this.symbolicMethodTypeExact = symbolicMethodType;
            this.symbolicMethodTypeErased = symbolicMethodType.erase();
            this.symbolicMethodTypeInvoker = symbolicMethodType.insertParameterTypes(0, VarHandle.class);
            this.returnType = symbolicMethodType.returnType();
            this.type = type;
            this.mode = mode;
        }
    }

    static class TypesAndInvokers {
        @Stable
        final MethodType[] methodType_table = new MethodType[AccessType.COUNT];
        @Stable
        final MethodHandle[] methodHandle_table = new MethodHandle[AccessMode.COUNT];

        TypesAndInvokers() {
        }
    }

    public static final class VarHandleDesc
    extends DynamicConstantDesc<VarHandle> {
        private final Kind kind;
        private final ClassDesc declaringClass;
        private final ClassDesc varType;

        private VarHandleDesc(Kind kind, String name, ClassDesc declaringClass, ClassDesc varType) {
            super(kind.bootstrapMethod, name, ConstantDescs.CD_VarHandle, kind.toBSMArgs(declaringClass, varType));
            this.kind = kind;
            this.declaringClass = declaringClass;
            this.varType = varType;
        }

        public static VarHandleDesc ofField(ClassDesc declaringClass, String name, ClassDesc fieldType) {
            Objects.requireNonNull(declaringClass);
            Objects.requireNonNull(name);
            Objects.requireNonNull(fieldType);
            return new VarHandleDesc(Kind.FIELD, name, declaringClass, fieldType);
        }

        public static VarHandleDesc ofStaticField(ClassDesc declaringClass, String name, ClassDesc fieldType) {
            Objects.requireNonNull(declaringClass);
            Objects.requireNonNull(name);
            Objects.requireNonNull(fieldType);
            return new VarHandleDesc(Kind.STATIC_FIELD, name, declaringClass, fieldType);
        }

        public static VarHandleDesc ofArray(ClassDesc arrayClass) {
            Objects.requireNonNull(arrayClass);
            if (!arrayClass.isArray()) {
                throw new IllegalArgumentException("Array class argument not an array: " + arrayClass);
            }
            return new VarHandleDesc(Kind.ARRAY, "_", arrayClass, arrayClass.componentType());
        }

        public ClassDesc varType() {
            return this.varType;
        }

        @Override
        public VarHandle resolveConstantDesc(MethodHandles.Lookup lookup) throws ReflectiveOperationException {
            return switch (this.kind) {
                case Kind.FIELD -> lookup.findVarHandle((Class)this.declaringClass.resolveConstantDesc(lookup), this.constantName(), (Class)this.varType.resolveConstantDesc(lookup));
                case Kind.STATIC_FIELD -> lookup.findStaticVarHandle((Class)this.declaringClass.resolveConstantDesc(lookup), this.constantName(), (Class)this.varType.resolveConstantDesc(lookup));
                case Kind.ARRAY -> MethodHandles.arrayElementVarHandle((Class)this.declaringClass.resolveConstantDesc(lookup));
                default -> throw new InternalError("Cannot reach here");
            };
        }

        @Override
        public String toString() {
            return switch (this.kind) {
                case Kind.FIELD, Kind.STATIC_FIELD -> String.format("VarHandleDesc[%s%s.%s:%s]", this.kind == Kind.STATIC_FIELD ? "static " : "", this.declaringClass.displayName(), this.constantName(), this.varType.displayName());
                case Kind.ARRAY -> String.format("VarHandleDesc[%s[]]", this.declaringClass.displayName());
                default -> throw new InternalError("Cannot reach here");
            };
        }

        private static enum Kind {
            FIELD(ConstantDescs.BSM_VARHANDLE_FIELD),
            STATIC_FIELD(ConstantDescs.BSM_VARHANDLE_STATIC_FIELD),
            ARRAY(ConstantDescs.BSM_VARHANDLE_ARRAY);

            final DirectMethodHandleDesc bootstrapMethod;

            private Kind(DirectMethodHandleDesc bootstrapMethod) {
                this.bootstrapMethod = bootstrapMethod;
            }

            ConstantDesc[] toBSMArgs(ClassDesc declaringClass, ClassDesc varType) {
                ConstantDesc[] constantDescArray;
                switch (this) {
                    case FIELD: 
                    case STATIC_FIELD: {
                        ConstantDesc[] constantDescArray2 = new ConstantDesc[2];
                        constantDescArray2[0] = declaringClass;
                        constantDescArray = constantDescArray2;
                        constantDescArray2[1] = varType;
                        break;
                    }
                    case ARRAY: {
                        ConstantDesc[] constantDescArray3 = new ConstantDesc[1];
                        constantDescArray = constantDescArray3;
                        constantDescArray3[0] = declaringClass;
                        break;
                    }
                    default: {
                        throw new InternalError("Cannot reach here");
                    }
                }
                return constantDescArray;
            }
        }
    }
}

