/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.constant.ClassDesc;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarForm;
import java.lang.invoke.VarHandle;
import java.lang.invoke.VarHandles;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.Optional;
import jdk.internal.util.Preconditions;
import jdk.internal.vm.annotation.ForceInline;

final class VarHandleBooleans {
    VarHandleBooleans() {
    }

    static final class Array
    extends VarHandle {
        final int abase;
        final int ashift;
        static final VarForm FORM = new VarForm(Array.class, boolean[].class, Boolean.TYPE, Integer.TYPE);

        Array(int abase, int ashift) {
            this(abase, ashift, false);
        }

        private Array(int abase, int ashift, boolean exact) {
            super(FORM, exact);
            this.abase = abase;
            this.ashift = ashift;
        }

        @Override
        public Array withInvokeExactBehavior() {
            return this.hasInvokeExactBehavior() ? this : new Array(this.abase, this.ashift, true);
        }

        @Override
        public Array withInvokeBehavior() {
            return !this.hasInvokeExactBehavior() ? this : new Array(this.abase, this.ashift, false);
        }

        @Override
        public Optional<VarHandle.VarHandleDesc> describeConstable() {
            Optional<ClassDesc> arrayTypeRef = boolean[].class.describeConstable();
            if (!arrayTypeRef.isPresent()) {
                return Optional.empty();
            }
            return Optional.of(VarHandle.VarHandleDesc.ofArray(arrayTypeRef.get()));
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessType at) {
            return at.accessModeType(boolean[].class, Boolean.TYPE, Integer.TYPE);
        }

        @ForceInline
        static boolean get(VarHandle ob, Object oarray, int index) {
            Array handle = (Array)ob;
            boolean[] array = (boolean[])oarray;
            return array[index];
        }

        @ForceInline
        static void set(VarHandle ob, Object oarray, int index, boolean value) {
            Array handle = (Array)ob;
            boolean[] array = (boolean[])oarray;
            array[index] = value;
        }

        @ForceInline
        static boolean getVolatile(VarHandle ob, Object oarray, int index) {
            Array handle = (Array)ob;
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.getBooleanVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase);
        }

        @ForceInline
        static void setVolatile(VarHandle ob, Object oarray, int index, boolean value) {
            Array handle = (Array)ob;
            boolean[] array = (boolean[])oarray;
            MethodHandleStatics.UNSAFE.putBooleanVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static boolean getOpaque(VarHandle ob, Object oarray, int index) {
            Array handle = (Array)ob;
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.getBooleanOpaque(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase);
        }

        @ForceInline
        static void setOpaque(VarHandle ob, Object oarray, int index, boolean value) {
            Array handle = (Array)ob;
            boolean[] array = (boolean[])oarray;
            MethodHandleStatics.UNSAFE.putBooleanOpaque(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static boolean getAcquire(VarHandle ob, Object oarray, int index) {
            Array handle = (Array)ob;
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.getBooleanAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase);
        }

        @ForceInline
        static void setRelease(VarHandle ob, Object oarray, int index, boolean value) {
            Array handle = (Array)ob;
            boolean[] array = (boolean[])oarray;
            MethodHandleStatics.UNSAFE.putBooleanRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static boolean compareAndSet(VarHandle ob, Object oarray, int index, boolean expected, boolean value) {
            Array handle = (Array)ob;
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndSetBoolean(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean compareAndExchange(VarHandle ob, Object oarray, int index, boolean expected, boolean value) {
            Array handle = (Array)ob;
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndExchangeBoolean(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean compareAndExchangeAcquire(VarHandle ob, Object oarray, int index, boolean expected, boolean value) {
            Array handle = (Array)ob;
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndExchangeBooleanAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean compareAndExchangeRelease(VarHandle ob, Object oarray, int index, boolean expected, boolean value) {
            Array handle = (Array)ob;
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndExchangeBooleanRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(VarHandle ob, Object oarray, int index, boolean expected, boolean value) {
            Array handle = (Array)ob;
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetBooleanPlain(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSet(VarHandle ob, Object oarray, int index, boolean expected, boolean value) {
            Array handle = (Array)ob;
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetBoolean(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(VarHandle ob, Object oarray, int index, boolean expected, boolean value) {
            Array handle = (Array)ob;
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetBooleanAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(VarHandle ob, Object oarray, int index, boolean expected, boolean value) {
            Array handle = (Array)ob;
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetBooleanRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean getAndSet(VarHandle ob, Object oarray, int index, boolean value) {
            Array handle = (Array)ob;
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.getAndSetBoolean(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static boolean getAndSetAcquire(VarHandle ob, Object oarray, int index, boolean value) {
            Array handle = (Array)ob;
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.getAndSetBooleanAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static boolean getAndSetRelease(VarHandle ob, Object oarray, int index, boolean value) {
            Array handle = (Array)ob;
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.getAndSetBooleanRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static boolean getAndBitwiseOr(VarHandle ob, Object oarray, int index, boolean value) {
            Array handle = (Array)ob;
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrBoolean(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static boolean getAndBitwiseOrRelease(VarHandle ob, Object oarray, int index, boolean value) {
            Array handle = (Array)ob;
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrBooleanRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static boolean getAndBitwiseOrAcquire(VarHandle ob, Object oarray, int index, boolean value) {
            Array handle = (Array)ob;
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrBooleanAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static boolean getAndBitwiseAnd(VarHandle ob, Object oarray, int index, boolean value) {
            Array handle = (Array)ob;
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndBoolean(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static boolean getAndBitwiseAndRelease(VarHandle ob, Object oarray, int index, boolean value) {
            Array handle = (Array)ob;
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndBooleanRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static boolean getAndBitwiseAndAcquire(VarHandle ob, Object oarray, int index, boolean value) {
            Array handle = (Array)ob;
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndBooleanAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static boolean getAndBitwiseXor(VarHandle ob, Object oarray, int index, boolean value) {
            Array handle = (Array)ob;
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorBoolean(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static boolean getAndBitwiseXorRelease(VarHandle ob, Object oarray, int index, boolean value) {
            Array handle = (Array)ob;
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorBooleanRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static boolean getAndBitwiseXorAcquire(VarHandle ob, Object oarray, int index, boolean value) {
            Array handle = (Array)ob;
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorBooleanAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }
    }

    static final class FieldStaticReadWrite
    extends FieldStaticReadOnly {
        static final VarForm FORM = new VarForm(FieldStaticReadWrite.class, null, Boolean.TYPE, new Class[0]);

        FieldStaticReadWrite(Object base, long fieldOffset) {
            this(base, fieldOffset, false);
        }

        private FieldStaticReadWrite(Object base, long fieldOffset, boolean exact) {
            super(base, fieldOffset, FORM, exact);
        }

        @Override
        public FieldStaticReadWrite withInvokeExactBehavior() {
            return this.hasInvokeExactBehavior() ? this : new FieldStaticReadWrite(this.base, this.fieldOffset, true);
        }

        @Override
        public FieldStaticReadWrite withInvokeBehavior() {
            return !this.hasInvokeExactBehavior() ? this : new FieldStaticReadWrite(this.base, this.fieldOffset, false);
        }

        @ForceInline
        static void set(VarHandle ob, boolean value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            MethodHandleStatics.UNSAFE.putBoolean(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static void setVolatile(VarHandle ob, boolean value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            MethodHandleStatics.UNSAFE.putBooleanVolatile(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static void setOpaque(VarHandle ob, boolean value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            MethodHandleStatics.UNSAFE.putBooleanOpaque(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static void setRelease(VarHandle ob, boolean value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            MethodHandleStatics.UNSAFE.putBooleanRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static boolean compareAndSet(VarHandle ob, boolean expected, boolean value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.compareAndSetBoolean(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean compareAndExchange(VarHandle ob, boolean expected, boolean value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.compareAndExchangeBoolean(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean compareAndExchangeAcquire(VarHandle ob, boolean expected, boolean value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.compareAndExchangeBooleanAcquire(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean compareAndExchangeRelease(VarHandle ob, boolean expected, boolean value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.compareAndExchangeBooleanRelease(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(VarHandle ob, boolean expected, boolean value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetBooleanPlain(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSet(VarHandle ob, boolean expected, boolean value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetBoolean(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(VarHandle ob, boolean expected, boolean value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetBooleanAcquire(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(VarHandle ob, boolean expected, boolean value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetBooleanRelease(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean getAndSet(VarHandle ob, boolean value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndSetBoolean(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static boolean getAndSetAcquire(VarHandle ob, boolean value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndSetBooleanAcquire(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static boolean getAndSetRelease(VarHandle ob, boolean value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndSetBooleanRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static boolean getAndBitwiseOr(VarHandle ob, boolean value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrBoolean(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static boolean getAndBitwiseOrRelease(VarHandle ob, boolean value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrBooleanRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static boolean getAndBitwiseOrAcquire(VarHandle ob, boolean value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrBooleanAcquire(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static boolean getAndBitwiseAnd(VarHandle ob, boolean value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndBoolean(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static boolean getAndBitwiseAndRelease(VarHandle ob, boolean value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndBooleanRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static boolean getAndBitwiseAndAcquire(VarHandle ob, boolean value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndBooleanAcquire(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static boolean getAndBitwiseXor(VarHandle ob, boolean value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorBoolean(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static boolean getAndBitwiseXorRelease(VarHandle ob, boolean value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorBooleanRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static boolean getAndBitwiseXorAcquire(VarHandle ob, boolean value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorBooleanAcquire(handle.base, handle.fieldOffset, value);
        }
    }

    static class FieldStaticReadOnly
    extends VarHandle {
        final Object base;
        final long fieldOffset;
        static final VarForm FORM = new VarForm(FieldStaticReadOnly.class, null, Boolean.TYPE, new Class[0]);

        FieldStaticReadOnly(Object base, long fieldOffset) {
            this(base, fieldOffset, FORM, false);
        }

        protected FieldStaticReadOnly(Object base, long fieldOffset, VarForm form, boolean exact) {
            super(form, exact);
            this.base = base;
            this.fieldOffset = fieldOffset;
        }

        @Override
        public FieldStaticReadOnly withInvokeExactBehavior() {
            return this.hasInvokeExactBehavior() ? this : new FieldStaticReadOnly(this.base, this.fieldOffset, this.vform, true);
        }

        @Override
        public FieldStaticReadOnly withInvokeBehavior() {
            return !this.hasInvokeExactBehavior() ? this : new FieldStaticReadOnly(this.base, this.fieldOffset, this.vform, false);
        }

        @Override
        public Optional<VarHandle.VarHandleDesc> describeConstable() {
            Optional<ClassDesc> fieldTypeRef = Boolean.TYPE.describeConstable();
            if (!fieldTypeRef.isPresent()) {
                return Optional.empty();
            }
            Field staticField = VarHandles.getStaticFieldFromBaseAndOffset(this.base, this.fieldOffset, Boolean.TYPE);
            Optional<ClassDesc> receiverTypeRef = staticField.getDeclaringClass().describeConstable();
            if (!receiverTypeRef.isPresent()) {
                return Optional.empty();
            }
            return Optional.of(VarHandle.VarHandleDesc.ofStaticField(receiverTypeRef.get(), staticField.getName(), fieldTypeRef.get()));
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessType at) {
            return at.accessModeType(null, Boolean.TYPE, new Class[0]);
        }

        @ForceInline
        static boolean get(VarHandle ob) {
            FieldStaticReadOnly handle = (FieldStaticReadOnly)ob;
            return MethodHandleStatics.UNSAFE.getBoolean(handle.base, handle.fieldOffset);
        }

        @ForceInline
        static boolean getVolatile(VarHandle ob) {
            FieldStaticReadOnly handle = (FieldStaticReadOnly)ob;
            return MethodHandleStatics.UNSAFE.getBooleanVolatile(handle.base, handle.fieldOffset);
        }

        @ForceInline
        static boolean getOpaque(VarHandle ob) {
            FieldStaticReadOnly handle = (FieldStaticReadOnly)ob;
            return MethodHandleStatics.UNSAFE.getBooleanOpaque(handle.base, handle.fieldOffset);
        }

        @ForceInline
        static boolean getAcquire(VarHandle ob) {
            FieldStaticReadOnly handle = (FieldStaticReadOnly)ob;
            return MethodHandleStatics.UNSAFE.getBooleanAcquire(handle.base, handle.fieldOffset);
        }
    }

    static final class FieldInstanceReadWrite
    extends FieldInstanceReadOnly {
        static final VarForm FORM = new VarForm(FieldInstanceReadWrite.class, Object.class, Boolean.TYPE, new Class[0]);

        FieldInstanceReadWrite(Class<?> receiverType, long fieldOffset) {
            this(receiverType, fieldOffset, false);
        }

        private FieldInstanceReadWrite(Class<?> receiverType, long fieldOffset, boolean exact) {
            super(receiverType, fieldOffset, FORM, exact);
        }

        @Override
        public FieldInstanceReadWrite withInvokeExactBehavior() {
            return this.hasInvokeExactBehavior() ? this : new FieldInstanceReadWrite(this.receiverType, this.fieldOffset, true);
        }

        @Override
        public FieldInstanceReadWrite withInvokeBehavior() {
            return !this.hasInvokeExactBehavior() ? this : new FieldInstanceReadWrite(this.receiverType, this.fieldOffset, false);
        }

        @ForceInline
        static void set(VarHandle ob, Object holder, boolean value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            MethodHandleStatics.UNSAFE.putBoolean(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static void setVolatile(VarHandle ob, Object holder, boolean value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            MethodHandleStatics.UNSAFE.putBooleanVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static void setOpaque(VarHandle ob, Object holder, boolean value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            MethodHandleStatics.UNSAFE.putBooleanOpaque(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static void setRelease(VarHandle ob, Object holder, boolean value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            MethodHandleStatics.UNSAFE.putBooleanRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static boolean compareAndSet(VarHandle ob, Object holder, boolean expected, boolean value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.compareAndSetBoolean(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean compareAndExchange(VarHandle ob, Object holder, boolean expected, boolean value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.compareAndExchangeBoolean(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean compareAndExchangeAcquire(VarHandle ob, Object holder, boolean expected, boolean value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.compareAndExchangeBooleanAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean compareAndExchangeRelease(VarHandle ob, Object holder, boolean expected, boolean value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.compareAndExchangeBooleanRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(VarHandle ob, Object holder, boolean expected, boolean value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetBooleanPlain(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSet(VarHandle ob, Object holder, boolean expected, boolean value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetBoolean(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(VarHandle ob, Object holder, boolean expected, boolean value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetBooleanAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(VarHandle ob, Object holder, boolean expected, boolean value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetBooleanRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean getAndSet(VarHandle ob, Object holder, boolean value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndSetBoolean(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static boolean getAndSetAcquire(VarHandle ob, Object holder, boolean value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndSetBooleanAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static boolean getAndSetRelease(VarHandle ob, Object holder, boolean value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndSetBooleanRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static boolean getAndBitwiseOr(VarHandle ob, Object holder, boolean value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrBoolean(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static boolean getAndBitwiseOrRelease(VarHandle ob, Object holder, boolean value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrBooleanRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static boolean getAndBitwiseOrAcquire(VarHandle ob, Object holder, boolean value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrBooleanAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static boolean getAndBitwiseAnd(VarHandle ob, Object holder, boolean value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndBoolean(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static boolean getAndBitwiseAndRelease(VarHandle ob, Object holder, boolean value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndBooleanRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static boolean getAndBitwiseAndAcquire(VarHandle ob, Object holder, boolean value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndBooleanAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static boolean getAndBitwiseXor(VarHandle ob, Object holder, boolean value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorBoolean(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static boolean getAndBitwiseXorRelease(VarHandle ob, Object holder, boolean value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorBooleanRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static boolean getAndBitwiseXorAcquire(VarHandle ob, Object holder, boolean value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorBooleanAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }
    }

    static class FieldInstanceReadOnly
    extends VarHandle {
        final long fieldOffset;
        final Class<?> receiverType;
        static final VarForm FORM = new VarForm(FieldInstanceReadOnly.class, Object.class, Boolean.TYPE, new Class[0]);

        FieldInstanceReadOnly(Class<?> receiverType, long fieldOffset) {
            this(receiverType, fieldOffset, FORM, false);
        }

        protected FieldInstanceReadOnly(Class<?> receiverType, long fieldOffset, VarForm form, boolean exact) {
            super(form, exact);
            this.fieldOffset = fieldOffset;
            this.receiverType = receiverType;
        }

        @Override
        public FieldInstanceReadOnly withInvokeExactBehavior() {
            return this.hasInvokeExactBehavior() ? this : new FieldInstanceReadOnly(this.receiverType, this.fieldOffset, this.vform, true);
        }

        @Override
        public FieldInstanceReadOnly withInvokeBehavior() {
            return !this.hasInvokeExactBehavior() ? this : new FieldInstanceReadOnly(this.receiverType, this.fieldOffset, this.vform, false);
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessType at) {
            return at.accessModeType(this.receiverType, Boolean.TYPE, new Class[0]);
        }

        @Override
        public Optional<VarHandle.VarHandleDesc> describeConstable() {
            Optional<ClassDesc> receiverTypeRef = this.receiverType.describeConstable();
            Optional<ClassDesc> fieldTypeRef = Boolean.TYPE.describeConstable();
            if (!receiverTypeRef.isPresent() || !fieldTypeRef.isPresent()) {
                return Optional.empty();
            }
            String name = VarHandles.getFieldFromReceiverAndOffset(this.receiverType, this.fieldOffset, Boolean.TYPE).getName();
            return Optional.of(VarHandle.VarHandleDesc.ofField(receiverTypeRef.get(), name, fieldTypeRef.get()));
        }

        @ForceInline
        static boolean get(VarHandle ob, Object holder) {
            FieldInstanceReadOnly handle = (FieldInstanceReadOnly)ob;
            return MethodHandleStatics.UNSAFE.getBoolean(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }

        @ForceInline
        static boolean getVolatile(VarHandle ob, Object holder) {
            FieldInstanceReadOnly handle = (FieldInstanceReadOnly)ob;
            return MethodHandleStatics.UNSAFE.getBooleanVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }

        @ForceInline
        static boolean getOpaque(VarHandle ob, Object holder) {
            FieldInstanceReadOnly handle = (FieldInstanceReadOnly)ob;
            return MethodHandleStatics.UNSAFE.getBooleanOpaque(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }

        @ForceInline
        static boolean getAcquire(VarHandle ob, Object holder) {
            FieldInstanceReadOnly handle = (FieldInstanceReadOnly)ob;
            return MethodHandleStatics.UNSAFE.getBooleanAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }
    }
}

