/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarForm;
import java.lang.invoke.VarHandle;
import java.lang.invoke.VarHandleByteArrayBase;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import jdk.internal.access.JavaNioAccess;
import jdk.internal.access.SharedSecrets;
import jdk.internal.access.foreign.MemorySegmentProxy;
import jdk.internal.misc.ScopedMemoryAccess;
import jdk.internal.misc.Unsafe;
import jdk.internal.util.Preconditions;
import jdk.internal.vm.annotation.ForceInline;

final class VarHandleByteArrayAsChars
extends VarHandleByteArrayBase {
    static final JavaNioAccess NIO_ACCESS = SharedSecrets.getJavaNioAccess();
    static final int ALIGN = 1;
    static final ScopedMemoryAccess SCOPED_MEMORY_ACCESS = ScopedMemoryAccess.getScopedMemoryAccess();

    VarHandleByteArrayAsChars() {
    }

    @ForceInline
    static char convEndian(boolean big, char n) {
        return big == BE ? n : Character.reverseBytes(n);
    }

    static final class ByteBufferHandle
    extends ByteArrayViewVarHandle {
        static final VarForm FORM = new VarForm(ByteBufferHandle.class, ByteBuffer.class, Character.TYPE, Integer.TYPE);

        ByteBufferHandle(boolean be) {
            this(be, false);
        }

        private ByteBufferHandle(boolean be, boolean exact) {
            super(FORM, be, exact);
        }

        @Override
        public ByteBufferHandle withInvokeExactBehavior() {
            return this.hasInvokeExactBehavior() ? this : new ByteBufferHandle(this.be, true);
        }

        @Override
        public ByteBufferHandle withInvokeBehavior() {
            return !this.hasInvokeExactBehavior() ? this : new ByteBufferHandle(this.be, false);
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessType at) {
            return at.accessModeType(ByteBuffer.class, Character.TYPE, Integer.TYPE);
        }

        @ForceInline
        static int index(ByteBuffer bb, int index) {
            MemorySegmentProxy segmentProxy = NIO_ACCESS.bufferSegment(bb);
            return Preconditions.checkIndex(index, MethodHandleStatics.UNSAFE.getInt(bb, VarHandleByteArrayBase.BUFFER_LIMIT) - 1, null);
        }

        @ForceInline
        static ScopedMemoryAccess.Scope scope(ByteBuffer bb) {
            MemorySegmentProxy segmentProxy = NIO_ACCESS.bufferSegment(bb);
            return segmentProxy != null ? segmentProxy.scope() : null;
        }

        @ForceInline
        static int indexRO(ByteBuffer bb, int index) {
            if (MethodHandleStatics.UNSAFE.getBoolean(bb, VarHandleByteArrayBase.BYTE_BUFFER_IS_READ_ONLY)) {
                throw new ReadOnlyBufferException();
            }
            return ByteBufferHandle.index(bb, index);
        }

        @ForceInline
        static long address(ByteBuffer bb, int index) {
            long address = (long)index + MethodHandleStatics.UNSAFE.getLong(bb, VarHandleByteArrayBase.BUFFER_ADDRESS);
            if ((address & 1L) != 0L) {
                throw VarHandleByteArrayBase.newIllegalStateExceptionForMisalignedAccess(index);
            }
            return address;
        }

        @ForceInline
        static char get(VarHandle ob, Object obb, int index) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return SCOPED_MEMORY_ACCESS.getCharUnaligned(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), (long)ByteBufferHandle.index(bb, index) + MethodHandleStatics.UNSAFE.getLong(bb, VarHandleByteArrayBase.BUFFER_ADDRESS), handle.be);
        }

        @ForceInline
        static void set(VarHandle ob, Object obb, int index, char value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            SCOPED_MEMORY_ACCESS.putCharUnaligned(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), (long)ByteBufferHandle.indexRO(bb, index) + MethodHandleStatics.UNSAFE.getLong(bb, VarHandleByteArrayBase.BUFFER_ADDRESS), value, handle.be);
        }

        @ForceInline
        static char getVolatile(VarHandle ob, Object obb, int index) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return VarHandleByteArrayAsChars.convEndian(handle.be, SCOPED_MEMORY_ACCESS.getCharVolatile(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.index(bb, index))));
        }

        @ForceInline
        static void setVolatile(VarHandle ob, Object obb, int index, char value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            SCOPED_MEMORY_ACCESS.putCharVolatile(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsChars.convEndian(handle.be, value));
        }

        @ForceInline
        static char getAcquire(VarHandle ob, Object obb, int index) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return VarHandleByteArrayAsChars.convEndian(handle.be, SCOPED_MEMORY_ACCESS.getCharAcquire(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.index(bb, index))));
        }

        @ForceInline
        static void setRelease(VarHandle ob, Object obb, int index, char value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            SCOPED_MEMORY_ACCESS.putCharRelease(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsChars.convEndian(handle.be, value));
        }

        @ForceInline
        static char getOpaque(VarHandle ob, Object obb, int index) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return VarHandleByteArrayAsChars.convEndian(handle.be, SCOPED_MEMORY_ACCESS.getCharOpaque(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.index(bb, index))));
        }

        @ForceInline
        static void setOpaque(VarHandle ob, Object obb, int index, char value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            SCOPED_MEMORY_ACCESS.putCharOpaque(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsChars.convEndian(handle.be, value));
        }
    }

    static final class ArrayHandle
    extends ByteArrayViewVarHandle {
        private static final BiFunction<String, List<Number>, ArrayIndexOutOfBoundsException> OOBEF = Preconditions.outOfBoundsExceptionFormatter(ArrayIndexOutOfBoundsException::new);
        static final VarForm FORM = new VarForm(ArrayHandle.class, byte[].class, Character.TYPE, Integer.TYPE);

        ArrayHandle(boolean be) {
            this(be, false);
        }

        private ArrayHandle(boolean be, boolean exact) {
            super(FORM, be, exact);
        }

        @Override
        public ArrayHandle withInvokeExactBehavior() {
            return this.hasInvokeExactBehavior() ? this : new ArrayHandle(this.be, true);
        }

        @Override
        public ArrayHandle withInvokeBehavior() {
            return !this.hasInvokeExactBehavior() ? this : new ArrayHandle(this.be, false);
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessType at) {
            return at.accessModeType(byte[].class, Character.TYPE, Integer.TYPE);
        }

        @ForceInline
        static int index(byte[] ba, int index) {
            return Preconditions.checkIndex(index, ba.length - 1, OOBEF);
        }

        @ForceInline
        static long address(byte[] ba, int index) {
            long address = (long)index + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET;
            if ((address & 1L) != 0L) {
                throw VarHandleByteArrayBase.newIllegalStateExceptionForMisalignedAccess(index);
            }
            return address;
        }

        @ForceInline
        static char get(VarHandle ob, Object oba, int index) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return MethodHandleStatics.UNSAFE.getCharUnaligned(ba, (long)ArrayHandle.index(ba, index) + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET, handle.be);
        }

        @ForceInline
        static void set(VarHandle ob, Object oba, int index, char value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            MethodHandleStatics.UNSAFE.putCharUnaligned(ba, (long)ArrayHandle.index(ba, index) + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET, value, handle.be);
        }

        @ForceInline
        static char getVolatile(VarHandle ob, Object oba, int index) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsChars.convEndian(handle.be, MethodHandleStatics.UNSAFE.getCharVolatile(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index))));
        }

        @ForceInline
        static void setVolatile(VarHandle ob, Object oba, int index, char value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            MethodHandleStatics.UNSAFE.putCharVolatile(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsChars.convEndian(handle.be, value));
        }

        @ForceInline
        static char getAcquire(VarHandle ob, Object oba, int index) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsChars.convEndian(handle.be, MethodHandleStatics.UNSAFE.getCharAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index))));
        }

        @ForceInline
        static void setRelease(VarHandle ob, Object oba, int index, char value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            MethodHandleStatics.UNSAFE.putCharRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsChars.convEndian(handle.be, value));
        }

        @ForceInline
        static char getOpaque(VarHandle ob, Object oba, int index) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsChars.convEndian(handle.be, MethodHandleStatics.UNSAFE.getCharOpaque(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index))));
        }

        @ForceInline
        static void setOpaque(VarHandle ob, Object oba, int index, char value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            MethodHandleStatics.UNSAFE.putCharOpaque(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsChars.convEndian(handle.be, value));
        }
    }

    private static abstract class ByteArrayViewVarHandle
    extends VarHandle {
        final boolean be;

        ByteArrayViewVarHandle(VarForm form, boolean be, boolean exact) {
            super(form, exact);
            this.be = be;
        }
    }
}

