/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarForm;
import java.lang.invoke.VarHandle;
import java.lang.invoke.VarHandleByteArrayBase;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import jdk.internal.access.JavaNioAccess;
import jdk.internal.access.SharedSecrets;
import jdk.internal.access.foreign.MemorySegmentProxy;
import jdk.internal.misc.ScopedMemoryAccess;
import jdk.internal.misc.Unsafe;
import jdk.internal.util.Preconditions;
import jdk.internal.vm.annotation.ForceInline;

final class VarHandleByteArrayAsDoubles
extends VarHandleByteArrayBase {
    static final JavaNioAccess NIO_ACCESS = SharedSecrets.getJavaNioAccess();
    static final int ALIGN = 7;
    static final ScopedMemoryAccess SCOPED_MEMORY_ACCESS = ScopedMemoryAccess.getScopedMemoryAccess();

    VarHandleByteArrayAsDoubles() {
    }

    @ForceInline
    static long convEndian(boolean big, double v) {
        long rv = Double.doubleToRawLongBits(v);
        return big == BE ? rv : Long.reverseBytes(rv);
    }

    @ForceInline
    static double convEndian(boolean big, long rv) {
        rv = big == BE ? rv : Long.reverseBytes(rv);
        return Double.longBitsToDouble(rv);
    }

    static final class ByteBufferHandle
    extends ByteArrayViewVarHandle {
        static final VarForm FORM = new VarForm(ByteBufferHandle.class, ByteBuffer.class, Double.TYPE, Integer.TYPE);

        ByteBufferHandle(boolean be) {
            this(be, false);
        }

        private ByteBufferHandle(boolean be, boolean exact) {
            super(FORM, be, exact);
        }

        @Override
        public ByteBufferHandle withInvokeExactBehavior() {
            return this.hasInvokeExactBehavior() ? this : new ByteBufferHandle(this.be, true);
        }

        @Override
        public ByteBufferHandle withInvokeBehavior() {
            return !this.hasInvokeExactBehavior() ? this : new ByteBufferHandle(this.be, false);
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessType at) {
            return at.accessModeType(ByteBuffer.class, Double.TYPE, Integer.TYPE);
        }

        @ForceInline
        static int index(ByteBuffer bb, int index) {
            MemorySegmentProxy segmentProxy = NIO_ACCESS.bufferSegment(bb);
            return Preconditions.checkIndex(index, MethodHandleStatics.UNSAFE.getInt(bb, VarHandleByteArrayBase.BUFFER_LIMIT) - 7, null);
        }

        @ForceInline
        static ScopedMemoryAccess.Scope scope(ByteBuffer bb) {
            MemorySegmentProxy segmentProxy = NIO_ACCESS.bufferSegment(bb);
            return segmentProxy != null ? segmentProxy.scope() : null;
        }

        @ForceInline
        static int indexRO(ByteBuffer bb, int index) {
            if (MethodHandleStatics.UNSAFE.getBoolean(bb, VarHandleByteArrayBase.BYTE_BUFFER_IS_READ_ONLY)) {
                throw new ReadOnlyBufferException();
            }
            return ByteBufferHandle.index(bb, index);
        }

        @ForceInline
        static long address(ByteBuffer bb, int index) {
            long address = (long)index + MethodHandleStatics.UNSAFE.getLong(bb, VarHandleByteArrayBase.BUFFER_ADDRESS);
            if ((address & 7L) != 0L) {
                throw VarHandleByteArrayBase.newIllegalStateExceptionForMisalignedAccess(index);
            }
            return address;
        }

        @ForceInline
        static double get(VarHandle ob, Object obb, int index) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            long rawValue = SCOPED_MEMORY_ACCESS.getLongUnaligned(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), (long)ByteBufferHandle.index(bb, index) + MethodHandleStatics.UNSAFE.getLong(bb, VarHandleByteArrayBase.BUFFER_ADDRESS), handle.be);
            return Double.longBitsToDouble(rawValue);
        }

        @ForceInline
        static void set(VarHandle ob, Object obb, int index, double value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            SCOPED_MEMORY_ACCESS.putLongUnaligned(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), (long)ByteBufferHandle.indexRO(bb, index) + MethodHandleStatics.UNSAFE.getLong(bb, VarHandleByteArrayBase.BUFFER_ADDRESS), Double.doubleToRawLongBits(value), handle.be);
        }

        @ForceInline
        static double getVolatile(VarHandle ob, Object obb, int index) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return VarHandleByteArrayAsDoubles.convEndian(handle.be, SCOPED_MEMORY_ACCESS.getLongVolatile(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.index(bb, index))));
        }

        @ForceInline
        static void setVolatile(VarHandle ob, Object obb, int index, double value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            SCOPED_MEMORY_ACCESS.putLongVolatile(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, value));
        }

        @ForceInline
        static double getAcquire(VarHandle ob, Object obb, int index) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return VarHandleByteArrayAsDoubles.convEndian(handle.be, SCOPED_MEMORY_ACCESS.getLongAcquire(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.index(bb, index))));
        }

        @ForceInline
        static void setRelease(VarHandle ob, Object obb, int index, double value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            SCOPED_MEMORY_ACCESS.putLongRelease(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, value));
        }

        @ForceInline
        static double getOpaque(VarHandle ob, Object obb, int index) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return VarHandleByteArrayAsDoubles.convEndian(handle.be, SCOPED_MEMORY_ACCESS.getLongOpaque(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.index(bb, index))));
        }

        @ForceInline
        static void setOpaque(VarHandle ob, Object obb, int index, double value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            SCOPED_MEMORY_ACCESS.putLongOpaque(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean compareAndSet(VarHandle ob, Object obb, int index, double expected, double value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return SCOPED_MEMORY_ACCESS.compareAndSetLong(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, expected), VarHandleByteArrayAsDoubles.convEndian(handle.be, value));
        }

        @ForceInline
        static double compareAndExchange(VarHandle ob, Object obb, int index, double expected, double value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return VarHandleByteArrayAsDoubles.convEndian(handle.be, SCOPED_MEMORY_ACCESS.compareAndExchangeLong(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, expected), VarHandleByteArrayAsDoubles.convEndian(handle.be, value)));
        }

        @ForceInline
        static double compareAndExchangeAcquire(VarHandle ob, Object obb, int index, double expected, double value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return VarHandleByteArrayAsDoubles.convEndian(handle.be, SCOPED_MEMORY_ACCESS.compareAndExchangeLongAcquire(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, expected), VarHandleByteArrayAsDoubles.convEndian(handle.be, value)));
        }

        @ForceInline
        static double compareAndExchangeRelease(VarHandle ob, Object obb, int index, double expected, double value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return VarHandleByteArrayAsDoubles.convEndian(handle.be, SCOPED_MEMORY_ACCESS.compareAndExchangeLongRelease(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, expected), VarHandleByteArrayAsDoubles.convEndian(handle.be, value)));
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(VarHandle ob, Object obb, int index, double expected, double value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return SCOPED_MEMORY_ACCESS.weakCompareAndSetLongPlain(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, expected), VarHandleByteArrayAsDoubles.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean weakCompareAndSet(VarHandle ob, Object obb, int index, double expected, double value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return SCOPED_MEMORY_ACCESS.weakCompareAndSetLong(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, expected), VarHandleByteArrayAsDoubles.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(VarHandle ob, Object obb, int index, double expected, double value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return SCOPED_MEMORY_ACCESS.weakCompareAndSetLongAcquire(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, expected), VarHandleByteArrayAsDoubles.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(VarHandle ob, Object obb, int index, double expected, double value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return SCOPED_MEMORY_ACCESS.weakCompareAndSetLongRelease(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, expected), VarHandleByteArrayAsDoubles.convEndian(handle.be, value));
        }

        @ForceInline
        static double getAndSet(VarHandle ob, Object obb, int index, double value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return VarHandleByteArrayAsDoubles.convEndian(handle.be, SCOPED_MEMORY_ACCESS.getAndSetLong(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, value)));
        }

        @ForceInline
        static double getAndSetAcquire(VarHandle ob, Object obb, int index, double value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return VarHandleByteArrayAsDoubles.convEndian(handle.be, SCOPED_MEMORY_ACCESS.getAndSetLongAcquire(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, value)));
        }

        @ForceInline
        static double getAndSetRelease(VarHandle ob, Object obb, int index, double value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return VarHandleByteArrayAsDoubles.convEndian(handle.be, SCOPED_MEMORY_ACCESS.getAndSetLongRelease(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, value)));
        }
    }

    static final class ArrayHandle
    extends ByteArrayViewVarHandle {
        private static final BiFunction<String, List<Number>, ArrayIndexOutOfBoundsException> OOBEF = Preconditions.outOfBoundsExceptionFormatter(ArrayIndexOutOfBoundsException::new);
        static final VarForm FORM = new VarForm(ArrayHandle.class, byte[].class, Double.TYPE, Integer.TYPE);

        ArrayHandle(boolean be) {
            this(be, false);
        }

        private ArrayHandle(boolean be, boolean exact) {
            super(FORM, be, exact);
        }

        @Override
        public ArrayHandle withInvokeExactBehavior() {
            return this.hasInvokeExactBehavior() ? this : new ArrayHandle(this.be, true);
        }

        @Override
        public ArrayHandle withInvokeBehavior() {
            return !this.hasInvokeExactBehavior() ? this : new ArrayHandle(this.be, false);
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessType at) {
            return at.accessModeType(byte[].class, Double.TYPE, Integer.TYPE);
        }

        @ForceInline
        static int index(byte[] ba, int index) {
            return Preconditions.checkIndex(index, ba.length - 7, OOBEF);
        }

        @ForceInline
        static long address(byte[] ba, int index) {
            long address = (long)index + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET;
            if ((address & 7L) != 0L) {
                throw VarHandleByteArrayBase.newIllegalStateExceptionForMisalignedAccess(index);
            }
            return address;
        }

        @ForceInline
        static double get(VarHandle ob, Object oba, int index) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            long rawValue = MethodHandleStatics.UNSAFE.getLongUnaligned(ba, (long)ArrayHandle.index(ba, index) + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET, handle.be);
            return Double.longBitsToDouble(rawValue);
        }

        @ForceInline
        static void set(VarHandle ob, Object oba, int index, double value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            MethodHandleStatics.UNSAFE.putLongUnaligned(ba, (long)ArrayHandle.index(ba, index) + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET, Double.doubleToRawLongBits(value), handle.be);
        }

        @ForceInline
        static double getVolatile(VarHandle ob, Object oba, int index) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsDoubles.convEndian(handle.be, MethodHandleStatics.UNSAFE.getLongVolatile(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index))));
        }

        @ForceInline
        static void setVolatile(VarHandle ob, Object oba, int index, double value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            MethodHandleStatics.UNSAFE.putLongVolatile(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, value));
        }

        @ForceInline
        static double getAcquire(VarHandle ob, Object oba, int index) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsDoubles.convEndian(handle.be, MethodHandleStatics.UNSAFE.getLongAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index))));
        }

        @ForceInline
        static void setRelease(VarHandle ob, Object oba, int index, double value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            MethodHandleStatics.UNSAFE.putLongRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, value));
        }

        @ForceInline
        static double getOpaque(VarHandle ob, Object oba, int index) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsDoubles.convEndian(handle.be, MethodHandleStatics.UNSAFE.getLongOpaque(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index))));
        }

        @ForceInline
        static void setOpaque(VarHandle ob, Object oba, int index, double value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            MethodHandleStatics.UNSAFE.putLongOpaque(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean compareAndSet(VarHandle ob, Object oba, int index, double expected, double value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return MethodHandleStatics.UNSAFE.compareAndSetLong(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, expected), VarHandleByteArrayAsDoubles.convEndian(handle.be, value));
        }

        @ForceInline
        static double compareAndExchange(VarHandle ob, Object oba, int index, double expected, double value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsDoubles.convEndian(handle.be, MethodHandleStatics.UNSAFE.compareAndExchangeLong(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, expected), VarHandleByteArrayAsDoubles.convEndian(handle.be, value)));
        }

        @ForceInline
        static double compareAndExchangeAcquire(VarHandle ob, Object oba, int index, double expected, double value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsDoubles.convEndian(handle.be, MethodHandleStatics.UNSAFE.compareAndExchangeLongAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, expected), VarHandleByteArrayAsDoubles.convEndian(handle.be, value)));
        }

        @ForceInline
        static double compareAndExchangeRelease(VarHandle ob, Object oba, int index, double expected, double value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsDoubles.convEndian(handle.be, MethodHandleStatics.UNSAFE.compareAndExchangeLongRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, expected), VarHandleByteArrayAsDoubles.convEndian(handle.be, value)));
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(VarHandle ob, Object oba, int index, double expected, double value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetLongPlain(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, expected), VarHandleByteArrayAsDoubles.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean weakCompareAndSet(VarHandle ob, Object oba, int index, double expected, double value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetLong(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, expected), VarHandleByteArrayAsDoubles.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(VarHandle ob, Object oba, int index, double expected, double value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetLongAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, expected), VarHandleByteArrayAsDoubles.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(VarHandle ob, Object oba, int index, double expected, double value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetLongRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, expected), VarHandleByteArrayAsDoubles.convEndian(handle.be, value));
        }

        @ForceInline
        static double getAndSet(VarHandle ob, Object oba, int index, double value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsDoubles.convEndian(handle.be, MethodHandleStatics.UNSAFE.getAndSetLong(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, value)));
        }

        @ForceInline
        static double getAndSetAcquire(VarHandle ob, Object oba, int index, double value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsDoubles.convEndian(handle.be, MethodHandleStatics.UNSAFE.getAndSetLongAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, value)));
        }

        @ForceInline
        static double getAndSetRelease(VarHandle ob, Object oba, int index, double value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsDoubles.convEndian(handle.be, MethodHandleStatics.UNSAFE.getAndSetLongRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, value)));
        }
    }

    private static abstract class ByteArrayViewVarHandle
    extends VarHandle {
        final boolean be;

        ByteArrayViewVarHandle(VarForm form, boolean be, boolean exact) {
            super(form, exact);
            this.be = be;
        }
    }
}

