/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarForm;
import java.lang.invoke.VarHandle;
import java.lang.invoke.VarHandleByteArrayBase;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import jdk.internal.access.JavaNioAccess;
import jdk.internal.access.SharedSecrets;
import jdk.internal.access.foreign.MemorySegmentProxy;
import jdk.internal.misc.ScopedMemoryAccess;
import jdk.internal.misc.Unsafe;
import jdk.internal.util.Preconditions;
import jdk.internal.vm.annotation.ForceInline;

final class VarHandleByteArrayAsInts
extends VarHandleByteArrayBase {
    static final JavaNioAccess NIO_ACCESS = SharedSecrets.getJavaNioAccess();
    static final int ALIGN = 3;
    static final ScopedMemoryAccess SCOPED_MEMORY_ACCESS = ScopedMemoryAccess.getScopedMemoryAccess();

    VarHandleByteArrayAsInts() {
    }

    @ForceInline
    static int convEndian(boolean big, int n) {
        return big == BE ? n : Integer.reverseBytes(n);
    }

    static final class ByteBufferHandle
    extends ByteArrayViewVarHandle {
        static final VarForm FORM = new VarForm(ByteBufferHandle.class, ByteBuffer.class, Integer.TYPE, Integer.TYPE);

        ByteBufferHandle(boolean be) {
            this(be, false);
        }

        private ByteBufferHandle(boolean be, boolean exact) {
            super(FORM, be, exact);
        }

        @Override
        public ByteBufferHandle withInvokeExactBehavior() {
            return this.hasInvokeExactBehavior() ? this : new ByteBufferHandle(this.be, true);
        }

        @Override
        public ByteBufferHandle withInvokeBehavior() {
            return !this.hasInvokeExactBehavior() ? this : new ByteBufferHandle(this.be, false);
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessType at) {
            return at.accessModeType(ByteBuffer.class, Integer.TYPE, Integer.TYPE);
        }

        @ForceInline
        static int index(ByteBuffer bb, int index) {
            MemorySegmentProxy segmentProxy = NIO_ACCESS.bufferSegment(bb);
            return Preconditions.checkIndex(index, MethodHandleStatics.UNSAFE.getInt(bb, VarHandleByteArrayBase.BUFFER_LIMIT) - 3, null);
        }

        @ForceInline
        static ScopedMemoryAccess.Scope scope(ByteBuffer bb) {
            MemorySegmentProxy segmentProxy = NIO_ACCESS.bufferSegment(bb);
            return segmentProxy != null ? segmentProxy.scope() : null;
        }

        @ForceInline
        static int indexRO(ByteBuffer bb, int index) {
            if (MethodHandleStatics.UNSAFE.getBoolean(bb, VarHandleByteArrayBase.BYTE_BUFFER_IS_READ_ONLY)) {
                throw new ReadOnlyBufferException();
            }
            return ByteBufferHandle.index(bb, index);
        }

        @ForceInline
        static long address(ByteBuffer bb, int index) {
            long address = (long)index + MethodHandleStatics.UNSAFE.getLong(bb, VarHandleByteArrayBase.BUFFER_ADDRESS);
            if ((address & 3L) != 0L) {
                throw VarHandleByteArrayBase.newIllegalStateExceptionForMisalignedAccess(index);
            }
            return address;
        }

        @ForceInline
        static int get(VarHandle ob, Object obb, int index) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return SCOPED_MEMORY_ACCESS.getIntUnaligned(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), (long)ByteBufferHandle.index(bb, index) + MethodHandleStatics.UNSAFE.getLong(bb, VarHandleByteArrayBase.BUFFER_ADDRESS), handle.be);
        }

        @ForceInline
        static void set(VarHandle ob, Object obb, int index, int value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            SCOPED_MEMORY_ACCESS.putIntUnaligned(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), (long)ByteBufferHandle.indexRO(bb, index) + MethodHandleStatics.UNSAFE.getLong(bb, VarHandleByteArrayBase.BUFFER_ADDRESS), value, handle.be);
        }

        @ForceInline
        static int getVolatile(VarHandle ob, Object obb, int index) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return VarHandleByteArrayAsInts.convEndian(handle.be, SCOPED_MEMORY_ACCESS.getIntVolatile(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.index(bb, index))));
        }

        @ForceInline
        static void setVolatile(VarHandle ob, Object obb, int index, int value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            SCOPED_MEMORY_ACCESS.putIntVolatile(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsInts.convEndian(handle.be, value));
        }

        @ForceInline
        static int getAcquire(VarHandle ob, Object obb, int index) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return VarHandleByteArrayAsInts.convEndian(handle.be, SCOPED_MEMORY_ACCESS.getIntAcquire(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.index(bb, index))));
        }

        @ForceInline
        static void setRelease(VarHandle ob, Object obb, int index, int value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            SCOPED_MEMORY_ACCESS.putIntRelease(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsInts.convEndian(handle.be, value));
        }

        @ForceInline
        static int getOpaque(VarHandle ob, Object obb, int index) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return VarHandleByteArrayAsInts.convEndian(handle.be, SCOPED_MEMORY_ACCESS.getIntOpaque(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.index(bb, index))));
        }

        @ForceInline
        static void setOpaque(VarHandle ob, Object obb, int index, int value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            SCOPED_MEMORY_ACCESS.putIntOpaque(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsInts.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean compareAndSet(VarHandle ob, Object obb, int index, int expected, int value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return SCOPED_MEMORY_ACCESS.compareAndSetInt(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsInts.convEndian(handle.be, expected), VarHandleByteArrayAsInts.convEndian(handle.be, value));
        }

        @ForceInline
        static int compareAndExchange(VarHandle ob, Object obb, int index, int expected, int value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return VarHandleByteArrayAsInts.convEndian(handle.be, SCOPED_MEMORY_ACCESS.compareAndExchangeInt(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsInts.convEndian(handle.be, expected), VarHandleByteArrayAsInts.convEndian(handle.be, value)));
        }

        @ForceInline
        static int compareAndExchangeAcquire(VarHandle ob, Object obb, int index, int expected, int value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return VarHandleByteArrayAsInts.convEndian(handle.be, SCOPED_MEMORY_ACCESS.compareAndExchangeIntAcquire(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsInts.convEndian(handle.be, expected), VarHandleByteArrayAsInts.convEndian(handle.be, value)));
        }

        @ForceInline
        static int compareAndExchangeRelease(VarHandle ob, Object obb, int index, int expected, int value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return VarHandleByteArrayAsInts.convEndian(handle.be, SCOPED_MEMORY_ACCESS.compareAndExchangeIntRelease(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsInts.convEndian(handle.be, expected), VarHandleByteArrayAsInts.convEndian(handle.be, value)));
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(VarHandle ob, Object obb, int index, int expected, int value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return SCOPED_MEMORY_ACCESS.weakCompareAndSetIntPlain(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsInts.convEndian(handle.be, expected), VarHandleByteArrayAsInts.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean weakCompareAndSet(VarHandle ob, Object obb, int index, int expected, int value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return SCOPED_MEMORY_ACCESS.weakCompareAndSetInt(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsInts.convEndian(handle.be, expected), VarHandleByteArrayAsInts.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(VarHandle ob, Object obb, int index, int expected, int value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return SCOPED_MEMORY_ACCESS.weakCompareAndSetIntAcquire(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsInts.convEndian(handle.be, expected), VarHandleByteArrayAsInts.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(VarHandle ob, Object obb, int index, int expected, int value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return SCOPED_MEMORY_ACCESS.weakCompareAndSetIntRelease(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsInts.convEndian(handle.be, expected), VarHandleByteArrayAsInts.convEndian(handle.be, value));
        }

        @ForceInline
        static int getAndSet(VarHandle ob, Object obb, int index, int value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return VarHandleByteArrayAsInts.convEndian(handle.be, SCOPED_MEMORY_ACCESS.getAndSetInt(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsInts.convEndian(handle.be, value)));
        }

        @ForceInline
        static int getAndSetAcquire(VarHandle ob, Object obb, int index, int value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return VarHandleByteArrayAsInts.convEndian(handle.be, SCOPED_MEMORY_ACCESS.getAndSetIntAcquire(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsInts.convEndian(handle.be, value)));
        }

        @ForceInline
        static int getAndSetRelease(VarHandle ob, Object obb, int index, int value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return VarHandleByteArrayAsInts.convEndian(handle.be, SCOPED_MEMORY_ACCESS.getAndSetIntRelease(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsInts.convEndian(handle.be, value)));
        }

        @ForceInline
        static int getAndAdd(VarHandle ob, Object obb, int index, int delta) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            if (handle.be == VarHandleByteArrayBase.BE) {
                return SCOPED_MEMORY_ACCESS.getAndAddInt(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), delta);
            }
            return ByteBufferHandle.getAndAddConvEndianWithCAS(bb, index, delta);
        }

        @ForceInline
        static int getAndAddAcquire(VarHandle ob, Object obb, int index, int delta) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            if (handle.be == VarHandleByteArrayBase.BE) {
                return SCOPED_MEMORY_ACCESS.getAndAddIntAcquire(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), delta);
            }
            return ByteBufferHandle.getAndAddConvEndianWithCAS(bb, index, delta);
        }

        @ForceInline
        static int getAndAddRelease(VarHandle ob, Object obb, int index, int delta) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            if (handle.be == VarHandleByteArrayBase.BE) {
                return SCOPED_MEMORY_ACCESS.getAndAddIntRelease(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), delta);
            }
            return ByteBufferHandle.getAndAddConvEndianWithCAS(bb, index, delta);
        }

        @ForceInline
        static int getAndAddConvEndianWithCAS(ByteBuffer bb, int index, int delta) {
            int expectedValue;
            int nativeExpectedValue;
            Object base = MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB);
            long offset = ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index));
            while (!MethodHandleStatics.UNSAFE.weakCompareAndSetInt(base, offset, nativeExpectedValue = SCOPED_MEMORY_ACCESS.getIntVolatile(ByteBufferHandle.scope(bb), base, offset), Integer.reverseBytes((expectedValue = Integer.reverseBytes(nativeExpectedValue)) + delta))) {
            }
            return expectedValue;
        }

        @ForceInline
        static int getAndBitwiseOr(VarHandle ob, Object obb, int index, int value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            if (handle.be == VarHandleByteArrayBase.BE) {
                return SCOPED_MEMORY_ACCESS.getAndBitwiseOrInt(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), value);
            }
            return ByteBufferHandle.getAndBitwiseOrConvEndianWithCAS(bb, index, value);
        }

        @ForceInline
        static int getAndBitwiseOrRelease(VarHandle ob, Object obb, int index, int value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            if (handle.be == VarHandleByteArrayBase.BE) {
                return SCOPED_MEMORY_ACCESS.getAndBitwiseOrIntRelease(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), value);
            }
            return ByteBufferHandle.getAndBitwiseOrConvEndianWithCAS(bb, index, value);
        }

        @ForceInline
        static int getAndBitwiseOrAcquire(VarHandle ob, Object obb, int index, int value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            if (handle.be == VarHandleByteArrayBase.BE) {
                return SCOPED_MEMORY_ACCESS.getAndBitwiseOrIntAcquire(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), value);
            }
            return ByteBufferHandle.getAndBitwiseOrConvEndianWithCAS(bb, index, value);
        }

        @ForceInline
        static int getAndBitwiseOrConvEndianWithCAS(ByteBuffer bb, int index, int value) {
            int expectedValue;
            int nativeExpectedValue;
            Object base = MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB);
            long offset = ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index));
            while (!MethodHandleStatics.UNSAFE.weakCompareAndSetInt(base, offset, nativeExpectedValue = SCOPED_MEMORY_ACCESS.getIntVolatile(ByteBufferHandle.scope(bb), base, offset), Integer.reverseBytes((expectedValue = Integer.reverseBytes(nativeExpectedValue)) | value))) {
            }
            return expectedValue;
        }

        @ForceInline
        static int getAndBitwiseAnd(VarHandle ob, Object obb, int index, int value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            if (handle.be == VarHandleByteArrayBase.BE) {
                return SCOPED_MEMORY_ACCESS.getAndBitwiseAndInt(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), value);
            }
            return ByteBufferHandle.getAndBitwiseAndConvEndianWithCAS(bb, index, value);
        }

        @ForceInline
        static int getAndBitwiseAndRelease(VarHandle ob, Object obb, int index, int value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            if (handle.be == VarHandleByteArrayBase.BE) {
                return SCOPED_MEMORY_ACCESS.getAndBitwiseAndIntRelease(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), value);
            }
            return ByteBufferHandle.getAndBitwiseAndConvEndianWithCAS(bb, index, value);
        }

        @ForceInline
        static int getAndBitwiseAndAcquire(VarHandle ob, Object obb, int index, int value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            if (handle.be == VarHandleByteArrayBase.BE) {
                return SCOPED_MEMORY_ACCESS.getAndBitwiseAndIntAcquire(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), value);
            }
            return ByteBufferHandle.getAndBitwiseAndConvEndianWithCAS(bb, index, value);
        }

        @ForceInline
        static int getAndBitwiseAndConvEndianWithCAS(ByteBuffer bb, int index, int value) {
            int expectedValue;
            int nativeExpectedValue;
            Object base = MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB);
            long offset = ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index));
            while (!MethodHandleStatics.UNSAFE.weakCompareAndSetInt(base, offset, nativeExpectedValue = SCOPED_MEMORY_ACCESS.getIntVolatile(ByteBufferHandle.scope(bb), base, offset), Integer.reverseBytes((expectedValue = Integer.reverseBytes(nativeExpectedValue)) & value))) {
            }
            return expectedValue;
        }

        @ForceInline
        static int getAndBitwiseXor(VarHandle ob, Object obb, int index, int value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            if (handle.be == VarHandleByteArrayBase.BE) {
                return SCOPED_MEMORY_ACCESS.getAndBitwiseXorInt(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), value);
            }
            return ByteBufferHandle.getAndBitwiseXorConvEndianWithCAS(bb, index, value);
        }

        @ForceInline
        static int getAndBitwiseXorRelease(VarHandle ob, Object obb, int index, int value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            if (handle.be == VarHandleByteArrayBase.BE) {
                return SCOPED_MEMORY_ACCESS.getAndBitwiseXorIntRelease(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), value);
            }
            return ByteBufferHandle.getAndBitwiseXorConvEndianWithCAS(bb, index, value);
        }

        @ForceInline
        static int getAndBitwiseXorAcquire(VarHandle ob, Object obb, int index, int value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            if (handle.be == VarHandleByteArrayBase.BE) {
                return SCOPED_MEMORY_ACCESS.getAndBitwiseXorIntAcquire(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), value);
            }
            return ByteBufferHandle.getAndBitwiseXorConvEndianWithCAS(bb, index, value);
        }

        @ForceInline
        static int getAndBitwiseXorConvEndianWithCAS(ByteBuffer bb, int index, int value) {
            int expectedValue;
            int nativeExpectedValue;
            Object base = MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB);
            long offset = ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index));
            while (!MethodHandleStatics.UNSAFE.weakCompareAndSetInt(base, offset, nativeExpectedValue = SCOPED_MEMORY_ACCESS.getIntVolatile(ByteBufferHandle.scope(bb), base, offset), Integer.reverseBytes((expectedValue = Integer.reverseBytes(nativeExpectedValue)) ^ value))) {
            }
            return expectedValue;
        }
    }

    static final class ArrayHandle
    extends ByteArrayViewVarHandle {
        private static final BiFunction<String, List<Number>, ArrayIndexOutOfBoundsException> OOBEF = Preconditions.outOfBoundsExceptionFormatter(ArrayIndexOutOfBoundsException::new);
        static final VarForm FORM = new VarForm(ArrayHandle.class, byte[].class, Integer.TYPE, Integer.TYPE);

        ArrayHandle(boolean be) {
            this(be, false);
        }

        private ArrayHandle(boolean be, boolean exact) {
            super(FORM, be, exact);
        }

        @Override
        public ArrayHandle withInvokeExactBehavior() {
            return this.hasInvokeExactBehavior() ? this : new ArrayHandle(this.be, true);
        }

        @Override
        public ArrayHandle withInvokeBehavior() {
            return !this.hasInvokeExactBehavior() ? this : new ArrayHandle(this.be, false);
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessType at) {
            return at.accessModeType(byte[].class, Integer.TYPE, Integer.TYPE);
        }

        @ForceInline
        static int index(byte[] ba, int index) {
            return Preconditions.checkIndex(index, ba.length - 3, OOBEF);
        }

        @ForceInline
        static long address(byte[] ba, int index) {
            long address = (long)index + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET;
            if ((address & 3L) != 0L) {
                throw VarHandleByteArrayBase.newIllegalStateExceptionForMisalignedAccess(index);
            }
            return address;
        }

        @ForceInline
        static int get(VarHandle ob, Object oba, int index) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return MethodHandleStatics.UNSAFE.getIntUnaligned(ba, (long)ArrayHandle.index(ba, index) + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET, handle.be);
        }

        @ForceInline
        static void set(VarHandle ob, Object oba, int index, int value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            MethodHandleStatics.UNSAFE.putIntUnaligned(ba, (long)ArrayHandle.index(ba, index) + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET, value, handle.be);
        }

        @ForceInline
        static int getVolatile(VarHandle ob, Object oba, int index) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsInts.convEndian(handle.be, MethodHandleStatics.UNSAFE.getIntVolatile(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index))));
        }

        @ForceInline
        static void setVolatile(VarHandle ob, Object oba, int index, int value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            MethodHandleStatics.UNSAFE.putIntVolatile(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsInts.convEndian(handle.be, value));
        }

        @ForceInline
        static int getAcquire(VarHandle ob, Object oba, int index) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsInts.convEndian(handle.be, MethodHandleStatics.UNSAFE.getIntAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index))));
        }

        @ForceInline
        static void setRelease(VarHandle ob, Object oba, int index, int value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            MethodHandleStatics.UNSAFE.putIntRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsInts.convEndian(handle.be, value));
        }

        @ForceInline
        static int getOpaque(VarHandle ob, Object oba, int index) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsInts.convEndian(handle.be, MethodHandleStatics.UNSAFE.getIntOpaque(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index))));
        }

        @ForceInline
        static void setOpaque(VarHandle ob, Object oba, int index, int value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            MethodHandleStatics.UNSAFE.putIntOpaque(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsInts.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean compareAndSet(VarHandle ob, Object oba, int index, int expected, int value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return MethodHandleStatics.UNSAFE.compareAndSetInt(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsInts.convEndian(handle.be, expected), VarHandleByteArrayAsInts.convEndian(handle.be, value));
        }

        @ForceInline
        static int compareAndExchange(VarHandle ob, Object oba, int index, int expected, int value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsInts.convEndian(handle.be, MethodHandleStatics.UNSAFE.compareAndExchangeInt(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsInts.convEndian(handle.be, expected), VarHandleByteArrayAsInts.convEndian(handle.be, value)));
        }

        @ForceInline
        static int compareAndExchangeAcquire(VarHandle ob, Object oba, int index, int expected, int value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsInts.convEndian(handle.be, MethodHandleStatics.UNSAFE.compareAndExchangeIntAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsInts.convEndian(handle.be, expected), VarHandleByteArrayAsInts.convEndian(handle.be, value)));
        }

        @ForceInline
        static int compareAndExchangeRelease(VarHandle ob, Object oba, int index, int expected, int value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsInts.convEndian(handle.be, MethodHandleStatics.UNSAFE.compareAndExchangeIntRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsInts.convEndian(handle.be, expected), VarHandleByteArrayAsInts.convEndian(handle.be, value)));
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(VarHandle ob, Object oba, int index, int expected, int value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetIntPlain(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsInts.convEndian(handle.be, expected), VarHandleByteArrayAsInts.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean weakCompareAndSet(VarHandle ob, Object oba, int index, int expected, int value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetInt(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsInts.convEndian(handle.be, expected), VarHandleByteArrayAsInts.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(VarHandle ob, Object oba, int index, int expected, int value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetIntAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsInts.convEndian(handle.be, expected), VarHandleByteArrayAsInts.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(VarHandle ob, Object oba, int index, int expected, int value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetIntRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsInts.convEndian(handle.be, expected), VarHandleByteArrayAsInts.convEndian(handle.be, value));
        }

        @ForceInline
        static int getAndSet(VarHandle ob, Object oba, int index, int value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsInts.convEndian(handle.be, MethodHandleStatics.UNSAFE.getAndSetInt(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsInts.convEndian(handle.be, value)));
        }

        @ForceInline
        static int getAndSetAcquire(VarHandle ob, Object oba, int index, int value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsInts.convEndian(handle.be, MethodHandleStatics.UNSAFE.getAndSetIntAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsInts.convEndian(handle.be, value)));
        }

        @ForceInline
        static int getAndSetRelease(VarHandle ob, Object oba, int index, int value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsInts.convEndian(handle.be, MethodHandleStatics.UNSAFE.getAndSetIntRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsInts.convEndian(handle.be, value)));
        }

        @ForceInline
        static int getAndAdd(VarHandle ob, Object oba, int index, int delta) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndAddInt(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), delta);
            }
            return ArrayHandle.getAndAddConvEndianWithCAS(ba, index, delta);
        }

        @ForceInline
        static int getAndAddAcquire(VarHandle ob, Object oba, int index, int delta) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndAddIntAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), delta);
            }
            return ArrayHandle.getAndAddConvEndianWithCAS(ba, index, delta);
        }

        @ForceInline
        static int getAndAddRelease(VarHandle ob, Object oba, int index, int delta) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndAddIntRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), delta);
            }
            return ArrayHandle.getAndAddConvEndianWithCAS(ba, index, delta);
        }

        @ForceInline
        static int getAndAddConvEndianWithCAS(byte[] ba, int index, int delta) {
            int expectedValue;
            int nativeExpectedValue;
            long offset = ArrayHandle.address(ba, ArrayHandle.index(ba, index));
            while (!MethodHandleStatics.UNSAFE.weakCompareAndSetInt(ba, offset, nativeExpectedValue = MethodHandleStatics.UNSAFE.getIntVolatile(ba, offset), Integer.reverseBytes((expectedValue = Integer.reverseBytes(nativeExpectedValue)) + delta))) {
            }
            return expectedValue;
        }

        @ForceInline
        static int getAndBitwiseOr(VarHandle ob, Object oba, int index, int value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseOrInt(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), value);
            }
            return ArrayHandle.getAndBitwiseOrConvEndianWithCAS(ba, index, value);
        }

        @ForceInline
        static int getAndBitwiseOrRelease(VarHandle ob, Object oba, int index, int value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseOrIntRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), value);
            }
            return ArrayHandle.getAndBitwiseOrConvEndianWithCAS(ba, index, value);
        }

        @ForceInline
        static int getAndBitwiseOrAcquire(VarHandle ob, Object oba, int index, int value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseOrIntAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), value);
            }
            return ArrayHandle.getAndBitwiseOrConvEndianWithCAS(ba, index, value);
        }

        @ForceInline
        static int getAndBitwiseOrConvEndianWithCAS(byte[] ba, int index, int value) {
            int expectedValue;
            int nativeExpectedValue;
            long offset = ArrayHandle.address(ba, ArrayHandle.index(ba, index));
            while (!MethodHandleStatics.UNSAFE.weakCompareAndSetInt(ba, offset, nativeExpectedValue = MethodHandleStatics.UNSAFE.getIntVolatile(ba, offset), Integer.reverseBytes((expectedValue = Integer.reverseBytes(nativeExpectedValue)) | value))) {
            }
            return expectedValue;
        }

        @ForceInline
        static int getAndBitwiseAnd(VarHandle ob, Object oba, int index, int value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseAndInt(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), value);
            }
            return ArrayHandle.getAndBitwiseAndConvEndianWithCAS(ba, index, value);
        }

        @ForceInline
        static int getAndBitwiseAndRelease(VarHandle ob, Object oba, int index, int value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseAndIntRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), value);
            }
            return ArrayHandle.getAndBitwiseAndConvEndianWithCAS(ba, index, value);
        }

        @ForceInline
        static int getAndBitwiseAndAcquire(VarHandle ob, Object oba, int index, int value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseAndIntAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), value);
            }
            return ArrayHandle.getAndBitwiseAndConvEndianWithCAS(ba, index, value);
        }

        @ForceInline
        static int getAndBitwiseAndConvEndianWithCAS(byte[] ba, int index, int value) {
            int expectedValue;
            int nativeExpectedValue;
            long offset = ArrayHandle.address(ba, ArrayHandle.index(ba, index));
            while (!MethodHandleStatics.UNSAFE.weakCompareAndSetInt(ba, offset, nativeExpectedValue = MethodHandleStatics.UNSAFE.getIntVolatile(ba, offset), Integer.reverseBytes((expectedValue = Integer.reverseBytes(nativeExpectedValue)) & value))) {
            }
            return expectedValue;
        }

        @ForceInline
        static int getAndBitwiseXor(VarHandle ob, Object oba, int index, int value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseXorInt(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), value);
            }
            return ArrayHandle.getAndBitwiseXorConvEndianWithCAS(ba, index, value);
        }

        @ForceInline
        static int getAndBitwiseXorRelease(VarHandle ob, Object oba, int index, int value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseXorIntRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), value);
            }
            return ArrayHandle.getAndBitwiseXorConvEndianWithCAS(ba, index, value);
        }

        @ForceInline
        static int getAndBitwiseXorAcquire(VarHandle ob, Object oba, int index, int value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseXorIntAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), value);
            }
            return ArrayHandle.getAndBitwiseXorConvEndianWithCAS(ba, index, value);
        }

        @ForceInline
        static int getAndBitwiseXorConvEndianWithCAS(byte[] ba, int index, int value) {
            int expectedValue;
            int nativeExpectedValue;
            long offset = ArrayHandle.address(ba, ArrayHandle.index(ba, index));
            while (!MethodHandleStatics.UNSAFE.weakCompareAndSetInt(ba, offset, nativeExpectedValue = MethodHandleStatics.UNSAFE.getIntVolatile(ba, offset), Integer.reverseBytes((expectedValue = Integer.reverseBytes(nativeExpectedValue)) ^ value))) {
            }
            return expectedValue;
        }
    }

    private static abstract class ByteArrayViewVarHandle
    extends VarHandle {
        final boolean be;

        ByteArrayViewVarHandle(VarForm form, boolean be, boolean exact) {
            super(form, exact);
            this.be = be;
        }
    }
}

