/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarForm;
import java.lang.invoke.VarHandle;
import java.lang.invoke.VarHandleByteArrayBase;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import jdk.internal.access.JavaNioAccess;
import jdk.internal.access.SharedSecrets;
import jdk.internal.access.foreign.MemorySegmentProxy;
import jdk.internal.misc.ScopedMemoryAccess;
import jdk.internal.misc.Unsafe;
import jdk.internal.util.Preconditions;
import jdk.internal.vm.annotation.ForceInline;

final class VarHandleByteArrayAsLongs
extends VarHandleByteArrayBase {
    static final JavaNioAccess NIO_ACCESS = SharedSecrets.getJavaNioAccess();
    static final int ALIGN = 7;
    static final ScopedMemoryAccess SCOPED_MEMORY_ACCESS = ScopedMemoryAccess.getScopedMemoryAccess();

    VarHandleByteArrayAsLongs() {
    }

    @ForceInline
    static long convEndian(boolean big, long n) {
        return big == BE ? n : Long.reverseBytes(n);
    }

    static final class ByteBufferHandle
    extends ByteArrayViewVarHandle {
        static final VarForm FORM = new VarForm(ByteBufferHandle.class, ByteBuffer.class, Long.TYPE, Integer.TYPE);

        ByteBufferHandle(boolean be) {
            this(be, false);
        }

        private ByteBufferHandle(boolean be, boolean exact) {
            super(FORM, be, exact);
        }

        @Override
        public ByteBufferHandle withInvokeExactBehavior() {
            return this.hasInvokeExactBehavior() ? this : new ByteBufferHandle(this.be, true);
        }

        @Override
        public ByteBufferHandle withInvokeBehavior() {
            return !this.hasInvokeExactBehavior() ? this : new ByteBufferHandle(this.be, false);
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessType at) {
            return at.accessModeType(ByteBuffer.class, Long.TYPE, Integer.TYPE);
        }

        @ForceInline
        static int index(ByteBuffer bb, int index) {
            MemorySegmentProxy segmentProxy = NIO_ACCESS.bufferSegment(bb);
            return Preconditions.checkIndex(index, MethodHandleStatics.UNSAFE.getInt(bb, VarHandleByteArrayBase.BUFFER_LIMIT) - 7, null);
        }

        @ForceInline
        static ScopedMemoryAccess.Scope scope(ByteBuffer bb) {
            MemorySegmentProxy segmentProxy = NIO_ACCESS.bufferSegment(bb);
            return segmentProxy != null ? segmentProxy.scope() : null;
        }

        @ForceInline
        static int indexRO(ByteBuffer bb, int index) {
            if (MethodHandleStatics.UNSAFE.getBoolean(bb, VarHandleByteArrayBase.BYTE_BUFFER_IS_READ_ONLY)) {
                throw new ReadOnlyBufferException();
            }
            return ByteBufferHandle.index(bb, index);
        }

        @ForceInline
        static long address(ByteBuffer bb, int index) {
            long address = (long)index + MethodHandleStatics.UNSAFE.getLong(bb, VarHandleByteArrayBase.BUFFER_ADDRESS);
            if ((address & 7L) != 0L) {
                throw VarHandleByteArrayBase.newIllegalStateExceptionForMisalignedAccess(index);
            }
            return address;
        }

        @ForceInline
        static long get(VarHandle ob, Object obb, int index) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return SCOPED_MEMORY_ACCESS.getLongUnaligned(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), (long)ByteBufferHandle.index(bb, index) + MethodHandleStatics.UNSAFE.getLong(bb, VarHandleByteArrayBase.BUFFER_ADDRESS), handle.be);
        }

        @ForceInline
        static void set(VarHandle ob, Object obb, int index, long value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            SCOPED_MEMORY_ACCESS.putLongUnaligned(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), (long)ByteBufferHandle.indexRO(bb, index) + MethodHandleStatics.UNSAFE.getLong(bb, VarHandleByteArrayBase.BUFFER_ADDRESS), value, handle.be);
        }

        @ForceInline
        static long getVolatile(VarHandle ob, Object obb, int index) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return VarHandleByteArrayAsLongs.convEndian(handle.be, SCOPED_MEMORY_ACCESS.getLongVolatile(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.index(bb, index))));
        }

        @ForceInline
        static void setVolatile(VarHandle ob, Object obb, int index, long value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            SCOPED_MEMORY_ACCESS.putLongVolatile(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, value));
        }

        @ForceInline
        static long getAcquire(VarHandle ob, Object obb, int index) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return VarHandleByteArrayAsLongs.convEndian(handle.be, SCOPED_MEMORY_ACCESS.getLongAcquire(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.index(bb, index))));
        }

        @ForceInline
        static void setRelease(VarHandle ob, Object obb, int index, long value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            SCOPED_MEMORY_ACCESS.putLongRelease(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, value));
        }

        @ForceInline
        static long getOpaque(VarHandle ob, Object obb, int index) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return VarHandleByteArrayAsLongs.convEndian(handle.be, SCOPED_MEMORY_ACCESS.getLongOpaque(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.index(bb, index))));
        }

        @ForceInline
        static void setOpaque(VarHandle ob, Object obb, int index, long value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            SCOPED_MEMORY_ACCESS.putLongOpaque(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean compareAndSet(VarHandle ob, Object obb, int index, long expected, long value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return SCOPED_MEMORY_ACCESS.compareAndSetLong(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, expected), VarHandleByteArrayAsLongs.convEndian(handle.be, value));
        }

        @ForceInline
        static long compareAndExchange(VarHandle ob, Object obb, int index, long expected, long value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return VarHandleByteArrayAsLongs.convEndian(handle.be, SCOPED_MEMORY_ACCESS.compareAndExchangeLong(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, expected), VarHandleByteArrayAsLongs.convEndian(handle.be, value)));
        }

        @ForceInline
        static long compareAndExchangeAcquire(VarHandle ob, Object obb, int index, long expected, long value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return VarHandleByteArrayAsLongs.convEndian(handle.be, SCOPED_MEMORY_ACCESS.compareAndExchangeLongAcquire(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, expected), VarHandleByteArrayAsLongs.convEndian(handle.be, value)));
        }

        @ForceInline
        static long compareAndExchangeRelease(VarHandle ob, Object obb, int index, long expected, long value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return VarHandleByteArrayAsLongs.convEndian(handle.be, SCOPED_MEMORY_ACCESS.compareAndExchangeLongRelease(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, expected), VarHandleByteArrayAsLongs.convEndian(handle.be, value)));
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(VarHandle ob, Object obb, int index, long expected, long value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return SCOPED_MEMORY_ACCESS.weakCompareAndSetLongPlain(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, expected), VarHandleByteArrayAsLongs.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean weakCompareAndSet(VarHandle ob, Object obb, int index, long expected, long value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return SCOPED_MEMORY_ACCESS.weakCompareAndSetLong(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, expected), VarHandleByteArrayAsLongs.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(VarHandle ob, Object obb, int index, long expected, long value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return SCOPED_MEMORY_ACCESS.weakCompareAndSetLongAcquire(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, expected), VarHandleByteArrayAsLongs.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(VarHandle ob, Object obb, int index, long expected, long value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return SCOPED_MEMORY_ACCESS.weakCompareAndSetLongRelease(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, expected), VarHandleByteArrayAsLongs.convEndian(handle.be, value));
        }

        @ForceInline
        static long getAndSet(VarHandle ob, Object obb, int index, long value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return VarHandleByteArrayAsLongs.convEndian(handle.be, SCOPED_MEMORY_ACCESS.getAndSetLong(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, value)));
        }

        @ForceInline
        static long getAndSetAcquire(VarHandle ob, Object obb, int index, long value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return VarHandleByteArrayAsLongs.convEndian(handle.be, SCOPED_MEMORY_ACCESS.getAndSetLongAcquire(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, value)));
        }

        @ForceInline
        static long getAndSetRelease(VarHandle ob, Object obb, int index, long value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return VarHandleByteArrayAsLongs.convEndian(handle.be, SCOPED_MEMORY_ACCESS.getAndSetLongRelease(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, value)));
        }

        @ForceInline
        static long getAndAdd(VarHandle ob, Object obb, int index, long delta) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            if (handle.be == VarHandleByteArrayBase.BE) {
                return SCOPED_MEMORY_ACCESS.getAndAddLong(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), delta);
            }
            return ByteBufferHandle.getAndAddConvEndianWithCAS(bb, index, delta);
        }

        @ForceInline
        static long getAndAddAcquire(VarHandle ob, Object obb, int index, long delta) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            if (handle.be == VarHandleByteArrayBase.BE) {
                return SCOPED_MEMORY_ACCESS.getAndAddLongAcquire(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), delta);
            }
            return ByteBufferHandle.getAndAddConvEndianWithCAS(bb, index, delta);
        }

        @ForceInline
        static long getAndAddRelease(VarHandle ob, Object obb, int index, long delta) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            if (handle.be == VarHandleByteArrayBase.BE) {
                return SCOPED_MEMORY_ACCESS.getAndAddLongRelease(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), delta);
            }
            return ByteBufferHandle.getAndAddConvEndianWithCAS(bb, index, delta);
        }

        @ForceInline
        static long getAndAddConvEndianWithCAS(ByteBuffer bb, int index, long delta) {
            long expectedValue;
            long nativeExpectedValue;
            Object base = MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB);
            long offset = ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index));
            while (!MethodHandleStatics.UNSAFE.weakCompareAndSetLong(base, offset, nativeExpectedValue = SCOPED_MEMORY_ACCESS.getLongVolatile(ByteBufferHandle.scope(bb), base, offset), Long.reverseBytes((expectedValue = Long.reverseBytes(nativeExpectedValue)) + delta))) {
            }
            return expectedValue;
        }

        @ForceInline
        static long getAndBitwiseOr(VarHandle ob, Object obb, int index, long value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            if (handle.be == VarHandleByteArrayBase.BE) {
                return SCOPED_MEMORY_ACCESS.getAndBitwiseOrLong(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), value);
            }
            return ByteBufferHandle.getAndBitwiseOrConvEndianWithCAS(bb, index, value);
        }

        @ForceInline
        static long getAndBitwiseOrRelease(VarHandle ob, Object obb, int index, long value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            if (handle.be == VarHandleByteArrayBase.BE) {
                return SCOPED_MEMORY_ACCESS.getAndBitwiseOrLongRelease(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), value);
            }
            return ByteBufferHandle.getAndBitwiseOrConvEndianWithCAS(bb, index, value);
        }

        @ForceInline
        static long getAndBitwiseOrAcquire(VarHandle ob, Object obb, int index, long value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            if (handle.be == VarHandleByteArrayBase.BE) {
                return SCOPED_MEMORY_ACCESS.getAndBitwiseOrLongAcquire(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), value);
            }
            return ByteBufferHandle.getAndBitwiseOrConvEndianWithCAS(bb, index, value);
        }

        @ForceInline
        static long getAndBitwiseOrConvEndianWithCAS(ByteBuffer bb, int index, long value) {
            long expectedValue;
            long nativeExpectedValue;
            Object base = MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB);
            long offset = ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index));
            while (!MethodHandleStatics.UNSAFE.weakCompareAndSetLong(base, offset, nativeExpectedValue = SCOPED_MEMORY_ACCESS.getLongVolatile(ByteBufferHandle.scope(bb), base, offset), Long.reverseBytes((expectedValue = Long.reverseBytes(nativeExpectedValue)) | value))) {
            }
            return expectedValue;
        }

        @ForceInline
        static long getAndBitwiseAnd(VarHandle ob, Object obb, int index, long value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            if (handle.be == VarHandleByteArrayBase.BE) {
                return SCOPED_MEMORY_ACCESS.getAndBitwiseAndLong(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), value);
            }
            return ByteBufferHandle.getAndBitwiseAndConvEndianWithCAS(bb, index, value);
        }

        @ForceInline
        static long getAndBitwiseAndRelease(VarHandle ob, Object obb, int index, long value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            if (handle.be == VarHandleByteArrayBase.BE) {
                return SCOPED_MEMORY_ACCESS.getAndBitwiseAndLongRelease(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), value);
            }
            return ByteBufferHandle.getAndBitwiseAndConvEndianWithCAS(bb, index, value);
        }

        @ForceInline
        static long getAndBitwiseAndAcquire(VarHandle ob, Object obb, int index, long value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            if (handle.be == VarHandleByteArrayBase.BE) {
                return SCOPED_MEMORY_ACCESS.getAndBitwiseAndLongAcquire(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), value);
            }
            return ByteBufferHandle.getAndBitwiseAndConvEndianWithCAS(bb, index, value);
        }

        @ForceInline
        static long getAndBitwiseAndConvEndianWithCAS(ByteBuffer bb, int index, long value) {
            long expectedValue;
            long nativeExpectedValue;
            Object base = MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB);
            long offset = ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index));
            while (!MethodHandleStatics.UNSAFE.weakCompareAndSetLong(base, offset, nativeExpectedValue = SCOPED_MEMORY_ACCESS.getLongVolatile(ByteBufferHandle.scope(bb), base, offset), Long.reverseBytes((expectedValue = Long.reverseBytes(nativeExpectedValue)) & value))) {
            }
            return expectedValue;
        }

        @ForceInline
        static long getAndBitwiseXor(VarHandle ob, Object obb, int index, long value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            if (handle.be == VarHandleByteArrayBase.BE) {
                return SCOPED_MEMORY_ACCESS.getAndBitwiseXorLong(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), value);
            }
            return ByteBufferHandle.getAndBitwiseXorConvEndianWithCAS(bb, index, value);
        }

        @ForceInline
        static long getAndBitwiseXorRelease(VarHandle ob, Object obb, int index, long value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            if (handle.be == VarHandleByteArrayBase.BE) {
                return SCOPED_MEMORY_ACCESS.getAndBitwiseXorLongRelease(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), value);
            }
            return ByteBufferHandle.getAndBitwiseXorConvEndianWithCAS(bb, index, value);
        }

        @ForceInline
        static long getAndBitwiseXorAcquire(VarHandle ob, Object obb, int index, long value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            if (handle.be == VarHandleByteArrayBase.BE) {
                return SCOPED_MEMORY_ACCESS.getAndBitwiseXorLongAcquire(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), value);
            }
            return ByteBufferHandle.getAndBitwiseXorConvEndianWithCAS(bb, index, value);
        }

        @ForceInline
        static long getAndBitwiseXorConvEndianWithCAS(ByteBuffer bb, int index, long value) {
            long expectedValue;
            long nativeExpectedValue;
            Object base = MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB);
            long offset = ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index));
            while (!MethodHandleStatics.UNSAFE.weakCompareAndSetLong(base, offset, nativeExpectedValue = SCOPED_MEMORY_ACCESS.getLongVolatile(ByteBufferHandle.scope(bb), base, offset), Long.reverseBytes((expectedValue = Long.reverseBytes(nativeExpectedValue)) ^ value))) {
            }
            return expectedValue;
        }
    }

    static final class ArrayHandle
    extends ByteArrayViewVarHandle {
        private static final BiFunction<String, List<Number>, ArrayIndexOutOfBoundsException> OOBEF = Preconditions.outOfBoundsExceptionFormatter(ArrayIndexOutOfBoundsException::new);
        static final VarForm FORM = new VarForm(ArrayHandle.class, byte[].class, Long.TYPE, Integer.TYPE);

        ArrayHandle(boolean be) {
            this(be, false);
        }

        private ArrayHandle(boolean be, boolean exact) {
            super(FORM, be, exact);
        }

        @Override
        public ArrayHandle withInvokeExactBehavior() {
            return this.hasInvokeExactBehavior() ? this : new ArrayHandle(this.be, true);
        }

        @Override
        public ArrayHandle withInvokeBehavior() {
            return !this.hasInvokeExactBehavior() ? this : new ArrayHandle(this.be, false);
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessType at) {
            return at.accessModeType(byte[].class, Long.TYPE, Integer.TYPE);
        }

        @ForceInline
        static int index(byte[] ba, int index) {
            return Preconditions.checkIndex(index, ba.length - 7, OOBEF);
        }

        @ForceInline
        static long address(byte[] ba, int index) {
            long address = (long)index + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET;
            if ((address & 7L) != 0L) {
                throw VarHandleByteArrayBase.newIllegalStateExceptionForMisalignedAccess(index);
            }
            return address;
        }

        @ForceInline
        static long get(VarHandle ob, Object oba, int index) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return MethodHandleStatics.UNSAFE.getLongUnaligned(ba, (long)ArrayHandle.index(ba, index) + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET, handle.be);
        }

        @ForceInline
        static void set(VarHandle ob, Object oba, int index, long value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            MethodHandleStatics.UNSAFE.putLongUnaligned(ba, (long)ArrayHandle.index(ba, index) + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET, value, handle.be);
        }

        @ForceInline
        static long getVolatile(VarHandle ob, Object oba, int index) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsLongs.convEndian(handle.be, MethodHandleStatics.UNSAFE.getLongVolatile(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index))));
        }

        @ForceInline
        static void setVolatile(VarHandle ob, Object oba, int index, long value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            MethodHandleStatics.UNSAFE.putLongVolatile(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, value));
        }

        @ForceInline
        static long getAcquire(VarHandle ob, Object oba, int index) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsLongs.convEndian(handle.be, MethodHandleStatics.UNSAFE.getLongAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index))));
        }

        @ForceInline
        static void setRelease(VarHandle ob, Object oba, int index, long value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            MethodHandleStatics.UNSAFE.putLongRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, value));
        }

        @ForceInline
        static long getOpaque(VarHandle ob, Object oba, int index) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsLongs.convEndian(handle.be, MethodHandleStatics.UNSAFE.getLongOpaque(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index))));
        }

        @ForceInline
        static void setOpaque(VarHandle ob, Object oba, int index, long value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            MethodHandleStatics.UNSAFE.putLongOpaque(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean compareAndSet(VarHandle ob, Object oba, int index, long expected, long value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return MethodHandleStatics.UNSAFE.compareAndSetLong(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, expected), VarHandleByteArrayAsLongs.convEndian(handle.be, value));
        }

        @ForceInline
        static long compareAndExchange(VarHandle ob, Object oba, int index, long expected, long value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsLongs.convEndian(handle.be, MethodHandleStatics.UNSAFE.compareAndExchangeLong(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, expected), VarHandleByteArrayAsLongs.convEndian(handle.be, value)));
        }

        @ForceInline
        static long compareAndExchangeAcquire(VarHandle ob, Object oba, int index, long expected, long value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsLongs.convEndian(handle.be, MethodHandleStatics.UNSAFE.compareAndExchangeLongAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, expected), VarHandleByteArrayAsLongs.convEndian(handle.be, value)));
        }

        @ForceInline
        static long compareAndExchangeRelease(VarHandle ob, Object oba, int index, long expected, long value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsLongs.convEndian(handle.be, MethodHandleStatics.UNSAFE.compareAndExchangeLongRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, expected), VarHandleByteArrayAsLongs.convEndian(handle.be, value)));
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(VarHandle ob, Object oba, int index, long expected, long value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetLongPlain(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, expected), VarHandleByteArrayAsLongs.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean weakCompareAndSet(VarHandle ob, Object oba, int index, long expected, long value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetLong(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, expected), VarHandleByteArrayAsLongs.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(VarHandle ob, Object oba, int index, long expected, long value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetLongAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, expected), VarHandleByteArrayAsLongs.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(VarHandle ob, Object oba, int index, long expected, long value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetLongRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, expected), VarHandleByteArrayAsLongs.convEndian(handle.be, value));
        }

        @ForceInline
        static long getAndSet(VarHandle ob, Object oba, int index, long value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsLongs.convEndian(handle.be, MethodHandleStatics.UNSAFE.getAndSetLong(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, value)));
        }

        @ForceInline
        static long getAndSetAcquire(VarHandle ob, Object oba, int index, long value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsLongs.convEndian(handle.be, MethodHandleStatics.UNSAFE.getAndSetLongAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, value)));
        }

        @ForceInline
        static long getAndSetRelease(VarHandle ob, Object oba, int index, long value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsLongs.convEndian(handle.be, MethodHandleStatics.UNSAFE.getAndSetLongRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, value)));
        }

        @ForceInline
        static long getAndAdd(VarHandle ob, Object oba, int index, long delta) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndAddLong(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), delta);
            }
            return ArrayHandle.getAndAddConvEndianWithCAS(ba, index, delta);
        }

        @ForceInline
        static long getAndAddAcquire(VarHandle ob, Object oba, int index, long delta) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndAddLongAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), delta);
            }
            return ArrayHandle.getAndAddConvEndianWithCAS(ba, index, delta);
        }

        @ForceInline
        static long getAndAddRelease(VarHandle ob, Object oba, int index, long delta) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndAddLongRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), delta);
            }
            return ArrayHandle.getAndAddConvEndianWithCAS(ba, index, delta);
        }

        @ForceInline
        static long getAndAddConvEndianWithCAS(byte[] ba, int index, long delta) {
            long expectedValue;
            long nativeExpectedValue;
            long offset = ArrayHandle.address(ba, ArrayHandle.index(ba, index));
            while (!MethodHandleStatics.UNSAFE.weakCompareAndSetLong(ba, offset, nativeExpectedValue = MethodHandleStatics.UNSAFE.getLongVolatile(ba, offset), Long.reverseBytes((expectedValue = Long.reverseBytes(nativeExpectedValue)) + delta))) {
            }
            return expectedValue;
        }

        @ForceInline
        static long getAndBitwiseOr(VarHandle ob, Object oba, int index, long value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseOrLong(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), value);
            }
            return ArrayHandle.getAndBitwiseOrConvEndianWithCAS(ba, index, value);
        }

        @ForceInline
        static long getAndBitwiseOrRelease(VarHandle ob, Object oba, int index, long value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseOrLongRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), value);
            }
            return ArrayHandle.getAndBitwiseOrConvEndianWithCAS(ba, index, value);
        }

        @ForceInline
        static long getAndBitwiseOrAcquire(VarHandle ob, Object oba, int index, long value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseOrLongAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), value);
            }
            return ArrayHandle.getAndBitwiseOrConvEndianWithCAS(ba, index, value);
        }

        @ForceInline
        static long getAndBitwiseOrConvEndianWithCAS(byte[] ba, int index, long value) {
            long expectedValue;
            long nativeExpectedValue;
            long offset = ArrayHandle.address(ba, ArrayHandle.index(ba, index));
            while (!MethodHandleStatics.UNSAFE.weakCompareAndSetLong(ba, offset, nativeExpectedValue = MethodHandleStatics.UNSAFE.getLongVolatile(ba, offset), Long.reverseBytes((expectedValue = Long.reverseBytes(nativeExpectedValue)) | value))) {
            }
            return expectedValue;
        }

        @ForceInline
        static long getAndBitwiseAnd(VarHandle ob, Object oba, int index, long value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseAndLong(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), value);
            }
            return ArrayHandle.getAndBitwiseAndConvEndianWithCAS(ba, index, value);
        }

        @ForceInline
        static long getAndBitwiseAndRelease(VarHandle ob, Object oba, int index, long value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseAndLongRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), value);
            }
            return ArrayHandle.getAndBitwiseAndConvEndianWithCAS(ba, index, value);
        }

        @ForceInline
        static long getAndBitwiseAndAcquire(VarHandle ob, Object oba, int index, long value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseAndLongAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), value);
            }
            return ArrayHandle.getAndBitwiseAndConvEndianWithCAS(ba, index, value);
        }

        @ForceInline
        static long getAndBitwiseAndConvEndianWithCAS(byte[] ba, int index, long value) {
            long expectedValue;
            long nativeExpectedValue;
            long offset = ArrayHandle.address(ba, ArrayHandle.index(ba, index));
            while (!MethodHandleStatics.UNSAFE.weakCompareAndSetLong(ba, offset, nativeExpectedValue = MethodHandleStatics.UNSAFE.getLongVolatile(ba, offset), Long.reverseBytes((expectedValue = Long.reverseBytes(nativeExpectedValue)) & value))) {
            }
            return expectedValue;
        }

        @ForceInline
        static long getAndBitwiseXor(VarHandle ob, Object oba, int index, long value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseXorLong(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), value);
            }
            return ArrayHandle.getAndBitwiseXorConvEndianWithCAS(ba, index, value);
        }

        @ForceInline
        static long getAndBitwiseXorRelease(VarHandle ob, Object oba, int index, long value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseXorLongRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), value);
            }
            return ArrayHandle.getAndBitwiseXorConvEndianWithCAS(ba, index, value);
        }

        @ForceInline
        static long getAndBitwiseXorAcquire(VarHandle ob, Object oba, int index, long value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseXorLongAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), value);
            }
            return ArrayHandle.getAndBitwiseXorConvEndianWithCAS(ba, index, value);
        }

        @ForceInline
        static long getAndBitwiseXorConvEndianWithCAS(byte[] ba, int index, long value) {
            long expectedValue;
            long nativeExpectedValue;
            long offset = ArrayHandle.address(ba, ArrayHandle.index(ba, index));
            while (!MethodHandleStatics.UNSAFE.weakCompareAndSetLong(ba, offset, nativeExpectedValue = MethodHandleStatics.UNSAFE.getLongVolatile(ba, offset), Long.reverseBytes((expectedValue = Long.reverseBytes(nativeExpectedValue)) ^ value))) {
            }
            return expectedValue;
        }
    }

    private static abstract class ByteArrayViewVarHandle
    extends VarHandle {
        final boolean be;

        ByteArrayViewVarHandle(VarForm form, boolean be, boolean exact) {
            super(form, exact);
            this.be = be;
        }
    }
}

