/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarForm;
import java.lang.invoke.VarHandle;
import java.lang.invoke.VarHandleByteArrayBase;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import jdk.internal.access.JavaNioAccess;
import jdk.internal.access.SharedSecrets;
import jdk.internal.access.foreign.MemorySegmentProxy;
import jdk.internal.misc.ScopedMemoryAccess;
import jdk.internal.misc.Unsafe;
import jdk.internal.util.Preconditions;
import jdk.internal.vm.annotation.ForceInline;

final class VarHandleByteArrayAsShorts
extends VarHandleByteArrayBase {
    static final JavaNioAccess NIO_ACCESS = SharedSecrets.getJavaNioAccess();
    static final int ALIGN = 1;
    static final ScopedMemoryAccess SCOPED_MEMORY_ACCESS = ScopedMemoryAccess.getScopedMemoryAccess();

    VarHandleByteArrayAsShorts() {
    }

    @ForceInline
    static short convEndian(boolean big, short n) {
        return big == BE ? n : Short.reverseBytes(n);
    }

    static final class ByteBufferHandle
    extends ByteArrayViewVarHandle {
        static final VarForm FORM = new VarForm(ByteBufferHandle.class, ByteBuffer.class, Short.TYPE, Integer.TYPE);

        ByteBufferHandle(boolean be) {
            this(be, false);
        }

        private ByteBufferHandle(boolean be, boolean exact) {
            super(FORM, be, exact);
        }

        @Override
        public ByteBufferHandle withInvokeExactBehavior() {
            return this.hasInvokeExactBehavior() ? this : new ByteBufferHandle(this.be, true);
        }

        @Override
        public ByteBufferHandle withInvokeBehavior() {
            return !this.hasInvokeExactBehavior() ? this : new ByteBufferHandle(this.be, false);
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessType at) {
            return at.accessModeType(ByteBuffer.class, Short.TYPE, Integer.TYPE);
        }

        @ForceInline
        static int index(ByteBuffer bb, int index) {
            MemorySegmentProxy segmentProxy = NIO_ACCESS.bufferSegment(bb);
            return Preconditions.checkIndex(index, MethodHandleStatics.UNSAFE.getInt(bb, VarHandleByteArrayBase.BUFFER_LIMIT) - 1, null);
        }

        @ForceInline
        static ScopedMemoryAccess.Scope scope(ByteBuffer bb) {
            MemorySegmentProxy segmentProxy = NIO_ACCESS.bufferSegment(bb);
            return segmentProxy != null ? segmentProxy.scope() : null;
        }

        @ForceInline
        static int indexRO(ByteBuffer bb, int index) {
            if (MethodHandleStatics.UNSAFE.getBoolean(bb, VarHandleByteArrayBase.BYTE_BUFFER_IS_READ_ONLY)) {
                throw new ReadOnlyBufferException();
            }
            return ByteBufferHandle.index(bb, index);
        }

        @ForceInline
        static long address(ByteBuffer bb, int index) {
            long address = (long)index + MethodHandleStatics.UNSAFE.getLong(bb, VarHandleByteArrayBase.BUFFER_ADDRESS);
            if ((address & 1L) != 0L) {
                throw VarHandleByteArrayBase.newIllegalStateExceptionForMisalignedAccess(index);
            }
            return address;
        }

        @ForceInline
        static short get(VarHandle ob, Object obb, int index) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return SCOPED_MEMORY_ACCESS.getShortUnaligned(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), (long)ByteBufferHandle.index(bb, index) + MethodHandleStatics.UNSAFE.getLong(bb, VarHandleByteArrayBase.BUFFER_ADDRESS), handle.be);
        }

        @ForceInline
        static void set(VarHandle ob, Object obb, int index, short value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            SCOPED_MEMORY_ACCESS.putShortUnaligned(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), (long)ByteBufferHandle.indexRO(bb, index) + MethodHandleStatics.UNSAFE.getLong(bb, VarHandleByteArrayBase.BUFFER_ADDRESS), value, handle.be);
        }

        @ForceInline
        static short getVolatile(VarHandle ob, Object obb, int index) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return VarHandleByteArrayAsShorts.convEndian(handle.be, SCOPED_MEMORY_ACCESS.getShortVolatile(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.index(bb, index))));
        }

        @ForceInline
        static void setVolatile(VarHandle ob, Object obb, int index, short value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            SCOPED_MEMORY_ACCESS.putShortVolatile(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsShorts.convEndian(handle.be, value));
        }

        @ForceInline
        static short getAcquire(VarHandle ob, Object obb, int index) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return VarHandleByteArrayAsShorts.convEndian(handle.be, SCOPED_MEMORY_ACCESS.getShortAcquire(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.index(bb, index))));
        }

        @ForceInline
        static void setRelease(VarHandle ob, Object obb, int index, short value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            SCOPED_MEMORY_ACCESS.putShortRelease(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsShorts.convEndian(handle.be, value));
        }

        @ForceInline
        static short getOpaque(VarHandle ob, Object obb, int index) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            return VarHandleByteArrayAsShorts.convEndian(handle.be, SCOPED_MEMORY_ACCESS.getShortOpaque(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.index(bb, index))));
        }

        @ForceInline
        static void setOpaque(VarHandle ob, Object obb, int index, short value) {
            ByteBufferHandle handle = (ByteBufferHandle)ob;
            ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(obb);
            SCOPED_MEMORY_ACCESS.putShortOpaque(ByteBufferHandle.scope(bb), MethodHandleStatics.UNSAFE.getReference(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsShorts.convEndian(handle.be, value));
        }
    }

    static final class ArrayHandle
    extends ByteArrayViewVarHandle {
        private static final BiFunction<String, List<Number>, ArrayIndexOutOfBoundsException> OOBEF = Preconditions.outOfBoundsExceptionFormatter(ArrayIndexOutOfBoundsException::new);
        static final VarForm FORM = new VarForm(ArrayHandle.class, byte[].class, Short.TYPE, Integer.TYPE);

        ArrayHandle(boolean be) {
            this(be, false);
        }

        private ArrayHandle(boolean be, boolean exact) {
            super(FORM, be, exact);
        }

        @Override
        public ArrayHandle withInvokeExactBehavior() {
            return this.hasInvokeExactBehavior() ? this : new ArrayHandle(this.be, true);
        }

        @Override
        public ArrayHandle withInvokeBehavior() {
            return !this.hasInvokeExactBehavior() ? this : new ArrayHandle(this.be, false);
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessType at) {
            return at.accessModeType(byte[].class, Short.TYPE, Integer.TYPE);
        }

        @ForceInline
        static int index(byte[] ba, int index) {
            return Preconditions.checkIndex(index, ba.length - 1, OOBEF);
        }

        @ForceInline
        static long address(byte[] ba, int index) {
            long address = (long)index + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET;
            if ((address & 1L) != 0L) {
                throw VarHandleByteArrayBase.newIllegalStateExceptionForMisalignedAccess(index);
            }
            return address;
        }

        @ForceInline
        static short get(VarHandle ob, Object oba, int index) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return MethodHandleStatics.UNSAFE.getShortUnaligned(ba, (long)ArrayHandle.index(ba, index) + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET, handle.be);
        }

        @ForceInline
        static void set(VarHandle ob, Object oba, int index, short value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            MethodHandleStatics.UNSAFE.putShortUnaligned(ba, (long)ArrayHandle.index(ba, index) + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET, value, handle.be);
        }

        @ForceInline
        static short getVolatile(VarHandle ob, Object oba, int index) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsShorts.convEndian(handle.be, MethodHandleStatics.UNSAFE.getShortVolatile(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index))));
        }

        @ForceInline
        static void setVolatile(VarHandle ob, Object oba, int index, short value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            MethodHandleStatics.UNSAFE.putShortVolatile(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsShorts.convEndian(handle.be, value));
        }

        @ForceInline
        static short getAcquire(VarHandle ob, Object oba, int index) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsShorts.convEndian(handle.be, MethodHandleStatics.UNSAFE.getShortAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index))));
        }

        @ForceInline
        static void setRelease(VarHandle ob, Object oba, int index, short value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            MethodHandleStatics.UNSAFE.putShortRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsShorts.convEndian(handle.be, value));
        }

        @ForceInline
        static short getOpaque(VarHandle ob, Object oba, int index) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsShorts.convEndian(handle.be, MethodHandleStatics.UNSAFE.getShortOpaque(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index))));
        }

        @ForceInline
        static void setOpaque(VarHandle ob, Object oba, int index, short value) {
            ArrayHandle handle = (ArrayHandle)ob;
            byte[] ba = (byte[])oba;
            MethodHandleStatics.UNSAFE.putShortOpaque(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsShorts.convEndian(handle.be, value));
        }
    }

    private static abstract class ByteArrayViewVarHandle
    extends VarHandle {
        final boolean be;

        ByteArrayViewVarHandle(VarForm form, boolean be, boolean exact) {
            super(form, exact);
            this.be = be;
        }
    }
}

