/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.constant.ClassDesc;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarForm;
import java.lang.invoke.VarHandle;
import java.lang.invoke.VarHandles;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.Optional;
import jdk.internal.util.Preconditions;
import jdk.internal.vm.annotation.ForceInline;

final class VarHandleDoubles {
    VarHandleDoubles() {
    }

    static final class Array
    extends VarHandle {
        final int abase;
        final int ashift;
        static final VarForm FORM = new VarForm(Array.class, double[].class, Double.TYPE, Integer.TYPE);

        Array(int abase, int ashift) {
            this(abase, ashift, false);
        }

        private Array(int abase, int ashift, boolean exact) {
            super(FORM, exact);
            this.abase = abase;
            this.ashift = ashift;
        }

        @Override
        public Array withInvokeExactBehavior() {
            return this.hasInvokeExactBehavior() ? this : new Array(this.abase, this.ashift, true);
        }

        @Override
        public Array withInvokeBehavior() {
            return !this.hasInvokeExactBehavior() ? this : new Array(this.abase, this.ashift, false);
        }

        @Override
        public Optional<VarHandle.VarHandleDesc> describeConstable() {
            Optional<ClassDesc> arrayTypeRef = double[].class.describeConstable();
            if (!arrayTypeRef.isPresent()) {
                return Optional.empty();
            }
            return Optional.of(VarHandle.VarHandleDesc.ofArray(arrayTypeRef.get()));
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessType at) {
            return at.accessModeType(double[].class, Double.TYPE, Integer.TYPE);
        }

        @ForceInline
        static double get(VarHandle ob, Object oarray, int index) {
            Array handle = (Array)ob;
            double[] array = (double[])oarray;
            return array[index];
        }

        @ForceInline
        static void set(VarHandle ob, Object oarray, int index, double value) {
            Array handle = (Array)ob;
            double[] array = (double[])oarray;
            array[index] = value;
        }

        @ForceInline
        static double getVolatile(VarHandle ob, Object oarray, int index) {
            Array handle = (Array)ob;
            double[] array = (double[])oarray;
            return MethodHandleStatics.UNSAFE.getDoubleVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase);
        }

        @ForceInline
        static void setVolatile(VarHandle ob, Object oarray, int index, double value) {
            Array handle = (Array)ob;
            double[] array = (double[])oarray;
            MethodHandleStatics.UNSAFE.putDoubleVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static double getOpaque(VarHandle ob, Object oarray, int index) {
            Array handle = (Array)ob;
            double[] array = (double[])oarray;
            return MethodHandleStatics.UNSAFE.getDoubleOpaque(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase);
        }

        @ForceInline
        static void setOpaque(VarHandle ob, Object oarray, int index, double value) {
            Array handle = (Array)ob;
            double[] array = (double[])oarray;
            MethodHandleStatics.UNSAFE.putDoubleOpaque(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static double getAcquire(VarHandle ob, Object oarray, int index) {
            Array handle = (Array)ob;
            double[] array = (double[])oarray;
            return MethodHandleStatics.UNSAFE.getDoubleAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase);
        }

        @ForceInline
        static void setRelease(VarHandle ob, Object oarray, int index, double value) {
            Array handle = (Array)ob;
            double[] array = (double[])oarray;
            MethodHandleStatics.UNSAFE.putDoubleRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static boolean compareAndSet(VarHandle ob, Object oarray, int index, double expected, double value) {
            Array handle = (Array)ob;
            double[] array = (double[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndSetDouble(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static double compareAndExchange(VarHandle ob, Object oarray, int index, double expected, double value) {
            Array handle = (Array)ob;
            double[] array = (double[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndExchangeDouble(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static double compareAndExchangeAcquire(VarHandle ob, Object oarray, int index, double expected, double value) {
            Array handle = (Array)ob;
            double[] array = (double[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndExchangeDoubleAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static double compareAndExchangeRelease(VarHandle ob, Object oarray, int index, double expected, double value) {
            Array handle = (Array)ob;
            double[] array = (double[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndExchangeDoubleRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(VarHandle ob, Object oarray, int index, double expected, double value) {
            Array handle = (Array)ob;
            double[] array = (double[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetDoublePlain(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSet(VarHandle ob, Object oarray, int index, double expected, double value) {
            Array handle = (Array)ob;
            double[] array = (double[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetDouble(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(VarHandle ob, Object oarray, int index, double expected, double value) {
            Array handle = (Array)ob;
            double[] array = (double[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetDoubleAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(VarHandle ob, Object oarray, int index, double expected, double value) {
            Array handle = (Array)ob;
            double[] array = (double[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetDoubleRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static double getAndSet(VarHandle ob, Object oarray, int index, double value) {
            Array handle = (Array)ob;
            double[] array = (double[])oarray;
            return MethodHandleStatics.UNSAFE.getAndSetDouble(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static double getAndSetAcquire(VarHandle ob, Object oarray, int index, double value) {
            Array handle = (Array)ob;
            double[] array = (double[])oarray;
            return MethodHandleStatics.UNSAFE.getAndSetDoubleAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static double getAndSetRelease(VarHandle ob, Object oarray, int index, double value) {
            Array handle = (Array)ob;
            double[] array = (double[])oarray;
            return MethodHandleStatics.UNSAFE.getAndSetDoubleRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static double getAndAdd(VarHandle ob, Object oarray, int index, double value) {
            Array handle = (Array)ob;
            double[] array = (double[])oarray;
            return MethodHandleStatics.UNSAFE.getAndAddDouble(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static double getAndAddAcquire(VarHandle ob, Object oarray, int index, double value) {
            Array handle = (Array)ob;
            double[] array = (double[])oarray;
            return MethodHandleStatics.UNSAFE.getAndAddDoubleAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static double getAndAddRelease(VarHandle ob, Object oarray, int index, double value) {
            Array handle = (Array)ob;
            double[] array = (double[])oarray;
            return MethodHandleStatics.UNSAFE.getAndAddDoubleRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }
    }

    static final class FieldStaticReadWrite
    extends FieldStaticReadOnly {
        static final VarForm FORM = new VarForm(FieldStaticReadWrite.class, null, Double.TYPE, new Class[0]);

        FieldStaticReadWrite(Object base, long fieldOffset) {
            this(base, fieldOffset, false);
        }

        private FieldStaticReadWrite(Object base, long fieldOffset, boolean exact) {
            super(base, fieldOffset, FORM, exact);
        }

        @Override
        public FieldStaticReadWrite withInvokeExactBehavior() {
            return this.hasInvokeExactBehavior() ? this : new FieldStaticReadWrite(this.base, this.fieldOffset, true);
        }

        @Override
        public FieldStaticReadWrite withInvokeBehavior() {
            return !this.hasInvokeExactBehavior() ? this : new FieldStaticReadWrite(this.base, this.fieldOffset, false);
        }

        @ForceInline
        static void set(VarHandle ob, double value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            MethodHandleStatics.UNSAFE.putDouble(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static void setVolatile(VarHandle ob, double value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            MethodHandleStatics.UNSAFE.putDoubleVolatile(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static void setOpaque(VarHandle ob, double value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            MethodHandleStatics.UNSAFE.putDoubleOpaque(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static void setRelease(VarHandle ob, double value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            MethodHandleStatics.UNSAFE.putDoubleRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static boolean compareAndSet(VarHandle ob, double expected, double value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.compareAndSetDouble(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static double compareAndExchange(VarHandle ob, double expected, double value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.compareAndExchangeDouble(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static double compareAndExchangeAcquire(VarHandle ob, double expected, double value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.compareAndExchangeDoubleAcquire(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static double compareAndExchangeRelease(VarHandle ob, double expected, double value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.compareAndExchangeDoubleRelease(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(VarHandle ob, double expected, double value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetDoublePlain(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSet(VarHandle ob, double expected, double value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetDouble(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(VarHandle ob, double expected, double value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetDoubleAcquire(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(VarHandle ob, double expected, double value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetDoubleRelease(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static double getAndSet(VarHandle ob, double value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndSetDouble(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static double getAndSetAcquire(VarHandle ob, double value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndSetDoubleAcquire(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static double getAndSetRelease(VarHandle ob, double value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndSetDoubleRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static double getAndAdd(VarHandle ob, double value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndAddDouble(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static double getAndAddAcquire(VarHandle ob, double value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndAddDoubleAcquire(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static double getAndAddRelease(VarHandle ob, double value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndAddDoubleRelease(handle.base, handle.fieldOffset, value);
        }
    }

    static class FieldStaticReadOnly
    extends VarHandle {
        final Object base;
        final long fieldOffset;
        static final VarForm FORM = new VarForm(FieldStaticReadOnly.class, null, Double.TYPE, new Class[0]);

        FieldStaticReadOnly(Object base, long fieldOffset) {
            this(base, fieldOffset, FORM, false);
        }

        protected FieldStaticReadOnly(Object base, long fieldOffset, VarForm form, boolean exact) {
            super(form, exact);
            this.base = base;
            this.fieldOffset = fieldOffset;
        }

        @Override
        public FieldStaticReadOnly withInvokeExactBehavior() {
            return this.hasInvokeExactBehavior() ? this : new FieldStaticReadOnly(this.base, this.fieldOffset, this.vform, true);
        }

        @Override
        public FieldStaticReadOnly withInvokeBehavior() {
            return !this.hasInvokeExactBehavior() ? this : new FieldStaticReadOnly(this.base, this.fieldOffset, this.vform, false);
        }

        @Override
        public Optional<VarHandle.VarHandleDesc> describeConstable() {
            Optional<ClassDesc> fieldTypeRef = Double.TYPE.describeConstable();
            if (!fieldTypeRef.isPresent()) {
                return Optional.empty();
            }
            Field staticField = VarHandles.getStaticFieldFromBaseAndOffset(this.base, this.fieldOffset, Double.TYPE);
            Optional<ClassDesc> receiverTypeRef = staticField.getDeclaringClass().describeConstable();
            if (!receiverTypeRef.isPresent()) {
                return Optional.empty();
            }
            return Optional.of(VarHandle.VarHandleDesc.ofStaticField(receiverTypeRef.get(), staticField.getName(), fieldTypeRef.get()));
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessType at) {
            return at.accessModeType(null, Double.TYPE, new Class[0]);
        }

        @ForceInline
        static double get(VarHandle ob) {
            FieldStaticReadOnly handle = (FieldStaticReadOnly)ob;
            return MethodHandleStatics.UNSAFE.getDouble(handle.base, handle.fieldOffset);
        }

        @ForceInline
        static double getVolatile(VarHandle ob) {
            FieldStaticReadOnly handle = (FieldStaticReadOnly)ob;
            return MethodHandleStatics.UNSAFE.getDoubleVolatile(handle.base, handle.fieldOffset);
        }

        @ForceInline
        static double getOpaque(VarHandle ob) {
            FieldStaticReadOnly handle = (FieldStaticReadOnly)ob;
            return MethodHandleStatics.UNSAFE.getDoubleOpaque(handle.base, handle.fieldOffset);
        }

        @ForceInline
        static double getAcquire(VarHandle ob) {
            FieldStaticReadOnly handle = (FieldStaticReadOnly)ob;
            return MethodHandleStatics.UNSAFE.getDoubleAcquire(handle.base, handle.fieldOffset);
        }
    }

    static final class FieldInstanceReadWrite
    extends FieldInstanceReadOnly {
        static final VarForm FORM = new VarForm(FieldInstanceReadWrite.class, Object.class, Double.TYPE, new Class[0]);

        FieldInstanceReadWrite(Class<?> receiverType, long fieldOffset) {
            this(receiverType, fieldOffset, false);
        }

        private FieldInstanceReadWrite(Class<?> receiverType, long fieldOffset, boolean exact) {
            super(receiverType, fieldOffset, FORM, exact);
        }

        @Override
        public FieldInstanceReadWrite withInvokeExactBehavior() {
            return this.hasInvokeExactBehavior() ? this : new FieldInstanceReadWrite(this.receiverType, this.fieldOffset, true);
        }

        @Override
        public FieldInstanceReadWrite withInvokeBehavior() {
            return !this.hasInvokeExactBehavior() ? this : new FieldInstanceReadWrite(this.receiverType, this.fieldOffset, false);
        }

        @ForceInline
        static void set(VarHandle ob, Object holder, double value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            MethodHandleStatics.UNSAFE.putDouble(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static void setVolatile(VarHandle ob, Object holder, double value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            MethodHandleStatics.UNSAFE.putDoubleVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static void setOpaque(VarHandle ob, Object holder, double value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            MethodHandleStatics.UNSAFE.putDoubleOpaque(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static void setRelease(VarHandle ob, Object holder, double value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            MethodHandleStatics.UNSAFE.putDoubleRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static boolean compareAndSet(VarHandle ob, Object holder, double expected, double value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.compareAndSetDouble(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static double compareAndExchange(VarHandle ob, Object holder, double expected, double value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.compareAndExchangeDouble(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static double compareAndExchangeAcquire(VarHandle ob, Object holder, double expected, double value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.compareAndExchangeDoubleAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static double compareAndExchangeRelease(VarHandle ob, Object holder, double expected, double value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.compareAndExchangeDoubleRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(VarHandle ob, Object holder, double expected, double value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetDoublePlain(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSet(VarHandle ob, Object holder, double expected, double value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetDouble(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(VarHandle ob, Object holder, double expected, double value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetDoubleAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(VarHandle ob, Object holder, double expected, double value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetDoubleRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static double getAndSet(VarHandle ob, Object holder, double value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndSetDouble(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static double getAndSetAcquire(VarHandle ob, Object holder, double value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndSetDoubleAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static double getAndSetRelease(VarHandle ob, Object holder, double value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndSetDoubleRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static double getAndAdd(VarHandle ob, Object holder, double value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndAddDouble(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static double getAndAddAcquire(VarHandle ob, Object holder, double value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndAddDoubleAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static double getAndAddRelease(VarHandle ob, Object holder, double value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndAddDoubleRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }
    }

    static class FieldInstanceReadOnly
    extends VarHandle {
        final long fieldOffset;
        final Class<?> receiverType;
        static final VarForm FORM = new VarForm(FieldInstanceReadOnly.class, Object.class, Double.TYPE, new Class[0]);

        FieldInstanceReadOnly(Class<?> receiverType, long fieldOffset) {
            this(receiverType, fieldOffset, FORM, false);
        }

        protected FieldInstanceReadOnly(Class<?> receiverType, long fieldOffset, VarForm form, boolean exact) {
            super(form, exact);
            this.fieldOffset = fieldOffset;
            this.receiverType = receiverType;
        }

        @Override
        public FieldInstanceReadOnly withInvokeExactBehavior() {
            return this.hasInvokeExactBehavior() ? this : new FieldInstanceReadOnly(this.receiverType, this.fieldOffset, this.vform, true);
        }

        @Override
        public FieldInstanceReadOnly withInvokeBehavior() {
            return !this.hasInvokeExactBehavior() ? this : new FieldInstanceReadOnly(this.receiverType, this.fieldOffset, this.vform, false);
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessType at) {
            return at.accessModeType(this.receiverType, Double.TYPE, new Class[0]);
        }

        @Override
        public Optional<VarHandle.VarHandleDesc> describeConstable() {
            Optional<ClassDesc> receiverTypeRef = this.receiverType.describeConstable();
            Optional<ClassDesc> fieldTypeRef = Double.TYPE.describeConstable();
            if (!receiverTypeRef.isPresent() || !fieldTypeRef.isPresent()) {
                return Optional.empty();
            }
            String name = VarHandles.getFieldFromReceiverAndOffset(this.receiverType, this.fieldOffset, Double.TYPE).getName();
            return Optional.of(VarHandle.VarHandleDesc.ofField(receiverTypeRef.get(), name, fieldTypeRef.get()));
        }

        @ForceInline
        static double get(VarHandle ob, Object holder) {
            FieldInstanceReadOnly handle = (FieldInstanceReadOnly)ob;
            return MethodHandleStatics.UNSAFE.getDouble(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }

        @ForceInline
        static double getVolatile(VarHandle ob, Object holder) {
            FieldInstanceReadOnly handle = (FieldInstanceReadOnly)ob;
            return MethodHandleStatics.UNSAFE.getDoubleVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }

        @ForceInline
        static double getOpaque(VarHandle ob, Object holder) {
            FieldInstanceReadOnly handle = (FieldInstanceReadOnly)ob;
            return MethodHandleStatics.UNSAFE.getDoubleOpaque(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }

        @ForceInline
        static double getAcquire(VarHandle ob, Object holder) {
            FieldInstanceReadOnly handle = (FieldInstanceReadOnly)ob;
            return MethodHandleStatics.UNSAFE.getDoubleAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }
    }
}

