/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.constant.ClassDesc;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarForm;
import java.lang.invoke.VarHandle;
import java.lang.invoke.VarHandles;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.Optional;
import jdk.internal.util.Preconditions;
import jdk.internal.vm.annotation.ForceInline;

final class VarHandleInts {
    VarHandleInts() {
    }

    static final class Array
    extends VarHandle {
        final int abase;
        final int ashift;
        static final VarForm FORM = new VarForm(Array.class, int[].class, Integer.TYPE, Integer.TYPE);

        Array(int abase, int ashift) {
            this(abase, ashift, false);
        }

        private Array(int abase, int ashift, boolean exact) {
            super(FORM, exact);
            this.abase = abase;
            this.ashift = ashift;
        }

        @Override
        public Array withInvokeExactBehavior() {
            return this.hasInvokeExactBehavior() ? this : new Array(this.abase, this.ashift, true);
        }

        @Override
        public Array withInvokeBehavior() {
            return !this.hasInvokeExactBehavior() ? this : new Array(this.abase, this.ashift, false);
        }

        @Override
        public Optional<VarHandle.VarHandleDesc> describeConstable() {
            Optional<ClassDesc> arrayTypeRef = int[].class.describeConstable();
            if (!arrayTypeRef.isPresent()) {
                return Optional.empty();
            }
            return Optional.of(VarHandle.VarHandleDesc.ofArray(arrayTypeRef.get()));
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessType at) {
            return at.accessModeType(int[].class, Integer.TYPE, Integer.TYPE);
        }

        @ForceInline
        static int get(VarHandle ob, Object oarray, int index) {
            Array handle = (Array)ob;
            int[] array = (int[])oarray;
            return array[index];
        }

        @ForceInline
        static void set(VarHandle ob, Object oarray, int index, int value) {
            Array handle = (Array)ob;
            int[] array = (int[])oarray;
            array[index] = value;
        }

        @ForceInline
        static int getVolatile(VarHandle ob, Object oarray, int index) {
            Array handle = (Array)ob;
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.getIntVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase);
        }

        @ForceInline
        static void setVolatile(VarHandle ob, Object oarray, int index, int value) {
            Array handle = (Array)ob;
            int[] array = (int[])oarray;
            MethodHandleStatics.UNSAFE.putIntVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static int getOpaque(VarHandle ob, Object oarray, int index) {
            Array handle = (Array)ob;
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.getIntOpaque(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase);
        }

        @ForceInline
        static void setOpaque(VarHandle ob, Object oarray, int index, int value) {
            Array handle = (Array)ob;
            int[] array = (int[])oarray;
            MethodHandleStatics.UNSAFE.putIntOpaque(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static int getAcquire(VarHandle ob, Object oarray, int index) {
            Array handle = (Array)ob;
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.getIntAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase);
        }

        @ForceInline
        static void setRelease(VarHandle ob, Object oarray, int index, int value) {
            Array handle = (Array)ob;
            int[] array = (int[])oarray;
            MethodHandleStatics.UNSAFE.putIntRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static boolean compareAndSet(VarHandle ob, Object oarray, int index, int expected, int value) {
            Array handle = (Array)ob;
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndSetInt(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static int compareAndExchange(VarHandle ob, Object oarray, int index, int expected, int value) {
            Array handle = (Array)ob;
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndExchangeInt(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static int compareAndExchangeAcquire(VarHandle ob, Object oarray, int index, int expected, int value) {
            Array handle = (Array)ob;
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndExchangeIntAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static int compareAndExchangeRelease(VarHandle ob, Object oarray, int index, int expected, int value) {
            Array handle = (Array)ob;
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndExchangeIntRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(VarHandle ob, Object oarray, int index, int expected, int value) {
            Array handle = (Array)ob;
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetIntPlain(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSet(VarHandle ob, Object oarray, int index, int expected, int value) {
            Array handle = (Array)ob;
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetInt(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(VarHandle ob, Object oarray, int index, int expected, int value) {
            Array handle = (Array)ob;
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetIntAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(VarHandle ob, Object oarray, int index, int expected, int value) {
            Array handle = (Array)ob;
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetIntRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static int getAndSet(VarHandle ob, Object oarray, int index, int value) {
            Array handle = (Array)ob;
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.getAndSetInt(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static int getAndSetAcquire(VarHandle ob, Object oarray, int index, int value) {
            Array handle = (Array)ob;
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.getAndSetIntAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static int getAndSetRelease(VarHandle ob, Object oarray, int index, int value) {
            Array handle = (Array)ob;
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.getAndSetIntRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static int getAndAdd(VarHandle ob, Object oarray, int index, int value) {
            Array handle = (Array)ob;
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.getAndAddInt(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static int getAndAddAcquire(VarHandle ob, Object oarray, int index, int value) {
            Array handle = (Array)ob;
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.getAndAddIntAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static int getAndAddRelease(VarHandle ob, Object oarray, int index, int value) {
            Array handle = (Array)ob;
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.getAndAddIntRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static int getAndBitwiseOr(VarHandle ob, Object oarray, int index, int value) {
            Array handle = (Array)ob;
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrInt(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static int getAndBitwiseOrRelease(VarHandle ob, Object oarray, int index, int value) {
            Array handle = (Array)ob;
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrIntRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static int getAndBitwiseOrAcquire(VarHandle ob, Object oarray, int index, int value) {
            Array handle = (Array)ob;
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrIntAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static int getAndBitwiseAnd(VarHandle ob, Object oarray, int index, int value) {
            Array handle = (Array)ob;
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndInt(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static int getAndBitwiseAndRelease(VarHandle ob, Object oarray, int index, int value) {
            Array handle = (Array)ob;
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndIntRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static int getAndBitwiseAndAcquire(VarHandle ob, Object oarray, int index, int value) {
            Array handle = (Array)ob;
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndIntAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static int getAndBitwiseXor(VarHandle ob, Object oarray, int index, int value) {
            Array handle = (Array)ob;
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorInt(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static int getAndBitwiseXorRelease(VarHandle ob, Object oarray, int index, int value) {
            Array handle = (Array)ob;
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorIntRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static int getAndBitwiseXorAcquire(VarHandle ob, Object oarray, int index, int value) {
            Array handle = (Array)ob;
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorIntAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }
    }

    static final class FieldStaticReadWrite
    extends FieldStaticReadOnly {
        static final VarForm FORM = new VarForm(FieldStaticReadWrite.class, null, Integer.TYPE, new Class[0]);

        FieldStaticReadWrite(Object base, long fieldOffset) {
            this(base, fieldOffset, false);
        }

        private FieldStaticReadWrite(Object base, long fieldOffset, boolean exact) {
            super(base, fieldOffset, FORM, exact);
        }

        @Override
        public FieldStaticReadWrite withInvokeExactBehavior() {
            return this.hasInvokeExactBehavior() ? this : new FieldStaticReadWrite(this.base, this.fieldOffset, true);
        }

        @Override
        public FieldStaticReadWrite withInvokeBehavior() {
            return !this.hasInvokeExactBehavior() ? this : new FieldStaticReadWrite(this.base, this.fieldOffset, false);
        }

        @ForceInline
        static void set(VarHandle ob, int value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            MethodHandleStatics.UNSAFE.putInt(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static void setVolatile(VarHandle ob, int value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            MethodHandleStatics.UNSAFE.putIntVolatile(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static void setOpaque(VarHandle ob, int value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            MethodHandleStatics.UNSAFE.putIntOpaque(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static void setRelease(VarHandle ob, int value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            MethodHandleStatics.UNSAFE.putIntRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static boolean compareAndSet(VarHandle ob, int expected, int value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.compareAndSetInt(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static int compareAndExchange(VarHandle ob, int expected, int value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.compareAndExchangeInt(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static int compareAndExchangeAcquire(VarHandle ob, int expected, int value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.compareAndExchangeIntAcquire(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static int compareAndExchangeRelease(VarHandle ob, int expected, int value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.compareAndExchangeIntRelease(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(VarHandle ob, int expected, int value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetIntPlain(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSet(VarHandle ob, int expected, int value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetInt(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(VarHandle ob, int expected, int value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetIntAcquire(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(VarHandle ob, int expected, int value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetIntRelease(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static int getAndSet(VarHandle ob, int value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndSetInt(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndSetAcquire(VarHandle ob, int value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndSetIntAcquire(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndSetRelease(VarHandle ob, int value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndSetIntRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndAdd(VarHandle ob, int value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndAddInt(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndAddAcquire(VarHandle ob, int value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndAddIntAcquire(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndAddRelease(VarHandle ob, int value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndAddIntRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndBitwiseOr(VarHandle ob, int value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrInt(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndBitwiseOrRelease(VarHandle ob, int value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrIntRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndBitwiseOrAcquire(VarHandle ob, int value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrIntAcquire(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndBitwiseAnd(VarHandle ob, int value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndInt(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndBitwiseAndRelease(VarHandle ob, int value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndIntRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndBitwiseAndAcquire(VarHandle ob, int value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndIntAcquire(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndBitwiseXor(VarHandle ob, int value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorInt(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndBitwiseXorRelease(VarHandle ob, int value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorIntRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndBitwiseXorAcquire(VarHandle ob, int value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorIntAcquire(handle.base, handle.fieldOffset, value);
        }
    }

    static class FieldStaticReadOnly
    extends VarHandle {
        final Object base;
        final long fieldOffset;
        static final VarForm FORM = new VarForm(FieldStaticReadOnly.class, null, Integer.TYPE, new Class[0]);

        FieldStaticReadOnly(Object base, long fieldOffset) {
            this(base, fieldOffset, FORM, false);
        }

        protected FieldStaticReadOnly(Object base, long fieldOffset, VarForm form, boolean exact) {
            super(form, exact);
            this.base = base;
            this.fieldOffset = fieldOffset;
        }

        @Override
        public FieldStaticReadOnly withInvokeExactBehavior() {
            return this.hasInvokeExactBehavior() ? this : new FieldStaticReadOnly(this.base, this.fieldOffset, this.vform, true);
        }

        @Override
        public FieldStaticReadOnly withInvokeBehavior() {
            return !this.hasInvokeExactBehavior() ? this : new FieldStaticReadOnly(this.base, this.fieldOffset, this.vform, false);
        }

        @Override
        public Optional<VarHandle.VarHandleDesc> describeConstable() {
            Optional<ClassDesc> fieldTypeRef = Integer.TYPE.describeConstable();
            if (!fieldTypeRef.isPresent()) {
                return Optional.empty();
            }
            Field staticField = VarHandles.getStaticFieldFromBaseAndOffset(this.base, this.fieldOffset, Integer.TYPE);
            Optional<ClassDesc> receiverTypeRef = staticField.getDeclaringClass().describeConstable();
            if (!receiverTypeRef.isPresent()) {
                return Optional.empty();
            }
            return Optional.of(VarHandle.VarHandleDesc.ofStaticField(receiverTypeRef.get(), staticField.getName(), fieldTypeRef.get()));
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessType at) {
            return at.accessModeType(null, Integer.TYPE, new Class[0]);
        }

        @ForceInline
        static int get(VarHandle ob) {
            FieldStaticReadOnly handle = (FieldStaticReadOnly)ob;
            return MethodHandleStatics.UNSAFE.getInt(handle.base, handle.fieldOffset);
        }

        @ForceInline
        static int getVolatile(VarHandle ob) {
            FieldStaticReadOnly handle = (FieldStaticReadOnly)ob;
            return MethodHandleStatics.UNSAFE.getIntVolatile(handle.base, handle.fieldOffset);
        }

        @ForceInline
        static int getOpaque(VarHandle ob) {
            FieldStaticReadOnly handle = (FieldStaticReadOnly)ob;
            return MethodHandleStatics.UNSAFE.getIntOpaque(handle.base, handle.fieldOffset);
        }

        @ForceInline
        static int getAcquire(VarHandle ob) {
            FieldStaticReadOnly handle = (FieldStaticReadOnly)ob;
            return MethodHandleStatics.UNSAFE.getIntAcquire(handle.base, handle.fieldOffset);
        }
    }

    static final class FieldInstanceReadWrite
    extends FieldInstanceReadOnly {
        static final VarForm FORM = new VarForm(FieldInstanceReadWrite.class, Object.class, Integer.TYPE, new Class[0]);

        FieldInstanceReadWrite(Class<?> receiverType, long fieldOffset) {
            this(receiverType, fieldOffset, false);
        }

        private FieldInstanceReadWrite(Class<?> receiverType, long fieldOffset, boolean exact) {
            super(receiverType, fieldOffset, FORM, exact);
        }

        @Override
        public FieldInstanceReadWrite withInvokeExactBehavior() {
            return this.hasInvokeExactBehavior() ? this : new FieldInstanceReadWrite(this.receiverType, this.fieldOffset, true);
        }

        @Override
        public FieldInstanceReadWrite withInvokeBehavior() {
            return !this.hasInvokeExactBehavior() ? this : new FieldInstanceReadWrite(this.receiverType, this.fieldOffset, false);
        }

        @ForceInline
        static void set(VarHandle ob, Object holder, int value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            MethodHandleStatics.UNSAFE.putInt(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static void setVolatile(VarHandle ob, Object holder, int value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            MethodHandleStatics.UNSAFE.putIntVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static void setOpaque(VarHandle ob, Object holder, int value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            MethodHandleStatics.UNSAFE.putIntOpaque(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static void setRelease(VarHandle ob, Object holder, int value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            MethodHandleStatics.UNSAFE.putIntRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static boolean compareAndSet(VarHandle ob, Object holder, int expected, int value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.compareAndSetInt(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static int compareAndExchange(VarHandle ob, Object holder, int expected, int value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.compareAndExchangeInt(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static int compareAndExchangeAcquire(VarHandle ob, Object holder, int expected, int value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.compareAndExchangeIntAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static int compareAndExchangeRelease(VarHandle ob, Object holder, int expected, int value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.compareAndExchangeIntRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(VarHandle ob, Object holder, int expected, int value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetIntPlain(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSet(VarHandle ob, Object holder, int expected, int value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetInt(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(VarHandle ob, Object holder, int expected, int value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetIntAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(VarHandle ob, Object holder, int expected, int value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetIntRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static int getAndSet(VarHandle ob, Object holder, int value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndSetInt(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndSetAcquire(VarHandle ob, Object holder, int value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndSetIntAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndSetRelease(VarHandle ob, Object holder, int value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndSetIntRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndAdd(VarHandle ob, Object holder, int value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndAddInt(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndAddAcquire(VarHandle ob, Object holder, int value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndAddIntAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndAddRelease(VarHandle ob, Object holder, int value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndAddIntRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndBitwiseOr(VarHandle ob, Object holder, int value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrInt(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndBitwiseOrRelease(VarHandle ob, Object holder, int value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrIntRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndBitwiseOrAcquire(VarHandle ob, Object holder, int value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrIntAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndBitwiseAnd(VarHandle ob, Object holder, int value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndInt(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndBitwiseAndRelease(VarHandle ob, Object holder, int value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndIntRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndBitwiseAndAcquire(VarHandle ob, Object holder, int value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndIntAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndBitwiseXor(VarHandle ob, Object holder, int value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorInt(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndBitwiseXorRelease(VarHandle ob, Object holder, int value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorIntRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndBitwiseXorAcquire(VarHandle ob, Object holder, int value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorIntAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }
    }

    static class FieldInstanceReadOnly
    extends VarHandle {
        final long fieldOffset;
        final Class<?> receiverType;
        static final VarForm FORM = new VarForm(FieldInstanceReadOnly.class, Object.class, Integer.TYPE, new Class[0]);

        FieldInstanceReadOnly(Class<?> receiverType, long fieldOffset) {
            this(receiverType, fieldOffset, FORM, false);
        }

        protected FieldInstanceReadOnly(Class<?> receiverType, long fieldOffset, VarForm form, boolean exact) {
            super(form, exact);
            this.fieldOffset = fieldOffset;
            this.receiverType = receiverType;
        }

        @Override
        public FieldInstanceReadOnly withInvokeExactBehavior() {
            return this.hasInvokeExactBehavior() ? this : new FieldInstanceReadOnly(this.receiverType, this.fieldOffset, this.vform, true);
        }

        @Override
        public FieldInstanceReadOnly withInvokeBehavior() {
            return !this.hasInvokeExactBehavior() ? this : new FieldInstanceReadOnly(this.receiverType, this.fieldOffset, this.vform, false);
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessType at) {
            return at.accessModeType(this.receiverType, Integer.TYPE, new Class[0]);
        }

        @Override
        public Optional<VarHandle.VarHandleDesc> describeConstable() {
            Optional<ClassDesc> receiverTypeRef = this.receiverType.describeConstable();
            Optional<ClassDesc> fieldTypeRef = Integer.TYPE.describeConstable();
            if (!receiverTypeRef.isPresent() || !fieldTypeRef.isPresent()) {
                return Optional.empty();
            }
            String name = VarHandles.getFieldFromReceiverAndOffset(this.receiverType, this.fieldOffset, Integer.TYPE).getName();
            return Optional.of(VarHandle.VarHandleDesc.ofField(receiverTypeRef.get(), name, fieldTypeRef.get()));
        }

        @ForceInline
        static int get(VarHandle ob, Object holder) {
            FieldInstanceReadOnly handle = (FieldInstanceReadOnly)ob;
            return MethodHandleStatics.UNSAFE.getInt(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }

        @ForceInline
        static int getVolatile(VarHandle ob, Object holder) {
            FieldInstanceReadOnly handle = (FieldInstanceReadOnly)ob;
            return MethodHandleStatics.UNSAFE.getIntVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }

        @ForceInline
        static int getOpaque(VarHandle ob, Object holder) {
            FieldInstanceReadOnly handle = (FieldInstanceReadOnly)ob;
            return MethodHandleStatics.UNSAFE.getIntOpaque(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }

        @ForceInline
        static int getAcquire(VarHandle ob, Object holder) {
            FieldInstanceReadOnly handle = (FieldInstanceReadOnly)ob;
            return MethodHandleStatics.UNSAFE.getIntAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }
    }
}

