/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.constant.ClassDesc;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarForm;
import java.lang.invoke.VarHandle;
import java.lang.invoke.VarHandles;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.Optional;
import jdk.internal.util.Preconditions;
import jdk.internal.vm.annotation.ForceInline;

final class VarHandleReferences {
    VarHandleReferences() {
    }

    static final class Array
    extends VarHandle {
        final int abase;
        final int ashift;
        final Class<?> arrayType;
        final Class<?> componentType;
        static final VarForm FORM = new VarForm(Array.class, Object[].class, Object.class, Integer.TYPE);

        Array(int abase, int ashift, Class<?> arrayType) {
            this(abase, ashift, arrayType, false);
        }

        private Array(int abase, int ashift, Class<?> arrayType, boolean exact) {
            super(FORM, exact);
            this.abase = abase;
            this.ashift = ashift;
            this.arrayType = arrayType;
            this.componentType = arrayType.getComponentType();
        }

        @Override
        public Array withInvokeExactBehavior() {
            return this.hasInvokeExactBehavior() ? this : new Array(this.abase, this.ashift, this.arrayType, true);
        }

        @Override
        public Array withInvokeBehavior() {
            return !this.hasInvokeExactBehavior() ? this : new Array(this.abase, this.ashift, this.arrayType, false);
        }

        @Override
        public Optional<VarHandle.VarHandleDesc> describeConstable() {
            Optional<ClassDesc> arrayTypeRef = this.arrayType.describeConstable();
            if (!arrayTypeRef.isPresent()) {
                return Optional.empty();
            }
            return Optional.of(VarHandle.VarHandleDesc.ofArray(arrayTypeRef.get()));
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessType at) {
            return at.accessModeType(this.arrayType, this.arrayType.getComponentType(), Integer.TYPE);
        }

        @ForceInline
        static Object runtimeTypeCheck(Array handle, Object[] oarray, Object value) {
            if (handle.arrayType == oarray.getClass()) {
                return handle.componentType.cast(value);
            }
            return Array.reflectiveTypeCheck(oarray, value);
        }

        @ForceInline
        static Object reflectiveTypeCheck(Object[] oarray, Object value) {
            try {
                return oarray.getClass().getComponentType().cast(value);
            }
            catch (ClassCastException e) {
                throw new ArrayStoreException();
            }
        }

        @ForceInline
        static Object get(VarHandle ob, Object oarray, int index) {
            Array handle = (Array)ob;
            Object[] array = (Object[])handle.arrayType.cast(oarray);
            return array[index];
        }

        @ForceInline
        static void set(VarHandle ob, Object oarray, int index, Object value) {
            Array handle = (Array)ob;
            Object[] array = (Object[])handle.arrayType.cast(oarray);
            array[index] = handle.componentType.cast(value);
        }

        @ForceInline
        static Object getVolatile(VarHandle ob, Object oarray, int index) {
            Array handle = (Array)ob;
            Object[] array = (Object[])handle.arrayType.cast(oarray);
            return MethodHandleStatics.UNSAFE.getReferenceVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase);
        }

        @ForceInline
        static void setVolatile(VarHandle ob, Object oarray, int index, Object value) {
            Array handle = (Array)ob;
            Object[] array = (Object[])handle.arrayType.cast(oarray);
            MethodHandleStatics.UNSAFE.putReferenceVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, Array.runtimeTypeCheck(handle, array, value));
        }

        @ForceInline
        static Object getOpaque(VarHandle ob, Object oarray, int index) {
            Array handle = (Array)ob;
            Object[] array = (Object[])handle.arrayType.cast(oarray);
            return MethodHandleStatics.UNSAFE.getReferenceOpaque(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase);
        }

        @ForceInline
        static void setOpaque(VarHandle ob, Object oarray, int index, Object value) {
            Array handle = (Array)ob;
            Object[] array = (Object[])handle.arrayType.cast(oarray);
            MethodHandleStatics.UNSAFE.putReferenceOpaque(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, Array.runtimeTypeCheck(handle, array, value));
        }

        @ForceInline
        static Object getAcquire(VarHandle ob, Object oarray, int index) {
            Array handle = (Array)ob;
            Object[] array = (Object[])handle.arrayType.cast(oarray);
            return MethodHandleStatics.UNSAFE.getReferenceAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase);
        }

        @ForceInline
        static void setRelease(VarHandle ob, Object oarray, int index, Object value) {
            Array handle = (Array)ob;
            Object[] array = (Object[])handle.arrayType.cast(oarray);
            MethodHandleStatics.UNSAFE.putReferenceRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, Array.runtimeTypeCheck(handle, array, value));
        }

        @ForceInline
        static boolean compareAndSet(VarHandle ob, Object oarray, int index, Object expected, Object value) {
            Array handle = (Array)ob;
            Object[] array = (Object[])handle.arrayType.cast(oarray);
            return MethodHandleStatics.UNSAFE.compareAndSetReference(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, handle.componentType.cast(expected), Array.runtimeTypeCheck(handle, array, value));
        }

        @ForceInline
        static Object compareAndExchange(VarHandle ob, Object oarray, int index, Object expected, Object value) {
            Array handle = (Array)ob;
            Object[] array = (Object[])handle.arrayType.cast(oarray);
            return MethodHandleStatics.UNSAFE.compareAndExchangeReference(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, handle.componentType.cast(expected), Array.runtimeTypeCheck(handle, array, value));
        }

        @ForceInline
        static Object compareAndExchangeAcquire(VarHandle ob, Object oarray, int index, Object expected, Object value) {
            Array handle = (Array)ob;
            Object[] array = (Object[])handle.arrayType.cast(oarray);
            return MethodHandleStatics.UNSAFE.compareAndExchangeReferenceAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, handle.componentType.cast(expected), Array.runtimeTypeCheck(handle, array, value));
        }

        @ForceInline
        static Object compareAndExchangeRelease(VarHandle ob, Object oarray, int index, Object expected, Object value) {
            Array handle = (Array)ob;
            Object[] array = (Object[])handle.arrayType.cast(oarray);
            return MethodHandleStatics.UNSAFE.compareAndExchangeReferenceRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, handle.componentType.cast(expected), Array.runtimeTypeCheck(handle, array, value));
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(VarHandle ob, Object oarray, int index, Object expected, Object value) {
            Array handle = (Array)ob;
            Object[] array = (Object[])handle.arrayType.cast(oarray);
            return MethodHandleStatics.UNSAFE.weakCompareAndSetReferencePlain(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, handle.componentType.cast(expected), Array.runtimeTypeCheck(handle, array, value));
        }

        @ForceInline
        static boolean weakCompareAndSet(VarHandle ob, Object oarray, int index, Object expected, Object value) {
            Array handle = (Array)ob;
            Object[] array = (Object[])handle.arrayType.cast(oarray);
            return MethodHandleStatics.UNSAFE.weakCompareAndSetReference(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, handle.componentType.cast(expected), Array.runtimeTypeCheck(handle, array, value));
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(VarHandle ob, Object oarray, int index, Object expected, Object value) {
            Array handle = (Array)ob;
            Object[] array = (Object[])handle.arrayType.cast(oarray);
            return MethodHandleStatics.UNSAFE.weakCompareAndSetReferenceAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, handle.componentType.cast(expected), Array.runtimeTypeCheck(handle, array, value));
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(VarHandle ob, Object oarray, int index, Object expected, Object value) {
            Array handle = (Array)ob;
            Object[] array = (Object[])handle.arrayType.cast(oarray);
            return MethodHandleStatics.UNSAFE.weakCompareAndSetReferenceRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, handle.componentType.cast(expected), Array.runtimeTypeCheck(handle, array, value));
        }

        @ForceInline
        static Object getAndSet(VarHandle ob, Object oarray, int index, Object value) {
            Array handle = (Array)ob;
            Object[] array = (Object[])handle.arrayType.cast(oarray);
            return MethodHandleStatics.UNSAFE.getAndSetReference(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, Array.runtimeTypeCheck(handle, array, value));
        }

        @ForceInline
        static Object getAndSetAcquire(VarHandle ob, Object oarray, int index, Object value) {
            Array handle = (Array)ob;
            Object[] array = (Object[])handle.arrayType.cast(oarray);
            return MethodHandleStatics.UNSAFE.getAndSetReferenceAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, Array.runtimeTypeCheck(handle, array, value));
        }

        @ForceInline
        static Object getAndSetRelease(VarHandle ob, Object oarray, int index, Object value) {
            Array handle = (Array)ob;
            Object[] array = (Object[])handle.arrayType.cast(oarray);
            return MethodHandleStatics.UNSAFE.getAndSetReferenceRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, Array.runtimeTypeCheck(handle, array, value));
        }
    }

    static final class FieldStaticReadWrite
    extends FieldStaticReadOnly {
        static final VarForm FORM = new VarForm(FieldStaticReadWrite.class, null, Object.class, new Class[0]);

        FieldStaticReadWrite(Object base, long fieldOffset, Class<?> fieldType) {
            this(base, fieldOffset, fieldType, false);
        }

        private FieldStaticReadWrite(Object base, long fieldOffset, Class<?> fieldType, boolean exact) {
            super(base, fieldOffset, fieldType, FORM, exact);
        }

        @Override
        public FieldStaticReadWrite withInvokeExactBehavior() {
            return this.hasInvokeExactBehavior() ? this : new FieldStaticReadWrite(this.base, this.fieldOffset, this.fieldType, true);
        }

        @Override
        public FieldStaticReadWrite withInvokeBehavior() {
            return !this.hasInvokeExactBehavior() ? this : new FieldStaticReadWrite(this.base, this.fieldOffset, this.fieldType, false);
        }

        @ForceInline
        static void set(VarHandle ob, Object value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            MethodHandleStatics.UNSAFE.putReference(handle.base, handle.fieldOffset, handle.fieldType.cast(value));
        }

        @ForceInline
        static void setVolatile(VarHandle ob, Object value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            MethodHandleStatics.UNSAFE.putReferenceVolatile(handle.base, handle.fieldOffset, handle.fieldType.cast(value));
        }

        @ForceInline
        static void setOpaque(VarHandle ob, Object value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            MethodHandleStatics.UNSAFE.putReferenceOpaque(handle.base, handle.fieldOffset, handle.fieldType.cast(value));
        }

        @ForceInline
        static void setRelease(VarHandle ob, Object value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            MethodHandleStatics.UNSAFE.putReferenceRelease(handle.base, handle.fieldOffset, handle.fieldType.cast(value));
        }

        @ForceInline
        static boolean compareAndSet(VarHandle ob, Object expected, Object value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.compareAndSetReference(handle.base, handle.fieldOffset, handle.fieldType.cast(expected), handle.fieldType.cast(value));
        }

        @ForceInline
        static Object compareAndExchange(VarHandle ob, Object expected, Object value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.compareAndExchangeReference(handle.base, handle.fieldOffset, handle.fieldType.cast(expected), handle.fieldType.cast(value));
        }

        @ForceInline
        static Object compareAndExchangeAcquire(VarHandle ob, Object expected, Object value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.compareAndExchangeReferenceAcquire(handle.base, handle.fieldOffset, handle.fieldType.cast(expected), handle.fieldType.cast(value));
        }

        @ForceInline
        static Object compareAndExchangeRelease(VarHandle ob, Object expected, Object value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.compareAndExchangeReferenceRelease(handle.base, handle.fieldOffset, handle.fieldType.cast(expected), handle.fieldType.cast(value));
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(VarHandle ob, Object expected, Object value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetReferencePlain(handle.base, handle.fieldOffset, handle.fieldType.cast(expected), handle.fieldType.cast(value));
        }

        @ForceInline
        static boolean weakCompareAndSet(VarHandle ob, Object expected, Object value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetReference(handle.base, handle.fieldOffset, handle.fieldType.cast(expected), handle.fieldType.cast(value));
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(VarHandle ob, Object expected, Object value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetReferenceAcquire(handle.base, handle.fieldOffset, handle.fieldType.cast(expected), handle.fieldType.cast(value));
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(VarHandle ob, Object expected, Object value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetReferenceRelease(handle.base, handle.fieldOffset, handle.fieldType.cast(expected), handle.fieldType.cast(value));
        }

        @ForceInline
        static Object getAndSet(VarHandle ob, Object value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndSetReference(handle.base, handle.fieldOffset, handle.fieldType.cast(value));
        }

        @ForceInline
        static Object getAndSetAcquire(VarHandle ob, Object value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndSetReferenceAcquire(handle.base, handle.fieldOffset, handle.fieldType.cast(value));
        }

        @ForceInline
        static Object getAndSetRelease(VarHandle ob, Object value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndSetReferenceRelease(handle.base, handle.fieldOffset, handle.fieldType.cast(value));
        }
    }

    static class FieldStaticReadOnly
    extends VarHandle {
        final Object base;
        final long fieldOffset;
        final Class<?> fieldType;
        static final VarForm FORM = new VarForm(FieldStaticReadOnly.class, null, Object.class, new Class[0]);

        FieldStaticReadOnly(Object base, long fieldOffset, Class<?> fieldType) {
            this(base, fieldOffset, fieldType, FORM, false);
        }

        protected FieldStaticReadOnly(Object base, long fieldOffset, Class<?> fieldType, VarForm form, boolean exact) {
            super(form, exact);
            this.base = base;
            this.fieldOffset = fieldOffset;
            this.fieldType = fieldType;
        }

        @Override
        public FieldStaticReadOnly withInvokeExactBehavior() {
            return this.hasInvokeExactBehavior() ? this : new FieldStaticReadOnly(this.base, this.fieldOffset, this.fieldType, this.vform, true);
        }

        @Override
        public FieldStaticReadOnly withInvokeBehavior() {
            return !this.hasInvokeExactBehavior() ? this : new FieldStaticReadOnly(this.base, this.fieldOffset, this.fieldType, this.vform, false);
        }

        @Override
        public Optional<VarHandle.VarHandleDesc> describeConstable() {
            Optional<ClassDesc> fieldTypeRef = this.fieldType.describeConstable();
            if (!fieldTypeRef.isPresent()) {
                return Optional.empty();
            }
            Field staticField = VarHandles.getStaticFieldFromBaseAndOffset(this.base, this.fieldOffset, this.fieldType);
            Optional<ClassDesc> receiverTypeRef = staticField.getDeclaringClass().describeConstable();
            if (!receiverTypeRef.isPresent()) {
                return Optional.empty();
            }
            return Optional.of(VarHandle.VarHandleDesc.ofStaticField(receiverTypeRef.get(), staticField.getName(), fieldTypeRef.get()));
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessType at) {
            return at.accessModeType(null, this.fieldType, new Class[0]);
        }

        @ForceInline
        static Object get(VarHandle ob) {
            FieldStaticReadOnly handle = (FieldStaticReadOnly)ob;
            return MethodHandleStatics.UNSAFE.getReference(handle.base, handle.fieldOffset);
        }

        @ForceInline
        static Object getVolatile(VarHandle ob) {
            FieldStaticReadOnly handle = (FieldStaticReadOnly)ob;
            return MethodHandleStatics.UNSAFE.getReferenceVolatile(handle.base, handle.fieldOffset);
        }

        @ForceInline
        static Object getOpaque(VarHandle ob) {
            FieldStaticReadOnly handle = (FieldStaticReadOnly)ob;
            return MethodHandleStatics.UNSAFE.getReferenceOpaque(handle.base, handle.fieldOffset);
        }

        @ForceInline
        static Object getAcquire(VarHandle ob) {
            FieldStaticReadOnly handle = (FieldStaticReadOnly)ob;
            return MethodHandleStatics.UNSAFE.getReferenceAcquire(handle.base, handle.fieldOffset);
        }
    }

    static final class FieldInstanceReadWrite
    extends FieldInstanceReadOnly {
        static final VarForm FORM = new VarForm(FieldInstanceReadWrite.class, Object.class, Object.class, new Class[0]);

        FieldInstanceReadWrite(Class<?> receiverType, long fieldOffset, Class<?> fieldType) {
            this(receiverType, fieldOffset, fieldType, false);
        }

        private FieldInstanceReadWrite(Class<?> receiverType, long fieldOffset, Class<?> fieldType, boolean exact) {
            super(receiverType, fieldOffset, fieldType, FORM, exact);
        }

        @Override
        public FieldInstanceReadWrite withInvokeExactBehavior() {
            return this.hasInvokeExactBehavior() ? this : new FieldInstanceReadWrite(this.receiverType, this.fieldOffset, this.fieldType, true);
        }

        @Override
        public FieldInstanceReadWrite withInvokeBehavior() {
            return !this.hasInvokeExactBehavior() ? this : new FieldInstanceReadWrite(this.receiverType, this.fieldOffset, this.fieldType, false);
        }

        @ForceInline
        static void set(VarHandle ob, Object holder, Object value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            MethodHandleStatics.UNSAFE.putReference(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, handle.fieldType.cast(value));
        }

        @ForceInline
        static void setVolatile(VarHandle ob, Object holder, Object value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            MethodHandleStatics.UNSAFE.putReferenceVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, handle.fieldType.cast(value));
        }

        @ForceInline
        static void setOpaque(VarHandle ob, Object holder, Object value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            MethodHandleStatics.UNSAFE.putReferenceOpaque(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, handle.fieldType.cast(value));
        }

        @ForceInline
        static void setRelease(VarHandle ob, Object holder, Object value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            MethodHandleStatics.UNSAFE.putReferenceRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, handle.fieldType.cast(value));
        }

        @ForceInline
        static boolean compareAndSet(VarHandle ob, Object holder, Object expected, Object value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.compareAndSetReference(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, handle.fieldType.cast(expected), handle.fieldType.cast(value));
        }

        @ForceInline
        static Object compareAndExchange(VarHandle ob, Object holder, Object expected, Object value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.compareAndExchangeReference(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, handle.fieldType.cast(expected), handle.fieldType.cast(value));
        }

        @ForceInline
        static Object compareAndExchangeAcquire(VarHandle ob, Object holder, Object expected, Object value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.compareAndExchangeReferenceAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, handle.fieldType.cast(expected), handle.fieldType.cast(value));
        }

        @ForceInline
        static Object compareAndExchangeRelease(VarHandle ob, Object holder, Object expected, Object value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.compareAndExchangeReferenceRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, handle.fieldType.cast(expected), handle.fieldType.cast(value));
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(VarHandle ob, Object holder, Object expected, Object value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetReferencePlain(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, handle.fieldType.cast(expected), handle.fieldType.cast(value));
        }

        @ForceInline
        static boolean weakCompareAndSet(VarHandle ob, Object holder, Object expected, Object value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetReference(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, handle.fieldType.cast(expected), handle.fieldType.cast(value));
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(VarHandle ob, Object holder, Object expected, Object value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetReferenceAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, handle.fieldType.cast(expected), handle.fieldType.cast(value));
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(VarHandle ob, Object holder, Object expected, Object value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetReferenceRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, handle.fieldType.cast(expected), handle.fieldType.cast(value));
        }

        @ForceInline
        static Object getAndSet(VarHandle ob, Object holder, Object value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndSetReference(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, handle.fieldType.cast(value));
        }

        @ForceInline
        static Object getAndSetAcquire(VarHandle ob, Object holder, Object value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndSetReferenceAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, handle.fieldType.cast(value));
        }

        @ForceInline
        static Object getAndSetRelease(VarHandle ob, Object holder, Object value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndSetReferenceRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, handle.fieldType.cast(value));
        }
    }

    static class FieldInstanceReadOnly
    extends VarHandle {
        final long fieldOffset;
        final Class<?> receiverType;
        final Class<?> fieldType;
        static final VarForm FORM = new VarForm(FieldInstanceReadOnly.class, Object.class, Object.class, new Class[0]);

        FieldInstanceReadOnly(Class<?> receiverType, long fieldOffset, Class<?> fieldType) {
            this(receiverType, fieldOffset, fieldType, FORM, false);
        }

        protected FieldInstanceReadOnly(Class<?> receiverType, long fieldOffset, Class<?> fieldType, VarForm form, boolean exact) {
            super(form, exact);
            this.fieldOffset = fieldOffset;
            this.receiverType = receiverType;
            this.fieldType = fieldType;
        }

        @Override
        public FieldInstanceReadOnly withInvokeExactBehavior() {
            return this.hasInvokeExactBehavior() ? this : new FieldInstanceReadOnly(this.receiverType, this.fieldOffset, this.fieldType, this.vform, true);
        }

        @Override
        public FieldInstanceReadOnly withInvokeBehavior() {
            return !this.hasInvokeExactBehavior() ? this : new FieldInstanceReadOnly(this.receiverType, this.fieldOffset, this.fieldType, this.vform, false);
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessType at) {
            return at.accessModeType(this.receiverType, this.fieldType, new Class[0]);
        }

        @Override
        public Optional<VarHandle.VarHandleDesc> describeConstable() {
            Optional<ClassDesc> receiverTypeRef = this.receiverType.describeConstable();
            Optional<ClassDesc> fieldTypeRef = this.fieldType.describeConstable();
            if (!receiverTypeRef.isPresent() || !fieldTypeRef.isPresent()) {
                return Optional.empty();
            }
            String name = VarHandles.getFieldFromReceiverAndOffset(this.receiverType, this.fieldOffset, this.fieldType).getName();
            return Optional.of(VarHandle.VarHandleDesc.ofField(receiverTypeRef.get(), name, fieldTypeRef.get()));
        }

        @ForceInline
        static Object get(VarHandle ob, Object holder) {
            FieldInstanceReadOnly handle = (FieldInstanceReadOnly)ob;
            return MethodHandleStatics.UNSAFE.getReference(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }

        @ForceInline
        static Object getVolatile(VarHandle ob, Object holder) {
            FieldInstanceReadOnly handle = (FieldInstanceReadOnly)ob;
            return MethodHandleStatics.UNSAFE.getReferenceVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }

        @ForceInline
        static Object getOpaque(VarHandle ob, Object holder) {
            FieldInstanceReadOnly handle = (FieldInstanceReadOnly)ob;
            return MethodHandleStatics.UNSAFE.getReferenceOpaque(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }

        @ForceInline
        static Object getAcquire(VarHandle ob, Object holder) {
            FieldInstanceReadOnly handle = (FieldInstanceReadOnly)ob;
            return MethodHandleStatics.UNSAFE.getReferenceAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }
    }
}

