/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.constant.ClassDesc;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarForm;
import java.lang.invoke.VarHandle;
import java.lang.invoke.VarHandles;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.Optional;
import jdk.internal.util.Preconditions;
import jdk.internal.vm.annotation.ForceInline;

final class VarHandleShorts {
    VarHandleShorts() {
    }

    static final class Array
    extends VarHandle {
        final int abase;
        final int ashift;
        static final VarForm FORM = new VarForm(Array.class, short[].class, Short.TYPE, Integer.TYPE);

        Array(int abase, int ashift) {
            this(abase, ashift, false);
        }

        private Array(int abase, int ashift, boolean exact) {
            super(FORM, exact);
            this.abase = abase;
            this.ashift = ashift;
        }

        @Override
        public Array withInvokeExactBehavior() {
            return this.hasInvokeExactBehavior() ? this : new Array(this.abase, this.ashift, true);
        }

        @Override
        public Array withInvokeBehavior() {
            return !this.hasInvokeExactBehavior() ? this : new Array(this.abase, this.ashift, false);
        }

        @Override
        public Optional<VarHandle.VarHandleDesc> describeConstable() {
            Optional<ClassDesc> arrayTypeRef = short[].class.describeConstable();
            if (!arrayTypeRef.isPresent()) {
                return Optional.empty();
            }
            return Optional.of(VarHandle.VarHandleDesc.ofArray(arrayTypeRef.get()));
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessType at) {
            return at.accessModeType(short[].class, Short.TYPE, Integer.TYPE);
        }

        @ForceInline
        static short get(VarHandle ob, Object oarray, int index) {
            Array handle = (Array)ob;
            short[] array = (short[])oarray;
            return array[index];
        }

        @ForceInline
        static void set(VarHandle ob, Object oarray, int index, short value) {
            Array handle = (Array)ob;
            short[] array = (short[])oarray;
            array[index] = value;
        }

        @ForceInline
        static short getVolatile(VarHandle ob, Object oarray, int index) {
            Array handle = (Array)ob;
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.getShortVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase);
        }

        @ForceInline
        static void setVolatile(VarHandle ob, Object oarray, int index, short value) {
            Array handle = (Array)ob;
            short[] array = (short[])oarray;
            MethodHandleStatics.UNSAFE.putShortVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static short getOpaque(VarHandle ob, Object oarray, int index) {
            Array handle = (Array)ob;
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.getShortOpaque(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase);
        }

        @ForceInline
        static void setOpaque(VarHandle ob, Object oarray, int index, short value) {
            Array handle = (Array)ob;
            short[] array = (short[])oarray;
            MethodHandleStatics.UNSAFE.putShortOpaque(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static short getAcquire(VarHandle ob, Object oarray, int index) {
            Array handle = (Array)ob;
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.getShortAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase);
        }

        @ForceInline
        static void setRelease(VarHandle ob, Object oarray, int index, short value) {
            Array handle = (Array)ob;
            short[] array = (short[])oarray;
            MethodHandleStatics.UNSAFE.putShortRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static boolean compareAndSet(VarHandle ob, Object oarray, int index, short expected, short value) {
            Array handle = (Array)ob;
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndSetShort(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static short compareAndExchange(VarHandle ob, Object oarray, int index, short expected, short value) {
            Array handle = (Array)ob;
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndExchangeShort(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static short compareAndExchangeAcquire(VarHandle ob, Object oarray, int index, short expected, short value) {
            Array handle = (Array)ob;
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndExchangeShortAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static short compareAndExchangeRelease(VarHandle ob, Object oarray, int index, short expected, short value) {
            Array handle = (Array)ob;
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndExchangeShortRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(VarHandle ob, Object oarray, int index, short expected, short value) {
            Array handle = (Array)ob;
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetShortPlain(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSet(VarHandle ob, Object oarray, int index, short expected, short value) {
            Array handle = (Array)ob;
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetShort(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(VarHandle ob, Object oarray, int index, short expected, short value) {
            Array handle = (Array)ob;
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetShortAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(VarHandle ob, Object oarray, int index, short expected, short value) {
            Array handle = (Array)ob;
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetShortRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static short getAndSet(VarHandle ob, Object oarray, int index, short value) {
            Array handle = (Array)ob;
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.getAndSetShort(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static short getAndSetAcquire(VarHandle ob, Object oarray, int index, short value) {
            Array handle = (Array)ob;
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.getAndSetShortAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static short getAndSetRelease(VarHandle ob, Object oarray, int index, short value) {
            Array handle = (Array)ob;
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.getAndSetShortRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static short getAndAdd(VarHandle ob, Object oarray, int index, short value) {
            Array handle = (Array)ob;
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.getAndAddShort(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static short getAndAddAcquire(VarHandle ob, Object oarray, int index, short value) {
            Array handle = (Array)ob;
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.getAndAddShortAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static short getAndAddRelease(VarHandle ob, Object oarray, int index, short value) {
            Array handle = (Array)ob;
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.getAndAddShortRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static short getAndBitwiseOr(VarHandle ob, Object oarray, int index, short value) {
            Array handle = (Array)ob;
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrShort(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static short getAndBitwiseOrRelease(VarHandle ob, Object oarray, int index, short value) {
            Array handle = (Array)ob;
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrShortRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static short getAndBitwiseOrAcquire(VarHandle ob, Object oarray, int index, short value) {
            Array handle = (Array)ob;
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrShortAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static short getAndBitwiseAnd(VarHandle ob, Object oarray, int index, short value) {
            Array handle = (Array)ob;
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndShort(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static short getAndBitwiseAndRelease(VarHandle ob, Object oarray, int index, short value) {
            Array handle = (Array)ob;
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndShortRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static short getAndBitwiseAndAcquire(VarHandle ob, Object oarray, int index, short value) {
            Array handle = (Array)ob;
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndShortAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static short getAndBitwiseXor(VarHandle ob, Object oarray, int index, short value) {
            Array handle = (Array)ob;
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorShort(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static short getAndBitwiseXorRelease(VarHandle ob, Object oarray, int index, short value) {
            Array handle = (Array)ob;
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorShortRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static short getAndBitwiseXorAcquire(VarHandle ob, Object oarray, int index, short value) {
            Array handle = (Array)ob;
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorShortAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }
    }

    static final class FieldStaticReadWrite
    extends FieldStaticReadOnly {
        static final VarForm FORM = new VarForm(FieldStaticReadWrite.class, null, Short.TYPE, new Class[0]);

        FieldStaticReadWrite(Object base, long fieldOffset) {
            this(base, fieldOffset, false);
        }

        private FieldStaticReadWrite(Object base, long fieldOffset, boolean exact) {
            super(base, fieldOffset, FORM, exact);
        }

        @Override
        public FieldStaticReadWrite withInvokeExactBehavior() {
            return this.hasInvokeExactBehavior() ? this : new FieldStaticReadWrite(this.base, this.fieldOffset, true);
        }

        @Override
        public FieldStaticReadWrite withInvokeBehavior() {
            return !this.hasInvokeExactBehavior() ? this : new FieldStaticReadWrite(this.base, this.fieldOffset, false);
        }

        @ForceInline
        static void set(VarHandle ob, short value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            MethodHandleStatics.UNSAFE.putShort(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static void setVolatile(VarHandle ob, short value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            MethodHandleStatics.UNSAFE.putShortVolatile(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static void setOpaque(VarHandle ob, short value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            MethodHandleStatics.UNSAFE.putShortOpaque(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static void setRelease(VarHandle ob, short value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            MethodHandleStatics.UNSAFE.putShortRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static boolean compareAndSet(VarHandle ob, short expected, short value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.compareAndSetShort(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static short compareAndExchange(VarHandle ob, short expected, short value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.compareAndExchangeShort(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static short compareAndExchangeAcquire(VarHandle ob, short expected, short value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.compareAndExchangeShortAcquire(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static short compareAndExchangeRelease(VarHandle ob, short expected, short value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.compareAndExchangeShortRelease(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(VarHandle ob, short expected, short value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetShortPlain(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSet(VarHandle ob, short expected, short value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetShort(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(VarHandle ob, short expected, short value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetShortAcquire(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(VarHandle ob, short expected, short value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetShortRelease(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static short getAndSet(VarHandle ob, short value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndSetShort(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndSetAcquire(VarHandle ob, short value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndSetShortAcquire(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndSetRelease(VarHandle ob, short value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndSetShortRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndAdd(VarHandle ob, short value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndAddShort(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndAddAcquire(VarHandle ob, short value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndAddShortAcquire(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndAddRelease(VarHandle ob, short value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndAddShortRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndBitwiseOr(VarHandle ob, short value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrShort(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndBitwiseOrRelease(VarHandle ob, short value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrShortRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndBitwiseOrAcquire(VarHandle ob, short value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrShortAcquire(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndBitwiseAnd(VarHandle ob, short value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndShort(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndBitwiseAndRelease(VarHandle ob, short value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndShortRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndBitwiseAndAcquire(VarHandle ob, short value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndShortAcquire(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndBitwiseXor(VarHandle ob, short value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorShort(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndBitwiseXorRelease(VarHandle ob, short value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorShortRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndBitwiseXorAcquire(VarHandle ob, short value) {
            FieldStaticReadWrite handle = (FieldStaticReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorShortAcquire(handle.base, handle.fieldOffset, value);
        }
    }

    static class FieldStaticReadOnly
    extends VarHandle {
        final Object base;
        final long fieldOffset;
        static final VarForm FORM = new VarForm(FieldStaticReadOnly.class, null, Short.TYPE, new Class[0]);

        FieldStaticReadOnly(Object base, long fieldOffset) {
            this(base, fieldOffset, FORM, false);
        }

        protected FieldStaticReadOnly(Object base, long fieldOffset, VarForm form, boolean exact) {
            super(form, exact);
            this.base = base;
            this.fieldOffset = fieldOffset;
        }

        @Override
        public FieldStaticReadOnly withInvokeExactBehavior() {
            return this.hasInvokeExactBehavior() ? this : new FieldStaticReadOnly(this.base, this.fieldOffset, this.vform, true);
        }

        @Override
        public FieldStaticReadOnly withInvokeBehavior() {
            return !this.hasInvokeExactBehavior() ? this : new FieldStaticReadOnly(this.base, this.fieldOffset, this.vform, false);
        }

        @Override
        public Optional<VarHandle.VarHandleDesc> describeConstable() {
            Optional<ClassDesc> fieldTypeRef = Short.TYPE.describeConstable();
            if (!fieldTypeRef.isPresent()) {
                return Optional.empty();
            }
            Field staticField = VarHandles.getStaticFieldFromBaseAndOffset(this.base, this.fieldOffset, Short.TYPE);
            Optional<ClassDesc> receiverTypeRef = staticField.getDeclaringClass().describeConstable();
            if (!receiverTypeRef.isPresent()) {
                return Optional.empty();
            }
            return Optional.of(VarHandle.VarHandleDesc.ofStaticField(receiverTypeRef.get(), staticField.getName(), fieldTypeRef.get()));
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessType at) {
            return at.accessModeType(null, Short.TYPE, new Class[0]);
        }

        @ForceInline
        static short get(VarHandle ob) {
            FieldStaticReadOnly handle = (FieldStaticReadOnly)ob;
            return MethodHandleStatics.UNSAFE.getShort(handle.base, handle.fieldOffset);
        }

        @ForceInline
        static short getVolatile(VarHandle ob) {
            FieldStaticReadOnly handle = (FieldStaticReadOnly)ob;
            return MethodHandleStatics.UNSAFE.getShortVolatile(handle.base, handle.fieldOffset);
        }

        @ForceInline
        static short getOpaque(VarHandle ob) {
            FieldStaticReadOnly handle = (FieldStaticReadOnly)ob;
            return MethodHandleStatics.UNSAFE.getShortOpaque(handle.base, handle.fieldOffset);
        }

        @ForceInline
        static short getAcquire(VarHandle ob) {
            FieldStaticReadOnly handle = (FieldStaticReadOnly)ob;
            return MethodHandleStatics.UNSAFE.getShortAcquire(handle.base, handle.fieldOffset);
        }
    }

    static final class FieldInstanceReadWrite
    extends FieldInstanceReadOnly {
        static final VarForm FORM = new VarForm(FieldInstanceReadWrite.class, Object.class, Short.TYPE, new Class[0]);

        FieldInstanceReadWrite(Class<?> receiverType, long fieldOffset) {
            this(receiverType, fieldOffset, false);
        }

        private FieldInstanceReadWrite(Class<?> receiverType, long fieldOffset, boolean exact) {
            super(receiverType, fieldOffset, FORM, exact);
        }

        @Override
        public FieldInstanceReadWrite withInvokeExactBehavior() {
            return this.hasInvokeExactBehavior() ? this : new FieldInstanceReadWrite(this.receiverType, this.fieldOffset, true);
        }

        @Override
        public FieldInstanceReadWrite withInvokeBehavior() {
            return !this.hasInvokeExactBehavior() ? this : new FieldInstanceReadWrite(this.receiverType, this.fieldOffset, false);
        }

        @ForceInline
        static void set(VarHandle ob, Object holder, short value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            MethodHandleStatics.UNSAFE.putShort(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static void setVolatile(VarHandle ob, Object holder, short value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            MethodHandleStatics.UNSAFE.putShortVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static void setOpaque(VarHandle ob, Object holder, short value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            MethodHandleStatics.UNSAFE.putShortOpaque(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static void setRelease(VarHandle ob, Object holder, short value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            MethodHandleStatics.UNSAFE.putShortRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static boolean compareAndSet(VarHandle ob, Object holder, short expected, short value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.compareAndSetShort(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static short compareAndExchange(VarHandle ob, Object holder, short expected, short value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.compareAndExchangeShort(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static short compareAndExchangeAcquire(VarHandle ob, Object holder, short expected, short value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.compareAndExchangeShortAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static short compareAndExchangeRelease(VarHandle ob, Object holder, short expected, short value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.compareAndExchangeShortRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(VarHandle ob, Object holder, short expected, short value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetShortPlain(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSet(VarHandle ob, Object holder, short expected, short value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetShort(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(VarHandle ob, Object holder, short expected, short value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetShortAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(VarHandle ob, Object holder, short expected, short value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.weakCompareAndSetShortRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static short getAndSet(VarHandle ob, Object holder, short value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndSetShort(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndSetAcquire(VarHandle ob, Object holder, short value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndSetShortAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndSetRelease(VarHandle ob, Object holder, short value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndSetShortRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndAdd(VarHandle ob, Object holder, short value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndAddShort(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndAddAcquire(VarHandle ob, Object holder, short value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndAddShortAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndAddRelease(VarHandle ob, Object holder, short value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndAddShortRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndBitwiseOr(VarHandle ob, Object holder, short value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrShort(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndBitwiseOrRelease(VarHandle ob, Object holder, short value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrShortRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndBitwiseOrAcquire(VarHandle ob, Object holder, short value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrShortAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndBitwiseAnd(VarHandle ob, Object holder, short value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndShort(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndBitwiseAndRelease(VarHandle ob, Object holder, short value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndShortRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndBitwiseAndAcquire(VarHandle ob, Object holder, short value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndShortAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndBitwiseXor(VarHandle ob, Object holder, short value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorShort(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndBitwiseXorRelease(VarHandle ob, Object holder, short value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorShortRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndBitwiseXorAcquire(VarHandle ob, Object holder, short value) {
            FieldInstanceReadWrite handle = (FieldInstanceReadWrite)ob;
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorShortAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }
    }

    static class FieldInstanceReadOnly
    extends VarHandle {
        final long fieldOffset;
        final Class<?> receiverType;
        static final VarForm FORM = new VarForm(FieldInstanceReadOnly.class, Object.class, Short.TYPE, new Class[0]);

        FieldInstanceReadOnly(Class<?> receiverType, long fieldOffset) {
            this(receiverType, fieldOffset, FORM, false);
        }

        protected FieldInstanceReadOnly(Class<?> receiverType, long fieldOffset, VarForm form, boolean exact) {
            super(form, exact);
            this.fieldOffset = fieldOffset;
            this.receiverType = receiverType;
        }

        @Override
        public FieldInstanceReadOnly withInvokeExactBehavior() {
            return this.hasInvokeExactBehavior() ? this : new FieldInstanceReadOnly(this.receiverType, this.fieldOffset, this.vform, true);
        }

        @Override
        public FieldInstanceReadOnly withInvokeBehavior() {
            return !this.hasInvokeExactBehavior() ? this : new FieldInstanceReadOnly(this.receiverType, this.fieldOffset, this.vform, false);
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessType at) {
            return at.accessModeType(this.receiverType, Short.TYPE, new Class[0]);
        }

        @Override
        public Optional<VarHandle.VarHandleDesc> describeConstable() {
            Optional<ClassDesc> receiverTypeRef = this.receiverType.describeConstable();
            Optional<ClassDesc> fieldTypeRef = Short.TYPE.describeConstable();
            if (!receiverTypeRef.isPresent() || !fieldTypeRef.isPresent()) {
                return Optional.empty();
            }
            String name = VarHandles.getFieldFromReceiverAndOffset(this.receiverType, this.fieldOffset, Short.TYPE).getName();
            return Optional.of(VarHandle.VarHandleDesc.ofField(receiverTypeRef.get(), name, fieldTypeRef.get()));
        }

        @ForceInline
        static short get(VarHandle ob, Object holder) {
            FieldInstanceReadOnly handle = (FieldInstanceReadOnly)ob;
            return MethodHandleStatics.UNSAFE.getShort(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }

        @ForceInline
        static short getVolatile(VarHandle ob, Object holder) {
            FieldInstanceReadOnly handle = (FieldInstanceReadOnly)ob;
            return MethodHandleStatics.UNSAFE.getShortVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }

        @ForceInline
        static short getOpaque(VarHandle ob, Object holder) {
            FieldInstanceReadOnly handle = (FieldInstanceReadOnly)ob;
            return MethodHandleStatics.UNSAFE.getShortOpaque(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }

        @ForceInline
        static short getAcquire(VarHandle ob, Object holder) {
            FieldInstanceReadOnly handle = (FieldInstanceReadOnly)ob;
            return MethodHandleStatics.UNSAFE.getShortAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }
    }
}

