/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.DelegatingMethodHandle;
import java.lang.invoke.DirectMethodHandle;
import java.lang.invoke.IndirectVarHandle;
import java.lang.invoke.InfoFromMemberName;
import java.lang.invoke.MemberName;
import java.lang.invoke.MemoryAccessVarHandleByteHelper;
import java.lang.invoke.MemoryAccessVarHandleCharHelper;
import java.lang.invoke.MemoryAccessVarHandleDoubleHelper;
import java.lang.invoke.MemoryAccessVarHandleFloatHelper;
import java.lang.invoke.MemoryAccessVarHandleIntHelper;
import java.lang.invoke.MemoryAccessVarHandleLongHelper;
import java.lang.invoke.MemoryAccessVarHandleShortHelper;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleNatives;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.invoke.VarHandle;
import java.lang.invoke.VarHandleBooleans;
import java.lang.invoke.VarHandleByteArrayAsChars;
import java.lang.invoke.VarHandleByteArrayAsDoubles;
import java.lang.invoke.VarHandleByteArrayAsFloats;
import java.lang.invoke.VarHandleByteArrayAsInts;
import java.lang.invoke.VarHandleByteArrayAsLongs;
import java.lang.invoke.VarHandleByteArrayAsShorts;
import java.lang.invoke.VarHandleBytes;
import java.lang.invoke.VarHandleChars;
import java.lang.invoke.VarHandleDoubles;
import java.lang.invoke.VarHandleFloats;
import java.lang.invoke.VarHandleInts;
import java.lang.invoke.VarHandleLongs;
import java.lang.invoke.VarHandleReferences;
import java.lang.invoke.VarHandleShorts;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import sun.invoke.util.Wrapper;

final class VarHandles {
    static ClassValue<ConcurrentMap<Integer, MethodHandle>> ADDRESS_FACTORIES = new ClassValue<ConcurrentMap<Integer, MethodHandle>>(){

        @Override
        protected ConcurrentMap<Integer, MethodHandle> computeValue(Class<?> type) {
            return new ConcurrentHashMap<Integer, MethodHandle>();
        }
    };

    VarHandles() {
    }

    static VarHandle makeFieldHandle(MemberName f, Class<?> refc, Class<?> type, boolean isWriteAllowedOnFinalFields) {
        if (!f.isStatic()) {
            long foffset = MethodHandleNatives.objectFieldOffset(f);
            if (!type.isPrimitive()) {
                return VarHandles.maybeAdapt(f.isFinal() && !isWriteAllowedOnFinalFields ? new VarHandleReferences.FieldInstanceReadOnly(refc, foffset, type) : new VarHandleReferences.FieldInstanceReadWrite(refc, foffset, type));
            }
            if (type == Boolean.TYPE) {
                return VarHandles.maybeAdapt(f.isFinal() && !isWriteAllowedOnFinalFields ? new VarHandleBooleans.FieldInstanceReadOnly(refc, foffset) : new VarHandleBooleans.FieldInstanceReadWrite(refc, foffset));
            }
            if (type == Byte.TYPE) {
                return VarHandles.maybeAdapt(f.isFinal() && !isWriteAllowedOnFinalFields ? new VarHandleBytes.FieldInstanceReadOnly(refc, foffset) : new VarHandleBytes.FieldInstanceReadWrite(refc, foffset));
            }
            if (type == Short.TYPE) {
                return VarHandles.maybeAdapt(f.isFinal() && !isWriteAllowedOnFinalFields ? new VarHandleShorts.FieldInstanceReadOnly(refc, foffset) : new VarHandleShorts.FieldInstanceReadWrite(refc, foffset));
            }
            if (type == Character.TYPE) {
                return VarHandles.maybeAdapt(f.isFinal() && !isWriteAllowedOnFinalFields ? new VarHandleChars.FieldInstanceReadOnly(refc, foffset) : new VarHandleChars.FieldInstanceReadWrite(refc, foffset));
            }
            if (type == Integer.TYPE) {
                return VarHandles.maybeAdapt(f.isFinal() && !isWriteAllowedOnFinalFields ? new VarHandleInts.FieldInstanceReadOnly(refc, foffset) : new VarHandleInts.FieldInstanceReadWrite(refc, foffset));
            }
            if (type == Long.TYPE) {
                return VarHandles.maybeAdapt(f.isFinal() && !isWriteAllowedOnFinalFields ? new VarHandleLongs.FieldInstanceReadOnly(refc, foffset) : new VarHandleLongs.FieldInstanceReadWrite(refc, foffset));
            }
            if (type == Float.TYPE) {
                return VarHandles.maybeAdapt(f.isFinal() && !isWriteAllowedOnFinalFields ? new VarHandleFloats.FieldInstanceReadOnly(refc, foffset) : new VarHandleFloats.FieldInstanceReadWrite(refc, foffset));
            }
            if (type == Double.TYPE) {
                return VarHandles.maybeAdapt(f.isFinal() && !isWriteAllowedOnFinalFields ? new VarHandleDoubles.FieldInstanceReadOnly(refc, foffset) : new VarHandleDoubles.FieldInstanceReadWrite(refc, foffset));
            }
            throw new UnsupportedOperationException();
        }
        if (MethodHandleStatics.UNSAFE.shouldBeInitialized(refc)) {
            MethodHandleStatics.UNSAFE.ensureClassInitialized(refc);
        }
        Object base = MethodHandleNatives.staticFieldBase(f);
        long foffset = MethodHandleNatives.staticFieldOffset(f);
        if (!type.isPrimitive()) {
            return VarHandles.maybeAdapt(f.isFinal() && !isWriteAllowedOnFinalFields ? new VarHandleReferences.FieldStaticReadOnly(base, foffset, type) : new VarHandleReferences.FieldStaticReadWrite(base, foffset, type));
        }
        if (type == Boolean.TYPE) {
            return VarHandles.maybeAdapt(f.isFinal() && !isWriteAllowedOnFinalFields ? new VarHandleBooleans.FieldStaticReadOnly(base, foffset) : new VarHandleBooleans.FieldStaticReadWrite(base, foffset));
        }
        if (type == Byte.TYPE) {
            return VarHandles.maybeAdapt(f.isFinal() && !isWriteAllowedOnFinalFields ? new VarHandleBytes.FieldStaticReadOnly(base, foffset) : new VarHandleBytes.FieldStaticReadWrite(base, foffset));
        }
        if (type == Short.TYPE) {
            return VarHandles.maybeAdapt(f.isFinal() && !isWriteAllowedOnFinalFields ? new VarHandleShorts.FieldStaticReadOnly(base, foffset) : new VarHandleShorts.FieldStaticReadWrite(base, foffset));
        }
        if (type == Character.TYPE) {
            return VarHandles.maybeAdapt(f.isFinal() && !isWriteAllowedOnFinalFields ? new VarHandleChars.FieldStaticReadOnly(base, foffset) : new VarHandleChars.FieldStaticReadWrite(base, foffset));
        }
        if (type == Integer.TYPE) {
            return VarHandles.maybeAdapt(f.isFinal() && !isWriteAllowedOnFinalFields ? new VarHandleInts.FieldStaticReadOnly(base, foffset) : new VarHandleInts.FieldStaticReadWrite(base, foffset));
        }
        if (type == Long.TYPE) {
            return VarHandles.maybeAdapt(f.isFinal() && !isWriteAllowedOnFinalFields ? new VarHandleLongs.FieldStaticReadOnly(base, foffset) : new VarHandleLongs.FieldStaticReadWrite(base, foffset));
        }
        if (type == Float.TYPE) {
            return VarHandles.maybeAdapt(f.isFinal() && !isWriteAllowedOnFinalFields ? new VarHandleFloats.FieldStaticReadOnly(base, foffset) : new VarHandleFloats.FieldStaticReadWrite(base, foffset));
        }
        if (type == Double.TYPE) {
            return VarHandles.maybeAdapt(f.isFinal() && !isWriteAllowedOnFinalFields ? new VarHandleDoubles.FieldStaticReadOnly(base, foffset) : new VarHandleDoubles.FieldStaticReadWrite(base, foffset));
        }
        throw new UnsupportedOperationException();
    }

    static Field getFieldFromReceiverAndOffset(Class<?> receiverType, long offset, Class<?> fieldType) {
        for (Field f : receiverType.getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers()) || offset != MethodHandleStatics.UNSAFE.objectFieldOffset(f)) continue;
            assert (f.getType() == fieldType);
            return f;
        }
        throw new InternalError("Field not found at offset");
    }

    static Field getStaticFieldFromBaseAndOffset(Object base, long offset, Class<?> fieldType) {
        Class receiverType = (Class)base;
        for (Field f : receiverType.getDeclaredFields()) {
            if (!Modifier.isStatic(f.getModifiers()) || offset != MethodHandleStatics.UNSAFE.staticFieldOffset(f)) continue;
            assert (f.getType() == fieldType);
            return f;
        }
        throw new InternalError("Static field not found at offset");
    }

    static VarHandle makeArrayElementHandle(Class<?> arrayClass) {
        if (!arrayClass.isArray()) {
            throw new IllegalArgumentException("not an array: " + arrayClass);
        }
        Class<?> componentType = arrayClass.getComponentType();
        int aoffset = MethodHandleStatics.UNSAFE.arrayBaseOffset(arrayClass);
        int ascale = MethodHandleStatics.UNSAFE.arrayIndexScale(arrayClass);
        int ashift = 31 - Integer.numberOfLeadingZeros(ascale);
        if (!componentType.isPrimitive()) {
            return VarHandles.maybeAdapt(new VarHandleReferences.Array(aoffset, ashift, arrayClass));
        }
        if (componentType == Boolean.TYPE) {
            return VarHandles.maybeAdapt(new VarHandleBooleans.Array(aoffset, ashift));
        }
        if (componentType == Byte.TYPE) {
            return VarHandles.maybeAdapt(new VarHandleBytes.Array(aoffset, ashift));
        }
        if (componentType == Short.TYPE) {
            return VarHandles.maybeAdapt(new VarHandleShorts.Array(aoffset, ashift));
        }
        if (componentType == Character.TYPE) {
            return VarHandles.maybeAdapt(new VarHandleChars.Array(aoffset, ashift));
        }
        if (componentType == Integer.TYPE) {
            return VarHandles.maybeAdapt(new VarHandleInts.Array(aoffset, ashift));
        }
        if (componentType == Long.TYPE) {
            return VarHandles.maybeAdapt(new VarHandleLongs.Array(aoffset, ashift));
        }
        if (componentType == Float.TYPE) {
            return VarHandles.maybeAdapt(new VarHandleFloats.Array(aoffset, ashift));
        }
        if (componentType == Double.TYPE) {
            return VarHandles.maybeAdapt(new VarHandleDoubles.Array(aoffset, ashift));
        }
        throw new UnsupportedOperationException();
    }

    static VarHandle byteArrayViewHandle(Class<?> viewArrayClass, boolean be) {
        if (!viewArrayClass.isArray()) {
            throw new IllegalArgumentException("not an array: " + viewArrayClass);
        }
        Class<?> viewComponentType = viewArrayClass.getComponentType();
        if (viewComponentType == Long.TYPE) {
            return VarHandles.maybeAdapt(new VarHandleByteArrayAsLongs.ArrayHandle(be));
        }
        if (viewComponentType == Integer.TYPE) {
            return VarHandles.maybeAdapt(new VarHandleByteArrayAsInts.ArrayHandle(be));
        }
        if (viewComponentType == Short.TYPE) {
            return VarHandles.maybeAdapt(new VarHandleByteArrayAsShorts.ArrayHandle(be));
        }
        if (viewComponentType == Character.TYPE) {
            return VarHandles.maybeAdapt(new VarHandleByteArrayAsChars.ArrayHandle(be));
        }
        if (viewComponentType == Double.TYPE) {
            return VarHandles.maybeAdapt(new VarHandleByteArrayAsDoubles.ArrayHandle(be));
        }
        if (viewComponentType == Float.TYPE) {
            return VarHandles.maybeAdapt(new VarHandleByteArrayAsFloats.ArrayHandle(be));
        }
        throw new UnsupportedOperationException();
    }

    static VarHandle makeByteBufferViewHandle(Class<?> viewArrayClass, boolean be) {
        if (!viewArrayClass.isArray()) {
            throw new IllegalArgumentException("not an array: " + viewArrayClass);
        }
        Class<?> viewComponentType = viewArrayClass.getComponentType();
        if (viewComponentType == Long.TYPE) {
            return VarHandles.maybeAdapt(new VarHandleByteArrayAsLongs.ByteBufferHandle(be));
        }
        if (viewComponentType == Integer.TYPE) {
            return VarHandles.maybeAdapt(new VarHandleByteArrayAsInts.ByteBufferHandle(be));
        }
        if (viewComponentType == Short.TYPE) {
            return VarHandles.maybeAdapt(new VarHandleByteArrayAsShorts.ByteBufferHandle(be));
        }
        if (viewComponentType == Character.TYPE) {
            return VarHandles.maybeAdapt(new VarHandleByteArrayAsChars.ByteBufferHandle(be));
        }
        if (viewComponentType == Double.TYPE) {
            return VarHandles.maybeAdapt(new VarHandleByteArrayAsDoubles.ByteBufferHandle(be));
        }
        if (viewComponentType == Float.TYPE) {
            return VarHandles.maybeAdapt(new VarHandleByteArrayAsFloats.ByteBufferHandle(be));
        }
        throw new UnsupportedOperationException();
    }

    static VarHandle makeMemoryAddressViewHandle(Class<?> carrier, boolean skipAlignmentMaskCheck, long alignmentMask, ByteOrder byteOrder) {
        if (!carrier.isPrimitive() || carrier == Void.TYPE || carrier == Boolean.TYPE) {
            throw new IllegalArgumentException("Invalid carrier: " + carrier.getName());
        }
        long size = Wrapper.forPrimitiveType(carrier).bitWidth() / 8;
        boolean be = byteOrder == ByteOrder.BIG_ENDIAN;
        boolean exact = false;
        if (carrier == Byte.TYPE) {
            return VarHandles.maybeAdapt(new MemoryAccessVarHandleByteHelper(skipAlignmentMaskCheck, be, size, alignmentMask, exact));
        }
        if (carrier == Character.TYPE) {
            return VarHandles.maybeAdapt(new MemoryAccessVarHandleCharHelper(skipAlignmentMaskCheck, be, size, alignmentMask, exact));
        }
        if (carrier == Short.TYPE) {
            return VarHandles.maybeAdapt(new MemoryAccessVarHandleShortHelper(skipAlignmentMaskCheck, be, size, alignmentMask, exact));
        }
        if (carrier == Integer.TYPE) {
            return VarHandles.maybeAdapt(new MemoryAccessVarHandleIntHelper(skipAlignmentMaskCheck, be, size, alignmentMask, exact));
        }
        if (carrier == Float.TYPE) {
            return VarHandles.maybeAdapt(new MemoryAccessVarHandleFloatHelper(skipAlignmentMaskCheck, be, size, alignmentMask, exact));
        }
        if (carrier == Long.TYPE) {
            return VarHandles.maybeAdapt(new MemoryAccessVarHandleLongHelper(skipAlignmentMaskCheck, be, size, alignmentMask, exact));
        }
        if (carrier == Double.TYPE) {
            return VarHandles.maybeAdapt(new MemoryAccessVarHandleDoubleHelper(skipAlignmentMaskCheck, be, size, alignmentMask, exact));
        }
        throw new IllegalStateException("Cannot get here");
    }

    private static VarHandle maybeAdapt(VarHandle target) {
        if (!MethodHandleStatics.VAR_HANDLE_IDENTITY_ADAPT) {
            return target;
        }
        target = VarHandles.filterValue(target, MethodHandles.identity(target.varType()), MethodHandles.identity(target.varType()));
        MethodType mtype = target.accessModeType(VarHandle.AccessMode.GET);
        for (int i = 0; i < mtype.parameterCount(); ++i) {
            target = VarHandles.filterCoordinates(target, i, MethodHandles.identity(mtype.parameterType(i)));
        }
        return target;
    }

    public static VarHandle filterValue(VarHandle target, MethodHandle filterToTarget, MethodHandle filterFromTarget) {
        Objects.requireNonNull(target);
        Objects.requireNonNull(filterToTarget);
        Objects.requireNonNull(filterFromTarget);
        VarHandles.noCheckedExceptions(filterToTarget);
        VarHandles.noCheckedExceptions(filterFromTarget);
        ArrayList<TypeDescriptor.OfField> newCoordinates = new ArrayList<TypeDescriptor.OfField>();
        ArrayList<TypeDescriptor.OfField> additionalCoordinates = new ArrayList<TypeDescriptor.OfField>();
        newCoordinates.addAll(target.coordinateTypes());
        if (filterFromTarget.type().parameterCount() != filterToTarget.type().parameterCount()) {
            throw MethodHandleStatics.newIllegalArgumentException("filterFromTarget and filterToTarget have different arity", filterFromTarget.type(), filterToTarget.type());
        }
        if (filterFromTarget.type().parameterCount() < 1) {
            throw MethodHandleStatics.newIllegalArgumentException("filterFromTarget filter type has wrong arity", filterFromTarget.type());
        }
        if (filterToTarget.type().parameterCount() < 1) {
            throw MethodHandleStatics.newIllegalArgumentException("filterToTarget filter type has wrong arity", filterFromTarget.type());
        }
        if (filterFromTarget.type().lastParameterType() != filterToTarget.type().returnType() || filterToTarget.type().lastParameterType() != filterFromTarget.type().returnType()) {
            throw MethodHandleStatics.newIllegalArgumentException("filterFromTarget and filterToTarget filter types do not match", filterFromTarget.type(), filterToTarget.type());
        }
        if (target.varType() != filterFromTarget.type().lastParameterType()) {
            throw MethodHandleStatics.newIllegalArgumentException("filterFromTarget filter type does not match target var handle type", filterFromTarget.type(), target.varType());
        }
        if (target.varType() != filterToTarget.type().returnType()) {
            throw MethodHandleStatics.newIllegalArgumentException("filterFromTarget filter type does not match target var handle type", filterToTarget.type(), target.varType());
        }
        if (filterFromTarget.type().parameterCount() > 1) {
            for (int i = 0; i < filterFromTarget.type().parameterCount() - 1; ++i) {
                if (filterFromTarget.type().parameterType(i) != filterToTarget.type().parameterType(i)) {
                    throw MethodHandleStatics.newIllegalArgumentException("filterFromTarget and filterToTarget filter types do not match", filterFromTarget.type(), filterToTarget.type());
                }
                newCoordinates.add(filterFromTarget.type().parameterType(i));
                additionalCoordinates.add(filterFromTarget.type().parameterType(i));
            }
        }
        return new IndirectVarHandle(target, (Class<?>)filterFromTarget.type().returnType(), newCoordinates.toArray(new Class[0]), (mode, modeHandle) -> {
            int lastParameterPos = modeHandle.type().parameterCount() - 1;
            return switch (mode.at) {
                default -> throw new IncompatibleClassChangeError();
                case VarHandle.AccessType.GET -> MethodHandles.collectReturnValue(modeHandle, filterFromTarget);
                case VarHandle.AccessType.SET -> MethodHandles.collectArguments(modeHandle, lastParameterPos, filterToTarget);
                case VarHandle.AccessType.GET_AND_UPDATE -> {
                    MethodHandle adapter = MethodHandles.collectReturnValue(modeHandle, filterFromTarget);
                    MethodHandle res = MethodHandles.collectArguments(adapter, lastParameterPos, filterToTarget);
                    if (additionalCoordinates.size() > 0) {
                        res = VarHandles.joinDuplicateArgs(res, lastParameterPos, lastParameterPos + additionalCoordinates.size() + 1, additionalCoordinates.size());
                    }
                    yield res;
                }
                case VarHandle.AccessType.COMPARE_AND_EXCHANGE -> {
                    MethodHandle adapter = MethodHandles.collectReturnValue(modeHandle, filterFromTarget);
                    adapter = MethodHandles.collectArguments(adapter, lastParameterPos, filterToTarget);
                    if (additionalCoordinates.size() > 0) {
                        adapter = VarHandles.joinDuplicateArgs(adapter, lastParameterPos, lastParameterPos + additionalCoordinates.size() + 1, additionalCoordinates.size());
                    }
                    MethodHandle res = MethodHandles.collectArguments(adapter, lastParameterPos - 1, filterToTarget);
                    if (additionalCoordinates.size() > 0) {
                        res = VarHandles.joinDuplicateArgs(res, lastParameterPos - 1, lastParameterPos + additionalCoordinates.size(), additionalCoordinates.size());
                    }
                    yield res;
                }
                case VarHandle.AccessType.COMPARE_AND_SET -> {
                    MethodHandle adapter = MethodHandles.collectArguments(modeHandle, lastParameterPos, filterToTarget);
                    MethodHandle res = MethodHandles.collectArguments(adapter, lastParameterPos - 1, filterToTarget);
                    if (additionalCoordinates.size() > 0) {
                        res = VarHandles.joinDuplicateArgs(res, lastParameterPos - 1, lastParameterPos + additionalCoordinates.size(), additionalCoordinates.size());
                    }
                    yield res;
                }
            };
        });
    }

    private static MethodHandle joinDuplicateArgs(MethodHandle handle, int originalStart, int dropStart, int length) {
        int i;
        int[] perms = new int[handle.type().parameterCount()];
        for (i = 0; i < dropStart; ++i) {
            perms[i] = i;
        }
        for (i = 0; i < length; ++i) {
            perms[dropStart + i] = originalStart + i;
        }
        for (i = dropStart + length; i < perms.length; ++i) {
            perms[i] = i - length;
        }
        return MethodHandles.permuteArguments(handle, handle.type().dropParameterTypes(dropStart, dropStart + length), perms);
    }

    public static VarHandle filterCoordinates(VarHandle target, int pos, MethodHandle ... filters) {
        Objects.requireNonNull(target);
        Objects.requireNonNull(filters);
        List<Class<?>> targetCoordinates = target.coordinateTypes();
        if (pos < 0 || pos >= targetCoordinates.size()) {
            throw MethodHandleStatics.newIllegalArgumentException("Invalid position " + pos + " for coordinate types", targetCoordinates);
        }
        if (pos + filters.length > targetCoordinates.size()) {
            throw new IllegalArgumentException("Too many filters");
        }
        if (filters.length == 0) {
            return target;
        }
        ArrayList newCoordinates = new ArrayList(targetCoordinates);
        for (int i = 0; i < filters.length; ++i) {
            VarHandles.noCheckedExceptions(filters[i]);
            MethodType filterType = filters[i].type();
            if (filterType.parameterCount() != 1) {
                throw MethodHandleStatics.newIllegalArgumentException("Invalid filter type " + filterType);
            }
            if (newCoordinates.get(pos + i) != filterType.returnType()) {
                throw MethodHandleStatics.newIllegalArgumentException("Invalid filter type " + filterType + " for coordinate type " + newCoordinates.get(i));
            }
            newCoordinates.set(pos + i, (Class<?>)filters[i].type().parameterType(0));
        }
        return new IndirectVarHandle(target, target.varType(), newCoordinates.toArray(new Class[0]), (mode, modeHandle) -> MethodHandles.filterArguments(modeHandle, 1 + pos, filters));
    }

    public static VarHandle insertCoordinates(VarHandle target, int pos, Object ... values) {
        Objects.requireNonNull(target);
        Objects.requireNonNull(values);
        List<Class<?>> targetCoordinates = target.coordinateTypes();
        if (pos < 0 || pos >= targetCoordinates.size()) {
            throw MethodHandleStatics.newIllegalArgumentException("Invalid position " + pos + " for coordinate types", targetCoordinates);
        }
        if (pos + values.length > targetCoordinates.size()) {
            throw new IllegalArgumentException("Too many values");
        }
        if (values.length == 0) {
            return target;
        }
        ArrayList newCoordinates = new ArrayList(targetCoordinates);
        for (int i = 0; i < values.length; ++i) {
            Class pt = (Class)newCoordinates.get(pos);
            if (pt.isPrimitive()) {
                Wrapper w = Wrapper.forPrimitiveType(pt);
                w.convert(values[i], pt);
            } else {
                pt.cast(values[i]);
            }
            newCoordinates.remove(pos);
        }
        return new IndirectVarHandle(target, target.varType(), newCoordinates.toArray(new Class[0]), (mode, modeHandle) -> MethodHandles.insertArguments(modeHandle, 1 + pos, values));
    }

    public static VarHandle permuteCoordinates(VarHandle target, List<Class<?>> newCoordinates, int ... reorder) {
        Objects.requireNonNull(target);
        Objects.requireNonNull(newCoordinates);
        Objects.requireNonNull(reorder);
        List<Class<?>> targetCoordinates = target.coordinateTypes();
        MethodHandles.permuteArgumentChecks(reorder, MethodType.methodType(Void.TYPE, newCoordinates), MethodType.methodType(Void.TYPE, targetCoordinates));
        return new IndirectVarHandle(target, target.varType(), newCoordinates.toArray(new Class[0]), (mode, modeHandle) -> MethodHandles.permuteArguments(modeHandle, VarHandles.methodTypeFor(mode.at, modeHandle.type(), targetCoordinates, newCoordinates), VarHandles.reorderArrayFor(mode.at, newCoordinates, reorder)));
    }

    private static int numTrailingArgs(VarHandle.AccessType at) {
        return switch (at) {
            default -> throw new IncompatibleClassChangeError();
            case VarHandle.AccessType.GET -> 0;
            case VarHandle.AccessType.GET_AND_UPDATE, VarHandle.AccessType.SET -> 1;
            case VarHandle.AccessType.COMPARE_AND_SET, VarHandle.AccessType.COMPARE_AND_EXCHANGE -> 2;
        };
    }

    private static int[] reorderArrayFor(VarHandle.AccessType at, List<Class<?>> newCoordinates, int[] reorder) {
        int i;
        int numTrailingArgs = VarHandles.numTrailingArgs(at);
        int[] adjustedReorder = new int[reorder.length + 1 + numTrailingArgs];
        adjustedReorder[0] = 0;
        for (i = 0; i < reorder.length; ++i) {
            adjustedReorder[i + 1] = reorder[i] + 1;
        }
        for (i = 0; i < numTrailingArgs; ++i) {
            adjustedReorder[i + reorder.length + 1] = i + newCoordinates.size() + 1;
        }
        return adjustedReorder;
    }

    private static MethodType methodTypeFor(VarHandle.AccessType at, MethodType oldType, List<Class<?>> oldCoordinates, List<Class<?>> newCoordinates) {
        int numTrailingArgs = VarHandles.numTrailingArgs(at);
        MethodType adjustedType = MethodType.methodType(oldType.returnType(), oldType.parameterType(0));
        adjustedType = adjustedType.appendParameterTypes(newCoordinates);
        for (int i = 0; i < numTrailingArgs; ++i) {
            adjustedType = adjustedType.appendParameterTypes(new Class[]{oldType.parameterType(1 + oldCoordinates.size() + i)});
        }
        return adjustedType;
    }

    public static VarHandle collectCoordinates(VarHandle target, int pos, MethodHandle filter) {
        Objects.requireNonNull(target);
        Objects.requireNonNull(filter);
        VarHandles.noCheckedExceptions(filter);
        List<Class<?>> targetCoordinates = target.coordinateTypes();
        if (pos < 0 || pos >= targetCoordinates.size()) {
            throw MethodHandleStatics.newIllegalArgumentException("Invalid position " + pos + " for coordinate types", targetCoordinates);
        }
        if (filter.type().returnType() == Void.TYPE) {
            throw MethodHandleStatics.newIllegalArgumentException("Invalid filter type " + filter.type() + " ; filter cannot be void");
        }
        if (filter.type().returnType() != targetCoordinates.get(pos)) {
            throw MethodHandleStatics.newIllegalArgumentException("Invalid filter type " + filter.type() + " for coordinate type " + targetCoordinates.get(pos));
        }
        ArrayList newCoordinates = new ArrayList(targetCoordinates);
        newCoordinates.remove(pos);
        newCoordinates.addAll(pos, filter.type().parameterList());
        return new IndirectVarHandle(target, target.varType(), newCoordinates.toArray(new Class[0]), (mode, modeHandle) -> MethodHandles.collectArguments(modeHandle, 1 + pos, filter));
    }

    public static VarHandle dropCoordinates(VarHandle target, int pos, Class<?> ... valueTypes) {
        Objects.requireNonNull(target);
        Objects.requireNonNull(valueTypes);
        List<Class<?>> targetCoordinates = target.coordinateTypes();
        if (pos < 0 || pos > targetCoordinates.size()) {
            throw MethodHandleStatics.newIllegalArgumentException("Invalid position " + pos + " for coordinate types", targetCoordinates);
        }
        if (valueTypes.length == 0) {
            return target;
        }
        ArrayList newCoordinates = new ArrayList(targetCoordinates);
        newCoordinates.addAll(pos, List.of(valueTypes));
        return new IndirectVarHandle(target, target.varType(), newCoordinates.toArray(new Class[0]), (mode, modeHandle) -> MethodHandles.dropArguments(modeHandle, 1 + pos, valueTypes));
    }

    private static void noCheckedExceptions(MethodHandle handle) {
        if (handle instanceof DirectMethodHandle) {
            Class<?>[] exceptionTypes;
            DirectMethodHandle directHandle = (DirectMethodHandle)handle;
            byte refKind = directHandle.member.getReferenceKind();
            InfoFromMemberName info = new InfoFromMemberName(MethodHandles.Lookup.IMPL_LOOKUP, directHandle.member, refKind);
            if (MethodHandleNatives.refKindIsMethod(refKind)) {
                exceptionTypes = info.reflectAs(Method.class, MethodHandles.Lookup.IMPL_LOOKUP).getExceptionTypes();
            } else if (MethodHandleNatives.refKindIsField(refKind)) {
                exceptionTypes = null;
            } else if (MethodHandleNatives.refKindIsConstructor(refKind)) {
                exceptionTypes = info.reflectAs(Constructor.class, MethodHandles.Lookup.IMPL_LOOKUP).getExceptionTypes();
            } else {
                throw new AssertionError((Object)"Cannot get here");
            }
            if (exceptionTypes != null && Stream.of(exceptionTypes).anyMatch(VarHandles::isCheckedException)) {
                throw MethodHandleStatics.newIllegalArgumentException("Cannot adapt a var handle with a method handle which throws checked exceptions");
            }
        } else if (handle instanceof DelegatingMethodHandle) {
            VarHandles.noCheckedExceptions(((DelegatingMethodHandle)handle).getTarget());
        } else {
            BoundMethodHandle boundHandle = (BoundMethodHandle)handle;
            for (int i = 0; i < boundHandle.fieldCount(); ++i) {
                Object arg = boundHandle.arg(i);
                if (!(arg instanceof MethodHandle)) continue;
                VarHandles.noCheckedExceptions((MethodHandle)arg);
            }
        }
    }

    private static boolean isCheckedException(Class<?> clazz) {
        return Throwable.class.isAssignableFrom(clazz) && !RuntimeException.class.isAssignableFrom(clazz) && !Error.class.isAssignableFrom(clazz);
    }
}

