/*
 * Decompiled with CFR 0.152.
 */
package java.lang.module;

import java.io.PrintStream;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.lang.module.ResolvedModule;
import java.lang.module.Resolver;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.internal.misc.CDS;
import jdk.internal.module.ModuleReferenceImpl;
import jdk.internal.module.ModuleTarget;
import jdk.internal.vm.annotation.Stable;

public final class Configuration {
    @Stable
    private static Configuration EMPTY_CONFIGURATION;
    private final List<Configuration> parents;
    private final Map<ResolvedModule, Set<ResolvedModule>> graph;
    private final Set<ResolvedModule> modules;
    private final Map<String, ResolvedModule> nameToModule;
    private final String targetPlatform;
    private volatile List<Configuration> allConfigurations;

    String targetPlatform() {
        return this.targetPlatform;
    }

    private Configuration() {
        this.parents = List.of();
        this.graph = Map.of();
        this.modules = Set.of();
        this.nameToModule = Map.of();
        this.targetPlatform = null;
    }

    private Configuration(List<Configuration> parents, Resolver resolver) {
        Map<ResolvedModule, Set<ResolvedModule>> g = resolver.finish(this);
        Map.Entry[] nameEntries = new Map.Entry[g.size()];
        ResolvedModule[] moduleArray = new ResolvedModule[g.size()];
        int i = 0;
        Iterator<ResolvedModule> iterator = g.keySet().iterator();
        while (iterator.hasNext()) {
            ResolvedModule resolvedModule;
            moduleArray[i] = resolvedModule = iterator.next();
            nameEntries[i] = Map.entry(resolvedModule.name(), resolvedModule);
            ++i;
        }
        this.parents = List.copyOf(parents);
        this.graph = g;
        this.modules = Set.of(moduleArray);
        this.nameToModule = Map.ofEntries(nameEntries);
        this.targetPlatform = resolver.targetPlatform();
    }

    Configuration(ModuleFinder finder, Map<String, Set<String>> map) {
        int moduleCount = map.size();
        Map.Entry[] nameEntries = new Map.Entry[moduleCount];
        ResolvedModule[] moduleArray = new ResolvedModule[moduleCount];
        String targetPlatform = null;
        int i = 0;
        for (String name : map.keySet()) {
            ResolvedModule resolvedModule;
            ModuleTarget target;
            ModuleReference mref = finder.find(name).orElse(null);
            assert (mref != null);
            if (targetPlatform == null && mref instanceof ModuleReferenceImpl && (target = ((ModuleReferenceImpl)mref).moduleTarget()) != null) {
                targetPlatform = target.targetPlatform();
            }
            moduleArray[i] = resolvedModule = new ResolvedModule(this, mref);
            nameEntries[i] = Map.entry(name, resolvedModule);
            ++i;
        }
        Map nameToModule = Map.ofEntries(nameEntries);
        Map.Entry[] moduleEntries = new Map.Entry[moduleCount];
        i = 0;
        for (ResolvedModule resolvedModule : moduleArray) {
            Set<String> names = map.get(resolvedModule.name());
            ResolvedModule[] readsArray = new ResolvedModule[names.size()];
            int j = 0;
            for (String name : names) {
                readsArray[j++] = (ResolvedModule)nameToModule.get(name);
            }
            moduleEntries[i++] = Map.entry(resolvedModule, Set.of(readsArray));
        }
        this.parents = List.of(Configuration.empty());
        this.graph = Map.ofEntries(moduleEntries);
        this.modules = Set.of(moduleArray);
        this.nameToModule = nameToModule;
        this.targetPlatform = targetPlatform;
    }

    public Configuration resolve(ModuleFinder before, ModuleFinder after, Collection<String> roots) {
        return Configuration.resolve(before, List.of(this), after, roots);
    }

    public Configuration resolveAndBind(ModuleFinder before, ModuleFinder after, Collection<String> roots) {
        return Configuration.resolveAndBind(before, List.of(this), after, roots);
    }

    static Configuration resolveAndBind(ModuleFinder finder, Collection<String> roots, PrintStream traceOutput) {
        List<Configuration> parents = List.of(Configuration.empty());
        Resolver resolver = new Resolver(finder, parents, ModuleFinder.of(new Path[0]), traceOutput);
        resolver.resolve(roots).bind(false);
        return new Configuration(parents, resolver);
    }

    public static Configuration resolve(ModuleFinder before, List<Configuration> parents, ModuleFinder after, Collection<String> roots) {
        Objects.requireNonNull(before);
        Objects.requireNonNull(after);
        Objects.requireNonNull(roots);
        ArrayList<Configuration> parentList = new ArrayList<Configuration>(parents);
        if (parentList.isEmpty()) {
            throw new IllegalArgumentException("'parents' is empty");
        }
        Resolver resolver = new Resolver(before, parentList, after, null);
        resolver.resolve(roots);
        return new Configuration(parentList, resolver);
    }

    public static Configuration resolveAndBind(ModuleFinder before, List<Configuration> parents, ModuleFinder after, Collection<String> roots) {
        Objects.requireNonNull(before);
        Objects.requireNonNull(after);
        Objects.requireNonNull(roots);
        ArrayList<Configuration> parentList = new ArrayList<Configuration>(parents);
        if (parentList.isEmpty()) {
            throw new IllegalArgumentException("'parents' is empty");
        }
        Resolver resolver = new Resolver(before, parentList, after, null);
        resolver.resolve(roots).bind();
        return new Configuration(parentList, resolver);
    }

    public static Configuration empty() {
        return EMPTY_CONFIGURATION;
    }

    public List<Configuration> parents() {
        return this.parents;
    }

    public Set<ResolvedModule> modules() {
        return this.modules;
    }

    public Optional<ResolvedModule> findModule(String name) {
        Objects.requireNonNull(name);
        ResolvedModule m = this.nameToModule.get(name);
        if (m != null) {
            return Optional.of(m);
        }
        if (!this.parents.isEmpty()) {
            return this.configurations().skip(1L).map(cf -> cf.nameToModule.get(name)).filter(Objects::nonNull).findFirst();
        }
        return Optional.empty();
    }

    Set<ModuleDescriptor> descriptors() {
        if (this.modules.isEmpty()) {
            return Set.of();
        }
        return this.modules.stream().map(ResolvedModule::reference).map(ModuleReference::descriptor).collect(Collectors.toSet());
    }

    Set<ResolvedModule> reads(ResolvedModule m) {
        return Set.copyOf((Collection)this.graph.get(m));
    }

    Stream<Configuration> configurations() {
        List<Configuration> allConfigurations = this.allConfigurations;
        if (allConfigurations == null) {
            allConfigurations = new ArrayList<Configuration>();
            HashSet<Configuration> visited = new HashSet<Configuration>();
            ArrayDeque<Configuration> stack = new ArrayDeque<Configuration>();
            visited.add(this);
            stack.push(this);
            while (!stack.isEmpty()) {
                Configuration layer = (Configuration)stack.pop();
                allConfigurations.add(layer);
                for (int i = layer.parents.size() - 1; i >= 0; --i) {
                    Configuration parent = layer.parents.get(i);
                    if (!visited.add(parent)) continue;
                    stack.push(parent);
                }
            }
            this.allConfigurations = allConfigurations;
        }
        return allConfigurations.stream();
    }

    public String toString() {
        return this.modules().stream().map(ResolvedModule::name).collect(Collectors.joining(", "));
    }

    static {
        CDS.initializeFromArchive(Configuration.class);
        if (EMPTY_CONFIGURATION == null) {
            EMPTY_CONFIGURATION = new Configuration();
        }
    }
}

