/*
 * Decompiled with CFR 0.152.
 */
package java.lang.module;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.internal.access.JavaLangModuleAccess;
import jdk.internal.access.SharedSecrets;
import jdk.internal.module.Checks;
import jdk.internal.module.ModuleInfo;

public class ModuleDescriptor
implements Comparable<ModuleDescriptor> {
    private final String name;
    private final Version version;
    private final String rawVersionString;
    private final Set<Modifier> modifiers;
    private final boolean open;
    private final boolean automatic;
    private final Set<Requires> requires;
    private final Set<Exports> exports;
    private final Set<Opens> opens;
    private final Set<String> uses;
    private final Set<Provides> provides;
    private final Set<String> packages;
    private final String mainClass;
    private transient int hash;

    private ModuleDescriptor(String name, Version version, String rawVersionString, Set<Modifier> modifiers, Set<Requires> requires, Set<Exports> exports, Set<Opens> opens, Set<String> uses, Set<Provides> provides, Set<String> packages, String mainClass) {
        assert (version == null || rawVersionString == null);
        this.name = name;
        this.version = version;
        this.rawVersionString = rawVersionString;
        this.modifiers = Set.copyOf(modifiers);
        this.open = modifiers.contains((Object)Modifier.OPEN);
        this.automatic = modifiers.contains((Object)Modifier.AUTOMATIC);
        assert (requires.stream().map(Requires::name).distinct().count() == (long)requires.size());
        this.requires = Set.copyOf(requires);
        this.exports = Set.copyOf(exports);
        this.opens = Set.copyOf(opens);
        this.uses = Set.copyOf(uses);
        this.provides = Set.copyOf(provides);
        this.packages = Set.copyOf(packages);
        this.mainClass = mainClass;
    }

    ModuleDescriptor(String name, Version version, Set<Modifier> modifiers, Set<Requires> requires, Set<Exports> exports, Set<Opens> opens, Set<String> uses, Set<Provides> provides, Set<String> packages, String mainClass, int hashCode, boolean unused) {
        this.name = name;
        this.version = version;
        this.rawVersionString = null;
        this.modifiers = modifiers;
        this.open = modifiers.contains((Object)Modifier.OPEN);
        this.automatic = modifiers.contains((Object)Modifier.AUTOMATIC);
        this.requires = requires;
        this.exports = exports;
        this.opens = opens;
        this.uses = uses;
        this.provides = provides;
        this.packages = packages;
        this.mainClass = mainClass;
        this.hash = hashCode;
    }

    public String name() {
        return this.name;
    }

    public Set<Modifier> modifiers() {
        return this.modifiers;
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isAutomatic() {
        return this.automatic;
    }

    public Set<Requires> requires() {
        return this.requires;
    }

    public Set<Exports> exports() {
        return this.exports;
    }

    public Set<Opens> opens() {
        return this.opens;
    }

    public Set<String> uses() {
        return this.uses;
    }

    public Set<Provides> provides() {
        return this.provides;
    }

    public Optional<Version> version() {
        return Optional.ofNullable(this.version);
    }

    public Optional<String> rawVersion() {
        if (this.version != null) {
            return Optional.of(this.version.toString());
        }
        return Optional.ofNullable(this.rawVersionString);
    }

    public String toNameAndVersion() {
        if (this.version != null) {
            return this.name() + "@" + this.version;
        }
        return this.name();
    }

    public Optional<String> mainClass() {
        return Optional.ofNullable(this.mainClass);
    }

    public Set<String> packages() {
        return this.packages;
    }

    @Override
    public int compareTo(ModuleDescriptor that) {
        long v2;
        if (this == that) {
            return 0;
        }
        int c = this.name().compareTo(that.name());
        if (c != 0) {
            return c;
        }
        c = ModuleDescriptor.compare(this.version, that.version);
        if (c != 0) {
            return c;
        }
        c = ModuleDescriptor.compare(this.rawVersionString, that.rawVersionString);
        if (c != 0) {
            return c;
        }
        long v1 = ModuleDescriptor.modsValue(this.modifiers());
        c = Long.compare(v1, v2 = ModuleDescriptor.modsValue(that.modifiers()));
        if (c != 0) {
            return c;
        }
        c = ModuleDescriptor.compare(this.requires, that.requires);
        if (c != 0) {
            return c;
        }
        c = ModuleDescriptor.compare(this.packages, that.packages);
        if (c != 0) {
            return c;
        }
        c = ModuleDescriptor.compare(this.exports, that.exports);
        if (c != 0) {
            return c;
        }
        c = ModuleDescriptor.compare(this.opens, that.opens);
        if (c != 0) {
            return c;
        }
        c = ModuleDescriptor.compare(this.uses, that.uses);
        if (c != 0) {
            return c;
        }
        c = ModuleDescriptor.compare(this.provides, that.provides);
        if (c != 0) {
            return c;
        }
        c = ModuleDescriptor.compare(this.mainClass, that.mainClass);
        if (c != 0) {
            return c;
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object ob) {
        if (ob == this) {
            return true;
        }
        if (!(ob instanceof ModuleDescriptor)) return false;
        ModuleDescriptor that = (ModuleDescriptor)ob;
        if (!this.name.equals(that.name)) return false;
        if (!this.modifiers.equals(that.modifiers)) return false;
        if (!this.requires.equals(that.requires)) return false;
        if (!Objects.equals(this.packages, that.packages)) return false;
        if (!this.exports.equals(that.exports)) return false;
        if (!this.opens.equals(that.opens)) return false;
        if (!this.uses.equals(that.uses)) return false;
        if (!this.provides.equals(that.provides)) return false;
        if (!Objects.equals(this.version, that.version)) return false;
        if (!Objects.equals(this.rawVersionString, that.rawVersionString)) return false;
        if (!Objects.equals(this.mainClass, that.mainClass)) return false;
        return true;
    }

    public int hashCode() {
        int hc = this.hash;
        if (hc == 0) {
            hc = this.name.hashCode();
            hc = hc * 43 + Objects.hashCode(this.modifiers);
            hc = hc * 43 + this.requires.hashCode();
            hc = hc * 43 + Objects.hashCode(this.packages);
            hc = hc * 43 + this.exports.hashCode();
            hc = hc * 43 + this.opens.hashCode();
            hc = hc * 43 + this.uses.hashCode();
            hc = hc * 43 + this.provides.hashCode();
            hc = hc * 43 + Objects.hashCode(this.version);
            hc = hc * 43 + Objects.hashCode(this.rawVersionString);
            if ((hc = hc * 43 + Objects.hashCode(this.mainClass)) == 0) {
                hc = -1;
            }
            this.hash = hc;
        }
        return hc;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isOpen()) {
            sb.append("open ");
        }
        sb.append("module { name: ").append(this.toNameAndVersion());
        if (!this.requires.isEmpty()) {
            sb.append(", ").append(this.requires);
        }
        if (!this.uses.isEmpty()) {
            sb.append(", uses: ").append(this.uses);
        }
        if (!this.exports.isEmpty()) {
            sb.append(", exports: ").append(this.exports);
        }
        if (!this.opens.isEmpty()) {
            sb.append(", opens: ").append(this.opens);
        }
        if (!this.provides.isEmpty()) {
            sb.append(", provides: ").append(this.provides);
        }
        sb.append(" }");
        return sb.toString();
    }

    public static Builder newModule(String name, Set<Modifier> ms) {
        HashSet<Modifier> mods = new HashSet<Modifier>(ms);
        if (mods.contains((Object)Modifier.AUTOMATIC) && mods.size() > 1) {
            throw new IllegalArgumentException("AUTOMATIC cannot be used with other modifiers");
        }
        return new Builder(name, true, mods);
    }

    public static Builder newModule(String name) {
        return new Builder(name, true, Set.of());
    }

    public static Builder newOpenModule(String name) {
        return new Builder(name, true, Set.of(Modifier.OPEN));
    }

    public static Builder newAutomaticModule(String name) {
        return new Builder(name, true, Set.of(Modifier.AUTOMATIC));
    }

    public static ModuleDescriptor read(InputStream in, Supplier<Set<String>> packageFinder) throws IOException {
        return ModuleInfo.read(in, Objects.requireNonNull(packageFinder)).descriptor();
    }

    public static ModuleDescriptor read(InputStream in) throws IOException {
        return ModuleInfo.read(in, null).descriptor();
    }

    public static ModuleDescriptor read(ByteBuffer bb, Supplier<Set<String>> packageFinder) {
        return ModuleInfo.read(bb, Objects.requireNonNull(packageFinder)).descriptor();
    }

    public static ModuleDescriptor read(ByteBuffer bb) {
        return ModuleInfo.read(bb, null).descriptor();
    }

    private static String packageName(String cn) {
        int index = cn.lastIndexOf(46);
        return index == -1 ? "" : cn.substring(0, index);
    }

    private static <M> String toString(Set<M> mods, String what) {
        return Stream.concat(mods.stream().map(e -> e.toString().toLowerCase(Locale.ROOT)), Stream.of(what)).collect(Collectors.joining(" "));
    }

    private static <T> int compare(T obj1, T obj2) {
        if (obj1 != null) {
            return obj2 != null ? ((Comparable)obj1).compareTo(obj2) : 1;
        }
        return obj2 == null ? 0 : -1;
    }

    private static <T> int compare(Set<T> s1, Set<T> s2) {
        Object[] a1 = s1.toArray();
        Object[] a2 = s2.toArray();
        Arrays.sort(a1);
        Arrays.sort(a2);
        return Arrays.compare((Comparable[])a1, (Comparable[])a2);
    }

    private static <E extends Enum<E>> long modsValue(Set<E> set) {
        long value = 0L;
        for (Enum e : set) {
            value += (long)(1 << e.ordinal());
        }
        return value;
    }

    static {
        SharedSecrets.setJavaLangModuleAccess(new JavaLangModuleAccess(){

            @Override
            public Builder newModuleBuilder(String mn, boolean strict, Set<Modifier> modifiers) {
                return new Builder(mn, strict, modifiers);
            }

            @Override
            public Set<String> packages(Builder builder) {
                return builder.packages();
            }

            @Override
            public void requires(Builder builder, Set<Requires.Modifier> ms, String mn, String rawCompiledVersion) {
                builder.requires(ms, mn, rawCompiledVersion);
            }

            @Override
            public Requires newRequires(Set<Requires.Modifier> ms, String mn, Version v) {
                return new Requires(ms, mn, v, true);
            }

            @Override
            public Exports newExports(Set<Exports.Modifier> ms, String source) {
                return new Exports(ms, source, Set.of(), true);
            }

            @Override
            public Exports newExports(Set<Exports.Modifier> ms, String source, Set<String> targets) {
                return new Exports(ms, source, targets, true);
            }

            @Override
            public Opens newOpens(Set<Opens.Modifier> ms, String source, Set<String> targets) {
                return new Opens(ms, source, targets, true);
            }

            @Override
            public Opens newOpens(Set<Opens.Modifier> ms, String source) {
                return new Opens(ms, source, Set.of(), true);
            }

            @Override
            public Provides newProvides(String service, List<String> providers) {
                return new Provides(service, providers, true);
            }

            @Override
            public ModuleDescriptor newModuleDescriptor(String name, Version version, Set<Modifier> modifiers, Set<Requires> requires, Set<Exports> exports, Set<Opens> opens, Set<String> uses, Set<Provides> provides, Set<String> packages, String mainClass, int hashCode) {
                return new ModuleDescriptor(name, version, modifiers, requires, exports, opens, uses, provides, packages, mainClass, hashCode, false);
            }

            @Override
            public Configuration resolveAndBind(ModuleFinder finder, Collection<String> roots, PrintStream traceOutput) {
                return Configuration.resolveAndBind(finder, roots, traceOutput);
            }

            @Override
            public Configuration newConfiguration(ModuleFinder finder, Map<String, Set<String>> graph) {
                return new Configuration(finder, graph);
            }
        });
    }

    public static final class Version
    implements Comparable<Version> {
        private final String version;
        private final List<Object> sequence;
        private final List<Object> pre;
        private final List<Object> build;

        private static int takeNumber(String s, int i, List<Object> acc) {
            char c = s.charAt(i);
            int d = c - 48;
            int n = s.length();
            while (++i < n && (c = s.charAt(i)) >= '0' && c <= '9') {
                d = d * 10 + (c - 48);
            }
            acc.add(d);
            return i;
        }

        private static int takeString(String s, int i, List<Object> acc) {
            char c;
            int b = i;
            int n = s.length();
            while (++i < n && (c = s.charAt(i)) != '.' && c != '-' && c != '+' && (c < '0' || c > '9')) {
            }
            acc.add(s.substring(b, i));
            return i;
        }

        private Version(String v) {
            if (v == null) {
                throw new IllegalArgumentException("Null version string");
            }
            int n = v.length();
            if (n == 0) {
                throw new IllegalArgumentException("Empty version string");
            }
            int i = 0;
            char c = v.charAt(i);
            if (c < '0' || c > '9') {
                throw new IllegalArgumentException(v + ": Version string does not start with a number");
            }
            ArrayList<Object> sequence = new ArrayList<Object>(4);
            ArrayList<Object> pre = new ArrayList<Object>(2);
            ArrayList<Object> build = new ArrayList<Object>(2);
            i = Version.takeNumber(v, i, sequence);
            while (i < n) {
                c = v.charAt(i);
                if (c == '.') {
                    ++i;
                    continue;
                }
                if (c == '-' || c == '+') {
                    ++i;
                    break;
                }
                if (c >= '0' && c <= '9') {
                    i = Version.takeNumber(v, i, sequence);
                    continue;
                }
                i = Version.takeString(v, i, sequence);
            }
            if (c == '-' && i >= n) {
                throw new IllegalArgumentException(v + ": Empty pre-release");
            }
            while (i < n && (i = (c = v.charAt(i)) >= '0' && c <= '9' ? Version.takeNumber(v, i, pre) : Version.takeString(v, i, pre)) < n) {
                c = v.charAt(i);
                if (c == '.' || c == '-') {
                    ++i;
                    continue;
                }
                if (c != '+') continue;
                ++i;
                break;
            }
            if (c == '+' && i >= n) {
                throw new IllegalArgumentException(v + ": Empty pre-release");
            }
            while (i < n && (i = (c = v.charAt(i)) >= '0' && c <= '9' ? Version.takeNumber(v, i, build) : Version.takeString(v, i, build)) < n) {
                c = v.charAt(i);
                if (c != '.' && c != '-' && c != '+') continue;
                ++i;
            }
            this.version = v;
            this.sequence = sequence;
            this.pre = pre;
            this.build = build;
        }

        public static Version parse(String v) {
            return new Version(v);
        }

        private int cmp(Object o1, Object o2) {
            return ((Comparable)o1).compareTo(o2);
        }

        private int compareTokens(List<Object> ts1, List<Object> ts2) {
            int n = Math.min(ts1.size(), ts2.size());
            for (int i = 0; i < n; ++i) {
                int c;
                Object o1 = ts1.get(i);
                Object o2 = ts2.get(i);
                if (o1 instanceof Integer && o2 instanceof Integer || o1 instanceof String && o2 instanceof String) {
                    c = this.cmp(o1, o2);
                    if (c == 0) continue;
                    return c;
                }
                c = o1.toString().compareTo(o2.toString());
                if (c == 0) continue;
                return c;
            }
            List<Object> rest = ts1.size() > ts2.size() ? ts1 : ts2;
            int e = rest.size();
            for (int i = n; i < e; ++i) {
                Object o = rest.get(i);
                if (o instanceof Integer && (Integer)o == 0) continue;
                return ts1.size() - ts2.size();
            }
            return 0;
        }

        @Override
        public int compareTo(Version that) {
            int c = this.compareTokens(this.sequence, that.sequence);
            if (c != 0) {
                return c;
            }
            if (this.pre.isEmpty()) {
                if (!that.pre.isEmpty()) {
                    return 1;
                }
            } else if (that.pre.isEmpty()) {
                return -1;
            }
            if ((c = this.compareTokens(this.pre, that.pre)) != 0) {
                return c;
            }
            return this.compareTokens(this.build, that.build);
        }

        public boolean equals(Object ob) {
            if (!(ob instanceof Version)) {
                return false;
            }
            return this.compareTo((Version)ob) == 0;
        }

        public int hashCode() {
            return this.version.hashCode();
        }

        public String toString() {
            return this.version;
        }
    }

    public static enum Modifier {
        OPEN,
        AUTOMATIC,
        SYNTHETIC,
        MANDATED;

    }

    public static final class Builder {
        final String name;
        final boolean strict;
        final Set<Modifier> modifiers;
        final boolean open;
        final boolean automatic;
        final Set<String> packages = new HashSet<String>();
        final Map<String, Requires> requires = new HashMap<String, Requires>();
        final Map<String, Exports> exports = new HashMap<String, Exports>();
        final Map<String, Opens> opens = new HashMap<String, Opens>();
        final Set<String> uses = new HashSet<String>();
        final Map<String, Provides> provides = new HashMap<String, Provides>();
        Version version;
        String rawVersionString;
        String mainClass;

        Builder(String name, boolean strict, Set<Modifier> modifiers) {
            this.name = strict ? Checks.requireModuleName(name) : name;
            this.strict = strict;
            this.modifiers = modifiers;
            this.open = modifiers.contains((Object)Modifier.OPEN);
            this.automatic = modifiers.contains((Object)Modifier.AUTOMATIC);
            assert (!this.open || !this.automatic);
        }

        Set<String> packages() {
            return Collections.unmodifiableSet(this.packages);
        }

        public Builder requires(Requires req) {
            if (this.automatic) {
                throw new IllegalStateException("Automatic modules cannot declare dependences");
            }
            String mn = req.name();
            if (this.name.equals(mn)) {
                throw new IllegalArgumentException("Dependence on self");
            }
            if (this.requires.containsKey(mn)) {
                throw new IllegalStateException("Dependence upon " + mn + " already declared");
            }
            this.requires.put(mn, req);
            return this;
        }

        public Builder requires(Set<Requires.Modifier> ms, String mn, Version compiledVersion) {
            Objects.requireNonNull(compiledVersion);
            if (this.strict) {
                mn = Checks.requireModuleName(mn);
            }
            return this.requires(new Requires(ms, mn, compiledVersion, null));
        }

        Builder requires(Set<Requires.Modifier> ms, String mn, String rawCompiledVersion) {
            Requires r;
            try {
                Version v = Version.parse(rawCompiledVersion);
                r = new Requires(ms, mn, v, null);
            }
            catch (IllegalArgumentException e) {
                if (this.strict) {
                    throw e;
                }
                r = new Requires(ms, mn, null, rawCompiledVersion);
            }
            return this.requires(r);
        }

        public Builder requires(Set<Requires.Modifier> ms, String mn) {
            if (this.strict) {
                mn = Checks.requireModuleName(mn);
            }
            return this.requires(new Requires(ms, mn, null, null));
        }

        public Builder requires(String mn) {
            return this.requires(EnumSet.noneOf(Requires.Modifier.class), mn);
        }

        public Builder exports(Exports e) {
            if (this.automatic) {
                throw new IllegalStateException("Automatic modules cannot declare exported packages");
            }
            String source = e.source();
            if (this.exports.containsKey(source)) {
                throw new IllegalStateException("Exported package " + source + " already declared");
            }
            this.exports.put(source, e);
            this.packages.add(source);
            return this;
        }

        public Builder exports(Set<Exports.Modifier> ms, String pn, Set<String> targets) {
            if ((targets = new HashSet<String>(targets)).isEmpty()) {
                throw new IllegalArgumentException("Empty target set");
            }
            if (this.strict) {
                Checks.requirePackageName(pn);
                targets.forEach(Checks::requireModuleName);
            }
            Exports e = new Exports(ms, pn, targets);
            return this.exports(e);
        }

        public Builder exports(Set<Exports.Modifier> ms, String pn) {
            if (this.strict) {
                Checks.requirePackageName(pn);
            }
            Exports e = new Exports(ms, pn, Set.of());
            return this.exports(e);
        }

        public Builder exports(String pn, Set<String> targets) {
            return this.exports(Set.of(), pn, targets);
        }

        public Builder exports(String pn) {
            return this.exports(Set.of(), pn);
        }

        public Builder opens(Opens obj) {
            if (this.open || this.automatic) {
                throw new IllegalStateException("Open or automatic modules cannot declare open packages");
            }
            String source = obj.source();
            if (this.opens.containsKey(source)) {
                throw new IllegalStateException("Open package " + source + " already declared");
            }
            this.opens.put(source, obj);
            this.packages.add(source);
            return this;
        }

        public Builder opens(Set<Opens.Modifier> ms, String pn, Set<String> targets) {
            if ((targets = new HashSet<String>(targets)).isEmpty()) {
                throw new IllegalArgumentException("Empty target set");
            }
            if (this.strict) {
                Checks.requirePackageName(pn);
                targets.forEach(Checks::requireModuleName);
            }
            Opens opens = new Opens(ms, pn, targets);
            return this.opens(opens);
        }

        public Builder opens(Set<Opens.Modifier> ms, String pn) {
            if (this.strict) {
                Checks.requirePackageName(pn);
            }
            Opens e = new Opens(ms, pn, Set.of());
            return this.opens(e);
        }

        public Builder opens(String pn, Set<String> targets) {
            return this.opens(Set.of(), pn, targets);
        }

        public Builder opens(String pn) {
            return this.opens(Set.of(), pn);
        }

        public Builder uses(String service) {
            if (this.automatic) {
                throw new IllegalStateException("Automatic modules can not declare service dependences");
            }
            if (this.uses.contains(Checks.requireServiceTypeName(service))) {
                throw new IllegalStateException("Dependence upon service " + service + " already declared");
            }
            this.uses.add(service);
            return this;
        }

        public Builder provides(Provides p) {
            String service = p.service();
            if (this.provides.containsKey(service)) {
                throw new IllegalStateException("Providers of service " + service + " already declared");
            }
            this.provides.put(service, p);
            p.providers().forEach(name -> this.packages.add(ModuleDescriptor.packageName(name)));
            return this;
        }

        public Builder provides(String service, List<String> providers) {
            if ((providers = new ArrayList<String>(providers)).isEmpty()) {
                throw new IllegalArgumentException("Empty providers set");
            }
            if (this.strict) {
                Checks.requireServiceTypeName(service);
                providers.forEach(Checks::requireServiceProviderName);
            } else {
                String pn = ModuleDescriptor.packageName(service);
                if (pn.isEmpty()) {
                    throw new IllegalArgumentException(service + ": unnamed package");
                }
                for (String name : providers) {
                    pn = ModuleDescriptor.packageName(name);
                    if (!pn.isEmpty()) continue;
                    throw new IllegalArgumentException(name + ": unnamed package");
                }
            }
            Provides p = new Provides(service, providers);
            return this.provides(p);
        }

        public Builder packages(Set<String> pns) {
            if (this.strict) {
                pns = new HashSet<String>(pns);
                pns.forEach(Checks::requirePackageName);
            }
            this.packages.addAll(pns);
            return this;
        }

        public Builder version(Version v) {
            this.version = Objects.requireNonNull(v);
            this.rawVersionString = null;
            return this;
        }

        public Builder version(String vs) {
            try {
                this.version = Version.parse(vs);
                this.rawVersionString = null;
            }
            catch (IllegalArgumentException e) {
                if (this.strict) {
                    throw e;
                }
                this.version = null;
                this.rawVersionString = vs;
            }
            return this;
        }

        public Builder mainClass(String mc) {
            String pn;
            if (this.strict) {
                mc = Checks.requireQualifiedClassName("main class name", mc);
                pn = ModuleDescriptor.packageName(mc);
                assert (!pn.isEmpty());
            } else {
                pn = ModuleDescriptor.packageName(mc);
                if (pn.isEmpty()) {
                    throw new IllegalArgumentException(mc + ": unnamed package");
                }
            }
            this.packages.add(pn);
            this.mainClass = mc;
            return this;
        }

        public ModuleDescriptor build() {
            HashSet<Requires> requires = new HashSet<Requires>(this.requires.values());
            HashSet<Exports> exports = new HashSet<Exports>(this.exports.values());
            HashSet<Opens> opens = new HashSet<Opens>(this.opens.values());
            if (this.strict && !this.name.equals("java.base") && !this.requires.containsKey("java.base")) {
                requires.add(new Requires(Set.of(Requires.Modifier.MANDATED), "java.base", null, null));
            }
            HashSet<Provides> provides = new HashSet<Provides>(this.provides.values());
            return new ModuleDescriptor(this.name, this.version, this.rawVersionString, this.modifiers, requires, exports, opens, this.uses, provides, this.packages, this.mainClass);
        }
    }

    public static final class Provides
    implements Comparable<Provides> {
        private final String service;
        private final List<String> providers;

        private Provides(String service, List<String> providers) {
            this.service = service;
            this.providers = List.copyOf(providers);
        }

        private Provides(String service, List<String> providers, boolean unused) {
            this.service = service;
            this.providers = providers;
        }

        public String service() {
            return this.service;
        }

        public List<String> providers() {
            return this.providers;
        }

        @Override
        public int compareTo(Provides that) {
            if (this == that) {
                return 0;
            }
            int c = this.service.compareTo(that.service);
            if (c != 0) {
                return c;
            }
            int size1 = this.providers.size();
            int size2 = that.providers.size();
            for (int index = 0; index < Math.min(size1, size2); ++index) {
                String e2;
                String e1 = this.providers.get(index);
                c = e1.compareTo(e2 = that.providers.get(index));
                if (c == 0) continue;
                return c;
            }
            if (size1 == size2) {
                return 0;
            }
            return size1 > size2 ? 1 : -1;
        }

        public int hashCode() {
            return this.service.hashCode() * 43 + this.providers.hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object ob) {
            if (!(ob instanceof Provides)) return false;
            Provides other = (Provides)ob;
            if (!Objects.equals(this.service, other.service)) return false;
            if (!Objects.equals(this.providers, other.providers)) return false;
            return true;
        }

        public String toString() {
            return this.service + " with " + this.providers;
        }
    }

    public static final class Opens
    implements Comparable<Opens> {
        private final Set<Modifier> mods;
        private final String source;
        private final Set<String> targets;

        private Opens(Set<Modifier> ms, String source, Set<String> targets) {
            this.mods = Set.copyOf(ms);
            this.source = source;
            this.targets = Set.copyOf(targets);
        }

        private Opens(Set<Modifier> ms, String source, Set<String> targets, boolean unused) {
            this.mods = ms;
            this.source = source;
            this.targets = targets;
        }

        public Set<Modifier> modifiers() {
            return this.mods;
        }

        public boolean isQualified() {
            return !this.targets.isEmpty();
        }

        public String source() {
            return this.source;
        }

        public Set<String> targets() {
            return this.targets;
        }

        @Override
        public int compareTo(Opens that) {
            long v2;
            if (this == that) {
                return 0;
            }
            int c = this.source.compareTo(that.source);
            if (c != 0) {
                return c;
            }
            long v1 = ModuleDescriptor.modsValue(this.modifiers());
            c = Long.compare(v1, v2 = ModuleDescriptor.modsValue(that.modifiers()));
            if (c != 0) {
                return c;
            }
            c = ModuleDescriptor.compare(this.targets, that.targets);
            if (c != 0) {
                return c;
            }
            return 0;
        }

        public int hashCode() {
            int hash = this.mods.hashCode();
            hash = hash * 43 + this.source.hashCode();
            return hash * 43 + this.targets.hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object ob) {
            if (!(ob instanceof Opens)) return false;
            Opens other = (Opens)ob;
            if (!Objects.equals(this.mods, other.mods)) return false;
            if (!Objects.equals(this.source, other.source)) return false;
            if (!Objects.equals(this.targets, other.targets)) return false;
            return true;
        }

        public String toString() {
            String s = ModuleDescriptor.toString(this.mods, this.source);
            if (this.targets.isEmpty()) {
                return s;
            }
            return s + " to " + this.targets;
        }

        public static enum Modifier {
            SYNTHETIC,
            MANDATED;

        }
    }

    public static final class Exports
    implements Comparable<Exports> {
        private final Set<Modifier> mods;
        private final String source;
        private final Set<String> targets;

        private Exports(Set<Modifier> ms, String source, Set<String> targets) {
            this.mods = Set.copyOf(ms);
            this.source = source;
            this.targets = Set.copyOf(targets);
        }

        private Exports(Set<Modifier> ms, String source, Set<String> targets, boolean unused) {
            this.mods = ms;
            this.source = source;
            this.targets = targets;
        }

        public Set<Modifier> modifiers() {
            return this.mods;
        }

        public boolean isQualified() {
            return !this.targets.isEmpty();
        }

        public String source() {
            return this.source;
        }

        public Set<String> targets() {
            return this.targets;
        }

        @Override
        public int compareTo(Exports that) {
            long v2;
            if (this == that) {
                return 0;
            }
            int c = this.source.compareTo(that.source);
            if (c != 0) {
                return c;
            }
            long v1 = ModuleDescriptor.modsValue(this.modifiers());
            c = Long.compare(v1, v2 = ModuleDescriptor.modsValue(that.modifiers()));
            if (c != 0) {
                return c;
            }
            c = ModuleDescriptor.compare(this.targets, that.targets);
            if (c != 0) {
                return c;
            }
            return 0;
        }

        public int hashCode() {
            int hash = this.mods.hashCode();
            hash = hash * 43 + this.source.hashCode();
            return hash * 43 + this.targets.hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object ob) {
            if (!(ob instanceof Exports)) return false;
            Exports other = (Exports)ob;
            if (!Objects.equals(this.mods, other.mods)) return false;
            if (!Objects.equals(this.source, other.source)) return false;
            if (!Objects.equals(this.targets, other.targets)) return false;
            return true;
        }

        public String toString() {
            String s = ModuleDescriptor.toString(this.mods, this.source);
            if (this.targets.isEmpty()) {
                return s;
            }
            return s + " to " + this.targets;
        }

        public static enum Modifier {
            SYNTHETIC,
            MANDATED;

        }
    }

    public static final class Requires
    implements Comparable<Requires> {
        private final Set<Modifier> mods;
        private final String name;
        private final Version compiledVersion;
        private final String rawCompiledVersion;

        private Requires(Set<Modifier> ms, String mn, Version v, String vs) {
            assert (v == null || vs == null);
            this.mods = Set.copyOf(ms);
            this.name = mn;
            this.compiledVersion = v;
            this.rawCompiledVersion = vs;
        }

        private Requires(Set<Modifier> ms, String mn, Version v, boolean unused) {
            this.mods = ms;
            this.name = mn;
            this.compiledVersion = v;
            this.rawCompiledVersion = null;
        }

        public Set<Modifier> modifiers() {
            return this.mods;
        }

        public String name() {
            return this.name;
        }

        public Optional<Version> compiledVersion() {
            return Optional.ofNullable(this.compiledVersion);
        }

        public Optional<String> rawCompiledVersion() {
            if (this.compiledVersion != null) {
                return Optional.of(this.compiledVersion.toString());
            }
            return Optional.ofNullable(this.rawCompiledVersion);
        }

        @Override
        public int compareTo(Requires that) {
            long v2;
            if (this == that) {
                return 0;
            }
            int c = this.name().compareTo(that.name());
            if (c != 0) {
                return c;
            }
            long v1 = ModuleDescriptor.modsValue(this.modifiers());
            c = Long.compare(v1, v2 = ModuleDescriptor.modsValue(that.modifiers()));
            if (c != 0) {
                return c;
            }
            c = ModuleDescriptor.compare(this.compiledVersion, that.compiledVersion);
            if (c != 0) {
                return c;
            }
            c = ModuleDescriptor.compare(this.rawCompiledVersion, that.rawCompiledVersion);
            if (c != 0) {
                return c;
            }
            return 0;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object ob) {
            if (!(ob instanceof Requires)) return false;
            Requires that = (Requires)ob;
            if (!this.name.equals(that.name)) return false;
            if (!this.mods.equals(that.mods)) return false;
            if (!Objects.equals(this.compiledVersion, that.compiledVersion)) return false;
            if (!Objects.equals(this.rawCompiledVersion, that.rawCompiledVersion)) return false;
            return true;
        }

        public int hashCode() {
            int hash = this.name.hashCode() * 43 + this.mods.hashCode();
            if (this.compiledVersion != null) {
                hash = hash * 43 + this.compiledVersion.hashCode();
            }
            if (this.rawCompiledVersion != null) {
                hash = hash * 43 + this.rawCompiledVersion.hashCode();
            }
            return hash;
        }

        public String toString() {
            String what = this.compiledVersion != null ? this.name() + " (@" + this.compiledVersion + ")" : this.name();
            return ModuleDescriptor.toString(this.mods, what);
        }

        public static enum Modifier {
            TRANSITIVE,
            STATIC,
            SYNTHETIC,
            MANDATED;

        }
    }
}

