/*
 * Decompiled with CFR 0.152.
 */
package java.lang.module;

import java.lang.module.Configuration;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleReference;
import java.util.Objects;
import java.util.Set;

public final class ResolvedModule {
    private final Configuration cf;
    private final ModuleReference mref;

    ResolvedModule(Configuration cf, ModuleReference mref) {
        this.cf = Objects.requireNonNull(cf);
        this.mref = Objects.requireNonNull(mref);
    }

    public Configuration configuration() {
        return this.cf;
    }

    public ModuleReference reference() {
        return this.mref;
    }

    ModuleDescriptor descriptor() {
        return this.mref.descriptor();
    }

    public String name() {
        return this.mref.descriptor().name();
    }

    public Set<ResolvedModule> reads() {
        return this.cf.reads(this);
    }

    public int hashCode() {
        return this.cf.hashCode() ^ this.mref.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object ob) {
        if (!(ob instanceof ResolvedModule)) return false;
        ResolvedModule that = (ResolvedModule)ob;
        if (!Objects.equals(this.cf, that.cf)) return false;
        if (!Objects.equals(this.mref, that.mref)) return false;
        return true;
    }

    public String toString() {
        return System.identityHashCode(this.cf) + "/" + this.name();
    }
}

