/*
 * Decompiled with CFR 0.152.
 */
package java.lang.module;

import java.io.PrintStream;
import java.lang.module.Configuration;
import java.lang.module.FindException;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.lang.module.ResolutionException;
import java.lang.module.ResolvedModule;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.HexFormat;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import jdk.internal.module.ModuleHashes;
import jdk.internal.module.ModuleReferenceImpl;
import jdk.internal.module.ModuleResolution;
import jdk.internal.module.ModuleTarget;

final class Resolver {
    private final ModuleFinder beforeFinder;
    private final List<Configuration> parents;
    private final ModuleFinder afterFinder;
    private final PrintStream traceOutput;
    private final Map<String, ModuleReference> nameToReference = new HashMap<String, ModuleReference>();
    private boolean haveAllAutomaticModules;
    private String targetPlatform;
    private Set<ModuleDescriptor> visited;
    private Set<ModuleDescriptor> visitPath;

    String targetPlatform() {
        return this.targetPlatform;
    }

    Resolver(ModuleFinder beforeFinder, List<Configuration> parents, ModuleFinder afterFinder, PrintStream traceOutput) {
        this.beforeFinder = beforeFinder;
        this.parents = parents;
        this.afterFinder = afterFinder;
        this.traceOutput = traceOutput;
        for (Configuration parent : parents) {
            String value = parent.targetPlatform();
            if (value == null) continue;
            if (this.targetPlatform == null) {
                this.targetPlatform = value;
                continue;
            }
            if (value.equals(this.targetPlatform)) continue;
            String msg = "Parents have conflicting constraints on target  platform: " + this.targetPlatform + ", " + value;
            throw new IllegalArgumentException(msg);
        }
    }

    Resolver resolve(Collection<String> roots) {
        ArrayDeque<ModuleDescriptor> q = new ArrayDeque<ModuleDescriptor>();
        for (String root : roots) {
            ModuleReference mref = this.findWithBeforeFinder(root);
            if (mref == null) {
                if (this.findInParent(root) != null) continue;
                mref = this.findWithAfterFinder(root);
                if (mref == null) {
                    Resolver.findFail("Module %s not found", root);
                }
            }
            if (this.isTracing()) {
                this.trace("root %s", this.nameAndInfo(mref));
            }
            this.addFoundModule(mref);
            q.push(mref.descriptor());
        }
        this.resolve((Deque<ModuleDescriptor>)q);
        return this;
    }

    private Set<ModuleDescriptor> resolve(Deque<ModuleDescriptor> q) {
        HashSet<ModuleDescriptor> resolved = new HashSet<ModuleDescriptor>();
        while (!q.isEmpty()) {
            ModuleDescriptor descriptor = q.poll();
            assert (this.nameToReference.containsKey(descriptor.name()));
            if (descriptor.isAutomatic() && !this.haveAllAutomaticModules) {
                this.addFoundAutomaticModules().forEach(mref -> {
                    ModuleDescriptor other = mref.descriptor();
                    q.offer(other);
                    if (this.isTracing()) {
                        this.trace("%s requires %s", descriptor.name(), this.nameAndInfo((ModuleReference)mref));
                    }
                });
                this.haveAllAutomaticModules = true;
            }
            for (ModuleDescriptor.Requires requires : descriptor.requires()) {
                if (requires.modifiers().contains((Object)ModuleDescriptor.Requires.Modifier.STATIC)) continue;
                String dn = requires.name();
                ModuleReference mref2 = this.findWithBeforeFinder(dn);
                if (mref2 == null) {
                    if (this.findInParent(dn) != null) continue;
                    mref2 = this.findWithAfterFinder(dn);
                    if (mref2 == null) {
                        Resolver.findFail("Module %s not found, required by %s", dn, descriptor.name());
                    }
                }
                if (this.isTracing() && !dn.equals("java.base")) {
                    this.trace("%s requires %s", descriptor.name(), this.nameAndInfo(mref2));
                }
                if (this.nameToReference.containsKey(dn)) continue;
                this.addFoundModule(mref2);
                q.offer(mref2.descriptor());
            }
            resolved.add(descriptor);
        }
        return resolved;
    }

    Resolver bind() {
        return this.bind(true);
    }

    Resolver bind(boolean bindIncubatorModules) {
        HashMap<String, HashSet<ModuleReference>> availableProviders = new HashMap<String, HashSet<ModuleReference>>();
        for (ModuleReference mref : this.findAll()) {
            ModuleResolution moduleResolution;
            ModuleDescriptor descriptor = mref.descriptor();
            boolean candidate = !bindIncubatorModules && mref instanceof ModuleReferenceImpl ? (moduleResolution = ((ModuleReferenceImpl)mref).moduleResolution()) == null || !moduleResolution.hasIncubatingWarning() : true;
            if (!candidate || descriptor.provides().isEmpty()) continue;
            for (ModuleDescriptor.Provides provides : descriptor.provides()) {
                String sn = provides.service();
                HashSet<ModuleReference> providers = (HashSet<ModuleReference>)availableProviders.get(sn);
                if (providers == null) {
                    providers = new HashSet<ModuleReference>();
                    availableProviders.put(sn, providers);
                }
                providers.add(mref);
            }
        }
        ArrayDeque<ModuleDescriptor> q = new ArrayDeque<ModuleDescriptor>();
        Set<Object> initialConsumers = ModuleLayer.boot() == null ? new HashSet() : this.parents.stream().flatMap(Configuration::configurations).distinct().flatMap(c -> c.descriptors().stream()).collect(Collectors.toSet());
        for (ModuleReference mref : this.nameToReference.values()) {
            initialConsumers.add(mref.descriptor());
        }
        Set<Object> candidateConsumers = initialConsumers;
        do {
            for (ModuleDescriptor moduleDescriptor : candidateConsumers) {
                if (moduleDescriptor.uses().isEmpty()) continue;
                HashSet<ModuleDescriptor> modulesToBind = null;
                if (this.isTracing()) {
                    modulesToBind = new HashSet<ModuleDescriptor>();
                }
                for (String service : moduleDescriptor.uses()) {
                    Set mrefs = (Set)availableProviders.get(service);
                    if (mrefs == null) continue;
                    for (ModuleReference mref : mrefs) {
                        String pn;
                        ModuleDescriptor provider = mref.descriptor();
                        if (provider.equals(moduleDescriptor)) continue;
                        if (this.isTracing() && modulesToBind.add(provider)) {
                            this.trace("%s binds %s", moduleDescriptor.name(), this.nameAndInfo(mref));
                        }
                        if (this.nameToReference.containsKey(pn = provider.name())) continue;
                        this.addFoundModule(mref);
                        q.push(provider);
                    }
                }
            }
        } while (!(candidateConsumers = this.resolve((Deque<ModuleDescriptor>)q)).isEmpty());
        return this;
    }

    private Set<ModuleReference> addFoundAutomaticModules() {
        HashSet<ModuleReference> result = new HashSet<ModuleReference>();
        this.findAll().forEach(mref -> {
            String mn = mref.descriptor().name();
            if (mref.descriptor().isAutomatic() && !this.nameToReference.containsKey(mn)) {
                this.addFoundModule((ModuleReference)mref);
                result.add((ModuleReference)mref);
            }
        });
        return result;
    }

    private void addFoundModule(ModuleReference mref) {
        ModuleTarget target;
        String mn = mref.descriptor().name();
        if (mref instanceof ModuleReferenceImpl && (target = ((ModuleReferenceImpl)mref).moduleTarget()) != null) {
            this.checkTargetPlatform(mn, target);
        }
        this.nameToReference.put(mn, mref);
    }

    private void checkTargetPlatform(String mn, ModuleTarget target) {
        String value = target.targetPlatform();
        if (value != null) {
            if (this.targetPlatform == null) {
                this.targetPlatform = value;
            } else if (!value.equals(this.targetPlatform)) {
                Resolver.findFail("Module %s has constraints on target platform (%s) that conflict with other modules: %s", mn, value, this.targetPlatform);
            }
        }
    }

    Map<ResolvedModule, Set<ResolvedModule>> finish(Configuration cf) {
        this.detectCycles();
        this.checkHashes();
        Map<ResolvedModule, Set<ResolvedModule>> graph = this.makeGraph(cf);
        this.checkExportSuppliers(graph);
        return graph;
    }

    private void detectCycles() {
        this.visited = new HashSet<ModuleDescriptor>();
        this.visitPath = new LinkedHashSet<ModuleDescriptor>();
        for (ModuleReference mref : this.nameToReference.values()) {
            this.visit(mref.descriptor());
        }
        this.visited.clear();
    }

    private void visit(ModuleDescriptor descriptor) {
        if (!this.visited.contains(descriptor)) {
            boolean added = this.visitPath.add(descriptor);
            if (!added) {
                Resolver.resolveFail("Cycle detected: %s", this.cycleAsString(descriptor));
            }
            for (ModuleDescriptor.Requires requires : descriptor.requires()) {
                ModuleDescriptor other;
                String dn = requires.name();
                ModuleReference mref = this.nameToReference.get(dn);
                if (mref == null || (other = mref.descriptor()) == descriptor) continue;
                this.visit(other);
            }
            this.visitPath.remove(descriptor);
            this.visited.add(descriptor);
        }
    }

    private String cycleAsString(ModuleDescriptor descriptor) {
        ArrayList<ModuleDescriptor> list = new ArrayList<ModuleDescriptor>(this.visitPath);
        list.add(descriptor);
        int index = list.indexOf(descriptor);
        return list.stream().skip(index).map(ModuleDescriptor::name).collect(Collectors.joining(" -> "));
    }

    private void checkHashes() {
        for (ModuleReference mref : this.nameToReference.values()) {
            ModuleHashes hashes;
            if (!(mref instanceof ModuleReferenceImpl) || (hashes = ((ModuleReferenceImpl)mref).recordedHashes()) == null) continue;
            ModuleDescriptor descriptor = mref.descriptor();
            String algorithm = hashes.algorithm();
            for (String dn : hashes.names()) {
                ModuleReferenceImpl other;
                ResolvedModule resolvedModule;
                ModuleReference mref2 = this.nameToReference.get(dn);
                if (mref2 == null && (resolvedModule = this.findInParent(dn)) != null) {
                    mref2 = resolvedModule.reference();
                }
                if (mref2 == null) continue;
                if (!(mref2 instanceof ModuleReferenceImpl)) {
                    Resolver.findFail("Unable to compute the hash of module %s", dn);
                }
                if ((other = (ModuleReferenceImpl)mref2) == null) continue;
                byte[] recordedHash = hashes.hashFor(dn);
                byte[] actualHash = other.computeHash(algorithm);
                if (actualHash == null) {
                    Resolver.findFail("Unable to compute the hash of module %s", dn);
                }
                if (Arrays.equals(recordedHash, actualHash)) continue;
                HexFormat hex = HexFormat.of();
                Resolver.findFail("Hash of %s (%s) differs to expected hash (%s) recorded in %s", dn, hex.formatHex(actualHash), hex.formatHex(recordedHash), descriptor.name());
            }
        }
    }

    private Map<ResolvedModule, Set<ResolvedModule>> makeGraph(Configuration cf) {
        boolean changed;
        int capacity = 1 + 4 * this.nameToReference.size() / 3;
        HashMap<ResolvedModule, Set<ResolvedModule>> g1 = new HashMap<ResolvedModule, Set<ResolvedModule>>(capacity);
        Map g2 = ModuleLayer.boot() == null ? new HashMap(capacity) : (Map)this.parents.stream().flatMap(Configuration::configurations).distinct().flatMap(c -> c.modules().stream().flatMap(m1 -> m1.descriptor().requires().stream().filter(r -> r.modifiers().contains((Object)ModuleDescriptor.Requires.Modifier.TRANSITIVE)).flatMap(r -> {
            Optional<ResolvedModule> m2 = c.findModule(r.name());
            assert (m2.isPresent() || r.modifiers().contains((Object)ModuleDescriptor.Requires.Modifier.STATIC));
            return m2.stream();
        }).map(m2 -> Map.entry(m1, m2)))).collect(Collectors.groupingBy(Map.Entry::getKey, HashMap::new, Collectors.mapping(Map.Entry::getValue, Collectors.toSet())));
        HashMap<String, ResolvedModule> nameToResolved = new HashMap<String, ResolvedModule>(capacity);
        for (ModuleReference mref : this.nameToReference.values()) {
            ModuleDescriptor descriptor = mref.descriptor();
            String name = descriptor.name();
            ResolvedModule m1 = this.computeIfAbsent(nameToResolved, name, cf, mref);
            HashSet<ResolvedModule> reads = new HashSet<ResolvedModule>();
            HashSet<ResolvedModule> requiresTransitive = new HashSet<ResolvedModule>();
            for (ModuleDescriptor.Requires requires : descriptor.requires()) {
                ResolvedModule m2;
                String dn = requires.name();
                ModuleReference mref2 = this.nameToReference.get(dn);
                if (mref2 != null) {
                    m2 = this.computeIfAbsent(nameToResolved, dn, cf, mref2);
                } else {
                    m2 = this.findInParent(dn);
                    if (m2 == null) {
                        assert (requires.modifiers().contains((Object)ModuleDescriptor.Requires.Modifier.STATIC));
                        continue;
                    }
                    if (m2.descriptor().isAutomatic()) {
                        m2.reads().stream().filter(d -> d.descriptor().isAutomatic()).forEach(reads::add);
                    }
                }
                reads.add(m2);
                if (!requires.modifiers().contains((Object)ModuleDescriptor.Requires.Modifier.TRANSITIVE)) continue;
                requiresTransitive.add(m2);
            }
            if (descriptor.isAutomatic()) {
                for (ModuleReference mref2 : this.nameToReference.values()) {
                    ModuleDescriptor descriptor2 = mref2.descriptor();
                    String name2 = descriptor2.name();
                    if (name.equals(name2)) continue;
                    ResolvedModule m2 = this.computeIfAbsent(nameToResolved, name2, cf, mref2);
                    reads.add(m2);
                    if (!descriptor2.isAutomatic()) continue;
                    requiresTransitive.add(m2);
                }
                for (Configuration parent : this.parents) {
                    parent.configurations().map(Configuration::modules).flatMap(Collection::stream).forEach(m -> {
                        reads.add((ResolvedModule)m);
                        if (m.reference().descriptor().isAutomatic()) {
                            requiresTransitive.add((ResolvedModule)m);
                        }
                    });
                }
            }
            g1.put(m1, reads);
            g2.put(m1, requiresTransitive);
        }
        ArrayList<ResolvedModule> toAdd = new ArrayList<ResolvedModule>();
        do {
            changed = false;
            for (Set m1Reads : g1.values()) {
                for (ResolvedModule m2 : m1Reads) {
                    Set m2RequiresTransitive = (Set)g2.get(m2);
                    if (m2RequiresTransitive == null) continue;
                    for (ResolvedModule m3 : m2RequiresTransitive) {
                        if (m1Reads.contains(m3)) continue;
                        toAdd.add(m3);
                    }
                }
                if (toAdd.isEmpty()) continue;
                m1Reads.addAll(toAdd);
                toAdd.clear();
                changed = true;
            }
        } while (changed);
        return g1;
    }

    private ResolvedModule computeIfAbsent(Map<String, ResolvedModule> map, String name, Configuration cf, ModuleReference mref) {
        ResolvedModule m = map.get(name);
        if (m == null) {
            m = new ResolvedModule(cf, mref);
            map.put(name, m);
        }
        return m;
    }

    private void checkExportSuppliers(Map<ResolvedModule, Set<ResolvedModule>> graph) {
        for (Map.Entry<ResolvedModule, Set<ResolvedModule>> e : graph.entrySet()) {
            String pn;
            ModuleDescriptor descriptor1 = e.getKey().descriptor();
            String name1 = descriptor1.name();
            HashSet<String> names = new HashSet<String>();
            names.add(name1);
            HashMap<String, ModuleDescriptor> packageToExporter = new HashMap<String, ModuleDescriptor>();
            Set<String> packages = descriptor1.packages();
            for (String pn2 : packages) {
                packageToExporter.put(pn2, descriptor1);
            }
            Set<ResolvedModule> reads = e.getValue();
            for (ResolvedModule endpoint : reads) {
                ModuleDescriptor descriptor2 = endpoint.descriptor();
                String name2 = descriptor2.name();
                if (descriptor2 != descriptor1 && !names.add(name2)) {
                    if (name2.equals(name1)) {
                        Resolver.resolveFail("Module %s reads another module named %s", name1, name1);
                    } else {
                        Resolver.resolveFail("Module %s reads more than one module named %s", name1, name2);
                    }
                }
                if (descriptor2.isAutomatic()) {
                    if (descriptor2 == descriptor1) continue;
                    for (String source : descriptor2.packages()) {
                        ModuleDescriptor supplier = packageToExporter.putIfAbsent(source, descriptor2);
                        if (supplier == null) continue;
                        this.failTwoSuppliers(descriptor1, source, descriptor2, supplier);
                    }
                    continue;
                }
                for (ModuleDescriptor.Exports export2 : descriptor2.exports()) {
                    String source;
                    ModuleDescriptor supplier;
                    if (export2.isQualified() && !export2.targets().contains(descriptor1.name()) || (supplier = packageToExporter.putIfAbsent(source = export2.source(), descriptor2)) == null) continue;
                    this.failTwoSuppliers(descriptor1, source, descriptor2, supplier);
                }
            }
            if (descriptor1.isAutomatic()) continue;
            for (String service : descriptor1.uses()) {
                pn = Resolver.packageName(service);
                if (packageToExporter.containsKey(pn)) continue;
                Resolver.resolveFail("Module %s does not read a module that exports %s", descriptor1.name(), pn);
            }
            for (ModuleDescriptor.Provides provides : descriptor1.provides()) {
                pn = Resolver.packageName(provides.service());
                if (packageToExporter.containsKey(pn)) continue;
                Resolver.resolveFail("Module %s does not read a module that exports %s", descriptor1.name(), pn);
            }
        }
    }

    private void failTwoSuppliers(ModuleDescriptor descriptor, String source, ModuleDescriptor supplier1, ModuleDescriptor supplier2) {
        if (supplier2 == descriptor) {
            ModuleDescriptor tmp = supplier1;
            supplier1 = supplier2;
            supplier2 = tmp;
        }
        if (supplier1 == descriptor) {
            Resolver.resolveFail("Module %s contains package %s, module %s exports package %s to %s", descriptor.name(), source, supplier2.name(), source, descriptor.name());
        } else {
            Resolver.resolveFail("Modules %s and %s export package %s to module %s", supplier1.name(), supplier2.name(), source, descriptor.name());
        }
    }

    private ResolvedModule findInParent(String mn) {
        for (Configuration parent : this.parents) {
            Optional<ResolvedModule> om = parent.findModule(mn);
            if (!om.isPresent()) continue;
            return om.get();
        }
        return null;
    }

    private ModuleReference findWithBeforeFinder(String mn) {
        return this.beforeFinder.find(mn).orElse(null);
    }

    private ModuleReference findWithAfterFinder(String mn) {
        return this.afterFinder.find(mn).orElse(null);
    }

    private Set<ModuleReference> findAll() {
        Set<ModuleReference> beforeModules = this.beforeFinder.findAll();
        Set<ModuleReference> afterModules = this.afterFinder.findAll();
        if (afterModules.isEmpty()) {
            return beforeModules;
        }
        if (beforeModules.isEmpty() && this.parents.size() == 1 && this.parents.get(0) == Configuration.empty()) {
            return afterModules;
        }
        HashSet<ModuleReference> result = new HashSet<ModuleReference>(beforeModules);
        for (ModuleReference mref : afterModules) {
            String name = mref.descriptor().name();
            if (this.beforeFinder.find(name).isPresent() || this.findInParent(name) != null) continue;
            result.add(mref);
        }
        return result;
    }

    private static String packageName(String cn) {
        int index = cn.lastIndexOf(".");
        return index == -1 ? "" : cn.substring(0, index);
    }

    private static void findFail(String fmt, Object ... args) {
        String msg = String.format(fmt, args);
        throw new FindException(msg);
    }

    private static void resolveFail(String fmt, Object ... args) {
        String msg = String.format(fmt, args);
        throw new ResolutionException(msg);
    }

    private boolean isTracing() {
        return this.traceOutput != null;
    }

    private void trace(String fmt, Object ... args) {
        if (this.traceOutput != null) {
            this.traceOutput.format(fmt, args);
            this.traceOutput.println();
        }
    }

    private String nameAndInfo(ModuleReference mref) {
        ModuleDescriptor descriptor = mref.descriptor();
        StringBuilder sb = new StringBuilder(descriptor.name());
        mref.location().ifPresent(uri -> sb.append(" " + uri));
        if (descriptor.isAutomatic()) {
            sb.append(" automatic");
        }
        return sb.toString();
    }
}

