/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;
import jdk.internal.ref.CleanerImpl;

public final class Cleaner {
    final CleanerImpl impl = new CleanerImpl();

    private Cleaner() {
    }

    public static Cleaner create() {
        Cleaner cleaner = new Cleaner();
        cleaner.impl.start(cleaner, null);
        return cleaner;
    }

    public static Cleaner create(ThreadFactory threadFactory) {
        Objects.requireNonNull(threadFactory, "threadFactory");
        Cleaner cleaner = new Cleaner();
        cleaner.impl.start(cleaner, threadFactory);
        return cleaner;
    }

    public Cleanable register(Object obj, Runnable action) {
        Objects.requireNonNull(obj, "obj");
        Objects.requireNonNull(action, "action");
        return new CleanerImpl.PhantomCleanableRef(obj, this, action);
    }

    static {
        CleanerImpl.setCleanerImplAccess(new Function<Cleaner, CleanerImpl>(){

            @Override
            public CleanerImpl apply(Cleaner cleaner) {
                return cleaner.impl;
            }
        });
    }

    public static interface Cleanable {
        public void clean();
    }
}

