/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.lang.ref.FinalReference;
import java.lang.ref.ReferenceQueue;
import java.security.AccessController;
import java.security.PrivilegedAction;
import jdk.internal.access.JavaLangAccess;
import jdk.internal.access.SharedSecrets;
import jdk.internal.misc.VM;

final class Finalizer
extends FinalReference<Object> {
    private static ReferenceQueue<Object> queue;
    private static Finalizer unfinalized;
    private static final Object lock;
    private Finalizer next;
    private Finalizer prev;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Finalizer(Object finalizee) {
        super(finalizee, queue);
        Object object2 = lock;
        synchronized (object2) {
            if (unfinalized != null) {
                this.next = unfinalized;
                Finalizer.unfinalized.prev = this;
            }
            unfinalized = this;
        }
    }

    static ReferenceQueue<Object> getQueue() {
        return queue;
    }

    static void register(Object finalizee) {
        new Finalizer(finalizee);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runFinalizer(JavaLangAccess jla) {
        Object object2 = lock;
        synchronized (object2) {
            if (this.next == this) {
                return;
            }
            if (unfinalized == this) {
                unfinalized = this.next;
            } else {
                this.prev.next = this.next;
            }
            if (this.next != null) {
                this.next.prev = this.prev;
            }
            this.prev = null;
            this.next = this;
        }
        try {
            Object finalizee = this.get();
            assert (finalizee != null);
            if (!(finalizee instanceof Enum)) {
                jla.invokeFinalize(finalizee);
                object2 = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.clear();
    }

    private static void forkSecondaryFinalizer(final Runnable proc) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Void run() {
                ThreadGroup tg;
                ThreadGroup tgn = tg = Thread.currentThread().getThreadGroup();
                while (tgn != null) {
                    tg = tgn;
                    tgn = tg.getParent();
                }
                Thread sft = new Thread(tg, proc, "Secondary finalizer", 0L, false);
                sft.start();
                try {
                    sft.join();
                }
                catch (InterruptedException x) {
                    Thread.currentThread().interrupt();
                }
                return null;
            }
        });
    }

    static void runFinalization() {
        if (VM.initLevel() == 0) {
            return;
        }
        Finalizer.forkSecondaryFinalizer(new Runnable(){
            private volatile boolean running;

            @Override
            public void run() {
                Finalizer f;
                if (this.running) {
                    return;
                }
                JavaLangAccess jla = SharedSecrets.getJavaLangAccess();
                this.running = true;
                while ((f = (Finalizer)queue.poll()) != null) {
                    f.runFinalizer(jla);
                }
            }
        });
    }

    static {
        ThreadGroup tg;
        queue = new ReferenceQueue();
        unfinalized = null;
        lock = new Object();
        ThreadGroup tgn = tg = Thread.currentThread().getThreadGroup();
        while (tgn != null) {
            tg = tgn;
            tgn = tg.getParent();
        }
        FinalizerThread finalizer = new FinalizerThread(tg);
        finalizer.setPriority(8);
        finalizer.setDaemon(true);
        finalizer.start();
    }

    private static class FinalizerThread
    extends Thread {
        private volatile boolean running;

        FinalizerThread(ThreadGroup g) {
            super(g, null, "Finalizer", 0L, false);
        }

        @Override
        public void run() {
            if (this.running) {
                return;
            }
            while (VM.initLevel() == 0) {
                try {
                    VM.awaitInitLevel(1);
                }
                catch (InterruptedException interruptedException) {}
            }
            JavaLangAccess jla = SharedSecrets.getJavaLangAccess();
            this.running = true;
            while (true) {
                try {
                    while (true) {
                        Finalizer f = (Finalizer)queue.remove();
                        f.runFinalizer(jla);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

