/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.lang.ref.FinalReference;
import java.lang.ref.Finalizer;
import java.lang.ref.ReferenceQueue;
import jdk.internal.access.JavaLangRefAccess;
import jdk.internal.access.SharedSecrets;
import jdk.internal.ref.Cleaner;
import jdk.internal.vm.annotation.ForceInline;
import jdk.internal.vm.annotation.IntrinsicCandidate;

public abstract class Reference<T> {
    private T referent;
    volatile ReferenceQueue<? super T> queue;
    volatile Reference next;
    private transient Reference<?> discovered;
    private static final Object processPendingLock;
    private static boolean processPendingActive;

    private static native Reference<?> getAndClearReferencePendingList();

    private static native boolean hasReferencePendingList();

    private static native void waitForReferencePendingList();

    private void enqueueFromPending() {
        ReferenceQueue<T> q = this.queue;
        if (q != ReferenceQueue.NULL) {
            q.enqueue(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processPendingReferences() {
        Reference<?> pendingList;
        Reference.waitForReferencePendingList();
        Object object2 = processPendingLock;
        synchronized (object2) {
            pendingList = Reference.getAndClearReferencePendingList();
            processPendingActive = true;
        }
        while (pendingList != null) {
            Reference<?> ref = pendingList;
            pendingList = ref.discovered;
            ref.discovered = null;
            if (ref instanceof Cleaner) {
                ((Cleaner)ref).clean();
                Object object3 = processPendingLock;
                synchronized (object3) {
                    processPendingLock.notifyAll();
                    continue;
                }
            }
            ref.enqueueFromPending();
        }
        object2 = processPendingLock;
        synchronized (object2) {
            processPendingActive = false;
            processPendingLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean waitForReferenceProcessing() throws InterruptedException {
        Object object2 = processPendingLock;
        synchronized (object2) {
            if (processPendingActive || Reference.hasReferencePendingList()) {
                processPendingLock.wait();
                return true;
            }
            return false;
        }
    }

    @IntrinsicCandidate
    public T get() {
        return this.referent;
    }

    public final boolean refersTo(T obj) {
        return this.refersToImpl(obj);
    }

    boolean refersToImpl(T obj) {
        return this.refersTo0(obj);
    }

    @IntrinsicCandidate
    private native boolean refersTo0(Object var1);

    public void clear() {
        this.clear0();
    }

    private native void clear0();

    T getFromInactiveFinalReference() {
        assert (this instanceof FinalReference);
        assert (this.next != null);
        return this.referent;
    }

    void clearInactiveFinalReference() {
        assert (this instanceof FinalReference);
        assert (this.next != null);
        this.referent = null;
    }

    @Deprecated(since="16")
    public boolean isEnqueued() {
        return this.queue == ReferenceQueue.ENQUEUED;
    }

    public boolean enqueue() {
        this.clear0();
        return this.queue.enqueue(this);
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    Reference(T referent) {
        this(referent, null);
    }

    Reference(T referent, ReferenceQueue<? super T> queue) {
        this.referent = referent;
        this.queue = queue == null ? ReferenceQueue.NULL : queue;
    }

    @ForceInline
    public static void reachabilityFence(Object ref) {
    }

    static {
        ThreadGroup tg;
        processPendingLock = new Object();
        processPendingActive = false;
        ThreadGroup tgn = tg = Thread.currentThread().getThreadGroup();
        while (tgn != null) {
            tg = tgn;
            tgn = tg.getParent();
        }
        ReferenceHandler handler = new ReferenceHandler(tg, "Reference Handler");
        handler.setPriority(10);
        handler.setDaemon(true);
        handler.start();
        SharedSecrets.setJavaLangRefAccess(new JavaLangRefAccess(){

            @Override
            public boolean waitForReferenceProcessing() throws InterruptedException {
                return Reference.waitForReferenceProcessing();
            }

            @Override
            public void runFinalization() {
                Finalizer.runFinalization();
            }
        });
    }

    private static class ReferenceHandler
    extends Thread {
        private static void ensureClassInitialized(Class<?> clazz) {
            try {
                Class.forName(clazz.getName(), true, clazz.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw (Error)new NoClassDefFoundError(e.getMessage()).initCause(e);
            }
        }

        ReferenceHandler(ThreadGroup g, String name) {
            super(g, null, name, 0L, false);
        }

        @Override
        public void run() {
            while (true) {
                Reference.processPendingReferences();
            }
        }

        static {
            ReferenceHandler.ensureClassInitialized(Cleaner.class);
        }
    }
}

