/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.lang.ref.FinalReference;
import java.lang.ref.Reference;
import java.util.function.Consumer;
import jdk.internal.misc.VM;

public class ReferenceQueue<T> {
    static final ReferenceQueue<Object> NULL = new Null();
    static final ReferenceQueue<Object> ENQUEUED = new Null();
    private final Lock lock = new Lock();
    private volatile Reference<? extends T> head;
    private long queueLength = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean enqueue(Reference<? extends T> r) {
        Lock lock = this.lock;
        synchronized (lock) {
            ReferenceQueue queue = r.queue;
            if (queue == NULL || queue == ENQUEUED) {
                return false;
            }
            assert (queue == this);
            r.next = this.head == null ? r : this.head;
            this.head = r;
            ++this.queueLength;
            r.queue = ENQUEUED;
            if (r instanceof FinalReference) {
                VM.addFinalRefCount(1);
            }
            this.lock.notifyAll();
            return true;
        }
    }

    private Reference<? extends T> reallyPoll() {
        Reference<? extends T> r = this.head;
        if (r != null) {
            r.queue = NULL;
            Reference rn = r.next;
            this.head = rn == r ? null : rn;
            r.next = r;
            --this.queueLength;
            if (r instanceof FinalReference) {
                VM.addFinalRefCount(-1);
            }
            return r;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reference<? extends T> poll() {
        if (this.head == null) {
            return null;
        }
        Lock lock = this.lock;
        synchronized (lock) {
            return this.reallyPoll();
        }
    }

    public Reference<? extends T> remove(long timeout) throws IllegalArgumentException, InterruptedException {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Negative timeout value");
        }
        Lock lock = this.lock;
        synchronized (lock) {
            Reference<T> r = this.reallyPoll();
            if (r != null) {
                return r;
            }
            long start = timeout == 0L ? 0L : System.nanoTime();
            while (true) {
                this.lock.wait(timeout);
                r = this.reallyPoll();
                if (r != null) {
                    return r;
                }
                if (timeout == 0L) continue;
                long end = System.nanoTime();
                if ((timeout -= (end - start) / 1000000L) <= 0L) {
                    return null;
                }
                start = end;
            }
        }
    }

    public Reference<? extends T> remove() throws InterruptedException {
        return this.remove(0L);
    }

    void forEach(Consumer<? super Reference<? extends T>> action) {
        Reference<? extends T> r = this.head;
        while (r != null) {
            action.accept(r);
            Reference<? extends T> rn = r.next;
            if (rn == r) {
                if (r.queue == ENQUEUED) {
                    r = null;
                    continue;
                }
                r = this.head;
                continue;
            }
            r = rn;
        }
    }

    private static class Lock {
        private Lock() {
        }
    }

    private static class Null
    extends ReferenceQueue<Object> {
        private Null() {
        }

        @Override
        boolean enqueue(Reference<?> r) {
            return false;
        }
    }
}

