/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.ref.WeakReference;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ReflectAccess;
import java.security.AccessController;
import jdk.internal.access.SharedSecrets;
import jdk.internal.misc.VM;
import jdk.internal.reflect.CallerSensitive;
import jdk.internal.reflect.Reflection;
import jdk.internal.reflect.ReflectionFactory;
import sun.security.action.GetPropertyAction;
import sun.security.util.SecurityConstants;

public class AccessibleObject
implements AnnotatedElement {
    boolean override;
    static final ReflectionFactory reflectionFactory;
    volatile Object accessCheckCache;
    private static volatile boolean printStackWhenAccessFails;
    private static volatile boolean printStackPropertiesSet;

    static void checkPermission() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SecurityConstants.ACCESS_PERMISSION);
        }
    }

    @CallerSensitive
    public static void setAccessible(AccessibleObject[] array, boolean flag) {
        AccessibleObject.checkPermission();
        if (flag) {
            Class<?> caller = Reflection.getCallerClass();
            AccessibleObject[] accessibleObjectArray = array = (AccessibleObject[])array.clone();
            int n = accessibleObjectArray.length;
            for (int i = 0; i < n; ++i) {
                AccessibleObject ao = accessibleObjectArray[i];
                ao.checkCanSetAccessible(caller);
            }
        }
        for (AccessibleObject ao : array) {
            ao.setAccessible0(flag);
        }
    }

    @CallerSensitive
    public void setAccessible(boolean flag) {
        AccessibleObject.checkPermission();
        this.setAccessible0(flag);
    }

    boolean setAccessible0(boolean flag) {
        this.override = flag;
        return flag;
    }

    @CallerSensitive
    public final boolean trySetAccessible() {
        AccessibleObject.checkPermission();
        if (this.override) {
            return true;
        }
        if (!Member.class.isInstance(this)) {
            return this.setAccessible0(true);
        }
        Class<?> declaringClass = ((Member)((Object)this)).getDeclaringClass();
        if (declaringClass == Class.class && this instanceof Constructor) {
            return false;
        }
        if (this.checkCanSetAccessible(Reflection.getCallerClass(), declaringClass, false)) {
            return this.setAccessible0(true);
        }
        return false;
    }

    void checkCanSetAccessible(Class<?> caller) {
    }

    final void checkCanSetAccessible(Class<?> caller, Class<?> declaringClass) {
        this.checkCanSetAccessible(caller, declaringClass, true);
    }

    private boolean checkCanSetAccessible(Class<?> caller, Class<?> declaringClass, boolean throwExceptionIfDenied) {
        Module declaringModule;
        if (caller == MethodHandle.class) {
            throw new IllegalCallerException();
        }
        Module callerModule = caller.getModule();
        if (callerModule == (declaringModule = declaringClass.getModule())) {
            return true;
        }
        if (callerModule == Object.class.getModule()) {
            return true;
        }
        if (!declaringModule.isNamed()) {
            return true;
        }
        String pn = declaringClass.getPackageName();
        int modifiers = this instanceof Executable ? ((Executable)this).getModifiers() : ((Field)this).getModifiers();
        boolean isClassPublic = Modifier.isPublic(declaringClass.getModifiers());
        if (isClassPublic && declaringModule.isExported(pn, callerModule)) {
            if (Modifier.isPublic(modifiers)) {
                return true;
            }
            if (Modifier.isProtected(modifiers) && Modifier.isStatic(modifiers) && this.isSubclassOf(caller, declaringClass)) {
                return true;
            }
        }
        if (declaringModule.isOpen(pn, callerModule)) {
            return true;
        }
        if (throwExceptionIfDenied) {
            String msg = "Unable to make ";
            if (this instanceof Field) {
                msg = msg + "field ";
            }
            msg = msg + this + " accessible: " + declaringModule + " does not \"";
            msg = isClassPublic && Modifier.isPublic(modifiers) ? msg + "exports" : msg + "opens";
            msg = msg + " " + pn + "\" to " + callerModule;
            InaccessibleObjectException e = new InaccessibleObjectException(msg);
            if (AccessibleObject.printStackTraceWhenAccessFails()) {
                e.printStackTrace(System.err);
            }
            throw e;
        }
        return false;
    }

    private boolean isSubclassOf(Class<?> queryClass, Class<?> ofClass) {
        while (queryClass != null) {
            if (queryClass == ofClass) {
                return true;
            }
            queryClass = queryClass.getSuperclass();
        }
        return false;
    }

    String toShortString() {
        return this.toString();
    }

    @Deprecated(since="9")
    public boolean isAccessible() {
        return this.override;
    }

    @CallerSensitive
    public final boolean canAccess(Object obj) {
        if (!Member.class.isInstance(this)) {
            return this.override;
        }
        Class<?> declaringClass = ((Member)((Object)this)).getDeclaringClass();
        int modifiers = ((Member)((Object)this)).getModifiers();
        if (!Modifier.isStatic(modifiers) && (this instanceof Method || this instanceof Field)) {
            if (obj == null) {
                throw new IllegalArgumentException("null object for " + this);
            }
            if (!declaringClass.isAssignableFrom(obj.getClass())) {
                throw new IllegalArgumentException("object is not an instance of " + declaringClass.getName());
            }
        } else if (obj != null) {
            throw new IllegalArgumentException("non-null object for " + this);
        }
        if (this.override) {
            return true;
        }
        Class<?> caller = Reflection.getCallerClass();
        Class<?> targetClass = this instanceof Constructor ? declaringClass : (Modifier.isStatic(modifiers) ? null : obj.getClass());
        return this.verifyAccess(caller, declaringClass, targetClass, modifiers);
    }

    @Deprecated(since="17")
    protected AccessibleObject() {
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        throw new UnsupportedOperationException("All subclasses should override this method");
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return AnnotatedElement.super.isAnnotationPresent(annotationClass);
    }

    @Override
    public <T extends Annotation> T[] getAnnotationsByType(Class<T> annotationClass) {
        throw new UnsupportedOperationException("All subclasses should override this method");
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.getDeclaredAnnotations();
    }

    @Override
    public <T extends Annotation> T getDeclaredAnnotation(Class<T> annotationClass) {
        return this.getAnnotation(annotationClass);
    }

    @Override
    public <T extends Annotation> T[] getDeclaredAnnotationsByType(Class<T> annotationClass) {
        return this.getAnnotationsByType(annotationClass);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        throw new UnsupportedOperationException("All subclasses should override this method");
    }

    private boolean isAccessChecked(Class<?> caller, Class<?> targetClass) {
        Object cache = this.accessCheckCache;
        if (cache instanceof Cache) {
            return ((Cache)cache).isCacheFor(caller, targetClass);
        }
        return false;
    }

    private boolean isAccessChecked(Class<?> caller) {
        Object cache = this.accessCheckCache;
        if (cache instanceof WeakReference) {
            WeakReference ref = (WeakReference)cache;
            return ref.refersTo(caller);
        }
        return false;
    }

    final void checkAccess(Class<?> caller, Class<?> memberClass, Class<?> targetClass, int modifiers) throws IllegalAccessException {
        if (!this.verifyAccess(caller, memberClass, targetClass, modifiers)) {
            IllegalAccessException e = Reflection.newIllegalAccessException(caller, memberClass, targetClass, modifiers);
            if (AccessibleObject.printStackTraceWhenAccessFails()) {
                e.printStackTrace(System.err);
            }
            throw e;
        }
    }

    final boolean verifyAccess(Class<?> caller, Class<?> memberClass, Class<?> targetClass, int modifiers) {
        if (caller == memberClass) {
            return true;
        }
        if (targetClass != null && Modifier.isProtected(modifiers) && targetClass != memberClass ? this.isAccessChecked(caller, targetClass) : this.isAccessChecked(caller)) {
            return true;
        }
        return this.slowVerifyAccess(caller, memberClass, targetClass, modifiers);
    }

    private boolean slowVerifyAccess(Class<?> caller, Class<?> memberClass, Class<?> targetClass, int modifiers) {
        WeakReference cache;
        if (caller == null) {
            return Reflection.verifyPublicMemberAccess(memberClass, modifiers);
        }
        if (!Reflection.verifyMemberAccess(caller, memberClass, targetClass, modifiers)) {
            return false;
        }
        this.accessCheckCache = cache = targetClass != null && Modifier.isProtected(modifiers) && targetClass != memberClass ? Cache.protectedMemberCallerCache(caller, targetClass) : new WeakReference(caller);
        return true;
    }

    private static boolean printStackTraceWhenAccessFails() {
        if (!printStackPropertiesSet && VM.initLevel() >= 1) {
            String s = GetPropertyAction.privilegedGetProperty("sun.reflect.debugModuleAccessChecks");
            if (s != null) {
                printStackWhenAccessFails = !s.equalsIgnoreCase("false");
            }
            printStackPropertiesSet = true;
        }
        return printStackWhenAccessFails;
    }

    AccessibleObject getRoot() {
        throw new InternalError();
    }

    static {
        SharedSecrets.setJavaLangReflectAccess(new ReflectAccess());
        reflectionFactory = AccessController.doPrivileged(new ReflectionFactory.GetReflectionFactoryAction());
    }

    private static class Cache {
        final WeakReference<Class<?>> callerRef;
        final WeakReference<Class<?>> targetRef;

        Cache(Class<?> caller, Class<?> target) {
            this.callerRef = new WeakReference(caller);
            this.targetRef = new WeakReference(target);
        }

        boolean isCacheFor(Class<?> caller, Class<?> refc) {
            return this.callerRef.refersTo(caller) && this.targetRef.refersTo(refc);
        }

        static Object protectedMemberCallerCache(Class<?> caller, Class<?> refc) {
            return new Cache(caller, refc);
        }
    }
}

