/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import org.qbicc.runtime.CNative;
import org.qbicc.runtime.main.CompilerIntrinsics;

public final class Array$_native {
    public static int getLength(Object array) throws IllegalArgumentException {
        if (array == null) {
            throw new NullPointerException();
        }
        CNative.type_id typeId = CompilerIntrinsics.typeIdOf((Object)array);
        if (CompilerIntrinsics.isReferenceArray((CNative.type_id)typeId) || CompilerIntrinsics.isPrimArray((CNative.type_id)typeId)) {
            return CompilerIntrinsics.lengthOf((Object)array);
        }
        throw new IllegalArgumentException();
    }

    private static Object newArray(Class<?> componentType, int length) throws NegativeArraySizeException {
        if (componentType.isPrimitive()) {
            if (componentType == Byte.TYPE) {
                return new byte[length];
            }
            if (componentType == Boolean.TYPE) {
                return new boolean[length];
            }
            if (componentType == Short.TYPE) {
                return new short[length];
            }
            if (componentType == Character.TYPE) {
                return new char[length];
            }
            if (componentType == Integer.TYPE) {
                return new int[length];
            }
            if (componentType == Float.TYPE) {
                return new float[length];
            }
            if (componentType == Long.TYPE) {
                return new long[length];
            }
            if (componentType == Double.TYPE) {
                return new double[length];
            }
            throw new IllegalArgumentException();
        }
        int componentDim = CompilerIntrinsics.getDimensionsFromClass(componentType).intValue();
        if (componentDim == 0) {
            return CompilerIntrinsics.emitNewReferenceArray(componentType, (int)1, (int)length);
        }
        if (componentDim > 254) {
            throw new IllegalArgumentException();
        }
        CNative.type_id leafTypeId = CompilerIntrinsics.getTypeIdFromClass(componentType);
        Class leafClass = CompilerIntrinsics.getClassFromTypeIdSimple((CNative.type_id)leafTypeId);
        return CompilerIntrinsics.emitNewReferenceArray((Class)leafClass, (int)(componentDim + 1), (int)length);
    }

    private static Object multiNewArray(Class<?> componentType, int[] dimensions) throws IllegalArgumentException, NegativeArraySizeException {
        Class leafType;
        Class lastLeafType;
        int dimCount = dimensions.length;
        if (componentType.isPrimitive()) {
            if (componentType == Void.TYPE) {
                throw new IllegalArgumentException();
            }
            --dimCount;
            lastLeafType = componentType;
            leafType = CompilerIntrinsics.getArrayClassOf(componentType);
        } else {
            int componentDim = CompilerIntrinsics.getDimensionsFromClass(componentType).intValue();
            if (componentDim == 0) {
                leafType = lastLeafType = componentType;
            } else {
                dimCount += componentDim;
                CNative.type_id leafTypeId = CompilerIntrinsics.getTypeIdFromClass(componentType);
                leafType = lastLeafType = CompilerIntrinsics.getClassFromTypeIdSimple((CNative.type_id)leafTypeId);
            }
        }
        if (dimensions.length == 0 || dimCount > 255) {
            throw new IllegalArgumentException();
        }
        return Array$_native.multiNewArrayHelper(leafType, dimCount, lastLeafType, 0, dimensions);
    }

    private static Object multiNewArrayHelper(Class<?> leafType, int dimCount, Class<?> lastLeafType, int dimIdx, int[] dimensions) throws NegativeArraySizeException {
        if (dimIdx == dimensions.length - 1) {
            if (dimCount > 0) {
                return CompilerIntrinsics.emitNewReferenceArray(leafType, (int)dimCount, (int)dimensions[dimIdx]);
            }
            return Array$_native.newArray(lastLeafType, dimensions[dimIdx]);
        }
        Object[] spine = (Object[])CompilerIntrinsics.emitNewReferenceArray(leafType, (int)dimCount, (int)dimensions[dimIdx]);
        for (int i = 0; i < dimensions[dimIdx]; ++i) {
            spine[i] = Array$_native.multiNewArrayHelper(leafType, dimCount - 1, lastLeafType, dimIdx + 1, dimensions);
        }
        return spine;
    }
}

