/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.annotation.AnnotationFormatError;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.StringJoiner;
import jdk.internal.access.SharedSecrets;
import jdk.internal.reflect.CallerSensitive;
import jdk.internal.reflect.ConstructorAccessor;
import jdk.internal.reflect.Reflection;
import jdk.internal.vm.annotation.ForceInline;
import sun.reflect.annotation.TypeAnnotation;
import sun.reflect.annotation.TypeAnnotationParser;
import sun.reflect.generics.factory.CoreReflectionFactory;
import sun.reflect.generics.factory.GenericsFactory;
import sun.reflect.generics.repository.ConstructorRepository;
import sun.reflect.generics.scope.ConstructorScope;

public final class Constructor<T>
extends Executable {
    private Class<T> clazz;
    private int slot;
    private Class<?>[] parameterTypes;
    private Class<?>[] exceptionTypes;
    private int modifiers;
    private transient String signature;
    private transient ConstructorRepository genericInfo;
    private byte[] annotations;
    private byte[] parameterAnnotations;
    private volatile ConstructorAccessor constructorAccessor;
    private Constructor<T> root;

    private GenericsFactory getFactory() {
        return CoreReflectionFactory.make(this, ConstructorScope.make(this));
    }

    @Override
    ConstructorRepository getGenericInfo() {
        if (this.genericInfo == null) {
            this.genericInfo = ConstructorRepository.make(this.getSignature(), this.getFactory());
        }
        return this.genericInfo;
    }

    @Override
    Constructor<T> getRoot() {
        return this.root;
    }

    Constructor(Class<T> declaringClass, Class<?>[] parameterTypes, Class<?>[] checkedExceptions, int modifiers, int slot, String signature, byte[] annotations, byte[] parameterAnnotations) {
        this.clazz = declaringClass;
        this.parameterTypes = parameterTypes;
        this.exceptionTypes = checkedExceptions;
        this.modifiers = modifiers;
        this.slot = slot;
        this.signature = signature;
        this.annotations = annotations;
        this.parameterAnnotations = parameterAnnotations;
    }

    Constructor<T> copy() {
        if (this.root != null) {
            throw new IllegalArgumentException("Can not copy a non-root Constructor");
        }
        Constructor<T> res = new Constructor<T>(this.clazz, this.parameterTypes, this.exceptionTypes, this.modifiers, this.slot, this.signature, this.annotations, this.parameterAnnotations);
        res.root = this;
        res.constructorAccessor = this.constructorAccessor;
        return res;
    }

    @Override
    @CallerSensitive
    public void setAccessible(boolean flag) {
        AccessibleObject.checkPermission();
        if (flag) {
            this.checkCanSetAccessible(Reflection.getCallerClass());
        }
        this.setAccessible0(flag);
    }

    @Override
    void checkCanSetAccessible(Class<?> caller) {
        this.checkCanSetAccessible(caller, this.clazz);
        if (this.clazz == Class.class) {
            throw new SecurityException("Cannot make a java.lang.Class constructor accessible");
        }
    }

    @Override
    boolean hasGenericInformation() {
        return this.getSignature() != null;
    }

    @Override
    byte[] getAnnotationBytes() {
        return this.annotations;
    }

    public Class<T> getDeclaringClass() {
        return this.clazz;
    }

    @Override
    public String getName() {
        return this.getDeclaringClass().getName();
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    public TypeVariable<Constructor<T>>[] getTypeParameters() {
        if (this.getSignature() != null) {
            return this.getGenericInfo().getTypeParameters();
        }
        return new TypeVariable[0];
    }

    @Override
    Class<?>[] getSharedParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    Class<?>[] getSharedExceptionTypes() {
        return this.exceptionTypes;
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return (Class[])this.parameterTypes.clone();
    }

    @Override
    public int getParameterCount() {
        return this.parameterTypes.length;
    }

    @Override
    public Type[] getGenericParameterTypes() {
        return super.getGenericParameterTypes();
    }

    @Override
    public Class<?>[] getExceptionTypes() {
        return (Class[])this.exceptionTypes.clone();
    }

    @Override
    public Type[] getGenericExceptionTypes() {
        return super.getGenericExceptionTypes();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Constructor) {
            Constructor other = (Constructor)obj;
            if (this.getDeclaringClass() == other.getDeclaringClass()) {
                return this.equalParamTypes(this.parameterTypes, other.parameterTypes);
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode();
    }

    public String toString() {
        return this.sharedToString(Modifier.constructorModifiers(), false, this.parameterTypes, this.exceptionTypes);
    }

    @Override
    void specificToStringHeader(StringBuilder sb) {
        sb.append(this.getDeclaringClass().getTypeName());
    }

    @Override
    String toShortString() {
        StringBuilder sb = new StringBuilder("constructor ");
        sb.append(this.getDeclaringClass().getTypeName());
        sb.append('(');
        StringJoiner sj = new StringJoiner(",");
        for (Class<?> parameterType : this.getParameterTypes()) {
            sj.add(parameterType.getTypeName());
        }
        sb.append(sj);
        sb.append(')');
        return sb.toString();
    }

    @Override
    public String toGenericString() {
        return this.sharedToGenericString(Modifier.constructorModifiers(), false);
    }

    @Override
    void specificToGenericStringHeader(StringBuilder sb) {
        this.specificToStringHeader(sb);
    }

    @CallerSensitive
    @ForceInline
    public T newInstance(Object ... initargs) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<?> caller = this.override ? null : Reflection.getCallerClass();
        return this.newInstanceWithCaller(initargs, !this.override, caller);
    }

    T newInstanceWithCaller(Object[] args, boolean checkAccess, Class<?> caller) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        if (checkAccess) {
            this.checkAccess(caller, this.clazz, this.clazz, this.modifiers);
        }
        if ((this.clazz.getModifiers() & 0x4000) != 0) {
            throw new IllegalArgumentException("Cannot reflectively create enum objects");
        }
        ConstructorAccessor ca = this.constructorAccessor;
        if (ca == null) {
            ca = this.acquireConstructorAccessor();
        }
        Object inst = ca.newInstance(args);
        return (T)inst;
    }

    @Override
    public boolean isVarArgs() {
        return super.isVarArgs();
    }

    @Override
    public boolean isSynthetic() {
        return super.isSynthetic();
    }

    private ConstructorAccessor acquireConstructorAccessor() {
        ConstructorAccessor tmp = null;
        if (this.root != null) {
            tmp = this.root.getConstructorAccessor();
        }
        if (tmp != null) {
            this.constructorAccessor = tmp;
        } else {
            tmp = reflectionFactory.newConstructorAccessor(this);
            this.setConstructorAccessor(tmp);
        }
        return tmp;
    }

    ConstructorAccessor getConstructorAccessor() {
        return this.constructorAccessor;
    }

    void setConstructorAccessor(ConstructorAccessor accessor) {
        this.constructorAccessor = accessor;
        if (this.root != null) {
            this.root.setConstructorAccessor(accessor);
        }
    }

    int getSlot() {
        return this.slot;
    }

    String getSignature() {
        return this.signature;
    }

    byte[] getRawAnnotations() {
        return this.annotations;
    }

    byte[] getRawParameterAnnotations() {
        return this.parameterAnnotations;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return super.getAnnotation(annotationClass);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return super.getDeclaredAnnotations();
    }

    @Override
    public Annotation[][] getParameterAnnotations() {
        return this.sharedGetParameterAnnotations(this.parameterTypes, this.parameterAnnotations);
    }

    @Override
    boolean handleParameterNumberMismatch(int resultLength, Class<?>[] parameterTypes) {
        int numParameters = parameterTypes.length;
        Class<T> declaringClass = this.getDeclaringClass();
        if (declaringClass.isEnum()) {
            return resultLength + 2 == numParameters && parameterTypes[0] == String.class && parameterTypes[1] == Integer.TYPE;
        }
        if (declaringClass.isAnonymousClass() || declaringClass.isLocalClass()) {
            return false;
        }
        if (declaringClass.isMemberClass() && (declaringClass.getModifiers() & 8) == 0 && resultLength + 1 == numParameters) {
            return true;
        }
        throw new AnnotationFormatError("Parameter annotations don't match number of parameters");
    }

    @Override
    public AnnotatedType getAnnotatedReturnType() {
        return this.getAnnotatedReturnType0(this.getDeclaringClass());
    }

    @Override
    public AnnotatedType getAnnotatedReceiverType() {
        Class<T> thisDeclClass = this.getDeclaringClass();
        Class<?> enclosingClass = thisDeclClass.getEnclosingClass();
        if (enclosingClass == null) {
            return null;
        }
        Class<?> outerDeclaringClass = thisDeclClass.getDeclaringClass();
        if (outerDeclaringClass == null) {
            return null;
        }
        if (Modifier.isStatic(thisDeclClass.getModifiers())) {
            return null;
        }
        return TypeAnnotationParser.buildAnnotatedType(this.getTypeAnnotationBytes0(), SharedSecrets.getJavaLangAccess().getConstantPool(thisDeclClass), this, thisDeclClass, this.parameterize(enclosingClass), TypeAnnotation.TypeAnnotationTarget.METHOD_RECEIVER);
    }
}

