/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.MalformedParametersException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import jdk.internal.access.SharedSecrets;
import sun.reflect.annotation.AnnotationParser;
import sun.reflect.annotation.AnnotationSupport;
import sun.reflect.annotation.TypeAnnotation;
import sun.reflect.annotation.TypeAnnotationParser;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;
import sun.reflect.generics.repository.ConstructorRepository;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class Executable
extends AccessibleObject
implements Member,
GenericDeclaration {
    private volatile transient boolean hasRealParameterData;
    private volatile transient Parameter[] parameters;
    private volatile transient Map<Class<? extends Annotation>, Annotation> declaredAnnotations;

    Executable() {
    }

    abstract byte[] getAnnotationBytes();

    abstract boolean hasGenericInformation();

    abstract ConstructorRepository getGenericInfo();

    boolean equalParamTypes(Class<?>[] params1, Class<?>[] params2) {
        if (params1.length == params2.length) {
            for (int i = 0; i < params1.length; ++i) {
                if (params1[i] == params2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    Annotation[][] parseParameterAnnotations(byte[] parameterAnnotations) {
        return AnnotationParser.parseParameterAnnotations(parameterAnnotations, SharedSecrets.getJavaLangAccess().getConstantPool(this.getDeclaringClass()), this.getDeclaringClass());
    }

    void printModifiersIfNonzero(StringBuilder sb, int mask, boolean isDefault) {
        int mod = this.getModifiers() & mask;
        if (mod != 0 && !isDefault) {
            sb.append(Modifier.toString(mod)).append(' ');
        } else {
            int access_mod = mod & 7;
            if (access_mod != 0) {
                sb.append(Modifier.toString(access_mod)).append(' ');
            }
            if (isDefault) {
                sb.append("default ");
            }
            if ((mod &= 0xFFFFFFF8) != 0) {
                sb.append(Modifier.toString(mod)).append(' ');
            }
        }
    }

    String sharedToString(int modifierMask, boolean isDefault, Class<?>[] parameterTypes, Class<?>[] exceptionTypes) {
        try {
            StringBuilder sb = new StringBuilder();
            this.printModifiersIfNonzero(sb, modifierMask, isDefault);
            this.specificToStringHeader(sb);
            sb.append(Arrays.stream(parameterTypes).map(Type::getTypeName).collect(Collectors.joining(",", "(", ")")));
            if (exceptionTypes.length > 0) {
                sb.append(Arrays.stream(exceptionTypes).map(Type::getTypeName).collect(Collectors.joining(",", " throws ", "")));
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "<" + e + ">";
        }
    }

    abstract void specificToStringHeader(StringBuilder var1);

    static String typeVarBounds(TypeVariable<?> typeVar) {
        Type[] bounds = typeVar.getBounds();
        if (bounds.length == 1 && bounds[0].equals(Object.class)) {
            return typeVar.getName();
        }
        return typeVar.getName() + " extends " + Arrays.stream(bounds).map(Type::getTypeName).collect(Collectors.joining(" & "));
    }

    String sharedToGenericString(int modifierMask, boolean isDefault) {
        try {
            StringBuilder sb = new StringBuilder();
            this.printModifiersIfNonzero(sb, modifierMask, isDefault);
            TypeVariable<?>[] typeparms = this.getTypeParameters();
            if (typeparms.length > 0) {
                sb.append(Arrays.stream(typeparms).map(Executable::typeVarBounds).collect(Collectors.joining(",", "<", "> ")));
            }
            this.specificToGenericStringHeader(sb);
            sb.append('(');
            StringJoiner sj = new StringJoiner(",");
            Type[] params = this.getGenericParameterTypes();
            for (int j = 0; j < params.length; ++j) {
                String param = params[j].getTypeName();
                if (this.isVarArgs() && j == params.length - 1) {
                    param = param.replaceFirst("\\[\\]$", "...");
                }
                sj.add(param);
            }
            sb.append(sj.toString());
            sb.append(')');
            Type[] exceptionTypes = this.getGenericExceptionTypes();
            if (exceptionTypes.length > 0) {
                sb.append(Arrays.stream(exceptionTypes).map(Type::getTypeName).collect(Collectors.joining(",", " throws ", "")));
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "<" + e + ">";
        }
    }

    abstract void specificToGenericStringHeader(StringBuilder var1);

    @Override
    public abstract Class<?> getDeclaringClass();

    @Override
    public abstract String getName();

    @Override
    public abstract int getModifiers();

    @Override
    public abstract TypeVariable<?>[] getTypeParameters();

    abstract Class<?>[] getSharedParameterTypes();

    abstract Class<?>[] getSharedExceptionTypes();

    public abstract Class<?>[] getParameterTypes();

    public int getParameterCount() {
        throw new AbstractMethodError();
    }

    public Type[] getGenericParameterTypes() {
        if (this.hasGenericInformation()) {
            return this.getGenericInfo().getParameterTypes();
        }
        return this.getParameterTypes();
    }

    Type[] getAllGenericParameterTypes() {
        boolean genericInfo = this.hasGenericInformation();
        if (!genericInfo) {
            return this.getParameterTypes();
        }
        boolean realParamData = this.hasRealParameterData();
        Type[] genericParamTypes = this.getGenericParameterTypes();
        Class<?>[] nonGenericParamTypes = this.getParameterTypes();
        if (realParamData) {
            Type[] out = new Type[nonGenericParamTypes.length];
            Parameter[] params = this.getParameters();
            int fromidx = 0;
            for (int i = 0; i < out.length; ++i) {
                Parameter param = params[i];
                if (param.isSynthetic() || param.isImplicit()) {
                    out[i] = nonGenericParamTypes[i];
                    continue;
                }
                out[i] = genericParamTypes[fromidx];
                ++fromidx;
            }
            return out;
        }
        return genericParamTypes.length == nonGenericParamTypes.length ? genericParamTypes : nonGenericParamTypes;
    }

    public Parameter[] getParameters() {
        return (Parameter[])this.privateGetParameters().clone();
    }

    private Parameter[] synthesizeAllParams() {
        int realparams = this.getParameterCount();
        Parameter[] out = new Parameter[realparams];
        for (int i = 0; i < realparams; ++i) {
            out[i] = new Parameter("arg" + i, 0, this, i);
        }
        return out;
    }

    private void verifyParameters(Parameter[] parameters) {
        int mask = 36880;
        if (this.getParameterCount() != parameters.length) {
            throw new MalformedParametersException("Wrong number of parameters in MethodParameters attribute");
        }
        for (Parameter parameter : parameters) {
            String name = parameter.getRealName();
            int mods = parameter.getModifiers();
            if (name != null && (name.isEmpty() || name.indexOf(46) != -1 || name.indexOf(59) != -1 || name.indexOf(91) != -1 || name.indexOf(47) != -1)) {
                throw new MalformedParametersException("Invalid parameter name \"" + name + "\"");
            }
            if (mods == (mods & 0x9010)) continue;
            throw new MalformedParametersException("Invalid parameter modifiers");
        }
    }

    private Parameter[] privateGetParameters() {
        Parameter[] tmp = this.parameters;
        if (tmp == null) {
            try {
                tmp = this.getParameters0();
            }
            catch (IllegalArgumentException e) {
                throw new MalformedParametersException("Invalid constant pool index");
            }
            if (tmp == null) {
                this.hasRealParameterData = false;
                tmp = this.synthesizeAllParams();
            } else {
                this.hasRealParameterData = true;
                this.verifyParameters(tmp);
            }
            this.parameters = tmp;
        }
        return tmp;
    }

    boolean hasRealParameterData() {
        if (this.parameters == null) {
            this.privateGetParameters();
        }
        return this.hasRealParameterData;
    }

    private native Parameter[] getParameters0();

    native byte[] getTypeAnnotationBytes0();

    byte[] getTypeAnnotationBytes() {
        return this.getTypeAnnotationBytes0();
    }

    public abstract Class<?>[] getExceptionTypes();

    public Type[] getGenericExceptionTypes() {
        Type[] result;
        if (this.hasGenericInformation() && (result = this.getGenericInfo().getExceptionTypes()).length > 0) {
            return result;
        }
        return this.getExceptionTypes();
    }

    public abstract String toGenericString();

    public boolean isVarArgs() {
        return (this.getModifiers() & 0x80) != 0;
    }

    @Override
    public boolean isSynthetic() {
        return Modifier.isSynthetic(this.getModifiers());
    }

    public abstract Annotation[][] getParameterAnnotations();

    Annotation[][] sharedGetParameterAnnotations(Class<?>[] parameterTypes, byte[] parameterAnnotations) {
        int numParameters = parameterTypes.length;
        if (parameterAnnotations == null) {
            return new Annotation[numParameters][0];
        }
        Annotation[][] result = this.parseParameterAnnotations(parameterAnnotations);
        if (result.length != numParameters && this.handleParameterNumberMismatch(result.length, parameterTypes)) {
            Annotation[][] tmp = new Annotation[numParameters][];
            System.arraycopy(result, 0, tmp, numParameters - result.length, result.length);
            for (int i = 0; i < numParameters - result.length; ++i) {
                tmp[i] = new Annotation[0];
            }
            result = tmp;
        }
        return result;
    }

    abstract boolean handleParameterNumberMismatch(int var1, Class<?>[] var2);

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        Objects.requireNonNull(annotationClass);
        return (T)((Annotation)annotationClass.cast(this.declaredAnnotations().get(annotationClass)));
    }

    @Override
    public <T extends Annotation> T[] getAnnotationsByType(Class<T> annotationClass) {
        Objects.requireNonNull(annotationClass);
        return AnnotationSupport.getDirectlyAndIndirectlyPresent(this.declaredAnnotations(), annotationClass);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return AnnotationParser.toArray(this.declaredAnnotations());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Class<? extends Annotation>, Annotation> declaredAnnotations() {
        Map<Class<? extends Annotation>, Annotation> declAnnos = this.declaredAnnotations;
        if (declAnnos == null) {
            Executable executable = this;
            synchronized (executable) {
                declAnnos = this.declaredAnnotations;
                if (declAnnos == null) {
                    Executable root = (Executable)this.getRoot();
                    declAnnos = root != null ? root.declaredAnnotations() : AnnotationParser.parseAnnotations(this.getAnnotationBytes(), SharedSecrets.getJavaLangAccess().getConstantPool(this.getDeclaringClass()), this.getDeclaringClass());
                    this.declaredAnnotations = declAnnos;
                }
            }
        }
        return declAnnos;
    }

    public abstract AnnotatedType getAnnotatedReturnType();

    AnnotatedType getAnnotatedReturnType0(Type returnType) {
        return TypeAnnotationParser.buildAnnotatedType(this.getTypeAnnotationBytes0(), SharedSecrets.getJavaLangAccess().getConstantPool(this.getDeclaringClass()), this, this.getDeclaringClass(), returnType, TypeAnnotation.TypeAnnotationTarget.METHOD_RETURN);
    }

    public AnnotatedType getAnnotatedReceiverType() {
        if (Modifier.isStatic(this.getModifiers())) {
            return null;
        }
        return TypeAnnotationParser.buildAnnotatedType(this.getTypeAnnotationBytes0(), SharedSecrets.getJavaLangAccess().getConstantPool(this.getDeclaringClass()), this, this.getDeclaringClass(), this.parameterize(this.getDeclaringClass()), TypeAnnotation.TypeAnnotationTarget.METHOD_RECEIVER);
    }

    Type parameterize(Class<?> c) {
        Class<?> ownerClass = c.getDeclaringClass();
        Type[] typeVars = c.getTypeParameters();
        if (ownerClass == null || Modifier.isStatic(c.getModifiers())) {
            if (typeVars.length == 0) {
                return c;
            }
            return ParameterizedTypeImpl.make(c, typeVars, null);
        }
        Type ownerType = this.parameterize(ownerClass);
        if (ownerType instanceof Class && typeVars.length == 0) {
            return c;
        }
        return ParameterizedTypeImpl.make(c, typeVars, ownerType);
    }

    public AnnotatedType[] getAnnotatedParameterTypes() {
        return TypeAnnotationParser.buildAnnotatedTypes(this.getTypeAnnotationBytes0(), SharedSecrets.getJavaLangAccess().getConstantPool(this.getDeclaringClass()), this, this.getDeclaringClass(), this.getAllGenericParameterTypes(), TypeAnnotation.TypeAnnotationTarget.METHOD_FORMAL_PARAMETER);
    }

    public AnnotatedType[] getAnnotatedExceptionTypes() {
        return TypeAnnotationParser.buildAnnotatedTypes(this.getTypeAnnotationBytes0(), SharedSecrets.getJavaLangAccess().getConstantPool(this.getDeclaringClass()), this, this.getDeclaringClass(), this.getGenericExceptionTypes(), TypeAnnotation.TypeAnnotationTarget.THROWS);
    }
}

