/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import jdk.internal.access.SharedSecrets;
import jdk.internal.reflect.CallerSensitive;
import jdk.internal.reflect.FieldAccessor;
import jdk.internal.reflect.Reflection;
import jdk.internal.vm.annotation.ForceInline;
import sun.reflect.annotation.AnnotationParser;
import sun.reflect.annotation.AnnotationSupport;
import sun.reflect.annotation.TypeAnnotation;
import sun.reflect.annotation.TypeAnnotationParser;
import sun.reflect.generics.factory.CoreReflectionFactory;
import sun.reflect.generics.factory.GenericsFactory;
import sun.reflect.generics.repository.FieldRepository;
import sun.reflect.generics.scope.ClassScope;

public final class Field
extends AccessibleObject
implements Member {
    private Class<?> clazz;
    private int slot;
    private String name;
    private Class<?> type;
    private int modifiers;
    private boolean trustedFinal;
    private transient String signature;
    private transient FieldRepository genericInfo;
    private byte[] annotations;
    private FieldAccessor fieldAccessor;
    private FieldAccessor overrideFieldAccessor;
    private Field root;
    private volatile transient Map<Class<? extends Annotation>, Annotation> declaredAnnotations;

    private String getGenericSignature() {
        return this.signature;
    }

    private GenericsFactory getFactory() {
        Class<?> c = this.getDeclaringClass();
        return CoreReflectionFactory.make(c, ClassScope.make(c));
    }

    private FieldRepository getGenericInfo() {
        if (this.genericInfo == null) {
            this.genericInfo = FieldRepository.make(this.getGenericSignature(), this.getFactory());
        }
        return this.genericInfo;
    }

    Field(Class<?> declaringClass, String name, Class<?> type, int modifiers, boolean trustedFinal, int slot, String signature, byte[] annotations) {
        this.clazz = declaringClass;
        this.name = name;
        this.type = type;
        this.modifiers = modifiers;
        this.trustedFinal = trustedFinal;
        this.slot = slot;
        this.signature = signature;
        this.annotations = annotations;
    }

    Field copy() {
        if (this.root != null) {
            throw new IllegalArgumentException("Can not copy a non-root Field");
        }
        Field res = new Field(this.clazz, this.name, this.type, this.modifiers, this.trustedFinal, this.slot, this.signature, this.annotations);
        res.root = this;
        res.fieldAccessor = this.fieldAccessor;
        res.overrideFieldAccessor = this.overrideFieldAccessor;
        return res;
    }

    @Override
    @CallerSensitive
    public void setAccessible(boolean flag) {
        AccessibleObject.checkPermission();
        if (flag) {
            this.checkCanSetAccessible(Reflection.getCallerClass());
        }
        this.setAccessible0(flag);
    }

    @Override
    void checkCanSetAccessible(Class<?> caller) {
        this.checkCanSetAccessible(caller, this.clazz);
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.clazz;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    public boolean isEnumConstant() {
        return (this.getModifiers() & 0x4000) != 0;
    }

    @Override
    public boolean isSynthetic() {
        return Modifier.isSynthetic(this.getModifiers());
    }

    public Class<?> getType() {
        return this.type;
    }

    public Type getGenericType() {
        if (this.getGenericSignature() != null) {
            return this.getGenericInfo().getGenericType();
        }
        return this.getType();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Field) {
            Field other = (Field)obj;
            return this.getDeclaringClass() == other.getDeclaringClass() && this.getName() == other.getName() && this.getType() == other.getType();
        }
        return false;
    }

    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode() ^ this.getName().hashCode();
    }

    public String toString() {
        int mod = this.getModifiers();
        return (mod == 0 ? "" : Modifier.toString(mod) + " ") + this.getType().getTypeName() + " " + this.getDeclaringClass().getTypeName() + "." + this.getName();
    }

    @Override
    String toShortString() {
        return "field " + this.getDeclaringClass().getTypeName() + "." + this.getName();
    }

    public String toGenericString() {
        int mod = this.getModifiers();
        Type fieldType = this.getGenericType();
        return (mod == 0 ? "" : Modifier.toString(mod) + " ") + fieldType.getTypeName() + " " + this.getDeclaringClass().getTypeName() + "." + this.getName();
    }

    @CallerSensitive
    @ForceInline
    public Object get(Object obj) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override) {
            Class<?> caller = Reflection.getCallerClass();
            this.checkAccess(caller, obj);
        }
        return this.getFieldAccessor(obj).get(obj);
    }

    @CallerSensitive
    @ForceInline
    public boolean getBoolean(Object obj) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override) {
            Class<?> caller = Reflection.getCallerClass();
            this.checkAccess(caller, obj);
        }
        return this.getFieldAccessor(obj).getBoolean(obj);
    }

    @CallerSensitive
    @ForceInline
    public byte getByte(Object obj) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override) {
            Class<?> caller = Reflection.getCallerClass();
            this.checkAccess(caller, obj);
        }
        return this.getFieldAccessor(obj).getByte(obj);
    }

    @CallerSensitive
    @ForceInline
    public char getChar(Object obj) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override) {
            Class<?> caller = Reflection.getCallerClass();
            this.checkAccess(caller, obj);
        }
        return this.getFieldAccessor(obj).getChar(obj);
    }

    @CallerSensitive
    @ForceInline
    public short getShort(Object obj) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override) {
            Class<?> caller = Reflection.getCallerClass();
            this.checkAccess(caller, obj);
        }
        return this.getFieldAccessor(obj).getShort(obj);
    }

    @CallerSensitive
    @ForceInline
    public int getInt(Object obj) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override) {
            Class<?> caller = Reflection.getCallerClass();
            this.checkAccess(caller, obj);
        }
        return this.getFieldAccessor(obj).getInt(obj);
    }

    @CallerSensitive
    @ForceInline
    public long getLong(Object obj) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override) {
            Class<?> caller = Reflection.getCallerClass();
            this.checkAccess(caller, obj);
        }
        return this.getFieldAccessor(obj).getLong(obj);
    }

    @CallerSensitive
    @ForceInline
    public float getFloat(Object obj) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override) {
            Class<?> caller = Reflection.getCallerClass();
            this.checkAccess(caller, obj);
        }
        return this.getFieldAccessor(obj).getFloat(obj);
    }

    @CallerSensitive
    @ForceInline
    public double getDouble(Object obj) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override) {
            Class<?> caller = Reflection.getCallerClass();
            this.checkAccess(caller, obj);
        }
        return this.getFieldAccessor(obj).getDouble(obj);
    }

    @CallerSensitive
    @ForceInline
    public void set(Object obj, Object value) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override) {
            Class<?> caller = Reflection.getCallerClass();
            this.checkAccess(caller, obj);
        }
        this.getFieldAccessor(obj).set(obj, value);
    }

    @CallerSensitive
    @ForceInline
    public void setBoolean(Object obj, boolean z) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override) {
            Class<?> caller = Reflection.getCallerClass();
            this.checkAccess(caller, obj);
        }
        this.getFieldAccessor(obj).setBoolean(obj, z);
    }

    @CallerSensitive
    @ForceInline
    public void setByte(Object obj, byte b) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override) {
            Class<?> caller = Reflection.getCallerClass();
            this.checkAccess(caller, obj);
        }
        this.getFieldAccessor(obj).setByte(obj, b);
    }

    @CallerSensitive
    @ForceInline
    public void setChar(Object obj, char c) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override) {
            Class<?> caller = Reflection.getCallerClass();
            this.checkAccess(caller, obj);
        }
        this.getFieldAccessor(obj).setChar(obj, c);
    }

    @CallerSensitive
    @ForceInline
    public void setShort(Object obj, short s) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override) {
            Class<?> caller = Reflection.getCallerClass();
            this.checkAccess(caller, obj);
        }
        this.getFieldAccessor(obj).setShort(obj, s);
    }

    @CallerSensitive
    @ForceInline
    public void setInt(Object obj, int i) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override) {
            Class<?> caller = Reflection.getCallerClass();
            this.checkAccess(caller, obj);
        }
        this.getFieldAccessor(obj).setInt(obj, i);
    }

    @CallerSensitive
    @ForceInline
    public void setLong(Object obj, long l) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override) {
            Class<?> caller = Reflection.getCallerClass();
            this.checkAccess(caller, obj);
        }
        this.getFieldAccessor(obj).setLong(obj, l);
    }

    @CallerSensitive
    @ForceInline
    public void setFloat(Object obj, float f) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override) {
            Class<?> caller = Reflection.getCallerClass();
            this.checkAccess(caller, obj);
        }
        this.getFieldAccessor(obj).setFloat(obj, f);
    }

    @CallerSensitive
    @ForceInline
    public void setDouble(Object obj, double d) throws IllegalArgumentException, IllegalAccessException {
        if (!this.override) {
            Class<?> caller = Reflection.getCallerClass();
            this.checkAccess(caller, obj);
        }
        this.getFieldAccessor(obj).setDouble(obj, d);
    }

    private void checkAccess(Class<?> caller, Object obj) throws IllegalAccessException {
        this.checkAccess(caller, this.clazz, Modifier.isStatic(this.modifiers) ? null : obj.getClass(), this.modifiers);
    }

    private FieldAccessor getFieldAccessor(Object obj) throws IllegalAccessException {
        boolean ov = this.override;
        FieldAccessor a = ov ? this.overrideFieldAccessor : this.fieldAccessor;
        return a != null ? a : this.acquireFieldAccessor(ov);
    }

    private FieldAccessor acquireFieldAccessor(boolean overrideFinalCheck) {
        FieldAccessor tmp = null;
        if (this.root != null) {
            tmp = this.root.getFieldAccessor(overrideFinalCheck);
        }
        if (tmp != null) {
            if (overrideFinalCheck) {
                this.overrideFieldAccessor = tmp;
            } else {
                this.fieldAccessor = tmp;
            }
        } else {
            tmp = reflectionFactory.newFieldAccessor(this, overrideFinalCheck);
            this.setFieldAccessor(tmp, overrideFinalCheck);
        }
        return tmp;
    }

    private FieldAccessor getFieldAccessor(boolean overrideFinalCheck) {
        return overrideFinalCheck ? this.overrideFieldAccessor : this.fieldAccessor;
    }

    private void setFieldAccessor(FieldAccessor accessor, boolean overrideFinalCheck) {
        if (overrideFinalCheck) {
            this.overrideFieldAccessor = accessor;
        } else {
            this.fieldAccessor = accessor;
        }
        if (this.root != null) {
            this.root.setFieldAccessor(accessor, overrideFinalCheck);
        }
    }

    @Override
    Field getRoot() {
        return this.root;
    }

    boolean isTrustedFinal() {
        return this.trustedFinal;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        Objects.requireNonNull(annotationClass);
        return (T)((Annotation)annotationClass.cast(this.declaredAnnotations().get(annotationClass)));
    }

    @Override
    public <T extends Annotation> T[] getAnnotationsByType(Class<T> annotationClass) {
        Objects.requireNonNull(annotationClass);
        return AnnotationSupport.getDirectlyAndIndirectlyPresent(this.declaredAnnotations(), annotationClass);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return AnnotationParser.toArray(this.declaredAnnotations());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Class<? extends Annotation>, Annotation> declaredAnnotations() {
        Map<Class<? extends Annotation>, Annotation> declAnnos = this.declaredAnnotations;
        if (declAnnos == null) {
            Field field = this;
            synchronized (field) {
                declAnnos = this.declaredAnnotations;
                if (declAnnos == null) {
                    Field root = this.root;
                    declAnnos = root != null ? root.declaredAnnotations() : AnnotationParser.parseAnnotations(this.annotations, SharedSecrets.getJavaLangAccess().getConstantPool(this.getDeclaringClass()), this.getDeclaringClass());
                    this.declaredAnnotations = declAnnos;
                }
            }
        }
        return declAnnos;
    }

    private native byte[] getTypeAnnotationBytes0();

    public AnnotatedType getAnnotatedType() {
        return TypeAnnotationParser.buildAnnotatedType(this.getTypeAnnotationBytes0(), SharedSecrets.getJavaLangAccess().getConstantPool(this.getDeclaringClass()), this, this.getDeclaringClass(), this.getGenericType(), TypeAnnotation.TypeAnnotationTarget.FIELD);
    }
}

