/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Objects;
import jdk.internal.reflect.CallerSensitive;
import jdk.internal.reflect.Reflection;

public interface InvocationHandler {
    public Object invoke(Object var1, Method var2, Object[] var3) throws Throwable;

    @CallerSensitive
    public static Object invokeDefault(Object proxy, Method method, Object ... args) throws Throwable {
        Objects.requireNonNull(proxy);
        Objects.requireNonNull(method);
        if (!Proxy.isProxyClass(proxy.getClass())) {
            throw new IllegalArgumentException("'proxy' is not a proxy instance");
        }
        if (!method.isDefault()) {
            throw new IllegalArgumentException("\"" + method + "\" is not a default method");
        }
        Class<?> proxyClass = proxy.getClass();
        Class<?> intf = method.getDeclaringClass();
        method.checkAccess(Reflection.getCallerClass(), intf, proxyClass, method.getModifiers());
        MethodHandle mh = Proxy.defaultMethodHandle(proxyClass, method);
        try {
            Object[] params = args != null ? args : Proxy.EMPTY_ARGS;
            return mh.invokeExact(proxy, params);
        }
        catch (ClassCastException | NullPointerException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (Proxy.InvocationException e) {
            throw e.getCause();
        }
    }
}

