/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import jdk.internal.access.SharedSecrets;
import sun.reflect.annotation.AnnotationParser;
import sun.reflect.annotation.TypeAnnotation;
import sun.reflect.annotation.TypeAnnotationParser;
import sun.reflect.generics.factory.CoreReflectionFactory;
import sun.reflect.generics.factory.GenericsFactory;
import sun.reflect.generics.repository.FieldRepository;
import sun.reflect.generics.scope.ClassScope;

public final class RecordComponent
implements AnnotatedElement {
    private Class<?> clazz;
    private String name;
    private Class<?> type;
    private Method accessor;
    private String signature;
    private transient FieldRepository genericInfo;
    private byte[] annotations;
    private byte[] typeAnnotations;
    private RecordComponent root;
    private volatile transient Map<Class<? extends Annotation>, Annotation> declaredAnnotations;

    private RecordComponent() {
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getGenericSignature() {
        return this.signature;
    }

    public Type getGenericType() {
        if (this.getGenericSignature() != null) {
            return this.getGenericInfo().getGenericType();
        }
        return this.getType();
    }

    private FieldRepository getGenericInfo() {
        if (this.genericInfo == null) {
            this.genericInfo = FieldRepository.make(this.getGenericSignature(), this.getFactory());
        }
        return this.genericInfo;
    }

    private GenericsFactory getFactory() {
        Class<?> c = this.getDeclaringRecord();
        return CoreReflectionFactory.make(c, ClassScope.make(c));
    }

    public AnnotatedType getAnnotatedType() {
        return TypeAnnotationParser.buildAnnotatedType(this.typeAnnotations, SharedSecrets.getJavaLangAccess().getConstantPool(this.getDeclaringRecord()), this, this.getDeclaringRecord(), this.getGenericType(), TypeAnnotation.TypeAnnotationTarget.FIELD);
    }

    public Method getAccessor() {
        return this.accessor;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        Objects.requireNonNull(annotationClass);
        return (T)((Annotation)annotationClass.cast(this.declaredAnnotations().get(annotationClass)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Class<? extends Annotation>, Annotation> declaredAnnotations() {
        Map<Class<? extends Annotation>, Annotation> declAnnos = this.declaredAnnotations;
        if (declAnnos == null) {
            RecordComponent recordComponent = this;
            synchronized (recordComponent) {
                declAnnos = this.declaredAnnotations;
                if (declAnnos == null) {
                    RecordComponent root = this.root;
                    declAnnos = root != null ? root.declaredAnnotations() : AnnotationParser.parseAnnotations(this.annotations, SharedSecrets.getJavaLangAccess().getConstantPool(this.getDeclaringRecord()), this.getDeclaringRecord());
                    this.declaredAnnotations = declAnnos;
                }
            }
        }
        return declAnnos;
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.getDeclaredAnnotations();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return AnnotationParser.toArray(this.declaredAnnotations());
    }

    public String toString() {
        return this.getType().getTypeName() + " " + this.getName();
    }

    public Class<?> getDeclaringRecord() {
        return this.clazz;
    }
}

