/*
 * Decompiled with CFR 0.152.
 */
package java.lang.runtime;

import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.util.Objects;
import java.util.stream.Stream;
import jdk.internal.javac.PreviewFeature;

@PreviewFeature(feature=PreviewFeature.Feature.SWITCH_PATTERN_MATCHING)
public class SwitchBootstraps {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final MethodHandle DO_TYPE_SWITCH;
    private static final MethodHandle DO_ENUM_SWITCH;

    private SwitchBootstraps() {
    }

    public static CallSite typeSwitch(MethodHandles.Lookup lookup, String invocationName, MethodType invocationType, Object ... labels) {
        if (invocationType.parameterCount() != 2 || !invocationType.returnType().equals(Integer.TYPE) || ((Class)invocationType.parameterType(0)).isPrimitive() || !invocationType.parameterType(1).equals(Integer.TYPE)) {
            throw new IllegalArgumentException("Illegal invocation type " + invocationType);
        }
        Objects.requireNonNull(labels);
        labels = (Object[])labels.clone();
        Stream.of(labels).forEach(SwitchBootstraps::verifyLabel);
        MethodHandle target = MethodHandles.insertArguments(DO_TYPE_SWITCH, 2, new Object[]{labels});
        return new ConstantCallSite(target);
    }

    private static void verifyLabel(Object label) {
        if (label == null) {
            throw new IllegalArgumentException("null label found");
        }
        Class<?> labelClass = label.getClass();
        if (labelClass != Class.class && labelClass != String.class && labelClass != Integer.class) {
            throw new IllegalArgumentException("label with illegal type found: " + label.getClass());
        }
    }

    private static int doTypeSwitch(Object target, int startIndex, Object[] labels) {
        if (target == null) {
            return -1;
        }
        Class<?> targetClass = target.getClass();
        for (int i = startIndex; i < labels.length; ++i) {
            Object label = labels[i];
            if (label instanceof Class) {
                Class c = (Class)label;
                if (!c.isAssignableFrom(targetClass)) continue;
                return i;
            }
            if (label instanceof Integer) {
                Integer constant = (Integer)label;
                if (target instanceof Number) {
                    Number input = (Number)target;
                    if (constant.intValue() == input.intValue()) {
                        return i;
                    }
                }
                if (!(target instanceof Character)) continue;
                Character input = (Character)target;
                if (constant.intValue() != input.charValue()) continue;
                return i;
            }
            if (!label.equals(target)) continue;
            return i;
        }
        return labels.length;
    }

    public static CallSite enumSwitch(MethodHandles.Lookup lookup, String invocationName, MethodType invocationType, Object ... labels) {
        if (invocationType.parameterCount() != 2 || !invocationType.returnType().equals(Integer.TYPE) || ((Class)invocationType.parameterType(0)).isPrimitive() || !((Class)invocationType.parameterType(0)).isEnum() || !invocationType.parameterType(1).equals(Integer.TYPE)) {
            throw new IllegalArgumentException("Illegal invocation type " + invocationType);
        }
        Objects.requireNonNull(labels);
        labels = (Object[])labels.clone();
        TypeDescriptor.OfField enumClass = invocationType.parameterType(0);
        labels = Stream.of(labels).map(arg_0 -> SwitchBootstraps.lambda$enumSwitch$0(lookup, (Class)enumClass, arg_0)).toArray();
        MethodHandle target = MethodHandles.insertArguments(DO_ENUM_SWITCH, 2, new Object[]{labels});
        target = target.asType(invocationType);
        return new ConstantCallSite(target);
    }

    private static <E extends Enum<E>> Object convertEnumConstants(MethodHandles.Lookup lookup, Class<?> enumClassTemplate, Object label) {
        if (label == null) {
            throw new IllegalArgumentException("null label found");
        }
        Class<?> labelClass = label.getClass();
        if (labelClass == Class.class) {
            if (label != enumClassTemplate) {
                throw new IllegalArgumentException("the Class label: " + label + ", expected the provided enum class: " + enumClassTemplate);
            }
            return label;
        }
        if (labelClass == String.class) {
            Class<?> enumClass = enumClassTemplate;
            try {
                return ConstantBootstraps.enumConstant(lookup, (String)label, enumClass);
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
        }
        throw new IllegalArgumentException("label with illegal type found: " + labelClass + ", expected label of type either String or Class");
    }

    private static int doEnumSwitch(Enum<?> target, int startIndex, Object[] labels) {
        if (target == null) {
            return -1;
        }
        Class<?> targetClass = target.getClass();
        for (int i = startIndex; i < labels.length; ++i) {
            Class c;
            Object label = labels[i];
            if (!(label instanceof Class ? (c = (Class)label).isAssignableFrom(targetClass) : label == target)) continue;
            return i;
        }
        return labels.length;
    }

    private static /* synthetic */ Object lambda$enumSwitch$0(MethodHandles.Lookup lookup, Class enumClass, Object l) {
        return SwitchBootstraps.convertEnumConstants(lookup, enumClass, l);
    }

    static {
        try {
            DO_TYPE_SWITCH = LOOKUP.findStatic(SwitchBootstraps.class, "doTypeSwitch", MethodType.methodType(Integer.TYPE, Object.class, Integer.TYPE, Object[].class));
            DO_ENUM_SWITCH = LOOKUP.findStatic(SwitchBootstraps.class, "doEnumSwitch", MethodType.methodType(Integer.TYPE, Enum.class, Integer.TYPE, Object[].class));
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

