/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetAddressContainer;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketCleanable;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketInputStream;
import java.net.SocketOption;
import java.net.SocketOutputStream;
import java.net.StandardSocketOptions;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import jdk.internal.loader.BootLoader;
import sun.net.ConnectionResetException;
import sun.net.NetHooks;
import sun.net.PlatformSocketImpl;
import sun.net.ResourceManager;
import sun.net.ext.ExtendedSocketOptions;
import sun.net.util.IPAddressUtil;
import sun.net.util.SocketExceptions;

abstract class AbstractPlainSocketImpl
extends SocketImpl
implements PlatformSocketImpl {
    int timeout;
    private int trafficClass;
    private boolean shut_rd = false;
    private boolean shut_wr = false;
    private SocketInputStream socketInputStream = null;
    private SocketOutputStream socketOutputStream = null;
    protected int fdUseCount = 0;
    protected final Object fdLock = new Object();
    protected boolean closePending = false;
    private volatile boolean connectionReset;
    boolean isBound;
    volatile boolean isConnected;
    protected boolean stream;
    final boolean isServer;
    private static volatile boolean checkedReusePort;
    private static volatile boolean isReusePortAvailable;
    static final ExtendedSocketOptions extendedOptions;
    private static final Set<SocketOption<?>> clientSocketOptions;
    private static final Set<SocketOption<?>> serverSocketOptions;
    public static final int SHUT_RD = 0;
    public static final int SHUT_WR = 1;

    static boolean isReusePortAvailable() {
        if (!checkedReusePort) {
            isReusePortAvailable = AbstractPlainSocketImpl.isReusePortAvailable0();
            checkedReusePort = true;
        }
        return isReusePortAvailable;
    }

    AbstractPlainSocketImpl(boolean isServer) {
        this.isServer = isServer;
    }

    @Override
    protected synchronized void create(boolean stream) throws IOException {
        this.stream = stream;
        if (!stream) {
            ResourceManager.beforeUdpCreate();
            this.fd = new FileDescriptor();
            try {
                this.socketCreate(false);
                SocketCleanable.register(this.fd, false);
            }
            catch (IOException ioe) {
                ResourceManager.afterUdpClose();
                this.fd = null;
                throw ioe;
            }
        } else {
            this.fd = new FileDescriptor();
            this.socketCreate(true);
            SocketCleanable.register(this.fd, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void connect(String host, int port) throws UnknownHostException, IOException {
        boolean connected = false;
        try {
            InetAddress address;
            this.address = address = InetAddress.getByName(host);
            this.port = port;
            if (address.isLinkLocalAddress()) {
                address = IPAddressUtil.toScopedAddress(address);
            }
            this.connectToAddress(address, port, this.timeout);
            connected = true;
        }
        finally {
            if (!connected) {
                try {
                    this.close();
                }
                catch (IOException iOException) {}
            }
            this.isConnected = connected;
        }
    }

    @Override
    protected void connect(InetAddress address, int port) throws IOException {
        this.address = address;
        this.port = port;
        if (address.isLinkLocalAddress()) {
            address = IPAddressUtil.toScopedAddress(address);
        }
        try {
            this.connectToAddress(address, port, this.timeout);
            this.isConnected = true;
            return;
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void connect(SocketAddress address, int timeout) throws IOException {
        boolean connected = false;
        try {
            InetAddress ia;
            if (!(address instanceof InetSocketAddress)) {
                throw new IllegalArgumentException("unsupported address type");
            }
            InetSocketAddress addr = (InetSocketAddress)address;
            if (addr.isUnresolved()) {
                throw new UnknownHostException(addr.getHostName());
            }
            this.address = ia = addr.getAddress();
            this.port = addr.getPort();
            if (ia.isLinkLocalAddress()) {
                ia = IPAddressUtil.toScopedAddress(ia);
            }
            this.connectToAddress(ia, this.port, timeout);
            connected = true;
        }
        finally {
            if (!connected) {
                try {
                    this.close();
                }
                catch (IOException iOException) {}
            }
            this.isConnected = connected;
        }
    }

    private void connectToAddress(InetAddress address, int port, int timeout) throws IOException {
        if (address.isAnyLocalAddress()) {
            this.doConnect(InetAddress.getLocalHost(), port, timeout);
        } else {
            this.doConnect(address, port, timeout);
        }
    }

    @Override
    public void setOption(int opt, Object val) throws SocketException {
        if (this.isClosedOrPending()) {
            throw new SocketException("Socket Closed");
        }
        boolean on = true;
        switch (opt) {
            case 128: {
                if (!(val instanceof Integer) && !(val instanceof Boolean)) {
                    throw new SocketException("Bad parameter for option");
                }
                if (!(val instanceof Boolean)) break;
                on = false;
                break;
            }
            case 4102: {
                if (!(val instanceof Integer)) {
                    throw new SocketException("Bad parameter for SO_TIMEOUT");
                }
                int tmp = (Integer)val;
                if (tmp < 0) {
                    throw new IllegalArgumentException("timeout < 0");
                }
                this.timeout = tmp;
                break;
            }
            case 3: {
                if (!(val instanceof Integer)) {
                    throw new SocketException("bad argument for IP_TOS");
                }
                this.trafficClass = (Integer)val;
                break;
            }
            case 15: {
                throw new SocketException("Cannot re-bind socket");
            }
            case 1: {
                if (!(val instanceof Boolean)) {
                    throw new SocketException("bad parameter for TCP_NODELAY");
                }
                on = (Boolean)val;
                break;
            }
            case 4097: 
            case 4098: {
                if (val instanceof Integer && (Integer)val > 0) break;
                throw new SocketException("bad parameter for SO_SNDBUF or SO_RCVBUF");
            }
            case 8: {
                if (!(val instanceof Boolean)) {
                    throw new SocketException("bad parameter for SO_KEEPALIVE");
                }
                on = (Boolean)val;
                break;
            }
            case 4099: {
                if (!(val instanceof Boolean)) {
                    throw new SocketException("bad parameter for SO_OOBINLINE");
                }
                on = (Boolean)val;
                break;
            }
            case 4: {
                if (!(val instanceof Boolean)) {
                    throw new SocketException("bad parameter for SO_REUSEADDR");
                }
                on = (Boolean)val;
                break;
            }
            case 14: {
                if (!(val instanceof Boolean)) {
                    throw new SocketException("bad parameter for SO_REUSEPORT");
                }
                if (!this.supportedOptions().contains(StandardSocketOptions.SO_REUSEPORT)) {
                    throw new UnsupportedOperationException("unsupported option");
                }
                on = (Boolean)val;
                break;
            }
            default: {
                throw new SocketException("unrecognized TCP option: " + opt);
            }
        }
        this.socketSetOption(opt, on, val);
    }

    @Override
    public Object getOption(int opt) throws SocketException {
        if (this.isClosedOrPending()) {
            throw new SocketException("Socket Closed");
        }
        if (opt == 4102) {
            return this.timeout;
        }
        int ret = 0;
        switch (opt) {
            case 1: {
                ret = this.socketGetOption(opt, null);
                return ret != -1;
            }
            case 4099: {
                ret = this.socketGetOption(opt, null);
                return ret != -1;
            }
            case 128: {
                ret = this.socketGetOption(opt, null);
                return ret == -1 ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)Integer.valueOf(ret);
            }
            case 4: {
                ret = this.socketGetOption(opt, null);
                return ret != -1;
            }
            case 15: {
                InetAddressContainer in = new InetAddressContainer();
                ret = this.socketGetOption(opt, in);
                return in.addr;
            }
            case 4097: 
            case 4098: {
                ret = this.socketGetOption(opt, null);
                return ret;
            }
            case 3: {
                try {
                    ret = this.socketGetOption(opt, null);
                    if (ret == -1) {
                        return this.trafficClass;
                    }
                    return ret;
                }
                catch (SocketException se) {
                    return this.trafficClass;
                }
            }
            case 8: {
                ret = this.socketGetOption(opt, null);
                return ret != -1;
            }
            case 14: {
                if (!this.supportedOptions().contains(StandardSocketOptions.SO_REUSEPORT)) {
                    throw new UnsupportedOperationException("unsupported option");
                }
                ret = this.socketGetOption(opt, null);
                return ret != -1;
            }
        }
        return null;
    }

    private static Set<SocketOption<?>> clientSocketOptions() {
        HashSet options = new HashSet();
        options.add(StandardSocketOptions.SO_KEEPALIVE);
        options.add(StandardSocketOptions.SO_SNDBUF);
        options.add(StandardSocketOptions.SO_RCVBUF);
        options.add(StandardSocketOptions.SO_REUSEADDR);
        options.add(StandardSocketOptions.SO_LINGER);
        options.add(StandardSocketOptions.IP_TOS);
        options.add(StandardSocketOptions.TCP_NODELAY);
        if (AbstractPlainSocketImpl.isReusePortAvailable()) {
            options.add(StandardSocketOptions.SO_REUSEPORT);
        }
        options.addAll(ExtendedSocketOptions.clientSocketOptions());
        return Collections.unmodifiableSet(options);
    }

    private static Set<SocketOption<?>> serverSocketOptions() {
        HashSet options = new HashSet();
        options.add(StandardSocketOptions.SO_RCVBUF);
        options.add(StandardSocketOptions.SO_REUSEADDR);
        options.add(StandardSocketOptions.IP_TOS);
        if (AbstractPlainSocketImpl.isReusePortAvailable()) {
            options.add(StandardSocketOptions.SO_REUSEPORT);
        }
        options.addAll(ExtendedSocketOptions.serverSocketOptions());
        return Collections.unmodifiableSet(options);
    }

    @Override
    protected Set<SocketOption<?>> supportedOptions() {
        if (this.isServer) {
            return serverSocketOptions;
        }
        return clientSocketOptions;
    }

    @Override
    protected <T> void setOption(SocketOption<T> name, T value) throws IOException {
        Objects.requireNonNull(name);
        if (!this.supportedOptions().contains(name)) {
            throw new UnsupportedOperationException("'" + name + "' not supported");
        }
        if (!name.type().isInstance(value)) {
            throw new IllegalArgumentException("Invalid value '" + value + "'");
        }
        if (this.isClosedOrPending()) {
            throw new SocketException("Socket closed");
        }
        if (name == StandardSocketOptions.SO_KEEPALIVE) {
            this.setOption(8, value);
        } else if (name == StandardSocketOptions.SO_SNDBUF) {
            if ((Integer)value < 0) {
                throw new IllegalArgumentException("Invalid send buffer size:" + value);
            }
            this.setOption(4097, value);
        } else if (name == StandardSocketOptions.SO_RCVBUF) {
            if ((Integer)value < 0) {
                throw new IllegalArgumentException("Invalid recv buffer size:" + value);
            }
            this.setOption(4098, value);
        } else if (name == StandardSocketOptions.SO_REUSEADDR) {
            this.setOption(4, value);
        } else if (name == StandardSocketOptions.SO_REUSEPORT) {
            this.setOption(14, value);
        } else if (name == StandardSocketOptions.SO_LINGER) {
            if ((Integer)value < 0) {
                this.setOption(128, (Object)false);
            } else {
                this.setOption(128, value);
            }
        } else if (name == StandardSocketOptions.IP_TOS) {
            int i = (Integer)value;
            if (i < 0 || i > 255) {
                throw new IllegalArgumentException("Invalid IP_TOS value: " + value);
            }
            this.setOption(3, value);
        } else if (name == StandardSocketOptions.TCP_NODELAY) {
            this.setOption(1, value);
        } else if (extendedOptions.isOptionSupported(name)) {
            extendedOptions.setOption(this.fd, name, value);
        } else {
            throw new AssertionError((Object)("unknown option: " + name));
        }
    }

    @Override
    protected <T> T getOption(SocketOption<T> name) throws IOException {
        Objects.requireNonNull(name);
        if (!this.supportedOptions().contains(name)) {
            throw new UnsupportedOperationException("'" + name + "' not supported");
        }
        if (this.isClosedOrPending()) {
            throw new SocketException("Socket closed");
        }
        if (name == StandardSocketOptions.SO_KEEPALIVE) {
            return (T)this.getOption(8);
        }
        if (name == StandardSocketOptions.SO_SNDBUF) {
            return (T)this.getOption(4097);
        }
        if (name == StandardSocketOptions.SO_RCVBUF) {
            return (T)this.getOption(4098);
        }
        if (name == StandardSocketOptions.SO_REUSEADDR) {
            return (T)this.getOption(4);
        }
        if (name == StandardSocketOptions.SO_REUSEPORT) {
            return (T)this.getOption(14);
        }
        if (name == StandardSocketOptions.SO_LINGER) {
            Object value = this.getOption(128);
            if (value instanceof Boolean) {
                assert (!((Boolean)value).booleanValue());
                value = -1;
            }
            return (T)value;
        }
        if (name == StandardSocketOptions.IP_TOS) {
            return (T)this.getOption(3);
        }
        if (name == StandardSocketOptions.TCP_NODELAY) {
            return (T)this.getOption(1);
        }
        if (extendedOptions.isOptionSupported(name)) {
            return (T)extendedOptions.getOption(this.fd, name);
        }
        throw new AssertionError((Object)("unknown option: " + name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void doConnect(InetAddress address, int port, int timeout) throws IOException {
        Object object2 = this.fdLock;
        synchronized (object2) {
            if (!this.closePending && !this.isBound) {
                NetHooks.beforeTcpConnect(this.fd, address, port);
            }
        }
        try {
            this.acquireFD();
            try {
                this.socketConnect(address, port, timeout);
                object2 = this.fdLock;
                synchronized (object2) {
                    if (this.closePending) {
                        throw new SocketException("Socket closed");
                    }
                }
            }
            finally {
                this.releaseFD();
            }
        }
        catch (IOException e) {
            this.close();
            throw SocketExceptions.of(e, new InetSocketAddress(address, port));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void bind(InetAddress address, int lport) throws IOException {
        Object object2 = this.fdLock;
        synchronized (object2) {
            if (!this.closePending && !this.isBound) {
                NetHooks.beforeTcpBind(this.fd, address, lport);
            }
        }
        if (address.isLinkLocalAddress()) {
            address = IPAddressUtil.toScopedAddress(address);
        }
        this.socketBind(address, lport);
        this.isBound = true;
    }

    @Override
    protected synchronized void listen(int count) throws IOException {
        this.socketListen(count);
    }

    @Override
    protected void accept(SocketImpl si) throws IOException {
        si.fd = new FileDescriptor();
        this.acquireFD();
        try {
            this.socketAccept(si);
        }
        finally {
            this.releaseFD();
        }
        SocketCleanable.register(si.fd, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized InputStream getInputStream() throws IOException {
        Object object2 = this.fdLock;
        synchronized (object2) {
            if (this.isClosedOrPending()) {
                throw new IOException("Socket Closed");
            }
            if (this.shut_rd) {
                throw new IOException("Socket input is shutdown");
            }
            if (this.socketInputStream == null) {
                PrivilegedExceptionAction<SocketInputStream> pa = () -> new SocketInputStream(this);
                try {
                    this.socketInputStream = AccessController.doPrivileged(pa);
                }
                catch (PrivilegedActionException e) {
                    throw (IOException)e.getCause();
                }
            }
        }
        return this.socketInputStream;
    }

    void setInputStream(SocketInputStream in) {
        this.socketInputStream = in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized OutputStream getOutputStream() throws IOException {
        Object object2 = this.fdLock;
        synchronized (object2) {
            if (this.isClosedOrPending()) {
                throw new IOException("Socket Closed");
            }
            if (this.shut_wr) {
                throw new IOException("Socket output is shutdown");
            }
            if (this.socketOutputStream == null) {
                PrivilegedExceptionAction<SocketOutputStream> pa = () -> new SocketOutputStream(this);
                try {
                    this.socketOutputStream = AccessController.doPrivileged(pa);
                }
                catch (PrivilegedActionException e) {
                    throw (IOException)e.getCause();
                }
            }
        }
        return this.socketOutputStream;
    }

    void setFileDescriptor(FileDescriptor fd) {
        this.fd = fd;
    }

    void setAddress(InetAddress address) {
        this.address = address;
    }

    void setPort(int port) {
        this.port = port;
    }

    void setLocalPort(int localport) {
        this.localport = localport;
    }

    @Override
    protected synchronized int available() throws IOException {
        if (this.isClosedOrPending()) {
            throw new IOException("Stream closed.");
        }
        if (this.isConnectionReset() || this.shut_rd) {
            return 0;
        }
        int n = 0;
        try {
            n = this.socketAvailable();
        }
        catch (ConnectionResetException exc1) {
            this.setConnectionReset();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void close() throws IOException {
        Object object2 = this.fdLock;
        synchronized (object2) {
            if (this.fd != null) {
                if (this.fdUseCount == 0) {
                    if (this.closePending) {
                        return;
                    }
                    this.closePending = true;
                    try {
                        this.socketPreClose();
                    }
                    finally {
                        this.socketClose();
                    }
                    this.fd = null;
                    return;
                }
                if (!this.closePending) {
                    this.closePending = true;
                    --this.fdUseCount;
                    this.socketPreClose();
                }
            }
        }
    }

    @Override
    void reset() {
        throw new InternalError("should not get here");
    }

    @Override
    protected void shutdownInput() throws IOException {
        if (this.fd != null) {
            this.socketShutdown(0);
            if (this.socketInputStream != null) {
                this.socketInputStream.setEOF(true);
            }
            this.shut_rd = true;
        }
    }

    @Override
    protected void shutdownOutput() throws IOException {
        if (this.fd != null) {
            this.socketShutdown(1);
            this.shut_wr = true;
        }
    }

    @Override
    protected boolean supportsUrgentData() {
        return true;
    }

    @Override
    protected void sendUrgentData(int data) throws IOException {
        if (this.fd == null) {
            throw new IOException("Socket Closed");
        }
        this.socketSendUrgentData(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileDescriptor acquireFD() {
        Object object2 = this.fdLock;
        synchronized (object2) {
            ++this.fdUseCount;
            return this.fd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseFD() {
        Object object2 = this.fdLock;
        synchronized (object2) {
            --this.fdUseCount;
            if (this.fdUseCount == -1 && this.fd != null) {
                try {
                    this.socketClose();
                }
                catch (IOException iOException) {
                }
                finally {
                    this.fd = null;
                }
            }
        }
    }

    boolean isConnectionReset() {
        return this.connectionReset;
    }

    void setConnectionReset() {
        this.connectionReset = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosedOrPending() {
        Object object2 = this.fdLock;
        synchronized (object2) {
            return this.closePending || this.fd == null;
            {
            }
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    private void socketPreClose() throws IOException {
        this.socketClose0(true);
    }

    protected void socketClose() throws IOException {
        SocketCleanable.unregister(this.fd);
        try {
            this.socketClose0(false);
        }
        finally {
            if (!this.stream) {
                ResourceManager.afterUdpClose();
            }
        }
    }

    abstract void socketCreate(boolean var1) throws IOException;

    abstract void socketConnect(InetAddress var1, int var2, int var3) throws IOException;

    abstract void socketBind(InetAddress var1, int var2) throws IOException;

    abstract void socketListen(int var1) throws IOException;

    abstract void socketAccept(SocketImpl var1) throws IOException;

    abstract int socketAvailable() throws IOException;

    abstract void socketClose0(boolean var1) throws IOException;

    abstract void socketShutdown(int var1) throws IOException;

    abstract void socketSetOption(int var1, boolean var2, Object var3) throws SocketException;

    abstract int socketGetOption(int var1, Object var2) throws SocketException;

    abstract void socketSendUrgentData(int var1) throws IOException;

    private static native boolean isReusePortAvailable0();

    static {
        BootLoader.loadLibrary("net");
        extendedOptions = ExtendedSocketOptions.getInstance();
        clientSocketOptions = AbstractPlainSocketImpl.clientSocketOptions();
        serverSocketOptions = AbstractPlainSocketImpl.serverSocketOptions();
    }
}

