/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookiePolicy;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.InMemoryCookieStore;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import sun.util.logging.PlatformLogger;

public class CookieManager
extends CookieHandler {
    private CookiePolicy policyCallback;
    private CookieStore cookieJar = null;

    public CookieManager() {
        this(null, null);
    }

    public CookieManager(CookieStore store, CookiePolicy cookiePolicy) {
        this.policyCallback = cookiePolicy == null ? CookiePolicy.ACCEPT_ORIGINAL_SERVER : cookiePolicy;
        this.cookieJar = store == null ? new InMemoryCookieStore() : store;
    }

    public void setCookiePolicy(CookiePolicy cookiePolicy) {
        if (cookiePolicy != null) {
            this.policyCallback = cookiePolicy;
        }
    }

    public CookieStore getCookieStore() {
        return this.cookieJar;
    }

    @Override
    public Map<String, List<String>> get(URI uri, Map<String, List<String>> requestHeaders) throws IOException {
        if (uri == null || requestHeaders == null) {
            throw new IllegalArgumentException("Argument is null");
        }
        if (this.cookieJar == null) {
            return Map.of();
        }
        boolean secureLink = "https".equalsIgnoreCase(uri.getScheme());
        ArrayList<HttpCookie> cookies = new ArrayList<HttpCookie>();
        String path = uri.getPath();
        if (path == null || path.isEmpty()) {
            path = "/";
        }
        for (HttpCookie cookie : this.cookieJar.get(uri)) {
            String s;
            if (!this.pathMatches(path, cookie.getPath()) || !secureLink && cookie.getSecure() || cookie.isHttpOnly() && !"http".equalsIgnoreCase(s = uri.getScheme()) && !"https".equalsIgnoreCase(s)) continue;
            String ports = cookie.getPortlist();
            if (ports != null && !ports.isEmpty()) {
                int port = uri.getPort();
                if (port == -1) {
                    int n = port = "https".equals(uri.getScheme()) ? 443 : 80;
                }
                if (!CookieManager.isInPortList(ports, port)) continue;
                cookies.add(cookie);
                continue;
            }
            cookies.add(cookie);
        }
        List<String> cookieHeader = CookieManager.sortByPathAndAge(cookies);
        return Map.of("Cookie", cookieHeader);
    }

    @Override
    public void put(URI uri, Map<String, List<String>> responseHeaders) throws IOException {
        if (uri == null || responseHeaders == null) {
            throw new IllegalArgumentException("Argument is null");
        }
        if (this.cookieJar == null) {
            return;
        }
        PlatformLogger logger = PlatformLogger.getLogger("java.net.CookieManager");
        for (String headerKey : responseHeaders.keySet()) {
            if (headerKey == null || !headerKey.equalsIgnoreCase("Set-Cookie2") && !headerKey.equalsIgnoreCase("Set-Cookie")) continue;
            for (String headerValue : responseHeaders.get(headerKey)) {
                try {
                    List<HttpCookie> cookies;
                    block16: {
                        try {
                            cookies = HttpCookie.parse(headerValue);
                        }
                        catch (IllegalArgumentException e) {
                            cookies = Collections.emptyList();
                            if (!logger.isLoggable(PlatformLogger.Level.SEVERE)) break block16;
                            logger.severe("Invalid cookie for " + uri + ": " + headerValue);
                        }
                    }
                    for (HttpCookie cookie : cookies) {
                        String ports;
                        if (cookie.getPath() == null) {
                            String path = uri.getPath();
                            if (!path.endsWith("/")) {
                                int i = path.lastIndexOf(47);
                                path = i > 0 ? path.substring(0, i + 1) : "/";
                            }
                            cookie.setPath(path);
                        }
                        if (cookie.getDomain() == null) {
                            String host = uri.getHost();
                            if (host != null && !host.contains(".")) {
                                host = host + ".local";
                            }
                            cookie.setDomain(host);
                        }
                        if ((ports = cookie.getPortlist()) != null) {
                            int port = uri.getPort();
                            if (port == -1) {
                                int n = port = "https".equals(uri.getScheme()) ? 443 : 80;
                            }
                            if (ports.isEmpty()) {
                                cookie.setPortlist("" + port);
                                if (!this.shouldAcceptInternal(uri, cookie)) continue;
                                this.cookieJar.add(uri, cookie);
                                continue;
                            }
                            if (!CookieManager.isInPortList(ports, port) || !this.shouldAcceptInternal(uri, cookie)) continue;
                            this.cookieJar.add(uri, cookie);
                            continue;
                        }
                        if (!this.shouldAcceptInternal(uri, cookie)) continue;
                        this.cookieJar.add(uri, cookie);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
        }
    }

    private boolean shouldAcceptInternal(URI uri, HttpCookie cookie) {
        try {
            return this.policyCallback.shouldAccept(uri, cookie);
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private static boolean isInPortList(String lst, int port) {
        int i = lst.indexOf(44);
        int val = -1;
        while (i > 0) {
            try {
                val = Integer.parseInt(lst, 0, i, 10);
                if (val == port) {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            lst = lst.substring(i + 1);
            i = lst.indexOf(44);
        }
        if (!lst.isEmpty()) {
            try {
                val = Integer.parseInt(lst);
                if (val == port) {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean pathMatches(String path, String pathToMatchWith) {
        if (path == pathToMatchWith) {
            return true;
        }
        if (path == null || pathToMatchWith == null) {
            return false;
        }
        return path.startsWith(pathToMatchWith);
    }

    static List<String> sortByPathAndAge(List<HttpCookie> cookies) {
        Collections.sort(cookies, new CookieComparator());
        ArrayList<String> cookieHeader = new ArrayList<String>();
        for (HttpCookie cookie : cookies) {
            if (cookies.indexOf(cookie) == 0 && cookie.getVersion() > 0) {
                cookieHeader.add("$Version=\"1\"");
            }
            cookieHeader.add(cookie.toString());
        }
        return cookieHeader;
    }

    static class CookieComparator
    implements Comparator<HttpCookie> {
        CookieComparator() {
        }

        @Override
        public int compare(HttpCookie c1, HttpCookie c2) {
            long creation2;
            int len2;
            if (c1 == c2) {
                return 0;
            }
            if (c1 == null) {
                return -1;
            }
            if (c2 == null) {
                return 1;
            }
            String p1 = c1.getPath();
            String p2 = c2.getPath();
            p1 = p1 == null ? "" : p1;
            p2 = p2 == null ? "" : p2;
            int len1 = p1.length();
            if (len1 > (len2 = p2.length())) {
                return -1;
            }
            if (len2 > len1) {
                return 1;
            }
            long creation1 = c1.getCreationTime();
            if (creation1 < (creation2 = c2.getCreationTime())) {
                return -1;
            }
            if (creation1 > creation2) {
                return 1;
            }
            return 0;
        }
    }
}

