/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.Closeable;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocketImpl;
import java.net.DatagramSocketImplFactory;
import java.net.DefaultDatagramSocketImplFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetMulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.nio.channels.DatagramChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import sun.net.NetProperties;
import sun.nio.ch.DatagramSocketAdaptor;
import sun.nio.ch.DefaultSelectorProvider;

public class DatagramSocket
implements Closeable {
    private final DatagramSocket delegate;
    private static volatile DatagramSocketImplFactory factory;
    private static final SocketAddress NO_DELEGATE;
    private static final boolean USE_PLAINDATAGRAMSOCKET;

    DatagramSocket delegate() {
        if (this.delegate == null) {
            throw new InternalError("Should not get here");
        }
        return this.delegate;
    }

    DatagramSocket(DatagramSocket delegate) {
        assert (delegate == null || delegate instanceof NetMulticastSocket || delegate instanceof DatagramSocketAdaptor);
        this.delegate = delegate;
    }

    public DatagramSocket() throws SocketException {
        this(new InetSocketAddress(0));
    }

    protected DatagramSocket(DatagramSocketImpl impl) {
        this(new NetMulticastSocket(impl));
    }

    public DatagramSocket(SocketAddress bindaddr) throws SocketException {
        this(DatagramSocket.createDelegate(bindaddr, DatagramSocket.class));
    }

    public DatagramSocket(int port) throws SocketException {
        this(port, null);
    }

    public DatagramSocket(int port, InetAddress laddr) throws SocketException {
        this(new InetSocketAddress(laddr, port));
    }

    public void bind(SocketAddress addr) throws SocketException {
        this.delegate().bind(addr);
    }

    public void connect(InetAddress address, int port) {
        this.delegate().connect(address, port);
    }

    public void connect(SocketAddress addr) throws SocketException {
        this.delegate().connect(addr);
    }

    public void disconnect() {
        this.delegate().disconnect();
    }

    public boolean isBound() {
        return this.delegate().isBound();
    }

    public boolean isConnected() {
        return this.delegate().isConnected();
    }

    public InetAddress getInetAddress() {
        return this.delegate().getInetAddress();
    }

    public int getPort() {
        return this.delegate().getPort();
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.delegate().getRemoteSocketAddress();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.delegate().getLocalSocketAddress();
    }

    public void send(DatagramPacket p) throws IOException {
        this.delegate().send(p);
    }

    public void receive(DatagramPacket p) throws IOException {
        this.delegate().receive(p);
    }

    public InetAddress getLocalAddress() {
        return this.delegate().getLocalAddress();
    }

    public int getLocalPort() {
        return this.delegate().getLocalPort();
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this.delegate().setSoTimeout(timeout);
    }

    public int getSoTimeout() throws SocketException {
        return this.delegate().getSoTimeout();
    }

    public void setSendBufferSize(int size) throws SocketException {
        this.delegate().setSendBufferSize(size);
    }

    public int getSendBufferSize() throws SocketException {
        return this.delegate().getSendBufferSize();
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        this.delegate().setReceiveBufferSize(size);
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.delegate().getReceiveBufferSize();
    }

    public void setReuseAddress(boolean on) throws SocketException {
        this.delegate().setReuseAddress(on);
    }

    public boolean getReuseAddress() throws SocketException {
        return this.delegate().getReuseAddress();
    }

    public void setBroadcast(boolean on) throws SocketException {
        this.delegate().setBroadcast(on);
    }

    public boolean getBroadcast() throws SocketException {
        return this.delegate().getBroadcast();
    }

    public void setTrafficClass(int tc) throws SocketException {
        this.delegate().setTrafficClass(tc);
    }

    public int getTrafficClass() throws SocketException {
        return this.delegate().getTrafficClass();
    }

    @Override
    public void close() {
        this.delegate().close();
    }

    public boolean isClosed() {
        return this.delegate().isClosed();
    }

    public DatagramChannel getChannel() {
        return null;
    }

    @Deprecated(since="17")
    public static synchronized void setDatagramSocketImplFactory(DatagramSocketImplFactory fac) throws IOException {
        if (factory != null) {
            throw new SocketException("factory already defined");
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkSetFactory();
        }
        factory = fac;
    }

    public <T> DatagramSocket setOption(SocketOption<T> name, T value) throws IOException {
        this.delegate().setOption(name, value);
        return this;
    }

    public <T> T getOption(SocketOption<T> name) throws IOException {
        return this.delegate().getOption(name);
    }

    public Set<SocketOption<?>> supportedOptions() {
        return this.delegate().supportedOptions();
    }

    public void joinGroup(SocketAddress mcastaddr, NetworkInterface netIf) throws IOException {
        this.delegate().joinGroup(mcastaddr, netIf);
    }

    public void leaveGroup(SocketAddress mcastaddr, NetworkInterface netIf) throws IOException {
        this.delegate().leaveGroup(mcastaddr, netIf);
    }

    private static boolean usePlainDatagramSocketImpl() {
        PrivilegedAction<String> pa = () -> NetProperties.get("jdk.net.usePlainDatagramSocketImpl");
        String s = AccessController.doPrivileged(pa);
        return s != null && (s.isEmpty() || s.equalsIgnoreCase("true"));
    }

    private static SocketException toSocketException(IOException e) {
        if (e instanceof SocketException) {
            return (SocketException)e;
        }
        Throwable cause = e.getCause();
        if (cause instanceof SocketException) {
            return (SocketException)cause;
        }
        SocketException se = new SocketException(e.getMessage());
        se.initCause(e);
        return se;
    }

    static <T extends DatagramSocket> T createDelegate(SocketAddress bindaddr, Class<T> type) throws SocketException {
        if (bindaddr == NO_DELEGATE) {
            return null;
        }
        assert (type == DatagramSocket.class || type == MulticastSocket.class);
        boolean multicast = type == MulticastSocket.class;
        DatagramSocket delegate = null;
        boolean initialized = false;
        try {
            DatagramSocketImplFactory factory = DatagramSocket.factory;
            if (USE_PLAINDATAGRAMSOCKET || factory != null) {
                DatagramSocketImpl impl = factory != null ? factory.createDatagramSocketImpl() : DefaultDatagramSocketImplFactory.createDatagramSocketImpl(multicast);
                delegate = new NetMulticastSocket(impl);
                ((NetMulticastSocket)delegate).getImpl();
            } else {
                delegate = DefaultSelectorProvider.get().openUninterruptibleDatagramChannel().socket();
            }
            if (multicast) {
                delegate.setReuseAddress(true);
            }
            if (bindaddr != null) {
                delegate.bind(bindaddr);
            }
            try {
                delegate.setBroadcast(true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            initialized = true;
        }
        catch (IOException ioe) {
            throw DatagramSocket.toSocketException(ioe);
        }
        finally {
            if (!initialized && delegate != null) {
                delegate.close();
            }
        }
        DatagramSocket result = delegate;
        return (T)result;
    }

    static {
        NO_DELEGATE = new SocketAddress(){};
        USE_PLAINDATAGRAMSOCKET = DatagramSocket.usePlainDatagramSocketImpl();
    }
}

