/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.SocketOptions;
import java.util.Objects;
import java.util.Set;

public abstract class DatagramSocketImpl
implements SocketOptions {
    protected int localPort;
    protected FileDescriptor fd;

    int dataAvailable() {
        return 0;
    }

    protected abstract void create() throws SocketException;

    protected abstract void bind(int var1, InetAddress var2) throws SocketException;

    protected abstract void send(DatagramPacket var1) throws IOException;

    protected void connect(InetAddress address, int port) throws SocketException {
    }

    protected void disconnect() {
    }

    protected abstract int peek(InetAddress var1) throws IOException;

    protected abstract int peekData(DatagramPacket var1) throws IOException;

    protected abstract void receive(DatagramPacket var1) throws IOException;

    @Deprecated
    protected abstract void setTTL(byte var1) throws IOException;

    @Deprecated
    protected abstract byte getTTL() throws IOException;

    protected abstract void setTimeToLive(int var1) throws IOException;

    protected abstract int getTimeToLive() throws IOException;

    protected abstract void join(InetAddress var1) throws IOException;

    protected abstract void leave(InetAddress var1) throws IOException;

    protected abstract void joinGroup(SocketAddress var1, NetworkInterface var2) throws IOException;

    protected abstract void leaveGroup(SocketAddress var1, NetworkInterface var2) throws IOException;

    protected abstract void close();

    protected int getLocalPort() {
        return this.localPort;
    }

    protected FileDescriptor getFileDescriptor() {
        return this.fd;
    }

    protected <T> void setOption(SocketOption<T> name, T value) throws IOException {
        Objects.requireNonNull(name);
        throw new UnsupportedOperationException("'" + name + "' not supported");
    }

    protected <T> T getOption(SocketOption<T> name) throws IOException {
        Objects.requireNonNull(name);
        throw new UnsupportedOperationException("'" + name + "' not supported");
    }

    protected Set<SocketOption<?>> supportedOptions() {
        return Set.of();
    }
}

