/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.DatagramSocketImpl;
import java.net.SocketException;
import java.net.TwoStacksPlainDatagramSocketImpl;
import java.util.Properties;
import sun.security.action.GetPropertyAction;

class DefaultDatagramSocketImplFactory {
    private static final Class<?> prefixImplClass;
    private static final boolean preferIPv4Stack;
    private static final boolean exclusiveBind;

    DefaultDatagramSocketImplFactory() {
    }

    static DatagramSocketImpl createDatagramSocketImpl(boolean isMulticast) throws SocketException {
        if (prefixImplClass != null) {
            try {
                Object result = prefixImplClass.newInstance();
                return (DatagramSocketImpl)result;
            }
            catch (Exception e) {
                throw new SocketException("can't instantiate DatagramSocketImpl");
            }
        }
        return new TwoStacksPlainDatagramSocketImpl(exclusiveBind && !isMulticast, isMulticast);
    }

    static {
        Class<?> prefixImplClassLocal = null;
        Properties props = GetPropertyAction.privilegedGetProperties();
        preferIPv4Stack = Boolean.parseBoolean(props.getProperty("java.net.preferIPv4Stack"));
        String exclBindProp = props.getProperty("sun.net.useExclusiveBind", "");
        exclusiveBind = exclBindProp.isEmpty() ? true : Boolean.parseBoolean(exclBindProp);
        String prefix = null;
        try {
            prefix = props.getProperty("impl.prefix");
            if (prefix != null) {
                prefixImplClassLocal = Class.forName("java.net." + prefix + "DatagramSocketImpl");
            }
        }
        catch (Exception e) {
            System.err.println("Can't find class: java.net." + prefix + "DatagramSocketImpl: check impl.prefix property");
        }
        prefixImplClass = prefixImplClassLocal;
    }
}

