/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.lang.constant.Constable;
import java.net.AbstractPlainDatagramSocketImpl;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import jdk.internal.access.JavaIOFileDescriptorAccess;
import jdk.internal.access.SharedSecrets;
import sun.net.ext.ExtendedSocketOptions;

class DualStackPlainDatagramSocketImpl
extends AbstractPlainDatagramSocketImpl {
    static JavaIOFileDescriptorAccess fdAccess = SharedSecrets.getJavaIOFileDescriptorAccess();
    private final boolean exclusiveBind;
    private boolean reuseAddressEmulated;
    private boolean isReuseAddress;

    DualStackPlainDatagramSocketImpl(boolean exclBind) {
        super(false);
        this.exclusiveBind = exclBind;
    }

    @Override
    protected void datagramSocketCreate() throws SocketException {
        if (this.fd == null) {
            throw new SocketException("Socket closed");
        }
        int newfd = DualStackPlainDatagramSocketImpl.socketCreate();
        fdAccess.set(this.fd, newfd);
    }

    @Override
    protected synchronized void bind0(int lport, InetAddress laddr) throws SocketException {
        int nativefd = this.checkAndReturnNativeFD();
        if (laddr == null) {
            throw new NullPointerException("argument address");
        }
        DualStackPlainDatagramSocketImpl.socketBind(nativefd, laddr, lport, this.exclusiveBind);
        this.localPort = lport == 0 ? DualStackPlainDatagramSocketImpl.socketLocalPort(nativefd) : lport;
    }

    @Override
    protected synchronized int peek(InetAddress address) throws IOException {
        int nativefd = this.checkAndReturnNativeFD();
        if (address == null) {
            throw new NullPointerException("Null address in peek()");
        }
        DatagramPacket peekPacket = new DatagramPacket(new byte[1], 1);
        int peekPort = this.peekData(peekPacket);
        address = peekPacket.getAddress();
        return peekPort;
    }

    @Override
    protected synchronized int peekData(DatagramPacket p) throws IOException {
        int nativefd = this.checkAndReturnNativeFD();
        if (p == null) {
            throw new NullPointerException("packet");
        }
        if (p.getData() == null) {
            throw new NullPointerException("packet buffer");
        }
        return DualStackPlainDatagramSocketImpl.socketReceiveOrPeekData(nativefd, p, this.timeout, this.connected, true);
    }

    @Override
    protected synchronized void receive0(DatagramPacket p) throws IOException {
        int nativefd = this.checkAndReturnNativeFD();
        if (p == null) {
            throw new NullPointerException("packet");
        }
        if (p.getData() == null) {
            throw new NullPointerException("packet buffer");
        }
        DualStackPlainDatagramSocketImpl.socketReceiveOrPeekData(nativefd, p, this.timeout, this.connected, false);
    }

    @Override
    protected void send0(DatagramPacket p) throws IOException {
        int nativefd = this.checkAndReturnNativeFD();
        if (p == null) {
            throw new NullPointerException("null packet");
        }
        if (p.getAddress() == null || p.getData() == null) {
            throw new NullPointerException("null address || null buffer");
        }
        DualStackPlainDatagramSocketImpl.socketSend(nativefd, p.getData(), p.getOffset(), p.getLength(), p.getAddress(), p.getPort(), this.connected);
    }

    @Override
    protected void connect0(InetAddress address, int port) throws SocketException {
        int nativefd = this.checkAndReturnNativeFD();
        if (address == null) {
            throw new NullPointerException("address");
        }
        DualStackPlainDatagramSocketImpl.socketConnect(nativefd, address, port);
    }

    @Override
    protected void disconnect0(int family) {
        if (this.fd == null || !this.fd.valid()) {
            return;
        }
        DualStackPlainDatagramSocketImpl.socketDisconnect(fdAccess.get(this.fd));
    }

    @Override
    protected void datagramSocketClose() {
        if (this.fd == null || !this.fd.valid()) {
            return;
        }
        DualStackPlainDatagramSocketImpl.socketClose(fdAccess.get(this.fd));
        fdAccess.set(this.fd, -1);
    }

    @Override
    protected void socketSetOption(int opt, Object val) throws SocketException {
        int nativefd = this.checkAndReturnNativeFD();
        int optionValue = 0;
        if (opt == 14) {
            throw new UnsupportedOperationException("unsupported option");
        }
        switch (opt) {
            case 3: 
            case 4097: 
            case 4098: {
                optionValue = (Integer)val;
                break;
            }
            case 4: {
                if (this.exclusiveBind && this.localPort != 0) {
                    this.reuseAddressEmulated = true;
                    this.isReuseAddress = (Boolean)val;
                    return;
                }
            }
            case 32: {
                optionValue = (Boolean)val != false ? 1 : 0;
                break;
            }
            default: {
                throw new SocketException("Option not supported");
            }
        }
        DualStackPlainDatagramSocketImpl.socketSetIntOption(nativefd, opt, optionValue);
    }

    @Override
    protected Object socketGetOption(int opt) throws SocketException {
        int nativefd = this.checkAndReturnNativeFD();
        if (opt == 15) {
            return DualStackPlainDatagramSocketImpl.socketLocalAddress(nativefd);
        }
        if (opt == 4 && this.reuseAddressEmulated) {
            return this.isReuseAddress;
        }
        if (opt == 14) {
            throw new UnsupportedOperationException("unsupported option");
        }
        int value = DualStackPlainDatagramSocketImpl.socketGetIntOption(nativefd, opt);
        Constable returnValue = null;
        switch (opt) {
            case 4: 
            case 32: {
                returnValue = value == 0 ? Boolean.FALSE : Boolean.TRUE;
                break;
            }
            case 3: 
            case 4097: 
            case 4098: {
                returnValue = value;
                break;
            }
            default: {
                throw new SocketException("Option not supported");
            }
        }
        return returnValue;
    }

    @Override
    protected Set<SocketOption<?>> supportedOptions() {
        HashSet options = new HashSet();
        options.add(StandardSocketOptions.SO_SNDBUF);
        options.add(StandardSocketOptions.SO_RCVBUF);
        options.add(StandardSocketOptions.SO_REUSEADDR);
        options.add(StandardSocketOptions.SO_BROADCAST);
        options.add(StandardSocketOptions.IP_TOS);
        options.addAll(ExtendedSocketOptions.datagramSocketOptions());
        return Collections.unmodifiableSet(options);
    }

    @Override
    protected void join(InetAddress inetaddr, NetworkInterface netIf) throws IOException {
        throw new IOException("Method not implemented!");
    }

    @Override
    protected void leave(InetAddress inetaddr, NetworkInterface netIf) throws IOException {
        throw new IOException("Method not implemented!");
    }

    @Override
    protected void setTimeToLive(int ttl) throws IOException {
        throw new IOException("Method not implemented!");
    }

    @Override
    protected int getTimeToLive() throws IOException {
        throw new IOException("Method not implemented!");
    }

    @Override
    @Deprecated
    protected void setTTL(byte ttl) throws IOException {
        throw new IOException("Method not implemented!");
    }

    @Override
    @Deprecated
    protected byte getTTL() throws IOException {
        throw new IOException("Method not implemented!");
    }

    private int checkAndReturnNativeFD() throws SocketException {
        if (this.fd == null || !this.fd.valid()) {
            throw new SocketException("Socket closed");
        }
        return fdAccess.get(this.fd);
    }

    private static native void initIDs();

    private static native int socketCreate();

    private static native void socketBind(int var0, InetAddress var1, int var2, boolean var3) throws SocketException;

    private static native void socketConnect(int var0, InetAddress var1, int var2) throws SocketException;

    private static native void socketDisconnect(int var0);

    private static native void socketClose(int var0);

    private static native int socketLocalPort(int var0) throws SocketException;

    private static native Object socketLocalAddress(int var0) throws SocketException;

    private static native int socketReceiveOrPeekData(int var0, DatagramPacket var1, int var2, boolean var3, boolean var4) throws IOException;

    private static native void socketSend(int var0, byte[] var1, int var2, int var3, InetAddress var4, int var5, boolean var6) throws IOException;

    private static native void socketSetIntOption(int var0, int var1, int var2) throws SocketException;

    private static native int socketGetIntOption(int var0, int var1) throws SocketException;

    @Override
    native int dataAvailable();

    static {
        DualStackPlainDatagramSocketImpl.initIDs();
    }
}

