/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.File;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddressImpl;
import java.net.InetAddressImplFactory;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Scanner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicLong;
import jdk.internal.access.JavaNetInetAddressAccess;
import jdk.internal.access.SharedSecrets;
import jdk.internal.loader.BootLoader;
import jdk.internal.misc.Unsafe;
import sun.net.InetAddressCachePolicy;
import sun.net.util.IPAddressUtil;
import sun.nio.cs.UTF_8;
import sun.security.action.GetPropertyAction;

public class InetAddress
implements Serializable {
    static final int PREFER_IPV4_VALUE = 0;
    static final int PREFER_IPV6_VALUE = 1;
    static final int PREFER_SYSTEM_VALUE = 2;
    static final int IPv4 = 1;
    static final int IPv6 = 2;
    static final transient int preferIPv6Address;
    final transient InetAddressHolder holder = new InetAddressHolder();
    private static transient NameService nameService;
    private transient String canonicalHostName = null;
    private static final long serialVersionUID = 3286316764910316507L;
    private static final ConcurrentMap<String, Addresses> cache;
    private static final NavigableSet<CachedAddresses> expirySet;
    static final InetAddressImpl impl;
    private static volatile CachedLocalHost cachedLocalHost;
    private static final Unsafe UNSAFE;
    private static final long FIELDS_OFFSET;
    private static final ObjectStreamField[] serialPersistentFields;

    InetAddressHolder holder() {
        return this.holder;
    }

    InetAddress() {
    }

    private Object readResolve() throws ObjectStreamException {
        return new Inet4Address(this.holder().getHostName(), this.holder().getAddress());
    }

    public boolean isMulticastAddress() {
        return false;
    }

    public boolean isAnyLocalAddress() {
        return false;
    }

    public boolean isLoopbackAddress() {
        return false;
    }

    public boolean isLinkLocalAddress() {
        return false;
    }

    public boolean isSiteLocalAddress() {
        return false;
    }

    public boolean isMCGlobal() {
        return false;
    }

    public boolean isMCNodeLocal() {
        return false;
    }

    public boolean isMCLinkLocal() {
        return false;
    }

    public boolean isMCSiteLocal() {
        return false;
    }

    public boolean isMCOrgLocal() {
        return false;
    }

    public boolean isReachable(int timeout) throws IOException {
        return this.isReachable(null, 0, timeout);
    }

    public boolean isReachable(NetworkInterface netif, int ttl, int timeout) throws IOException {
        if (ttl < 0) {
            throw new IllegalArgumentException("ttl can't be negative");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout can't be negative");
        }
        return impl.isReachable(this, timeout, netif, ttl);
    }

    public String getHostName() {
        return this.getHostName(true);
    }

    String getHostName(boolean check) {
        if (this.holder().getHostName() == null) {
            this.holder().hostName = InetAddress.getHostFromNameService(this, check);
        }
        return this.holder().getHostName();
    }

    public String getCanonicalHostName() {
        String value = this.canonicalHostName;
        if (value == null) {
            this.canonicalHostName = value = InetAddress.getHostFromNameService(this, true);
        }
        return value;
    }

    private static String getHostFromNameService(InetAddress addr, boolean check) {
        String host = null;
        try {
            SecurityManager sec;
            host = nameService.getHostByAddr(addr.getAddress());
            if (check && (sec = System.getSecurityManager()) != null) {
                sec.checkConnect(host, -1);
            }
            InetAddress[] arr = InetAddress.getAllByName0(host, check);
            boolean ok = false;
            if (arr != null) {
                for (int i = 0; !ok && i < arr.length; ++i) {
                    ok = addr.equals(arr[i]);
                }
            }
            if (!ok) {
                host = addr.getHostAddress();
                return host;
            }
        }
        catch (SecurityException e) {
            host = addr.getHostAddress();
        }
        catch (UnknownHostException e) {
            host = addr.getHostAddress();
        }
        return host;
    }

    public byte[] getAddress() {
        return null;
    }

    public String getHostAddress() {
        return null;
    }

    public int hashCode() {
        return -1;
    }

    public boolean equals(Object obj) {
        return false;
    }

    public String toString() {
        String hostName = this.holder().getHostName();
        return Objects.toString(hostName, "") + "/" + this.getHostAddress();
    }

    private static NameService createNameService() {
        String hostsFileName = GetPropertyAction.privilegedGetProperty("jdk.net.hosts.file");
        NameService theNameService = hostsFileName != null ? new HostsFileNameService(hostsFileName) : new PlatformNameService();
        return theNameService;
    }

    public static InetAddress getByAddress(String host, byte[] addr) throws UnknownHostException {
        if (host != null && !host.isEmpty() && host.charAt(0) == '[' && host.charAt(host.length() - 1) == ']') {
            host = host.substring(1, host.length() - 1);
        }
        if (addr != null) {
            if (addr.length == 4) {
                return new Inet4Address(host, addr);
            }
            if (addr.length == 16) {
                byte[] newAddr = IPAddressUtil.convertFromIPv4MappedAddress(addr);
                if (newAddr != null) {
                    return new Inet4Address(host, newAddr);
                }
                return new Inet6Address(host, addr);
            }
        }
        throw new UnknownHostException("addr is of illegal length");
    }

    public static InetAddress getByName(String host) throws UnknownHostException {
        return InetAddress.getAllByName(host)[0];
    }

    private static InetAddress getByName(String host, InetAddress reqAddr) throws UnknownHostException {
        return InetAddress.getAllByName(host, reqAddr)[0];
    }

    public static InetAddress[] getAllByName(String host) throws UnknownHostException {
        return InetAddress.getAllByName(host, null);
    }

    private static InetAddress[] getAllByName(String host, InetAddress reqAddr) throws UnknownHostException {
        if (host == null || host.isEmpty()) {
            InetAddress[] ret = new InetAddress[]{impl.loopbackAddress()};
            return ret;
        }
        boolean ipv6Expected = false;
        if (host.charAt(0) == '[') {
            if (host.length() > 2 && host.charAt(host.length() - 1) == ']') {
                host = host.substring(1, host.length() - 1);
                ipv6Expected = true;
            } else {
                throw new UnknownHostException(host + ": invalid IPv6 address");
            }
        }
        if (Character.digit(host.charAt(0), 16) != -1 || host.charAt(0) == ':') {
            byte[] addr = null;
            int numericZone = -1;
            String ifname = null;
            addr = IPAddressUtil.textToNumericFormatV4(host);
            if (addr == null) {
                int pos = host.indexOf(37);
                if (pos != -1 && (numericZone = InetAddress.checkNumericZone(host)) == -1) {
                    ifname = host.substring(pos + 1);
                }
                if ((addr = IPAddressUtil.textToNumericFormatV6(host)) == null && host.contains(":")) {
                    throw new UnknownHostException(host + ": invalid IPv6 address");
                }
            } else if (ipv6Expected) {
                throw new UnknownHostException("[" + host + "]");
            }
            InetAddress[] ret = new InetAddress[1];
            if (addr != null) {
                ret[0] = addr.length == 4 ? new Inet4Address(null, addr) : (ifname != null ? new Inet6Address(null, addr, ifname) : new Inet6Address(null, addr, numericZone));
                return ret;
            }
        } else if (ipv6Expected) {
            throw new UnknownHostException("[" + host + "]");
        }
        return InetAddress.getAllByName0(host, reqAddr, true, true);
    }

    public static InetAddress getLoopbackAddress() {
        return impl.loopbackAddress();
    }

    private static int checkNumericZone(String s) throws UnknownHostException {
        int percent = s.indexOf(37);
        int slen = s.length();
        int zone = 0;
        if (percent == -1) {
            return -1;
        }
        for (int i = percent + 1; i < slen; ++i) {
            char c = s.charAt(i);
            if (c == ']') {
                if (i != percent + 1) break;
                return -1;
            }
            int digit = Character.digit(c, 10);
            if (digit < 0) {
                return -1;
            }
            zone = zone * 10 + digit;
        }
        return zone;
    }

    private static InetAddress[] getAllByName0(String host) throws UnknownHostException {
        return InetAddress.getAllByName0(host, true);
    }

    static InetAddress[] getAllByName0(String host, boolean check) throws UnknownHostException {
        return InetAddress.getAllByName0(host, null, check, true);
    }

    private static InetAddress[] getAllByName0(String host, InetAddress reqAddr, boolean check, boolean useCache) throws UnknownHostException {
        Addresses oldAddrs;
        Addresses addrs;
        SecurityManager security;
        if (check && (security = System.getSecurityManager()) != null) {
            security.checkConnect(host, -1);
        }
        long now = System.nanoTime();
        for (CachedAddresses caddrs : expirySet) {
            if (caddrs.expiryTime - now >= 0L) break;
            if (!expirySet.remove(caddrs)) continue;
            cache.remove(caddrs.host, caddrs);
        }
        if (useCache) {
            addrs = (Addresses)cache.get(host);
        } else {
            addrs = (Addresses)cache.remove(host);
            if (addrs != null) {
                if (addrs instanceof CachedAddresses) {
                    expirySet.remove(addrs);
                }
                addrs = null;
            }
        }
        if (addrs == null && (oldAddrs = cache.putIfAbsent(host, addrs = new NameServiceAddresses(host, reqAddr))) != null) {
            addrs = oldAddrs;
        }
        return (InetAddress[])addrs.get().clone();
    }

    static InetAddress[] getAddressesFromNameService(String host, InetAddress reqAddr) throws UnknownHostException {
        InetAddress[] addresses = null;
        UnknownHostException ex = null;
        try {
            addresses = nameService.lookupAllHostAddr(host);
        }
        catch (UnknownHostException uhe) {
            if (host.equalsIgnoreCase("localhost")) {
                addresses = new InetAddress[]{impl.loopbackAddress()};
            }
            ex = uhe;
        }
        if (addresses == null) {
            throw ex == null ? new UnknownHostException(host) : ex;
        }
        if (reqAddr != null && addresses.length > 1 && !addresses[0].equals(reqAddr)) {
            int i;
            for (i = 1; i < addresses.length && !addresses[i].equals(reqAddr); ++i) {
            }
            if (i < addresses.length) {
                InetAddress tmp2 = reqAddr;
                for (int j = 0; j < i; ++j) {
                    InetAddress tmp = addresses[j];
                    addresses[j] = tmp2;
                    tmp2 = tmp;
                }
                addresses[i] = tmp2;
            }
        }
        return addresses;
    }

    public static InetAddress getByAddress(byte[] addr) throws UnknownHostException {
        return InetAddress.getByAddress(null, addr);
    }

    public static InetAddress getLocalHost() throws UnknownHostException {
        SecurityManager security = System.getSecurityManager();
        try {
            InetAddress localAddr;
            CachedLocalHost clh = cachedLocalHost;
            if (clh != null && clh.expiryTime - System.nanoTime() >= 0L) {
                if (security != null) {
                    security.checkConnect(clh.host, -1);
                }
                return clh.addr;
            }
            String local = impl.getLocalHostName();
            if (security != null) {
                security.checkConnect(local, -1);
            }
            if (local.equals("localhost")) {
                localAddr = impl.loopbackAddress();
            } else {
                try {
                    localAddr = InetAddress.getAllByName0(local, null, false, false)[0];
                }
                catch (UnknownHostException uhe) {
                    UnknownHostException uhe2 = new UnknownHostException(local + ": " + uhe.getMessage());
                    uhe2.initCause(uhe);
                    throw uhe2;
                }
            }
            cachedLocalHost = new CachedLocalHost(local, localAddr);
            return localAddr;
        }
        catch (SecurityException e) {
            return impl.loopbackAddress();
        }
    }

    private static native void init();

    static InetAddress anyLocalAddress() {
        return impl.anyLocalAddress();
    }

    static InetAddressImpl loadImpl(String implName) {
        Object tmp;
        Object impl = null;
        String prefix = GetPropertyAction.privilegedGetProperty("impl.prefix", "");
        try {
            tmp = Class.forName("java.net." + prefix + implName).newInstance();
            impl = tmp;
        }
        catch (ClassNotFoundException e) {
            System.err.println("Class not found: java.net." + prefix + implName + ":\ncheck impl.prefix property in your properties file.");
        }
        catch (InstantiationException e) {
            System.err.println("Could not instantiate: java.net." + prefix + implName + ":\ncheck impl.prefix property in your properties file.");
        }
        catch (IllegalAccessException e) {
            System.err.println("Cannot access class: java.net." + prefix + implName + ":\ncheck impl.prefix property in your properties file.");
        }
        if (impl == null) {
            try {
                tmp = Class.forName(implName).newInstance();
                impl = tmp;
            }
            catch (Exception e) {
                throw new Error("System property impl.prefix incorrect");
            }
        }
        return impl;
    }

    private void readObjectNoData() {
        if (this.getClass().getClassLoader() != null) {
            throw new SecurityException("invalid address type");
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        if (this.getClass().getClassLoader() != null) {
            throw new SecurityException("invalid address type");
        }
        ObjectInputStream.GetField gf = s.readFields();
        String host = (String)gf.get("hostName", null);
        int address = gf.get("address", 0);
        int family = gf.get("family", 0);
        if (family != 1 && family != 2) {
            throw new InvalidObjectException("invalid address family type: " + family);
        }
        InetAddressHolder h = new InetAddressHolder(host, address, family);
        UNSAFE.putReference(this, FIELDS_OFFSET, h);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        if (this.getClass().getClassLoader() != null) {
            throw new SecurityException("invalid address type");
        }
        ObjectOutputStream.PutField pf = s.putFields();
        pf.put("hostName", this.holder().getHostName());
        pf.put("address", this.holder().getAddress());
        pf.put("family", this.holder().getFamily());
        s.writeFields();
    }

    static {
        String str = GetPropertyAction.privilegedGetProperty("java.net.preferIPv6Addresses");
        preferIPv6Address = str == null ? 0 : (str.equalsIgnoreCase("true") ? 1 : (str.equalsIgnoreCase("false") ? 0 : (str.equalsIgnoreCase("system") ? 2 : 0)));
        BootLoader.loadLibrary("net");
        SharedSecrets.setJavaNetInetAddressAccess(new JavaNetInetAddressAccess(){

            @Override
            public String getOriginalHostName(InetAddress ia) {
                return ia.holder.getOriginalHostName();
            }

            @Override
            public InetAddress getByName(String hostName, InetAddress hostAddress) throws UnknownHostException {
                return InetAddress.getByName(hostName, hostAddress);
            }

            @Override
            public int addressValue(Inet4Address inet4Address) {
                return inet4Address.addressValue();
            }

            @Override
            public byte[] addressBytes(Inet6Address inet6Address) {
                return inet6Address.addressBytes();
            }
        });
        InetAddress.init();
        cache = new ConcurrentHashMap<String, Addresses>();
        expirySet = new ConcurrentSkipListSet<CachedAddresses>();
        impl = InetAddressImplFactory.create();
        nameService = InetAddress.createNameService();
        UNSAFE = Unsafe.getUnsafe();
        FIELDS_OFFSET = UNSAFE.objectFieldOffset(InetAddress.class, "holder");
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("hostName", String.class), new ObjectStreamField("address", Integer.TYPE), new ObjectStreamField("family", Integer.TYPE)};
    }

    static class InetAddressHolder {
        String originalHostName;
        String hostName;
        int address;
        int family;

        InetAddressHolder() {
        }

        InetAddressHolder(String hostName, int address, int family) {
            this.originalHostName = hostName;
            this.hostName = hostName;
            this.address = address;
            this.family = family;
        }

        void init(String hostName, int family) {
            this.originalHostName = hostName;
            this.hostName = hostName;
            if (family != -1) {
                this.family = family;
            }
        }

        String getHostName() {
            return this.hostName;
        }

        String getOriginalHostName() {
            return this.originalHostName;
        }

        int getAddress() {
            return this.address;
        }

        int getFamily() {
            return this.family;
        }
    }

    private static interface NameService {
        public InetAddress[] lookupAllHostAddr(String var1) throws UnknownHostException;

        public String getHostByAddr(byte[] var1) throws UnknownHostException;
    }

    private static final class HostsFileNameService
    implements NameService {
        private static final InetAddress[] EMPTY_ARRAY = new InetAddress[0];
        private static final boolean preferIPv4Stack = Boolean.parseBoolean(GetPropertyAction.privilegedGetProperty("java.net.preferIPv4Stack"));
        private final String hostsFile;

        public HostsFileNameService(String hostsFileName) {
            this.hostsFile = hostsFileName;
        }

        @Override
        public String getHostByAddr(byte[] addr) throws UnknownHostException {
            String host = null;
            try (Scanner hostsFileScanner = new Scanner(new File(this.hostsFile), (Charset)UTF_8.INSTANCE);){
                while (hostsFileScanner.hasNextLine()) {
                    String[] mapping;
                    String hostEntry = hostsFileScanner.nextLine();
                    if (hostEntry.startsWith("#") || (mapping = (hostEntry = this.removeComments(hostEntry)).split("\\s+")).length < 2 || !Arrays.equals(addr, this.createAddressByteArray(mapping[0]))) continue;
                    host = mapping[1];
                    break;
                }
            }
            catch (IOException e) {
                throw new UnknownHostException("Unable to resolve address " + Arrays.toString(addr) + " as hosts file " + this.hostsFile + " not found ");
            }
            if (host == null || host.isEmpty() || host.equals(" ")) {
                throw new UnknownHostException("Requested address " + Arrays.toString(addr) + " resolves to an invalid entry in hosts file " + this.hostsFile);
            }
            return host;
        }

        @Override
        public InetAddress[] lookupAllHostAddr(String host) throws UnknownHostException {
            ArrayList<InetAddress> res;
            ArrayList<InetAddress> inetAddresses = new ArrayList<InetAddress>();
            ArrayList<InetAddress> inet4Addresses = new ArrayList<InetAddress>();
            ArrayList<InetAddress> inet6Addresses = new ArrayList<InetAddress>();
            try (Scanner hostsFileScanner = new Scanner(new File(this.hostsFile), (Charset)UTF_8.INSTANCE);){
                while (hostsFileScanner.hasNextLine()) {
                    byte[] addr;
                    String addrStr;
                    String hostEntry = hostsFileScanner.nextLine();
                    if (hostEntry.startsWith("#") || !(hostEntry = this.removeComments(hostEntry)).contains(host) || (addrStr = this.extractHostAddr(hostEntry, host)) == null || addrStr.isEmpty() || (addr = this.createAddressByteArray(addrStr)) == null) continue;
                    InetAddress address = InetAddress.getByAddress(host, addr);
                    inetAddresses.add(address);
                    if (address instanceof Inet4Address) {
                        inet4Addresses.add(address);
                    }
                    if (!(address instanceof Inet6Address)) continue;
                    inet6Addresses.add(address);
                }
            }
            catch (IOException e) {
                throw new UnknownHostException("Unable to resolve host " + host + " as hosts file " + this.hostsFile + " not found ");
            }
            if (preferIPv4Stack) {
                res = inet4Addresses;
            } else {
                switch (preferIPv6Address) {
                    case 0: {
                        List<InetAddress> list = HostsFileNameService.concatAddresses(inet4Addresses, inet6Addresses);
                        break;
                    }
                    case 1: {
                        List<InetAddress> list = HostsFileNameService.concatAddresses(inet6Addresses, inet4Addresses);
                        break;
                    }
                    default: {
                        List<InetAddress> list = res = inetAddresses;
                    }
                }
            }
            if (res.isEmpty()) {
                throw new UnknownHostException("Unable to resolve host " + host + " in hosts file " + this.hostsFile);
            }
            return res.toArray(EMPTY_ARRAY);
        }

        private static List<InetAddress> concatAddresses(List<InetAddress> firstPart, List<InetAddress> secondPart) {
            ArrayList<InetAddress> result = new ArrayList<InetAddress>(firstPart);
            result.addAll(secondPart);
            return result;
        }

        private String removeComments(String hostsEntry) {
            String filteredEntry = hostsEntry;
            int hashIndex = hostsEntry.indexOf("#");
            if (hashIndex != -1) {
                filteredEntry = hostsEntry.substring(0, hashIndex);
            }
            return filteredEntry;
        }

        private byte[] createAddressByteArray(String addrStr) {
            byte[] addrArray = IPAddressUtil.textToNumericFormatV4(addrStr);
            if (addrArray == null) {
                addrArray = IPAddressUtil.textToNumericFormatV6(addrStr);
            }
            return addrArray;
        }

        private String extractHostAddr(String hostEntry, String host) {
            String[] mapping = hostEntry.split("\\s+");
            String hostAddr = null;
            if (mapping.length >= 2) {
                for (int i = 1; i < mapping.length; ++i) {
                    if (!mapping[i].equalsIgnoreCase(host)) continue;
                    hostAddr = mapping[0];
                }
            }
            return hostAddr;
        }
    }

    private static final class PlatformNameService
    implements NameService {
        private PlatformNameService() {
        }

        @Override
        public InetAddress[] lookupAllHostAddr(String host) throws UnknownHostException {
            return impl.lookupAllHostAddr(host);
        }

        @Override
        public String getHostByAddr(byte[] addr) throws UnknownHostException {
            return impl.getHostByAddr(addr);
        }
    }

    private static final class CachedAddresses
    implements Addresses,
    Comparable<CachedAddresses> {
        private static final AtomicLong seq = new AtomicLong();
        final String host;
        final InetAddress[] inetAddresses;
        final long expiryTime;
        final long id = seq.incrementAndGet();

        CachedAddresses(String host, InetAddress[] inetAddresses, long expiryTime) {
            this.host = host;
            this.inetAddresses = inetAddresses;
            this.expiryTime = expiryTime;
        }

        @Override
        public InetAddress[] get() throws UnknownHostException {
            if (this.inetAddresses == null) {
                throw new UnknownHostException(this.host);
            }
            return this.inetAddresses;
        }

        @Override
        public int compareTo(CachedAddresses other) {
            long diff = this.expiryTime - other.expiryTime;
            if (diff < 0L) {
                return -1;
            }
            if (diff > 0L) {
                return 1;
            }
            return Long.compare(this.id, other.id);
        }
    }

    private static interface Addresses {
        public InetAddress[] get() throws UnknownHostException;
    }

    private static final class NameServiceAddresses
    implements Addresses {
        private final String host;
        private final InetAddress reqAddr;

        NameServiceAddresses(String host, InetAddress reqAddr) {
            this.host = host;
            this.reqAddr = reqAddr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InetAddress[] get() throws UnknownHostException {
            Addresses addresses;
            NameServiceAddresses nameServiceAddresses = this;
            synchronized (nameServiceAddresses) {
                addresses = cache.putIfAbsent(this.host, this);
                if (addresses == null) {
                    addresses = this;
                }
                if (addresses == this) {
                    int cachePolicy;
                    UnknownHostException ex;
                    InetAddress[] inetAddresses;
                    try {
                        inetAddresses = InetAddress.getAddressesFromNameService(this.host, this.reqAddr);
                        ex = null;
                        cachePolicy = InetAddressCachePolicy.get();
                    }
                    catch (UnknownHostException uhe) {
                        inetAddresses = null;
                        ex = uhe;
                        cachePolicy = InetAddressCachePolicy.getNegative();
                    }
                    if (cachePolicy == 0) {
                        cache.remove(this.host, this);
                    } else {
                        CachedAddresses cachedAddresses = new CachedAddresses(this.host, inetAddresses, cachePolicy == -1 ? 0L : System.nanoTime() + 1000000000L * (long)cachePolicy);
                        if (cache.replace(this.host, this, cachedAddresses) && cachePolicy != -1) {
                            expirySet.add(cachedAddresses);
                        }
                    }
                    if (inetAddresses == null) {
                        throw ex == null ? new UnknownHostException(this.host) : ex;
                    }
                    return inetAddresses;
                }
            }
            return addresses.get();
        }
    }

    private static final class CachedLocalHost {
        final String host;
        final InetAddress addr;
        final long expiryTime = System.nanoTime() + 5000000000L;

        CachedLocalHost(String host, InetAddress addr) {
            this.host = host;
            this.addr = addr;
        }
    }
}

