/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.Certificate;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import sun.net.www.ParseUtil;

public abstract class JarURLConnection
extends URLConnection {
    private URL jarFileURL;
    private String entryName;
    protected URLConnection jarFileURLConnection;

    protected JarURLConnection(URL url) throws MalformedURLException {
        super(url);
        this.parseSpecs(url);
    }

    private void parseSpecs(URL url) throws MalformedURLException {
        String spec = url.getFile();
        int separator = spec.indexOf("!/");
        if (separator == -1) {
            throw new MalformedURLException("no !/ found in url spec:" + spec);
        }
        this.jarFileURL = new URL(spec.substring(0, separator++));
        if ("runtime".equals(url.getRef())) {
            this.jarFileURL = new URL(this.jarFileURL, "#runtime");
        }
        this.entryName = null;
        if (++separator != spec.length()) {
            this.entryName = spec.substring(separator, spec.length());
            this.entryName = ParseUtil.decode(this.entryName);
        }
    }

    public URL getJarFileURL() {
        return this.jarFileURL;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public abstract JarFile getJarFile() throws IOException;

    public Manifest getManifest() throws IOException {
        return this.getJarFile().getManifest();
    }

    public JarEntry getJarEntry() throws IOException {
        return this.entryName == null ? null : this.getJarFile().getJarEntry(this.entryName);
    }

    public Attributes getAttributes() throws IOException {
        JarEntry e = this.getJarEntry();
        return e != null ? e.getAttributes() : null;
    }

    public Attributes getMainAttributes() throws IOException {
        Manifest man = this.getManifest();
        return man != null ? man.getMainAttributes() : null;
    }

    public Certificate[] getCertificates() throws IOException {
        JarEntry e = this.getJarEntry();
        return e != null ? e.getCertificates() : null;
    }
}

